/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.realestateRevCost;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.impl.DataMutexImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcproject.TaxcProjectDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bos.user.UserDataServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tdm.business.perm.TaxcPermBusiness;
import kd.taxc.tdm.business.realestateRevCost.CostReportTplBussiness;
import kd.taxc.tdm.business.realestateRevCost.CostRptBusiness;
import kd.taxc.tdm.common.util.AppLogUtils;

public class CostReportPagePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(CostReportPagePlugin.class);
    private static final String F7_COSTREPORTTPL = "costreporttpl";
    private static final String F7_CREATEORG = "createorg";
    private static final String F7_TAXPROJECT = "taxproject";
    private static final String F7_VERSION = "version";
    private static final String ENUM_COSTPERIOD = "costperiod";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTRY_COSTITEM = "costitem";
    private static final String ENTRY_TXT_COSTITEMNAME = "txt_costitemname";
    private static final String ENTRY_LEVEL = "level";
    private static final String ENTRY_PARENT = "parent";
    private static final String ENTRY_TAXAMOUNT = "taxamount";
    private static final String ENTRY_AMOUNT = "amount";
    private static final String ENTRY_TAX = "tax";
    private static final String ENTRY_ISLEAF = "isleaf";
    private static final String ENTRY_PERIODNUM = "periodnum";
    private static final String ENTRY_ENTRYID = "entryid";
    private static final String CHILDRENROW_CACHE = "_childrenRowCache";
    private static final String ROWTOPARENTROW_CHACHE = "_rowToParentRowCache";
    private static final String LEAFTOROOTROW_CHACHE = "_leafToRootRowCache";
    private static final String TAB = "tab";
    private static final int MAX_PERIODCOUNT = 10;
    private static final String NEXTLINE = "\r\n";

    public void initialize() {
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        OrgEdit createorgF7 = (OrgEdit)this.getView().getControl(F7_CREATEORG);
        createorgF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxProjectF7 = (BasedataEdit)this.getView().getControl(F7_TAXPROJECT);
        taxProjectF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costReportTPLF7 = (BasedataEdit)this.getView().getControl(F7_COSTREPORTTPL);
        costReportTPLF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.loadFormData();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        if (F7_CREATEORG.equalsIgnoreCase(name)) {
            List hasPermOrgs = TaxcPermBusiness.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)"tdm", (String)"tdm_costrpt", (String)"47156aff000000ac");
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)hasPermOrgs));
        } else if (F7_TAXPROJECT.equals(name)) {
            if (this.getModel().getValue(F7_CREATEORG) == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7f16\u5236\u7ec4\u7ec7\u3002", (String)"CostReportPagePlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue(F7_CREATEORG);
            QFilter orgFilter = new QFilter("taxorg.id", "=", (Object)org.getLong("id"));
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            showParameter.getListFilterParameter().setFilter(orgFilter);
            showParameter.getListFilterParameter().setFilter(statusFilter);
        } else if (F7_COSTREPORTTPL.equals(name)) {
            if (this.getModel().getValue(F7_CREATEORG) == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7f16\u5236\u7ec4\u7ec7\u3002", (String)"CostReportPagePlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.getModel().getValue(F7_TAXPROJECT) == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u9879\u76ee\u3002", (String)"CostReportPagePlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue(F7_CREATEORG);
            QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"tdm_costtpl", (Long)this.getDynamicObjectID(org));
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            DynamicObject taxproject = (DynamicObject)this.getModel().getValue(F7_TAXPROJECT);
            QFilter taxProjectFilter1 = new QFilter(F7_TAXPROJECT, "=", (Object)this.getDynamicObjectID(taxproject));
            QFilter taxProjectFilter2 = new QFilter(F7_TAXPROJECT, "=", (Object)0L).or(taxProjectFilter1);
            showParameter.getListFilterParameter().setFilter(orgFilter);
            showParameter.getListFilterParameter().setFilter(enableFilter);
            showParameter.getListFilterParameter().setFilter(taxProjectFilter2);
        }
    }

    protected void loadFormData() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        if (!customParams.containsKey("id")) {
            this.setEntriesVisible(0);
        } else {
            Long id = (Long)customParams.get("id");
            this.getPageCache().put("id", String.valueOf(id));
            this.requireLock(this.getPageCache().get("id"));
            ArrayList<Long> idList = new ArrayList<Long>();
            idList.add(id);
            DynamicObject[] costReportData = CostRptBusiness.queryCostReportDataCollection(idList);
            if (costReportData != null && costReportData.length > 0) {
                IDataModel model = this.getModel();
                DynamicObject costReport = costReportData[0];
                model.setValue(F7_CREATEORG, (Object)costReport.getDynamicObject(F7_CREATEORG));
                model.setValue(F7_TAXPROJECT, (Object)costReport.getDynamicObject(F7_TAXPROJECT));
                model.setValue(F7_COSTREPORTTPL, (Object)costReport.getDynamicObject(F7_COSTREPORTTPL));
                model.setValue(ENUM_COSTPERIOD, (Object)costReport.getString(ENUM_COSTPERIOD));
                model.setValue(F7_VERSION, (Object)costReport.getDynamicObject(F7_VERSION));
                this.setEntriesVisible(this.getPeriodCount());
                this.fillEntriesByCostReport(costReport);
                model.endInit();
                this.getView().updateView();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (F7_COSTREPORTTPL.equals(propertyName)) {
            this.costReportTplChanged(e);
        } else if (F7_TAXPROJECT.equals(propertyName)) {
            this.taxprojectChanged(e);
        } else if (ENUM_COSTPERIOD.equals(propertyName)) {
            this.periodCountChanged(e);
        } else if (F7_CREATEORG.equals(propertyName)) {
            this.createOrgChanged(e);
        } else if (propertyName.startsWith(ENTRY_AMOUNT) || propertyName.startsWith(ENTRY_TAX) || propertyName.startsWith(ENTRY_TAXAMOUNT)) {
            this.moneyFieldsChanged(e);
        }
    }

    public void costReportTplChanged(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        DynamicObject newCostReportTPL = (DynamicObject)changeData[0].getNewValue();
        this.fillEntriesByCostReportTPL(newCostReportTPL);
    }

    public void fillEntriesByCostReportTPL(DynamicObject costReportTPL) {
        block5: {
            int periodCount;
            block4: {
                periodCount = this.getPeriodCount();
                if (periodCount <= 0) {
                    return;
                }
                if (costReportTPL != null) break block4;
                for (int i = 1; i <= 10; ++i) {
                    this.getModel().deleteEntryData(ENTRYENTITY + i);
                }
                break block5;
            }
            this.setRowRelationCache(costReportTPL);
            DynamicObjectCollection costReportTplEntries = costReportTPL.getDynamicObjectCollection(ENTRYENTITY);
            if (costReportTplEntries == null || costReportTplEntries.isEmpty()) break block5;
            for (int i = 1; i <= periodCount; ++i) {
                IDataModel model = this.getModel();
                model.beginInit();
                model.deleteEntryData(ENTRYENTITY + i);
                model.batchCreateNewEntryRow(ENTRYENTITY + i, costReportTplEntries.size());
                int index = 0;
                for (DynamicObject costReportTplEntry : costReportTplEntries) {
                    model.setValue(ENTRY_COSTITEM + i, (Object)this.getDynamicObjectID(costReportTplEntry.getDynamicObject(ENTRY_COSTITEM)), index);
                    model.setValue(ENTRY_TXT_COSTITEMNAME + i, (Object)this.getTabCostItemName(costReportTplEntry), index);
                    model.setValue(ENTRY_LEVEL + i, (Object)costReportTplEntry.getInt(ENTRY_LEVEL), index);
                    model.setValue(ENTRY_PARENT + i, (Object)this.getDynamicObjectID(costReportTplEntry.getDynamicObject(ENTRY_PARENT)), index);
                    model.setValue(ENTRY_TAXAMOUNT + i, (Object)0, index);
                    model.setValue(ENTRY_AMOUNT + i, (Object)0, index);
                    model.setValue(ENTRY_TAX + i, (Object)0, index);
                    model.setValue(ENTRY_ISLEAF + i, (Object)costReportTplEntry.getBoolean(ENTRY_ISLEAF), index);
                    ++index;
                }
                model.endInit();
                this.getView().updateView(ENTRYENTITY + i);
            }
        }
    }

    public Long getDynamicObjectID(DynamicObject object) {
        if (object == null) {
            return null;
        }
        return object.getLong("id");
    }

    public void fillEntriesByCostReport(DynamicObject costReport) {
        if (costReport == null) {
            return;
        }
        int periodCount = this.getPeriodCount();
        DynamicObjectCollection entryCollection = costReport.getDynamicObjectCollection(ENTRYENTITY);
        if (entryCollection == null || entryCollection.isEmpty() || periodCount <= 0) {
            return;
        }
        int tabRowCount = entryCollection.size() / periodCount;
        IDataModel model = this.getModel();
        for (int i = 1; i <= periodCount; ++i) {
            model.deleteEntryData(ENTRYENTITY + i);
            model.batchCreateNewEntryRow(ENTRYENTITY + i, tabRowCount);
        }
        for (DynamicObject entry : entryCollection) {
            int tabIndex = Integer.parseInt(entry.getString(ENTRY_PERIODNUM));
            int seq = entry.getInt("seq") - 1;
            model.setValue(ENTRY_COSTITEM + tabIndex, (Object)this.getDynamicObjectID(entry.getDynamicObject(ENTRY_COSTITEM)), seq);
            model.setValue(ENTRY_TXT_COSTITEMNAME + tabIndex, (Object)this.getTabCostItemName(entry), seq);
            model.setValue(ENTRY_LEVEL + tabIndex, (Object)entry.getInt(ENTRY_LEVEL), seq);
            model.setValue(ENTRY_PARENT + tabIndex, (Object)this.getDynamicObjectID(entry.getDynamicObject(ENTRY_PARENT)), seq);
            model.setValue(ENTRY_TAXAMOUNT + tabIndex, (Object)entry.getBigDecimal(ENTRY_TAXAMOUNT), seq);
            model.setValue(ENTRY_AMOUNT + tabIndex, (Object)entry.getBigDecimal(ENTRY_AMOUNT), seq);
            model.setValue(ENTRY_TAX + tabIndex, (Object)entry.getBigDecimal(ENTRY_TAX), seq);
            model.setValue(ENTRY_ISLEAF + tabIndex, (Object)entry.getBoolean(ENTRY_ISLEAF), seq);
            model.setValue(ENTRY_ENTRYID + tabIndex, (Object)entry.getLong("id"), seq);
        }
    }

    public void moneyFieldsChanged(PropertyChangedArgs e) {
        String entryName = e.getProperty().getParent().getName();
        ChangeData changeData = e.getChangeSet()[0];
        DynamicObject costReport = (DynamicObject)this.getModel().getValue(F7_COSTREPORTTPL);
        this.setRowRelationCache(costReport);
        if (costReport != null && StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(costReport.getString("id") + CHILDRENROW_CACHE)) && StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(costReport.getString("id") + ROWTOPARENTROW_CHACHE))) {
            int currentRowIndex = changeData.getRowIndex();
            DynamicObjectCollection entryDataCollection = this.getModel().getEntryEntity(entryName);
            this.updateParentRowData(e.getProperty().getName(), currentRowIndex, entryDataCollection, costReport.getString("id"), entryName);
        } else {
            logger.error("\u672a\u83b7\u53d6\u5230\u6210\u672c\u9879\u76ee\u4e0a\u4e0b\u7ea7\u5173\u7cfb");
        }
    }

    public void periodCountChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        String newValue = (String)changeSet[0].getNewValue();
        int count = 0;
        if (StringUtils.isNotEmpty((CharSequence)newValue)) {
            try {
                count = Integer.parseInt(newValue);
            }
            catch (Exception ex) {
                logger.error("cast costperiod to Integer error");
            }
        } else {
            this.getModel().setValue(ENUM_COSTPERIOD, null);
        }
        this.setEntriesVisible(count);
        this.fillEntriesByCostReportTPL((DynamicObject)this.getModel().getValue(F7_COSTREPORTTPL));
    }

    public void createOrgChanged(PropertyChangedArgs e) {
        this.getModel().setValue(F7_TAXPROJECT, null);
        this.getModel().setValue(F7_COSTREPORTTPL, null);
    }

    public void taxprojectChanged(PropertyChangedArgs e) {
        this.getModel().setValue(F7_COSTREPORTTPL, null);
    }

    public int getPeriodCount() {
        String value = (String)this.getModel().getValue(ENUM_COSTPERIOD);
        int count = 0;
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            try {
                count = Integer.parseInt(value);
            }
            catch (Exception ex) {
                logger.error("cast periodCount to Integer error");
            }
        }
        return count;
    }

    public String getTabCostItemName(DynamicObject costReportTplEntry) {
        if (costReportTplEntry == null) {
            return null;
        }
        DynamicObject costItem = costReportTplEntry.getDynamicObject(ENTRY_COSTITEM);
        if (costItem == null) {
            return null;
        }
        int level = costReportTplEntry.getInt(ENTRY_LEVEL);
        String name = costItem.getString("name");
        if (level > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < level; ++i) {
                sb.append("\t");
            }
            sb.append(name);
            return sb.toString();
        }
        return name;
    }

    public void setRowRelationCache(DynamicObject costReportTpl) {
        if (costReportTpl == null) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.getPageCache().get(costReportTpl.getString("id") + CHILDRENROW_CACHE)) || StringUtils.isEmpty((CharSequence)this.getPageCache().get(costReportTpl.getString("id") + ROWTOPARENTROW_CHACHE))) {
            DynamicObjectCollection costReportTplEntries = null;
            try {
                costReportTplEntries = costReportTpl.getDynamicObjectCollection(ENTRYENTITY);
            }
            catch (ORMDesignException e) {
                ArrayList<Long> costReportIdList = new ArrayList<Long>();
                costReportIdList.add(costReportTpl.getLong("id"));
                DynamicObject[] costReportTplDataCollection = CostReportTplBussiness.queryCostReportTplDataCollection(costReportIdList);
                costReportTpl = costReportTplDataCollection[0];
                costReportTplEntries = costReportTpl.getDynamicObjectCollection(ENTRYENTITY);
            }
            if (costReportTplEntries != null && !costReportTplEntries.isEmpty()) {
                DynamicObjectCollection finalCostReportTplEntries = costReportTplEntries;
                Map<Long, Integer> costItemId_index = costReportTplEntries.stream().collect(Collectors.toMap(costReport -> costReport.getDynamicObject(ENTRY_COSTITEM).getLong("id"), costReport -> finalCostReportTplEntries.indexOf(costReport)));
                HashMap childrenRowRelation = new HashMap();
                HashMap<Integer, Integer> parentRowRelation = new HashMap<Integer, Integer>();
                for (DynamicObject costReportTplEntry : costReportTplEntries) {
                    DynamicObject parentCostItem;
                    Long parentCostItemId;
                    if (costReportTplEntry.getDynamicObject(ENTRY_PARENT) == null || !costItemId_index.containsKey(parentCostItemId = Long.valueOf((parentCostItem = costReportTplEntry.getDynamicObject(ENTRY_PARENT)).getLong("id")))) continue;
                    int parentRowIndex = costItemId_index.get(parentCostItemId);
                    parentRowRelation.put(costItemId_index.get(costReportTplEntry.getDynamicObject(ENTRY_COSTITEM).getLong("id")), parentRowIndex);
                    if (childrenRowRelation.containsKey(parentRowIndex)) {
                        ((List)childrenRowRelation.get(parentRowIndex)).add(costItemId_index.get(costReportTplEntry.getDynamicObject(ENTRY_COSTITEM).getLong("id")));
                        continue;
                    }
                    ArrayList<Integer> childrenRowIndex = new ArrayList<Integer>();
                    childrenRowIndex.add(costItemId_index.get(costReportTplEntry.getDynamicObject(ENTRY_COSTITEM).getLong("id")));
                    childrenRowRelation.put(parentRowIndex, childrenRowIndex);
                }
                this.getPageCache().put(costReportTpl.getString("id") + CHILDRENROW_CACHE, SerializationUtils.toJsonString(childrenRowRelation));
                this.getPageCache().put(costReportTpl.getString("id") + ROWTOPARENTROW_CHACHE, SerializationUtils.toJsonString(parentRowRelation));
            }
        }
    }

    private void updateParentRowData(String fieldName, int currntRowIndex, DynamicObjectCollection entryCollection, String costReportTplId, String entryentityName) {
        ArrayList<Integer> updateIndexList = new ArrayList<Integer>(10);
        Map childrenRow = (Map)JSONObject.parseObject((String)this.getPageCache().get(costReportTplId + CHILDRENROW_CACHE), Map.class);
        Map tempParentRow = (Map)JSONObject.parseObject((String)this.getPageCache().get(costReportTplId + ROWTOPARENTROW_CHACHE), Map.class);
        Map parentRow = tempParentRow.entrySet().stream().collect(Collectors.toMap(entry -> Integer.valueOf((String)entry.getKey()), entry -> (Integer)entry.getValue(), (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        while (parentRow.containsKey(currntRowIndex)) {
            int parentRowIndex = (Integer)parentRow.get(currntRowIndex);
            updateIndexList.add(parentRowIndex);
            if (childrenRow.containsKey(parentRowIndex + "")) {
                JSONArray childrenJSONObjects = (JSONArray)childrenRow.get(parentRowIndex + "");
                if (childrenJSONObjects == null) {
                    currntRowIndex = parentRowIndex;
                    continue;
                }
                List childrenRowIndex = childrenJSONObjects.stream().map(jsonObject -> (Integer)jsonObject).collect(Collectors.toList());
                BigDecimal money = BigDecimal.ZERO;
                Iterator iterator = childrenRowIndex.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    money = money.add(((DynamicObject)entryCollection.get(i)).getBigDecimal(fieldName));
                }
                ((DynamicObject)entryCollection.get(parentRowIndex)).set(fieldName, (Object)money);
            }
            currntRowIndex = parentRowIndex;
        }
        if (!updateIndexList.isEmpty()) {
            this.getModel().beginInit();
            Iterator iterator = updateIndexList.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                this.getModel().getEntryEntity(entryentityName).set(i, entryCollection.get(i));
            }
            this.getModel().endInit();
            this.getView().updateView(entryentityName);
        }
    }

    public void setEntriesVisible(int count) {
        if (count <= 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
        } else {
            int i;
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap"});
            for (i = 1; i <= count; ++i) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{TAB + i});
            }
            for (i = count + 1; i <= 10; ++i) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{TAB + i});
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("save".equals(itemKey)) {
            this.saveData();
        }
    }

    public void saveData() {
        if (this.checkLock(this.getPageCache().get("id"))) {
            return;
        }
        boolean isPassCheck = this.checkBeforeSaveData();
        if (!isPassCheck) {
            return;
        }
        IDataModel model = this.getModel();
        int periodCount = this.getPeriodCount();
        if (periodCount > 0) {
            boolean isAddnew = true;
            DynamicObject finalData = null;
            if (this.getPageCache().get("id") != null) {
                isAddnew = false;
                Long id = Long.valueOf(this.getPageCache().get("id"));
                ArrayList<Long> idList = new ArrayList<Long>();
                idList.add(id);
                DynamicObject[] costReportData = CostRptBusiness.queryCostReportDataCollection(idList);
                if (costReportData != null && costReportData.length > 0) {
                    finalData = costReportData[0];
                    finalData.getDynamicObjectCollection(ENTRYENTITY).clear();
                }
            } else {
                finalData = BusinessDataServiceHelper.newDynamicObject((String)"tdm_costrpt");
                finalData.set("status", (Object)"C");
                finalData.set("enable", (Object)"1");
                finalData.set("creator", (Object)UserServiceHelper.getCurrentUserId());
                finalData.set("createtime", (Object)new Date());
            }
            if (finalData != null) {
                finalData.set(F7_CREATEORG, model.getValue(F7_CREATEORG));
                finalData.set(F7_TAXPROJECT, model.getValue(F7_TAXPROJECT));
                finalData.set(F7_COSTREPORTTPL, model.getValue(F7_COSTREPORTTPL));
                finalData.set(ENUM_COSTPERIOD, model.getValue(ENUM_COSTPERIOD));
                finalData.set(F7_VERSION, model.getValue(F7_VERSION));
                DynamicObjectCollection entryCollection = finalData.getDynamicObjectCollection(ENTRYENTITY);
                for (int i = 1; i <= periodCount; ++i) {
                    DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRYENTITY + i);
                    int rowCount = entryEntity.getRowCount();
                    for (int j = 0; j < rowCount; ++j) {
                        DynamicObject newEntry = entryCollection.addNew();
                        newEntry.set(ENTRY_PERIODNUM, (Object)i);
                        newEntry.set("seq", ((DynamicObject)entryEntity.get(j)).get("seq"));
                        newEntry.set(ENTRY_COSTITEM, (Object)((DynamicObject)entryEntity.get(j)).getDynamicObject(ENTRY_COSTITEM + i));
                        newEntry.set(ENTRY_TAXAMOUNT, (Object)this.dealBigDecimal(((DynamicObject)entryEntity.get(j)).getBigDecimal(ENTRY_TAXAMOUNT + i)));
                        newEntry.set(ENTRY_AMOUNT, (Object)this.dealBigDecimal(((DynamicObject)entryEntity.get(j)).getBigDecimal(ENTRY_AMOUNT + i)));
                        newEntry.set(ENTRY_TAX, (Object)this.dealBigDecimal(((DynamicObject)entryEntity.get(j)).getBigDecimal(ENTRY_TAX + i)));
                        newEntry.set(ENTRY_LEVEL, (Object)((DynamicObject)entryEntity.get(j)).getInt(ENTRY_LEVEL + i));
                        newEntry.set(ENTRY_PARENT, (Object)((DynamicObject)entryEntity.get(j)).getDynamicObject(ENTRY_PARENT + i));
                        newEntry.set(ENTRY_ISLEAF, (Object)((DynamicObject)entryEntity.get(j)).getBoolean(ENTRY_ISLEAF + i));
                        if (((DynamicObject)entryEntity.get(j)).get(ENTRY_ENTRYID + i) == null) continue;
                        newEntry.set("id", (Object)((DynamicObject)entryEntity.get(j)).getLong(ENTRY_ENTRYID + i));
                    }
                }
                DynamicObject[] savedData = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finalData});
                this.getPageCache().put("id", String.valueOf(savedData[0].getLong("id")));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6210\u672c\u62a5\u8868\u4fdd\u5b58\u6210\u529f\u3002", (String)"CostReportPagePlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                String success = ResManager.loadKDString((String)"\u6210\u529f", (String)"CostReportPagePlugin_13", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                if (isAddnew) {
                    String addNew = ResManager.loadKDString((String)"\u65b0\u589e", (String)"CostReportPagePlugin_11", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                    AppLogUtils.addLog((String)"tdm_costrpt", (String)addNew, (String)success);
                } else {
                    String modify = ResManager.loadKDString((String)"\u4fee\u6539", (String)"CostReportPagePlugin_12", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                    AppLogUtils.addLog((String)"tdm_costrpt", (String)modify, (String)success);
                }
            }
        }
    }

    private BigDecimal dealBigDecimal(BigDecimal value) {
        if (value == null || BigDecimal.ZERO.compareTo(value) == 0) {
            return BigDecimal.ZERO;
        }
        return value;
    }

    public boolean checkBeforeSaveData() {
        return this.checkPermission() && this.checkRequired() && this.checkPeriodNum() && this.checkUnique();
    }

    public boolean checkPermission() {
        String permIemId = "4715a0df000000ac";
        if (this.getPageCache().get("id") != null) {
            if (!this.checkPermission(permIemId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6210\u672c\u62a5\u8868\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostReportPagePlugin_15", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else {
            permIemId = "47156aff000000ac";
            if (!this.checkPermission(permIemId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6210\u672c\u62a5\u8868\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostReportPagePlugin_16", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public boolean checkPermission(String permItemId) {
        int hasSpecificPerm;
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject createOrg = (DynamicObject)this.getModel().getValue(F7_CREATEORG);
        long orgid = createOrg.getLong("id");
        return !StringUtils.isNotEmpty((CharSequence)permItemId) || (hasSpecificPerm = PermissionServiceHelper.checkPermission((Long)userId, (Long)orgid, (String)"tdm", (String)"tdm_costrpt", (String)permItemId)) == 1;
    }

    public boolean checkRequired() {
        IDataModel model = this.getModel();
        StringBuilder sb = new StringBuilder();
        if (model.getValue(F7_CREATEORG) == null) {
            sb.append(ResManager.loadKDString((String)"\u201c\u7f16\u5236\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostReportPagePlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0])).append(NEXTLINE);
        }
        if (model.getValue(F7_TAXPROJECT) == null) {
            sb.append(ResManager.loadKDString((String)"\u201c\u7a0e\u52a1\u9879\u76ee\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostReportPagePlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0])).append(NEXTLINE);
        }
        if (model.getValue(F7_COSTREPORTTPL) == null) {
            sb.append(ResManager.loadKDString((String)"\u201c\u62a5\u8868\u6a21\u677f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostReportPagePlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0])).append(NEXTLINE);
        }
        if (StringUtils.isEmpty((CharSequence)((String)model.getValue(ENUM_COSTPERIOD)))) {
            sb.append(ResManager.loadKDString((String)"\u201c\u6210\u672c\u5206\u671f\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u670d\u52a1\u4e91>\u57fa\u7840\u8d44\u6599>\u7a0e\u52a1\u6570\u636e>\u516c\u5171\u6570\u636e>\u7a0e\u52a1\u9879\u76ee\u4fe1\u606f\u201d\u7684\u201c\u571f\u5730\u589e\u503c\u7a0e\u201d\u9875\u7b7e\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"CostReportPagePlugin_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0])).append(NEXTLINE);
        }
        if (sb.length() > 0) {
            this.getView().showTipNotification(sb.toString());
            return false;
        }
        return true;
    }

    public boolean checkPeriodNum() {
        List data;
        IDataModel model = this.getModel();
        int periodCount = this.getPeriodCount();
        DynamicObject createOrg = (DynamicObject)model.getValue(F7_CREATEORG);
        ArrayList<Long> taxOrgIDList = new ArrayList<Long>();
        taxOrgIDList.add(createOrg.getLong("id"));
        DynamicObject taxProject = (DynamicObject)model.getValue(F7_TAXPROJECT);
        ArrayList<String> taxProjectNumList = new ArrayList<String>();
        taxProjectNumList.add(taxProject.getString("number"));
        TaxcProjectDataServiceHelper helper = new TaxcProjectDataServiceHelper();
        TaxResult listTaxResult = helper.queryTaxcProjectByTaxOrgIdsAndNumbers(taxOrgIDList, taxProjectNumList);
        if (listTaxResult.isSuccess() && (data = (List)listTaxResult.getData()) != null && !data.isEmpty()) {
            DynamicObject systemTaxProject = (DynamicObject)data.get(0);
            String cbfq = systemTaxProject.getString("cbfq");
            if (!String.valueOf(periodCount).equals(cbfq)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("periodNumDiff", (IFormPlugin)this);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"CostReportPagePlugin_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"CostReportPagePlugin_8", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                MessageBoxOptions options = MessageBoxOptions.OKCancel;
                String msg = ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u8868\u7684\u6210\u672c\u5206\u671f\u4e0e\u7a0e\u52a1\u9879\u76ee\u6210\u672c\u5206\u671f\u503c\u4e0d\u4e00\u81f4\uff0c\u5c06\u6e05\u7a7a\u62a5\u8868\u660e\u7ec6\u6570\u636e\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"CostReportPagePlugin_9", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps, cbfq);
                return false;
            }
        }
        return true;
    }

    public boolean checkUnique() {
        IDataModel model = this.getModel();
        DynamicObject costReport = null;
        QFilter filter = new QFilter(F7_CREATEORG, "=", (Object)this.getDynamicObjectID((DynamicObject)model.getValue(F7_CREATEORG)));
        filter.and(new QFilter(F7_TAXPROJECT, "=", (Object)this.getDynamicObjectID((DynamicObject)model.getValue(F7_TAXPROJECT))));
        Long versionId = this.getDynamicObjectID((DynamicObject)model.getValue(F7_VERSION));
        if (versionId == null) {
            filter.and(new QFilter(F7_VERSION, "=", (Object)0L));
        } else {
            filter.and(new QFilter(F7_VERSION, "=", (Object)versionId));
        }
        if (this.getPageCache().get("id") != null) {
            filter.and(new QFilter("id", "!=", (Object)Long.valueOf(this.getPageCache().get("id"))));
        }
        if ((costReport = CostRptBusiness.querySingleCostReport((QFilter)filter)) != null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7684\u6570\u636e\uff08\u7a0e\u52a1\u7ec4\u7ec7\u3001\u7a0e\u52a1\u9879\u76ee\u3001\u7248\u672c\u90fd\u76f8\u540c\uff09\u3002", (String)"CostReportPagePlugin_10", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if ("periodNumDiff".equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            String cbfq = event.getCustomVaule();
            this.getModel().setValue(ENUM_COSTPERIOD, (Object)cbfq);
            this.fillEntriesByCostReportTPL((DynamicObject)this.getModel().getValue(F7_COSTREPORTTPL));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void pageRelease(EventObject e) {
        this.releaseLock();
    }

    protected void requireLock(String reportId) {
        if (reportId == null) {
            return;
        }
        this.releaseLock();
        boolean newMutexLocked = MutexHelper.require((String)"tdm_costrpt", (Object)reportId, (String)"modify", (boolean)Boolean.FALSE, (StringBuilder)new StringBuilder());
        if (!newMutexLocked) {
            if (this.checkLock(reportId)) {
                // empty if block
            }
        } else {
            this.getPageCache().put("id_lock", reportId);
        }
    }

    protected void releaseLock() {
        DataMutexImpl dataMutex;
        Map lockInfo;
        String lockId = this.getPageCache().get("id_lock");
        if (StringUtil.isNotEmpty((CharSequence)lockId) && !"null".equalsIgnoreCase(lockId) && (lockInfo = (dataMutex = new DataMutexImpl()).getLockInfo(lockId, "default_netctrl", "tdm_costrpt")) != null && ((String)lockInfo.get("userid")).equals(String.valueOf(RequestContext.get().getCurrUserId()))) {
            MutexHelper.release((String)"tdm_costrpt", (String)"modify", (String)lockId);
        }
    }

    protected boolean checkLock(String reportId) {
        if (StringUtil.isEmpty((CharSequence)reportId)) {
            return false;
        }
        DataMutexImpl dataMutex = new DataMutexImpl();
        Map lockInfo = dataMutex.getLockInfo(reportId, "default_netctrl", "tdm_costrpt");
        if (lockInfo != null && !((String)lockInfo.get("userid")).equals(String.valueOf(RequestContext.get().getCurrUserId()))) {
            String username = "";
            TaxResult result = UserDataServiceHelper.queryUserNameByIds((Long)Long.valueOf((String)lockInfo.get("userid")));
            if (result != null && result.isSuccess()) {
                username = (String)result.getData();
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostReportPagePlugin_14", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), username));
            return true;
        }
        return false;
    }
}

