/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.realestateRevCost;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.tdm.business.realestateRevCost.CostItemBusiness;

public class CostReportTemplatePlugin
extends AbstractFormPlugin
implements EntryGridBindDataListener,
BeforeF7SelectListener {
    public static String ITEM_SELECTCOSTITEM = "selectcostitem";
    public static String ITEM_SAVE = "bar_save";
    public static String ENTRYGRID_NAME = "entryentity";
    public static String FIELD_COSTITEM = "costitem";
    public static String FIELD_COSTITEMNUMBER = "costitemnumber";
    public static String FIELD_COSTITEMNAME = "costitemname";
    public static String F7_CREATEORG = "createorg";
    public static String F7_TAXPROJECT = "taxproject";
    public static String FIELD_PARENT = "parent";
    public static String FIELD_LEVEL = "level";
    public static String FIELD_ISLEAF = "isleaf";
    public static String PARENTID = "parentid";
    public static String COSTITEMID = "costitemid";
    public static String TXT_COSTITEMNAME = "txt_costitemname";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addItemClickListeners(new String[]{"tbmain"});
        BasedataEdit taxProjectF7 = (BasedataEdit)this.getView().getControl(F7_TAXPROJECT);
        taxProjectF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYGRID_NAME);
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (ITEM_SELECTCOSTITEM.equals(key)) {
            DynamicObjectCollection entryList = this.getModel().getEntryEntity(ENTRYGRID_NAME);
            ArrayList listNode = new ArrayList();
            if (entryList != null) {
                for (DynamicObject obj : entryList) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    Object costItemObject = obj.get(FIELD_COSTITEM);
                    if (costItemObject == null) continue;
                    DynamicObject costItem = (DynamicObject)costItemObject;
                    map.put(COSTITEMID, costItem.getString("id"));
                    map.put(FIELD_COSTITEMNUMBER, costItem.getString("number"));
                    map.put(FIELD_COSTITEMNAME, costItem.getString("name"));
                    Object parentObject = obj.get(FIELD_PARENT);
                    DynamicObject parentCostItem = (DynamicObject)parentObject;
                    String parentid = obj.getString("id");
                    map.put(PARENTID, parentid);
                    listNode.add(map);
                }
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ITEM_SELECTCOSTITEM);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setCustomParam("listNode", listNode);
            showParameter.setCustomParam("org", (Object)this.getModel().getDataEntity().getDynamicObject("org"));
            showParameter.setFormId("tdm_costitem_select");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        IDataModel model = this.getModel();
        if (ITEM_SELECTCOSTITEM.equals(event.getActionId())) {
            DynamicObject[] costitems;
            ArrayList returnData = (ArrayList)event.getReturnData();
            if (returnData == null) {
                return;
            }
            if (returnData.isEmpty() || returnData.size() == 1) {
                this.getModel().deleteEntryData(ENTRYGRID_NAME);
                return;
            }
            ArrayList<Long> ids = new ArrayList<Long>();
            for (String id : returnData) {
                if ("-1".equals(id)) continue;
                ids.add(Long.valueOf(id));
            }
            HashMap<Long, DynamicObject> costitemMap = new HashMap<Long, DynamicObject>(ids.size());
            for (DynamicObject costitem : costitems = CostItemBusiness.queryCostItemDataCollection(ids)) {
                costitemMap.put(costitem.getLong("id"), costitem);
            }
            model.beginInit();
            model.deleteEntryData(ENTRYGRID_NAME);
            model.batchCreateNewEntryRow(ENTRYGRID_NAME, costitems.length);
            HashMap<Long, Integer> costitem_rowindex = new HashMap<Long, Integer>(ids.size());
            int index = 0;
            for (Long id : ids) {
                costitem_rowindex.put(id, index);
                model.setValue(FIELD_COSTITEM, costitemMap.get(id), index);
                model.setValue(FIELD_LEVEL, ((DynamicObject)costitemMap.get(id)).get(FIELD_LEVEL), index);
                model.setValue(TXT_COSTITEMNAME, (Object)this.getTabCostItemName((DynamicObject)costitemMap.get(id)), index);
                model.setValue(FIELD_ISLEAF, (Object)true, index);
                if (costitemMap.get(id) != null && ((DynamicObject)costitemMap.get(id)).get("parent") != null) {
                    DynamicObject parentCostItem = (DynamicObject)((DynamicObject)costitemMap.get(id)).get(FIELD_PARENT);
                    model.setValue(FIELD_PARENT, (Object)parentCostItem, index);
                    if (costitem_rowindex.containsKey(parentCostItem.getLong("id"))) {
                        model.setValue(FIELD_ISLEAF, (Object)false, ((Integer)costitem_rowindex.get(parentCostItem.getLong("id"))).intValue());
                    }
                }
                ++index;
            }
            model.endInit();
            this.getView().updateView(ENTRYGRID_NAME);
        }
    }

    public String getTabCostItemName(DynamicObject costitem) {
        if (costitem == null) {
            return null;
        }
        int level = costitem.getInt("level") - 1;
        String name = costitem.getString("name");
        if (level > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < level; ++i) {
                sb.append("\t");
            }
            sb.append(name);
            return sb.toString();
        }
        return name;
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        List rows = e.getRows();
        for (RowDataEntity rowData : rows) {
            rowData.getDataEntity().set(TXT_COSTITEMNAME, (Object)this.getTabCostItemName(rowData.getDataEntity().getDynamicObject(FIELD_COSTITEM)));
        }
        e.setReloadRows(true);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObject org;
        String name = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        if (F7_TAXPROJECT.equals(name) && (org = (DynamicObject)this.getModel().getValue(F7_CREATEORG)) != null) {
            QFilter orgFilter = new QFilter("taxorg.id", "=", (Object)org.getLong("id"));
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            showParameter.getListFilterParameter().setFilter(orgFilter);
            showParameter.getListFilterParameter().setFilter(statusFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryEntity;
        if (args.getSource() instanceof Save && ((entryEntity = this.getModel().getEntryEntity(ENTRYGRID_NAME)) == null || entryEntity.isEmpty())) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u9879\u76ee\u3002", (String)"CostReportTemplatePlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
    }
}

