/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.realestateRevCost;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mutex.impl.DataMutexImpl;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.user.UserDataServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tdm.common.helper.OrgCheckServiceHelper;
import kd.taxc.tdm.common.util.PermissionUtils;
import kd.taxc.tdm.formplugin.utils.TreeUtils;

public class CostRptListPlugin
extends AbstractListPlugin {
    public void initialize() {
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List<String> hideList = Arrays.asList("enable", "number", "name");
        args.getSchemeFilterColumns().removeIf(column -> hideList.contains(column.getFieldName()));
        args.getCommonFilterColumns().removeIf(column -> hideList.contains(column.getFieldName()));
        args.getFastFilterColumns().removeIf(column -> hideList.contains(column.getFieldName()));
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn column2 : commonFilterColumns) {
            if (!column2.getFieldName().startsWith("createorg.")) continue;
            CommonFilterColumn orgColumn = (CommonFilterColumn)column2;
            String defaultOrgId = this.getDefaultOrgId();
            orgColumn.setDefaultValue(defaultOrgId);
        }
    }

    private String getDefaultOrgId() {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission(hasPermOrgs, true);
        Long orgId = OrgCheckServiceHelper.setDefaultOrg((IFormView)this.getView(), (Long)RequestContext.get().getOrgId(), (DynamicObjectCollection)col);
        return orgId != null ? String.valueOf(orgId) : "0";
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List<String> hideList = Arrays.asList("number", "name", "enable");
        List listColumns = args.getListColumns();
        listColumns.removeIf(column -> hideList.contains(column.getListFieldKey()));
    }

    public void itemClick(ItemClickEvent evt) {
        String operationKey = evt.getItemKey();
        if ("addnew".equals(operationKey)) {
            if (!this.checkAddnewPermission()) {
                return;
            }
            this.openCostReportPage(null);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if ("taxproject_name".equals(args.getFieldName())) {
            args.setCancel(true);
            BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            ListSelectedRow currentRow = hyperLinkClickEvent.getCurrentRow();
            Long primaryKeyValue = (Long)currentRow.getPrimaryKeyValue();
            if (this.checkLock(String.valueOf(primaryKeyValue))) {
                return;
            }
            HashMap<String, Object> customParams = new HashMap<String, Object>(16);
            customParams.put("id", currentRow.getPrimaryKeyValue());
            this.openCostReportPage(customParams);
        }
    }

    protected boolean checkLock(String reportId) {
        if (StringUtil.isEmpty((CharSequence)reportId)) {
            return false;
        }
        DataMutexImpl dataMutex = new DataMutexImpl();
        Map lockInfo = dataMutex.getLockInfo(reportId, "default_netctrl", "tdm_costrpt");
        if (lockInfo != null && !((String)lockInfo.get("userid")).equals(String.valueOf(RequestContext.get().getCurrUserId()))) {
            String username = "";
            TaxResult result = UserDataServiceHelper.queryUserNameByIds((Long)Long.valueOf((String)lockInfo.get("userid")));
            if (result != null && result.isSuccess()) {
                username = (String)result.getData();
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostRptListPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), username));
            return true;
        }
        return false;
    }

    public void openCostReportPage(Map<String, Object> customParams) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("tdm_costreport_page");
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "tdm_costreport_page");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        if ("tdm_costreport_page".equals(event.getActionId())) {
            this.getView().invokeOperation("refresh");
        }
    }

    private boolean checkAddnewPermission() {
        long userId = RequestContext.get().getCurrUserId();
        long currentOrgId = RequestContext.get().getOrgId();
        int hasSpecificPerm = PermissionServiceHelper.checkPermission((Long)userId, (Long)currentOrgId, (String)"tdm", (String)"tdm_costrpt", (String)"47156aff000000ac");
        if (hasSpecificPerm != 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6210\u672c\u62a5\u8868\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostRptListPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

