/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.realestateRevCost;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckBasePlugin;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.tdm.business.realestateRevCost.DevLandInfoBusiness;

public class DevLandInfoEditPlugin
extends AbstractLicenseCheckBasePlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit base = (BasedataEdit)this.getView().getControl("org");
        base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit project = (BasedataEdit)this.getView().getControl("project");
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit stage = (BasedataEdit)this.getView().getControl("stage");
        stage.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterCreateNewData(EventObject e) {
        if (!"true".equals(this.getModel().getContextVariable("isChangingMainOrg"))) {
            Long defaultorg = this.getListViewOrg();
            DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)PermissionUtils.getAllPermOrgs((IFormView)this.getView()), (boolean)true);
            Long org = defaultorg != null ? defaultorg.longValue() : RequestContext.get().getOrgId();
            Long orgid = OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)org, (DynamicObjectCollection)col);
            if (orgid != null) {
                Boolean approve = (Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgIdAndIsTaxpayer((Long)orgid).getData();
                if (!approve.booleanValue()) {
                    this.getModel().setValue("org", null);
                    return;
                }
                this.getModel().setValue("org", (Object)orgid);
                this.setDefaultInfoByOrg(orgid);
            } else {
                return;
            }
        }
    }

    private Long getListViewOrg() {
        try {
            List orgs;
            ControlFilters controlFilters;
            List filter;
            IFormView parentView = this.getView().getParentView();
            if (parentView instanceof IListView && (filter = (controlFilters = ((IListView)parentView).getControlFilters()).getFilter("org.id")) != null && (orgs = filter.stream().filter(a -> a != null).map(a -> a.toString()).filter(b -> b.length() > 0).collect(Collectors.toList())).size() == 1) {
                return Long.parseLong((String)orgs.get(0));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("tbjrmj".equals(operateKey)) {
            Long stage = this.getStage();
            if (stage != null && stage != 0L) {
                BigDecimal areaSum = DevLandInfoBusiness.queryRoomsByStage((Long)stage);
                this.getModel().setValue("dsjrzksmjtb", (Object)areaSum);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"DevLandInfoEditPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5de5\u7a0b\u9879\u76ee\u5206\u671f\u3002", (String)"DevLandInfoEditPlugin_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void setDefaultInfoByOrg(Long orgid) {
        Long project = DevLandInfoBusiness.queryFirstProjectByOrg((Long)orgid);
        this.getModel().setValue("project", (Object)project);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        IDataModel model = this.getModel();
        if ("org".equals(name)) {
            model.beginInit();
            Long orgid = this.getOrgid();
            if (orgid == null || orgid == 0L) {
                model.setValue("project", null);
            } else {
                this.setDefaultInfoByOrg(orgid);
            }
            model.setValue("stage", null);
            this.getModel().deleteEntryData("entryentity");
            model.endInit();
            this.getView().updateView();
        } else if ("project".equals(name)) {
            model.beginInit();
            model.setValue("stage", null);
            this.getModel().deleteEntryData("entryentity");
            model.endInit();
            this.getView().updateView();
        } else if ("stage".equals(name)) {
            model.beginInit();
            this.getModel().deleteEntryData("entryentity");
            model.setValue("yxpjtdcrj", (Object)BigDecimal.ZERO);
            model.setValue("yxpjqqkffy", (Object)BigDecimal.ZERO);
            model.setValue("cqbck", (Object)BigDecimal.ZERO);
            model.setValue("qtzctz", (Object)BigDecimal.ZERO);
            model.setValue("yxdjtdjkhj", (Object)BigDecimal.ZERO);
            model.setValue("dsjrzksmj", (Object)BigDecimal.ZERO);
            model.endInit();
            this.getView().updateView();
            Long stage = this.getStage();
            if (stage != null && stage != 0L) {
                BigDecimal areaSum = DevLandInfoBusiness.queryRoomsByStage((Long)this.getStage());
                this.getModel().setValue("dsjrzksmjtb", (Object)areaSum);
            }
        } else if (Arrays.asList("yxpjtdcrj1", "yxpjqqkffy1", "cqbck1", "qtzctz1", "dsjrzksmj1").contains(name)) {
            if (!"dsjrzksmj1".equals(name)) {
                BigDecimal yxpjtdcrj1 = (BigDecimal)this.getModel().getValue("yxpjtdcrj1", rowIndex);
                BigDecimal yxpjqqkffy1 = (BigDecimal)this.getModel().getValue("yxpjqqkffy1", rowIndex);
                BigDecimal cqbck1 = (BigDecimal)this.getModel().getValue("cqbck1", rowIndex);
                BigDecimal qtzctz1 = (BigDecimal)this.getModel().getValue("qtzctz1", rowIndex);
                BigDecimal yxdjtdjkhj1 = yxpjtdcrj1.add(yxpjqqkffy1).add(cqbck1).add(qtzctz1);
                this.getModel().setValue("yxdjtdjkhj1", (Object)yxdjtdjkhj1, rowIndex);
            }
            this.syncMaxDateAmount(rowIndex);
        } else if ("bgdjsq".equals(name)) {
            this.syncMaxDateAmount(rowIndex);
            Date bgdjsq = (Date)this.getModel().getValue("bgdjsq", rowIndex);
            if (bgdjsq != null) {
                boolean validSeason = DevLandInfoBusiness.validPeriod((Long)this.getOrgid(), (Date)bgdjsq);
                if (!validSeason) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u589e\u503c\u7a0e\u7f34\u7eb3\u671f\u9650\u4e3a\u201c\u6309\u5b63\u7533\u62a5\u201d\uff0c\u8bf7\u9009\u62e91\u6708\u30014\u6708\u30017\u6708\u300110\u6708\u3002", (String)"DevLandInfoEditPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    this.clearBgdjsq(rowIndex, model);
                    return;
                }
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
                for (int i = 0; i < entryentity.size(); ++i) {
                    DynamicObject rowitem = (DynamicObject)entryentity.get(i);
                    Date date = rowitem.getDate("bgdjsq");
                    if (i == rowIndex || !bgdjsq.equals(date)) continue;
                    this.clearBgdjsq(rowIndex, model);
                    return;
                }
            }
        }
    }

    private void clearBgdjsq(int rowIndex, IDataModel model) {
        this.getModel().setValue("bgdjsq", null, rowIndex);
    }

    private void syncMaxDateAmount(int rowIndex) {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        Optional<Date> maxDate = entryentity.stream().map(a -> a.getDate("bgdjsq")).filter(b -> b != null).reduce(BinaryOperator.maxBy(Date::compareTo));
        if (maxDate.isPresent()) {
            Date date = maxDate.get();
            for (DynamicObject dynamicObject : entryentity) {
                Date bgdjsq = dynamicObject.getDate("bgdjsq");
                if (bgdjsq == null || !date.equals(bgdjsq)) continue;
                this.getModel().setValue("yxpjtdcrj", dynamicObject.get("yxpjtdcrj1"), rowIndex);
                this.getModel().setValue("yxpjqqkffy", dynamicObject.get("yxpjqqkffy1"), rowIndex);
                this.getModel().setValue("cqbck", dynamicObject.get("cqbck1"), rowIndex);
                this.getModel().setValue("qtzctz", dynamicObject.get("qtzctz1"), rowIndex);
                this.getModel().setValue("yxdjtdjkhj", dynamicObject.get("yxdjtdjkhj1"), rowIndex);
                this.getModel().setValue("dsjrzksmj", dynamicObject.get("dsjrzksmj1"), rowIndex);
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if (e.getEntryProp().getName().equals("entryentity")) {
            int[] rowIndexs = e.getRowIndexs();
            Long orgid = this.getOrgid();
            for (int rowIndex : rowIndexs) {
                boolean declared;
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
                Date bgdjsq = rowEntity.getDate("bgdjsq");
                Long id = rowEntity.getLong("id");
                if (id == null || id <= 0L || !(declared = DevLandInfoBusiness.isDeclared((Date)bgdjsq, (Long)orgid, (Boolean)false))) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u671f\u6570\u636e\u5df2\u7533\u62a5\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DevLandInfoEditPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (name.startsWith("org")) {
            List permOrgs = DevLandInfoBusiness.getPermOrgs((IFormView)this.getView());
            QFilter qFilter2 = new QFilter("id", "in", (Object)permOrgs);
            beforeF7SelectEvent.getCustomQFilters().add(qFilter2);
        } else if (name.startsWith("stage")) {
            Long projectId = this.getProjectId();
            if (projectId == null || projectId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u9879\u76ee\u3002", (String)"DevLandInfoEditPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter qFilter3 = new QFilter("taxproject", "=", (Object)projectId);
            beforeF7SelectEvent.getCustomQFilters().add(qFilter3);
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u5de5\u7a0b\u9879\u76ee\u5206\u671f", (String)"DevLandInfoEditPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            listShowParameter.setShowApproved(false);
        } else if (name.startsWith("project")) {
            Long orgid = this.getOrgid();
            if (orgid == null || orgid == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"DevLandInfoEditPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter qFilter3 = new QFilter("taxorg", "=", (Object)orgid);
            beforeF7SelectEvent.getCustomQFilters().add(qFilter3);
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.getTreeFilterParameter().getQFilters().add(new QFilter("number", "in", (Object)"001"));
            listShowParameter.getListFilterParameter().setFilter(new QFilter("group.number", "=", (Object)"001"));
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("focusNodeId", (Object)"1888314377338207232");
        }
    }

    private Long getOrgid() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        return org == null ? null : Long.valueOf(org.getLong("id"));
    }

    private Long getProjectId() {
        DynamicObject houseproject = (DynamicObject)this.getModel().getValue("project");
        return houseproject == null ? null : Long.valueOf(houseproject.getLong("id"));
    }

    private Long getStage() {
        DynamicObject houseproject = (DynamicObject)this.getModel().getValue("stage");
        return houseproject == null ? null : Long.valueOf(houseproject.getLong("id"));
    }
}

