/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.realestateRevCost;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.room.RoomDataServiceHelper;
import kd.taxc.tdm.common.bean.RoomRevenueInfo;

public class RoomRevenueImportPlugin
extends BatchImportPlugin {
    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        String importtype = (String)this.ctx.getOption().get("importtype");
        Iterator<ImportBillData> it = billdatas.iterator();
        ArrayList<RoomRevenueInfo> importRoomDataList = new ArrayList<RoomRevenueInfo>(billdatas.size());
        HashSet<String> taxorgNumberSet = new HashSet<String>(16);
        HashSet<String> taxprojectNumberSet = new HashSet<String>(16);
        HashSet<String> stageNumberSet = new HashSet<String>(16);
        HashSet<String> buildingNumberSet = new HashSet<String>(16);
        HashSet<String> roomNumberSet = new HashSet<String>(16);
        while (it.hasNext()) {
            JSONObject versionJsonObject;
            ImportBillData data = it.next();
            int index = data.getStartIndex();
            JSONObject taxorg = data.getData().getJSONObject("taxorg");
            String taxorgNumber = taxorg.getString("number");
            String taxprojectnumber = data.getData().getString("taxprojectnumber");
            String stagenumber = data.getData().getString("stagenumber");
            String buildingnumber = data.getData().getString("buildingnumber");
            JSONObject room = data.getData().getJSONObject("room");
            String roomnumber = room == null ? "" : room.getString("number");
            String versionNumber = "";
            if (data.getData().containsKey((Object)"version") && (versionJsonObject = data.getData().getJSONObject("version")).containsKey((Object)"number")) {
                versionNumber = versionJsonObject.getString("number");
            }
            if (StringUtils.isEmpty((String)taxorgNumber) || StringUtils.isEmpty((String)taxprojectnumber) || StringUtils.isEmpty((String)stagenumber) || StringUtils.isEmpty((String)buildingnumber) || StringUtils.isEmpty((String)roomnumber)) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u7f16\u7801\u3001\u7a0e\u52a1\u9879\u76ee\u7f16\u7801\u3001\u5de5\u7a0b\u5206\u671f\u7f16\u7801\u3001\u697c\u680b\u7f16\u7801\u548c\u623f\u95f4\u7f16\u7801\u5747\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RoomRevenueImportPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0])).fail();
                it.remove();
                continue;
            }
            RoomRevenueInfo roomData = new RoomRevenueInfo(taxorgNumber, taxprojectnumber, stagenumber, buildingnumber, roomnumber, versionNumber);
            importRoomDataList.add(roomData);
            taxorgNumberSet.add(taxorgNumber);
            taxprojectNumberSet.add(taxprojectnumber);
            stageNumberSet.add(stagenumber);
            buildingNumberSet.add(buildingnumber);
            roomNumberSet.add(roomnumber);
        }
        if (!billdatas.isEmpty()) {
            QFilter roomidFilter;
            DynamicObjectCollection roomrevenueCollection;
            DynamicObjectCollection sysRoomDataCollection = null;
            TaxResult queryRoomsTaxResult = RoomDataServiceHelper.queryRooms(taxorgNumberSet, taxprojectNumberSet, stageNumberSet, buildingNumberSet, roomNumberSet);
            if (queryRoomsTaxResult.isSuccess() && !CollectionUtils.isEmpty((Collection)((Collection)queryRoomsTaxResult.getData()))) {
                sysRoomDataCollection = (DynamicObjectCollection)queryRoomsTaxResult.getData();
            }
            HashSet<Long> roomidSet = new HashSet<Long>(16);
            if (sysRoomDataCollection != null && !sysRoomDataCollection.isEmpty()) {
                Map sysRoomDataMap = new HashMap(sysRoomDataCollection.size());
                sysRoomDataMap = sysRoomDataCollection.stream().collect(Collectors.toMap(this::getRoomPrimaryKey, roomdata -> roomdata.getLong("id"), (existing, replacement) -> existing, HashMap::new));
                if (!sysRoomDataMap.isEmpty()) {
                    Iterator iterator = importRoomDataList.iterator();
                    int count = 0;
                    while (iterator.hasNext()) {
                        RoomRevenueInfo roomData = (RoomRevenueInfo)iterator.next();
                        String roomString = roomData.getRoomString();
                        if (sysRoomDataMap.containsKey(roomString)) {
                            roomData.setRoomId((Long)sysRoomDataMap.get(roomString));
                            roomidSet.add(roomData.getRoomId());
                        } else {
                            iterator.remove();
                            logger.log(Integer.valueOf(billdatas.get(count).getStartIndex()), ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u4e0e\u7a0e\u52a1\u7ec4\u7ec7\u7f16\u7801\u3001\u7a0e\u52a1\u9879\u76ee\u7f16\u7801\u3001\u5de5\u7a0b\u5206\u671f\u7f16\u7801\u3001\u697c\u680b\u7f16\u7801\u548c\u623f\u95f4\u7f16\u7801\u5339\u914d\u7684\u623f\u95f4\u57fa\u7840\u4fe1\u606f\u3002", (String)"RoomRevenueImportPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0])).fail();
                            billdatas.remove(count);
                            --count;
                        }
                        ++count;
                    }
                }
            }
            if (!roomidSet.isEmpty() && (roomrevenueCollection = QueryServiceHelper.query((String)"tdm_room_revenue", (String)"id,room.id,version.number", (QFilter[])new QFilter[]{roomidFilter = new QFilter("room.id", "in", roomidSet)})) != null && !roomrevenueCollection.isEmpty()) {
                Map sysRoomrevenueDataMap = new HashMap(roomrevenueCollection.size());
                sysRoomrevenueDataMap = roomrevenueCollection.stream().collect(Collectors.toMap(this::getRoomRevenuePrimaryKey, roomrevenuedata -> roomrevenuedata.getLong("id"), (existing, replacement) -> existing, HashMap::new));
                int count = 0;
                for (RoomRevenueInfo roomData : importRoomDataList) {
                    String roomRevenueString = roomData.getRoomRevenueString();
                    if (sysRoomrevenueDataMap.containsKey(roomRevenueString)) {
                        if ("new".equals(importtype)) {
                            logger.log(Integer.valueOf(billdatas.get(count).getStartIndex()), ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7684\u6570\u636e(\u7a0e\u52a1\u7ec4\u7ec7\u3001\u623f\u95f4\u7f16\u7801\u3001\u7a0e\u52a1\u9879\u76ee\u3001\u5de5\u7a0b\u9879\u76ee\u5206\u671f\u3001\u697c\u680b\u540d\u79f0\u3001\u7248\u672c\u90fd\u76f8\u540c)\u3002", (String)"RoomRevenueImportPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0])).fail();
                            billdatas.remove(count);
                            continue;
                        }
                        billdatas.get(count).getData().put("id", sysRoomrevenueDataMap.get(roomRevenueString));
                    }
                    JSONObject roomJson = new JSONObject();
                    roomJson.put("importprop", (Object)"id");
                    roomJson.put("id", (Object)roomData.getRoomId());
                    billdatas.get(count).getData().put("room", (Object)roomJson);
                    if (StringUtils.isEmpty((String)roomData.getVersionNumber())) {
                        billdatas.get(count).getData().put("version", null);
                    }
                    ++count;
                }
            }
        }
    }

    protected boolean isForceBatch() {
        return true;
    }

    public String getDefaultKeyFields() {
        return "room,version";
    }

    private String getRoomPrimaryKey(DynamicObject roomData) {
        return String.format("%1$s_%2$s_%3$s_%4$s_%5$s", roomData.getString("taxorg.number"), roomData.getString("taxproject.number"), roomData.getString("stage.number"), roomData.getString("building.number"), roomData.getString("number"));
    }

    private String getRoomRevenuePrimaryKey(DynamicObject roomRevenueData) {
        return String.format("%1$s_%2$s", roomRevenueData.getLong("room.id"), roomRevenueData.getString("version.number") == null ? "" : roomRevenueData.getString("version.number"));
    }
}

