/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.realestateRevCost;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import org.apache.commons.lang3.ObjectUtils;

public class RoomRevenueListPlugin
extends AbstractListPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List<String> hideList = Arrays.asList("billno", "createtime", "billstatus", "creator.number", "creator.name", "modifier.number", "modifier.name", "modifytime", "auditor.number", "auditor.name", "auditdate");
        args.getSchemeFilterColumns().removeIf(column -> hideList.contains(column.getFieldName()));
        args.getCommonFilterColumns().removeIf(column -> hideList.contains(column.getFieldName()));
        args.getFastFilterColumns().removeIf(column -> hideList.contains(column.getFieldName()));
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List<String> hideList = Arrays.asList("billno", "billstatus");
        List listColumns = args.getListColumns();
        listColumns.removeIf(column -> hideList.contains(column.getListFieldKey()));
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        super.afterQueryOfExport(e);
        DynamicObject[] rows = e.getQueryValues();
        if (ObjectUtils.isNotEmpty((Object)rows)) {
            Stream.of(rows).forEach(row -> {
                DynamicObject room = row.getDynamicObject("room");
                row.set("taxprojectnumber", Optional.ofNullable(room.getDynamicObject("taxproject")).map(taxproject -> taxproject.getString("number")).orElse(null));
                row.set("stagenumber", Optional.ofNullable(room.getDynamicObject("stage")).map(stage -> stage.getString("number")).orElse(null));
                row.set("buildingnumber", Optional.ofNullable(room.getDynamicObject("building")).map(building -> building.getString("number")).orElse(null));
            });
        }
    }
}

