/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.rightuse;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class RightUseAssetEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit taxationsys = (BasedataEdit)this.getControl("taxationsys");
        BasedataEdit taxarea = (BasedataEdit)this.getControl("taxarea");
        BasedataEdit taxorg = (BasedataEdit)this.getControl("taxorg");
        BasedataEdit accountorg = (BasedataEdit)this.getControl("accountorg");
        taxationsys.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        taxarea.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        taxorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        accountorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("period", (Object)DateUtils.addMonth((Date)DateUtils.getFirstDateOfMonth((Date)new Date()), (int)-1));
        Long accountorgId = Optional.ofNullable((DynamicObject)this.getModel().getValue("accountorg")).map(s -> s.getLong("id")).orElseGet(() -> 0L);
        TaxResult taxcOrgIdsRs = OrgRelationDataServiceHelper.getTaxcOrgIdByAccountingOrgId((Long)accountorgId);
        List datas = (List)taxcOrgIdsRs.getData();
        if (!CollectionUtils.isEmpty((Collection)datas)) {
            DynamicObjectCollection bastaxTaxorg;
            this.getModel().setValue("taxorg", ((List)taxcOrgIdsRs.getData()).get(0));
            DynamicObject taxorg = (DynamicObject)this.getModel().getValue("taxorg");
            if (taxorg != null && (bastaxTaxorg = RightUseAssetEditPlugin.getBastaxTaxorg(taxorg.getLong("id"))) != null && bastaxTaxorg.size() == 1) {
                this.getModel().setValue("taxationsys", ((DynamicObject)bastaxTaxorg.get(0)).get("entryentity.entry_taxationsys"));
                Object value = this.getModel().getValue("taxationsys");
                if (value != null) {
                    DynamicObject country = ((DynamicObject)value).getDynamicObject("countryid");
                    this.getModel().setValue("taxarea", (Object)this.getCountryByName(country.getString("name")));
                }
            }
        }
    }

    public static DynamicObjectCollection getBastaxTaxorg(Long orgId) {
        DynamicObjectCollection object = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org,taxpayer,istaxpayer,isvirtual,unifiedsocialcode,entryentity.entry_taxationsys,entryentity.entry_taxarea", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("entryentity.entry_istaxpayer", "=", (Object)true)});
        return object;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        String name = e.getProperty().getName();
        if ("period".equals(name) && (newValue = e.getChangeSet()[0].getNewValue()) != null) {
            this.getModel().setValue("period", (Object)DateUtils.getFirstDateOfMonth((Date)((Date)newValue)));
        }
        if ("taxorg".equals(name)) {
            DynamicObject taxorg = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (taxorg != null) {
                DynamicObjectCollection bastaxTaxorg = RightUseAssetEditPlugin.getBastaxTaxorg(taxorg.getLong("id"));
                if (bastaxTaxorg != null && bastaxTaxorg.size() == 1) {
                    this.getModel().setValue("taxationsys", ((DynamicObject)bastaxTaxorg.get(0)).get("entryentity.entry_taxationsys"));
                    Object value = this.getModel().getValue("taxationsys");
                    if (value != null) {
                        DynamicObject country = ((DynamicObject)value).getDynamicObject("countryid");
                        this.getModel().setValue("taxarea", (Object)this.getCountryByName(country.getString("name")));
                    }
                } else {
                    this.getModel().setValue("taxationsys", null);
                    this.getModel().setValue("taxarea", null);
                }
            } else {
                this.getModel().setValue("taxationsys", null);
                this.getModel().setValue("taxarea", null);
            }
        }
        if ("taxationsys".equals(name)) {
            newValue = e.getChangeSet()[0].getNewValue();
            if (newValue == null) {
                this.getModel().setValue("taxarea", null);
            } else {
                DynamicObject country = ((DynamicObject)newValue).getDynamicObject("countryid");
                this.getModel().setValue("taxarea", (Object)this.getCountryByName(country.getString("name")));
            }
        }
    }

    private Long getCountryByName(String name) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bastax_taxarea", (String)"id,group.id", (QFilter[])new QFilter[]{new QFilter("country.name", "=", (Object)name), new QFilter("enable", "=", (Object)"1")});
        return !CollectionUtils.isEmpty((Collection)query) && query.size() == 1 ? Long.valueOf(((DynamicObject)query.get(0)).getLong("group.id")) : null;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        QFilter filter;
        ListShowParameter formShowParameter;
        if ("taxorg".equals(evt.getProperty().getName())) {
            Object accountorg = this.getModel().getValue("accountorg");
            if (Objects.isNull(accountorg)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"RightUseAssetEditPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            long accountOrgId = ((DynamicObject)accountorg).getLong("id");
            TaxResult taxcOrgIdByAccountingOrgIds = OrgRelationDataServiceHelper.getTaxcOrgIdByAccountingOrgId((Long)accountOrgId);
            List ids = (List)taxcOrgIdByAccountingOrgIds.getData();
            if (!taxcOrgIdByAccountingOrgIds.isSuccess() && CollectionUtils.isEmpty((Collection)ids)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u59d4\u6258\u7684\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"RightUseAssetEditPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            QFilter accountOrgFilter = new QFilter("id", "in", (Object)ids);
            evt.setCustomQFilters(Arrays.asList(enableFilter, accountOrgFilter));
        }
        if ("taxarea".equals(evt.getProperty().getName())) {
            DynamicObject taxationsys = (DynamicObject)this.getModel().getValue("taxationsys");
            if (taxationsys == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6536\u5236\u5ea6\u3002", (String)"RightUseAssetEditPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject country = taxationsys.getDynamicObject("countryid");
            formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bastax_taxarea", (String)"id,group.id", (QFilter[])new QFilter[]{new QFilter("country.name", "=", (Object)country.getString("name")), new QFilter("enable", "=", (Object)"1")});
            if (!CollectionUtils.isEmpty((Collection)query)) {
                filter = new QFilter("id", "in", (Object)query.stream().map(s -> s.getLong("group.id")).toArray());
                formShowParameter.getListFilterParameter().setFilter(filter);
            }
        }
        if ("taxationsys".equals(evt.getProperty().getName())) {
            DynamicObject taxorg = (DynamicObject)this.getModel().getValue("taxorg");
            if (taxorg == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"RightUseAssetEditPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Long orgid = taxorg.getLong("id");
            formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObjectCollection bastaxTaxorg = RightUseAssetEditPlugin.getBastaxTaxorg(orgid);
            if (!CollectionUtils.isEmpty((Collection)bastaxTaxorg)) {
                filter = new QFilter("id", "in", (Object)bastaxTaxorg.stream().map(s -> s.getLong("entryentity.entry_taxationsys")).toArray());
                formShowParameter.getListFilterParameter().setFilter(filter);
            }
        }
    }
}

