/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.rightuse;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class RightUseAssetImportPlugin
extends BatchImportPlugin {
    public String getDefaultKeyFields() {
        return "accountorg,taxorg,billno,lessor";
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            ImportBillData importBillData = it.next();
            JSONObject rowData = importBillData.getData();
            String orgNumber = rowData.getJSONObject("taxorg").getString("number");
            String accountOrgNumber = rowData.getJSONObject("accountorg").getString("number");
            String taxationsysNumber = rowData.getJSONObject("taxationsys").getString("number");
            String taxareaNumber = rowData.getJSONObject("taxarea").getString("number");
            String period = rowData.getString("period");
            String start = rowData.getString("start");
            String end = rowData.getString("end");
            DynamicObject accountOrg = this.getAccountOrg(accountOrgNumber);
            if (accountOrg == null) {
                logger.log(Integer.valueOf(importBillData.getStartIndex()), String.format(ResManager.loadKDString((String)"\u7f16\u7801\uff1a%s\u4e0d\u662f\u6838\u7b97\u7ec4\u7ec7\u6216\u72b6\u6001\u975e\u53ef\u7528\u3002", (String)"RightUseAssetImportPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), accountOrgNumber)).fail();
                it.remove();
                continue;
            }
            DynamicObject taxOrg = this.getTaxOrg(orgNumber);
            if (taxOrg == null) {
                logger.log(Integer.valueOf(importBillData.getStartIndex()), String.format(ResManager.loadKDString((String)"\u7f16\u7801\uff1a%s\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u5f15\u5165\u6570\u636e\u3002", (String)"RightUseAssetImportPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), orgNumber)).fail();
                it.remove();
                continue;
            }
            TaxResult taxcOrgIdsRs = OrgRelationDataServiceHelper.getTaxcOrgIdByAccountingOrgId((Long)accountOrg.getLong("id"));
            if (CollectionUtils.isEmpty((Collection)((Collection)taxcOrgIdsRs.getData())) || ((List)taxcOrgIdsRs.getData()).contains(taxOrg.getLong("id"))) {
                logger.log(Integer.valueOf(importBillData.getStartIndex()), ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0e\u7a0e\u52a1\u7ec4\u7ec7\u5173\u7cfb\u4e0d\u5339\u914d\uff0c\u8bf7\u67e5\u770b\u4e1a\u52a1\u5355\u5143\u95f4\u534f\u4f5c\u5173\u7cfb\u540e\u91cd\u65b0\u7ef4\u62a4\u3002", (String)"RightUseAssetImportPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0])).fail();
                it.remove();
                continue;
            }
            DynamicObject object = QueryServiceHelper.queryOne((String)"bd_taxationsys", (String)"countryid.name as name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)taxationsysNumber), new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C")});
            if (object == null) {
                logger.log(Integer.valueOf(importBillData.getStartIndex()), ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u7cfb\u7edf\u4e0d\u5b58\u5728\u3002", (String)"RightUseAssetImportPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0])).fail();
                it.remove();
                continue;
            }
            boolean exists = QueryServiceHelper.exists((String)"bastax_taxarea", (QFilter[])new QFilter[]{new QFilter("country.name", "=", (Object)object.getString("name")), new QFilter("enable", "=", (Object)"1"), new QFilter("group.number", "=", (Object)taxareaNumber)});
            if (!exists) {
                logger.log(Integer.valueOf(importBillData.getStartIndex()), ResManager.loadKDString((String)"\u7a0e\u6536\u8f96\u533a\u4e0e\u7a0e\u6536\u5236\u5ea6\u7684\u56fd\u5bb6\u5730\u533a\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", (String)"RightUseAssetImportPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0])).fail();
                it.remove();
                continue;
            }
            try {
                Date perioddate = DateUtils.stringToDate2((String)period);
                Date startdate = DateUtils.stringToDate2((String)start);
                Date enddate = DateUtils.stringToDate2((String)end);
                rowData.put("period", (Object)DateUtils.getFirstDateOfMonth((Date)perioddate));
                rowData.put("start", (Object)startdate);
                rowData.put("end", (Object)enddate);
            }
            catch (Exception e) {
                logger.log(Integer.valueOf(importBillData.getStartIndex()), e.getMessage()).fail();
                it.remove();
            }
        }
        return super.save(rowdatas, logger);
    }

    private DynamicObject getAccountOrg(String number) {
        return QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("fisaccounting", "=", (Object)true), new QFilter("enable", "=", (Object)"1")});
    }

    private DynamicObject getTaxOrg(String number) {
        return (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgNum((String)number).getData();
    }
}

