/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.service;

import java.util.ArrayList;
import java.util.List;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.taxc.tdm.common.util.DBUtils;

public class AccountSummaryService {
    private static final String SELECT_ACCOUNT = "select m.fid,m.faccountcode,m.fsourcesystem,m.faccounttableid,n.fname from t_tdm_account_code m left join t_tdm_account_code_l n on m.fid=n.fid and n.flocaleid='zh_CN' where n.fname is not null ";
    private static final String SELECT_ACCOUNTSUMMARY = "select j.fid,j.faccountcode,j.fsourcesystem,j.faccounttableid,i.fname from t_tdm_account_summary j left join t_tdm_account_summary_l i on j.fid=i.fid and i.flocaleid='zh_CN'";
    private static final String SELECT_FIELD = "fid,faccountcode,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,flongnumber,flevel,fisleaf,fparentid,forgid,faccountgrade,faccounttype,fbalancetype,fcurrencyid,faccounttable,faccounttableid,fsourcesystem";
    private static final String SELECT_LANGFIELD = "fpkid, fid, flocaleid, fname";
    private static final String SELECT_UPDATEID = "select a.fid from t_tdm_account_summary a,t_tdm_account_code b where a.fid=b.fid and (a.fmodifytime < b.fmodifytime or (b.fmodifytime is not null and a.fmodifytime is null)) ";

    public static void insertAccount() {
        try (TXHandle h = TX.requiresNew();){
            try {
                AccountSummaryService.updateAccountData();
                StringBuilder updateSql = new StringBuilder();
                updateSql.append("insert into t_tdm_account_summary (").append(SELECT_FIELD).append(") ");
                updateSql.append("select ").append(SELECT_FIELD).append(" from t_tdm_account_code where fid in (select min(c.fid) from (");
                updateSql.append("select a.fid,a.faccountcode,a.fsourcesystem,a.faccounttableid,a.fname from (").append(SELECT_ACCOUNT);
                updateSql.append(") a where not exists (select 1 from (").append(SELECT_ACCOUNTSUMMARY);
                updateSql.append(") b where a.faccountcode=b.faccountcode and a.fsourcesystem = b.fsourcesystem and a.faccounttableid=b.faccounttableid and a.fname=b.fname)");
                updateSql.append(") c group by c.faccountcode,c.fsourcesystem,c.faccounttableid,c.fname)");
                DBUtils.execute((String)updateSql.toString());
                StringBuilder updateLang = new StringBuilder();
                updateLang.append("insert into t_tdm_account_summary_l (").append(SELECT_LANGFIELD).append(") ");
                updateLang.append("select ").append(SELECT_LANGFIELD).append(" from t_tdm_account_code_l where fid in (select fid from t_tdm_account_summary) and fid not in (select fid from t_tdm_account_summary_l)");
                DBUtils.execute((String)updateLang.toString());
            }
            catch (Throwable t) {
                h.markRollback();
                throw t;
            }
        }
    }

    private static void updateAccountData() {
        List columnList = DBUtils.query((String)SELECT_UPDATEID);
        if (columnList != null && columnList.size() > 0) {
            ArrayList ids = new ArrayList();
            columnList.stream().forEach(column -> ids.add("'" + column.get("FID") + "'"));
            String idStr = String.join((CharSequence)",", ids);
            StringBuilder delSql = new StringBuilder();
            delSql.append("delete from t_tdm_account_summary where fid in (").append(idStr).append(") ");
            DBUtils.execute((String)delSql.toString());
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("insert into t_tdm_account_summary (").append(SELECT_FIELD).append(") ");
            insertSql.append("select ").append(SELECT_FIELD).append(" from t_tdm_account_code where fid in (").append(idStr).append(") ");
            DBUtils.execute((String)insertSql.toString());
            StringBuilder delLangSql = new StringBuilder();
            delLangSql.append("delete from t_tdm_account_summary_l where fid in (").append(idStr).append(") ");
            DBUtils.execute((String)delLangSql.toString());
            StringBuilder insertLangSql = new StringBuilder();
            insertLangSql.append("insert into t_tdm_account_summary_l (").append(SELECT_LANGFIELD).append(") ");
            insertLangSql.append("select ").append(SELECT_LANGFIELD).append(" from t_tdm_account_code_l where fid in (").append(idStr).append(") ");
            DBUtils.execute((String)insertLangSql.toString());
        }
    }
}

