/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.stamptax;

import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.tdm.common.util.DateUtils;

public class StampTaxVoucherPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit vouchertype = (BasedataEdit)this.getView().getControl("vouchertype");
        vouchertype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit subvouchertype = (BasedataEdit)this.getView().getControl("subvouchertype");
        subvouchertype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        DynamicObject vouchertype = (DynamicObject)this.getModel().getValue("vouchertype");
        if (vouchertype != null) {
            BasedataEdit subvouchertypeEdit = (BasedataEdit)this.getControl("subvouchertype");
            subvouchertypeEdit.setMustInput("02001".equals(vouchertype.getString("number")));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (name.equals("taxmoneyperiod")) {
            Date endDate = DateUtils.stringToDate((String)"2022-07-01 00:00:00");
            ChangeData[] changeSet = e.getChangeSet();
            Date newValue = (Date)changeSet[0].getNewValue();
            Date oldValue = (Date)changeSet[0].getOldValue();
            if (null == newValue || null == oldValue || endDate.compareTo(newValue) <= 0 && endDate.compareTo(oldValue) > 0 || endDate.compareTo(oldValue) <= 0 && endDate.compareTo(newValue) > 0) {
                this.getModel().setValue("vouchertype", (Object)"");
                this.getView().updateView();
            }
        } else if ("vouchertype".equals(name)) {
            ChangeData[] changeSet = e.getChangeSet();
            DynamicObject newValue = (DynamicObject)changeSet[0].getNewValue();
            if (newValue == null) {
                this.getModel().setValue("subvouchertype", null);
            } else {
                String number = newValue.getString("number");
                BasedataEdit subvouchertypeEdit = (BasedataEdit)this.getControl("subvouchertype");
                subvouchertypeEdit.setMustInput("02001".equals(number));
                DynamicObject subvouchertype = (DynamicObject)this.getModel().getValue("subvouchertype");
                if (subvouchertype != null && !StringUtils.equals((CharSequence)subvouchertype.getString("parent.number"), (CharSequence)number)) {
                    this.getModel().setValue("subvouchertype", null);
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
        ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
        if ("vouchertype".equals(event.getProperty().getName())) {
            Date endDate = DateUtils.stringToDate((String)"2022-07-01 00:00:00");
            Date taxmoneyperiod = (Date)this.getModel().getValue("taxmoneyperiod");
            if (null == taxmoneyperiod) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6b3e\u5c5e\u671f", (String)"StampTaxVoucherPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            if (taxmoneyperiod.compareTo(endDate) >= 0) {
                listFilterParameter.setFilter(new QFilter("longnumber", "like", (Object)"1%").and(new QFilter("isleaf", "=", (Object)"1")));
            } else {
                listFilterParameter.setFilter(new QFilter("longnumber", "like", (Object)"2%").and(new QFilter("isleaf", "=", (Object)"1")));
            }
        } else if ("subvouchertype".equals(event.getProperty().getName())) {
            DynamicObject vouchertype = (DynamicObject)this.getModel().getValue("vouchertype");
            if (vouchertype == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e94\u7a0e\u51ed\u8bc1\u79cd\u7c7b", (String)"StampTaxVoucherPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            String number = vouchertype.getString("number");
            listFilterParameter.setFilter(new QFilter("parent.number", "=", (Object)number));
        }
    }
}

