/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.taxSourceInfo;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tdm.common.metadata.MetadataUtil;
import kd.taxc.tdm.common.util.DBUtils;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.formplugin.utils.FcsByHireSourceInfoUtils;
import org.apache.commons.lang.StringUtils;

public class FcsByHireSourceAddPlugin
extends AbstractFormPlugin {
    private static final String RENTAL_EDIT_ENTITY_NAME = "entryentity";
    private static final String CONTRACT_INCOME = "rentincome";
    private static final String EACH_INCOME = "eachincome";
    private static final String START = "startdate";
    private static final String END = "enddate";
    private static final String MONTH_NO = "monthnumber";
    private static final String FCS_BY_HIRE_LIMIT = "fcsbyhirelimit";
    private static final String MONTH = "month";
    private static final String SEASON = "season";
    private static final String YEAR = "year";
    private static final String HALF_YEAR = "halfyear";
    private static final String SKSSQ = "skssq";
    private static final String RENT = "rent";
    private static final String ORG = "org";
    private static final int MONTH_VALUE = 1;
    private static final int SEASON_VALUE = 3;
    private static final int YEAR_VALUE = 12;
    private static final int HALF_MONTH_VALUE = 15;
    private static final int MINUS_HALF_MONTH_VALUE = -15;
    private static final int HALF_YEAR_VALUE = 6;
    private static final int DEFAULT_VALUE = 0;
    private static final String BT_NOK = "btnok";
    private static final String VIEWANDMODIFY = "viewandmodify";
    private static final String TCRET_DETAIL_TZ_DIALOG = "tcret_detail_tz_dialog";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BT_NOK});
        this.addClickListeners(new String[]{VIEWANDMODIFY});
        this.addClickListeners(new String[]{"flexpanelap1"});
    }

    public void initialize() {
        super.initialize();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String openModel = (String)customParams.get("openModel");
        if ("edit".equals(openModel)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{START});
            this.getView().setEnable(Boolean.FALSE, new String[]{END});
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String openModel = (String)customParams.get("openModel");
        if ("edit".equals(openModel)) {
            JSONObject data = (JSONObject)customParams.get("data");
            IDataModel model = this.getModel();
            model.setValue("hirearea", data.get((Object)"hirearea"));
            model.setValue(CONTRACT_INCOME, data.get((Object)CONTRACT_INCOME));
            model.setValue(START, data.get((Object)START));
            model.setValue(END, data.get((Object)END));
            model.setValue("hiretaxcode", data.get((Object)"hiretaxcode"));
            model.setValue("tenantry", data.get((Object)"tenantry"));
            model.setValue(MONTH_NO, data.get((Object)"rentmonth"));
            model.setValue(EACH_INCOME, data.get((Object)"eachrentincome"));
            JSONArray subentryentity = data.getJSONArray("subentryentity");
            if (subentryentity != null && subentryentity.size() > 0) {
                subentryentity.sort(Comparator.comparing(s -> ((JSONObject)s).getString("skperiod")));
                model.beginInit();
                model.batchCreateNewEntryRow(RENTAL_EDIT_ENTITY_NAME, subentryentity.size());
                int index = 0;
                for (Object obj : subentryentity) {
                    JSONObject sub = (JSONObject)obj;
                    model.setValue(SKSSQ, sub.get((Object)"skperiod"), index);
                    model.setValue(RENT, sub.get((Object)"rental"), index);
                    ++index;
                }
                model.endInit();
                this.getView().updateView(RENTAL_EDIT_ENTITY_NAME);
            }
        } else {
            long id = DBUtils.getLongId((String)"t_tdm_house_rental_entity");
            this.getPageCache().put("rentid", String.valueOf(id));
        }
    }

    public void beforeBindData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object adjustsumamount = customParams.get("adjustsumamount");
        if (null != adjustsumamount) {
            this.getModel().setValue(CONTRACT_INCOME, adjustsumamount);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        LocalDate localDate;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        IDataModel model = this.getModel();
        String limit = (String)customParams.get(FCS_BY_HIRE_LIMIT);
        Object start = model.getValue(START);
        Object end = model.getValue(END);
        String name = e.getProperty().getName();
        int taxLimitNo = this.getTaxLimitNo(limit);
        BigDecimal income = (BigDecimal)this.getModel().getValue(CONTRACT_INCOME);
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        if (START.equals(name)) {
            Date startdate = (Date)newValue;
            localDate = FcsByHireSourceInfoUtils.date2LocalDate(startdate);
            if (startdate != null && !startdate.equals(DateUtils.getFirstDateOfMonth((Date)startdate))) {
                this.getModel().setValue(START, (Object)DateUtils.getFirstDateOfMonth((Date)startdate));
                return;
            }
            if (!FcsByHireSourceInfoUtils.startBeforeEnd(localDate, FcsByHireSourceInfoUtils.date2LocalDate((Date)this.getModel().getValue(END)))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u79df\u91d1\u6240\u5c5e\u79df\u8d41\u671f\u8d77\u5fc5\u987b\u5c0f\u4e8e\u7533\u62a5\u79df\u91d1\u6240\u5c5e\u79df\u8d41\u671f\u6b62\u3002", (String)"FcsByHireSourceAddPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return;
            }
            String area = this.findarea(customParams, startdate);
            this.getModel().setValue("hirearea", (Object)area);
            if (startdate != null && end != null) {
                this.updateMonthNo(startdate, (Date)end);
            }
            this.updateEachIncome(income, (Integer)this.getModel().getValue(MONTH_NO), taxLimitNo);
            this.showCurrentYearValue(limit, start, end);
        }
        if (END.equals(name)) {
            Date enddate = (Date)newValue;
            localDate = FcsByHireSourceInfoUtils.date2LocalDate(enddate);
            if (enddate != null && !enddate.equals(DateUtils.getLastDateOfMonth2((Date)enddate))) {
                this.getModel().setValue(END, (Object)DateUtils.getLastDateOfMonth2((Date)enddate));
                return;
            }
            if (!FcsByHireSourceInfoUtils.startBeforeEnd(FcsByHireSourceInfoUtils.date2LocalDate((Date)this.getModel().getValue(START)), localDate)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u79df\u91d1\u6240\u5c5e\u79df\u8d41\u671f\u8d77\u5fc5\u987b\u5c0f\u4e8e\u7533\u62a5\u79df\u91d1\u6240\u5c5e\u79df\u8d41\u671f\u6b62\u3002", (String)"FcsByHireSourceAddPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (start != null && enddate != null) {
                this.updateMonthNo((Date)start, enddate);
            }
            this.updateEachIncome(income, (Integer)this.getModel().getValue(MONTH_NO), taxLimitNo);
            this.showCurrentYearValue(limit, start, end);
        }
        if (CONTRACT_INCOME.equals(name)) {
            this.updateEachIncome(newValue == null ? BigDecimal.ZERO : (BigDecimal)newValue, (Integer)this.getModel().getValue(MONTH_NO), taxLimitNo);
            this.showCurrentYearValue(limit, start, end);
        }
        if (MONTH_NO.equals(name)) {
            this.updateEachIncome(income, (Integer)newValue, taxLimitNo);
        }
    }

    private String findarea(Map<String, Object> customParams, Date startdate) {
        QFilter dateFilter = new QFilter("rententryentity.enddate", "<=", (Object)startdate);
        JSONArray entrydatelist = (JSONArray)customParams.get("entrydatelist");
        if (entrydatelist.size() > 0) {
            QFilter pkFilter;
            DynamicObjectCollection object;
            String pkid = (String)customParams.get("pkid");
            if (null == pkid || "null".equals(pkid)) {
                pkid = this.getPageCache().get("rentid");
            }
            if (null != (object = QueryServiceHelper.query((String)"tdm_house_rental_info", (String)"rententryentity.hirearea,rententryentity.startdate,rententryentity.enddate", (QFilter[])new QFilter[]{dateFilter, pkFilter = new QFilter("id", "=", (Object)Long.valueOf(pkid))}, (String)"rententryentity.enddate desc", (int)1)) && object.size() > 0) {
                String area = ((DynamicObject)object.get(0)).getString("rententryentity.hirearea");
                return area;
            }
            return "0";
        }
        return "0";
    }

    public void click(EventObject evt) {
        Map<String, Object> map;
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String rentid = null;
        Date start = (Date)this.getModel().getValue(START);
        Date end = (Date)this.getModel().getValue(END);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONObject data = (JSONObject)customParams.get("data");
        rentid = null != data ? data.getString("id") : this.getPageCache().get("rentid");
        customParams.put("skssqq", start);
        customParams.put("skssqz", end);
        customParams.put("rentid", rentid);
        JSONArray entrydatelist = (JSONArray)customParams.get("entrydatelist");
        if (BT_NOK.equals(key)) {
            map = FcsByHireSourceInfoUtils.validDate(start, end, entrydatelist);
            if (map.get("success").equals("no")) {
                this.getView().showErrorNotification((String)map.get("msg"));
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(RENTAL_EDIT_ENTITY_NAME);
            BigDecimal sumAmount = entryEntity.stream().map(s -> s.getBigDecimal(RENT)).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal currentrentincome = (BigDecimal)this.getModel().getValue(CONTRACT_INCOME);
            if (entryEntity.size() != 0 && sumAmount.compareTo(currentrentincome) != 0) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("confirmOk", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6bcf\u671f\u79df\u91d1\u660e\u7ec6\u5408\u8ba1\u4e0d\u7b49\u4e8e\u79df\u91d1\u6536\u5165\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FcsByHireSourceAddPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
                return;
            }
            if (null != data) {
                Date startdate = DateUtils.stringToDate((String)data.getString(START));
                Date enddate = DateUtils.stringToDate((String)data.getString(END));
                if (!start.equals(startdate) || !end.equals(enddate)) {
                    this.updateAccdet(start, end, rentid);
                }
            }
            this.getPageCache().put("btok", "true");
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("result", dataEntity);
            ret.put("id", rentid);
            ret.put("rowIndex", this.getView().getFormShowParameter().getCustomParams().get("rowIndex"));
            ret.put("saved", "true");
            this.getView().returnDataToParent(ret);
            this.getView().close();
        }
        if (VIEWANDMODIFY.equals(key)) {
            if (null != start && null != end) {
                if (null != entrydatelist && (map = FcsByHireSourceInfoUtils.validDate(start, end, entrydatelist)).get("success").equals("no")) {
                    this.getView().showErrorNotification((String)map.get("msg"));
                    return;
                }
                if (null != data) {
                    Date startdate = DateUtils.stringToDate((String)data.getString(START));
                    Date enddate = DateUtils.stringToDate((String)data.getString(END));
                    if (!start.equals(startdate) || !end.equals(enddate)) {
                        this.updateAccdet(start, end, rentid);
                        this.getPageCache().put("modifyDate", "true");
                    }
                }
                this.showForm(customParams, TCRET_DETAIL_TZ_DIALOG);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7533\u62a5\u79df\u91d1\u6240\u5c5e\u79df\u8d41\u5c5e\u671f\u3002", (String)"FcsByHireSourceAddPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        Date start = (Date)this.getModel().getValue(START);
        Date end = (Date)this.getModel().getValue(END);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONObject data = (JSONObject)customParams.get("data");
        String rentid = null == data ? null : data.getString("id");
        boolean modify = this.isModify(rentid);
        boolean modifyAgain = this.isModifyAgain(rentid);
        boolean isAccdetModify = this.isAccdetModify(rentid);
        boolean isAccdetAgain = this.isAccdetAgain(rentid);
        String btok = this.getPageCache().get("btok");
        if (null != btok) {
            if (modifyAgain) {
                this.deleteModifyDetail(rentid);
                this.saveModifyagainDetail(rentid);
            }
            if (isAccdetAgain) {
                this.deleteAccdetModifyDetail(rentid);
                this.saveAccdetModifyagainDetail(rentid);
            }
        } else {
            Object saved;
            if (modify) {
                saved = customParams.get("saved");
                if (null == saved) {
                    this.deleteModifyagainDetail(rentid);
                    this.deleteModifyDetail(rentid);
                } else if (modifyAgain) {
                    this.deleteModifyagainDetail(rentid);
                }
            }
            if (isAccdetModify) {
                saved = customParams.get("saved");
                if (null == saved) {
                    this.deleteAccdetAgainDetail(rentid);
                    this.deleteAccdetModifyDetail(rentid);
                } else if (isAccdetAgain) {
                    this.deleteAccdetAgainDetail(rentid);
                }
            }
        }
    }

    private void deleteAccdetModifyDetail(String rentid) {
        QFilter rentidFilter = new QFilter("rentid", "=", (Object)(rentid + "_modify"));
        DeleteServiceHelper.delete((String)"tcret_zjcj_accdet", (QFilter[])new QFilter[]{rentidFilter});
    }

    private void deleteAccdetAgainDetail(String rentid) {
        QFilter rentidFilter = new QFilter("rentid", "=", (Object)(rentid + "_modifyagain"));
        DeleteServiceHelper.delete((String)"tcret_zjcj_accdet", (QFilter[])new QFilter[]{rentidFilter});
    }

    private void deleteModifyDetail(String rentid) {
        QFilter rentidFilter = new QFilter("rentid", "=", (Object)(rentid + "_modify"));
        DeleteServiceHelper.delete((String)"tcret_adjust_detail", (QFilter[])new QFilter[]{rentidFilter});
    }

    private void deleteModifyagainDetail(String rentid) {
        QFilter rentidFilter = new QFilter("rentid", "=", (Object)(rentid + "_modifyagain"));
        DeleteServiceHelper.delete((String)"tcret_adjust_detail", (QFilter[])new QFilter[]{rentidFilter});
    }

    private void saveModifyagainDetail(String rentid) {
        DynamicObject[] modifyagaindetail;
        QFilter rentidFilter = new QFilter("rentid", "=", (Object)(rentid + "_modifyagain"));
        for (DynamicObject array : modifyagaindetail = BusinessDataServiceHelper.load((String)"tcret_adjust_detail", (String)"rentid", (QFilter[])new QFilter[]{rentidFilter})) {
            array.set("rentid", (Object)array.getString("rentid").replace("_modifyagain", "_modify"));
        }
        SaveServiceHelper.save((DynamicObject[])modifyagaindetail);
    }

    private void saveAccdetModifyagainDetail(String rentid) {
        DynamicObject[] modifyagaindetail;
        QFilter rentidFilter = new QFilter("rentid", "=", (Object)(rentid + "_modifyagain"));
        for (DynamicObject array : modifyagaindetail = BusinessDataServiceHelper.load((String)"tcret_zjcj_accdet", (String)"rentid", (QFilter[])new QFilter[]{rentidFilter})) {
            array.set("rentid", (Object)array.getString("rentid").replace("_modifyagain", "_modify"));
        }
        SaveServiceHelper.save((DynamicObject[])modifyagaindetail);
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((String)"confirmOk", (String)callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            String rentid = null;
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            JSONObject data = (JSONObject)customParams.get("data");
            rentid = null != data ? data.getString("id") : this.getPageCache().get("rentid");
            this.getPageCache().put("btok", "true");
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            HashMap<String, String> ret = new HashMap<String, String>();
            ret.put("id", rentid);
            ret.put("saved", "true");
            ret.put("result", (String)dataEntity);
            ret.put("rowIndex", (String)this.getView().getFormShowParameter().getCustomParams().get("rowIndex"));
            this.getView().returnDataToParent(ret);
            this.getView().close();
            this.getView().getParentView().updateView();
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private void showCurrentYearValue(Object limit, Object start, Object end) {
        if (null == limit || null == start || null == end) {
            return;
        }
        this.loadCurrentData(limit, start, end);
    }

    private int getTaxLimitNo(Object taxLimit) {
        if (null == taxLimit) {
            return 0;
        }
        switch ((String)taxLimit) {
            case "month": {
                return 1;
            }
            case "season": {
                return 3;
            }
            case "year": {
                return 12;
            }
            case "halfyear": {
                return 6;
            }
        }
        return 0;
    }

    private void loadCurrentData(Object limit, Object start, Object end) {
        int totalCount;
        IDataModel model = this.getModel();
        List<String> allSkssq = FcsByHireSourceInfoUtils.getAllSkssq((String)limit, (Date)start, (Date)end);
        if (null == allSkssq) {
            return;
        }
        int monthNo = (Integer)model.getValue(MONTH_NO);
        this.getModel().deleteEntryData(RENTAL_EDIT_ENTITY_NAME);
        if (totalCount < allSkssq.size()) {
            model.batchCreateNewEntryRow(RENTAL_EDIT_ENTITY_NAME, allSkssq.size() - totalCount);
        } else if (totalCount > allSkssq.size()) {
            for (totalCount = model.getEntryRowCount(RENTAL_EDIT_ENTITY_NAME); totalCount != allSkssq.size(); --totalCount) {
                model.deleteEntryRow(RENTAL_EDIT_ENTITY_NAME, totalCount - 1);
            }
        }
        BigDecimal income = (BigDecimal)model.getValue(CONTRACT_INCOME);
        if (allSkssq.size() == 1) {
            model.setValue(SKSSQ, (Object)allSkssq.get(0), 0);
            model.setValue(RENT, model.getValue(CONTRACT_INCOME), 0);
        } else if (allSkssq.size() == 2) {
            income = income == null ? BigDecimal.ZERO : income;
            BigDecimal firstPeriodMonth = BigDecimal.valueOf(FcsByHireSourceInfoUtils.getFirstMonthNum((String)limit, (Date)start));
            BigDecimal firstPeriodAmount = BigDecimalUtil.divideObject((Object)income.multiply(firstPeriodMonth), (Object)monthNo, (int)2) == null ? BigDecimal.ZERO : BigDecimalUtil.divideObject((Object)income.multiply(firstPeriodMonth), (Object)monthNo, (int)2);
            model.setValue(SKSSQ, (Object)allSkssq.get(0), 0);
            model.setValue(RENT, (Object)firstPeriodAmount, 0);
            model.setValue(SKSSQ, (Object)allSkssq.get(1), 1);
            model.setValue(RENT, (Object)income.subtract(firstPeriodAmount), 1);
        } else {
            for (int row = 0; row < allSkssq.size(); ++row) {
                BigDecimal eachIncome;
                BigDecimal currentEachIncome = (BigDecimal)model.getValue(EACH_INCOME);
                if (row == allSkssq.size() - 1) {
                    BigDecimal lastPeriodAmount;
                    income = income == null ? BigDecimal.ZERO : income;
                    currentEachIncome = currentEachIncome == null ? BigDecimal.ZERO : currentEachIncome;
                    BigDecimal firstPeriodMonth = BigDecimal.valueOf(FcsByHireSourceInfoUtils.getFirstMonthNum((String)limit, (Date)start));
                    BigDecimal firstPeriodAmount = BigDecimalUtil.divideObject((Object)income.multiply(firstPeriodMonth), (Object)monthNo, (int)2) == null ? BigDecimal.ZERO : BigDecimalUtil.divideObject((Object)income.multiply(firstPeriodMonth), (Object)monthNo, (int)2);
                    eachIncome = lastPeriodAmount = BigDecimalUtil.subtractObject((Object)BigDecimalUtil.subtractObject((Object)income, (Object)currentEachIncome.multiply(new BigDecimal(allSkssq.size() - 2))), (Object)firstPeriodAmount);
                    model.setValue(RENT, (Object)firstPeriodAmount, 0);
                } else {
                    eachIncome = currentEachIncome;
                }
                model.setValue(SKSSQ, (Object)allSkssq.get(row), row);
                model.setValue(RENT, (Object)eachIncome, row);
            }
        }
    }

    private void updateMonthNo(Date start, Date end) {
        int dateNo = FcsByHireSourceInfoUtils.getLocalDate(end).getDayOfMonth() - FcsByHireSourceInfoUtils.getLocalDate(start).getDayOfMonth();
        dateNo = dateNo > 15 ? 1 : (dateNo < -15 ? -1 : 0);
        int monthNo = (end.getYear() - start.getYear()) * 12 + (end.getMonth() - start.getMonth()) + dateNo;
        if (monthNo >= 0) {
            this.getModel().setValue(MONTH_NO, (Object)monthNo);
            this.getView().updateView();
        }
    }

    private void updateEachIncome(BigDecimal income, int monthNo, int taxLimitNo) {
        if (income.compareTo(BigDecimal.ZERO) == 0 || monthNo == 0 || taxLimitNo == 0) {
            this.getModel().setValue(EACH_INCOME, (Object)0);
        } else {
            this.getModel().setValue(EACH_INCOME, (Object)FcsByHireSourceInfoUtils.getEachIncome(income, monthNo, taxLimitNo));
        }
        this.getView().updateView();
    }

    private void updateAccdet(Date startdate, Date enddate, String rentid) {
        QFilter accdetFilter = new QFilter("rentid", "=", (Object)rentid);
        QFilter accdetAgainFilter = new QFilter("rentid", "=", (Object)(rentid + "_modify"));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tcret_zjcj_accdet", (String)MetadataUtil.getAllFieldString((String)"tcret_zjcj_accdet"), (QFilter[])new QFilter[]{accdetFilter});
        if (null != dynamicObject) {
            if (this.isAccdetAgain(rentid)) {
                DynamicObject againObject = BusinessDataServiceHelper.loadSingle((String)"tcret_zjcj_accdet", (String)MetadataUtil.getAllFieldString((String)"tcret_zjcj_accdet"), (QFilter[])new QFilter[]{accdetAgainFilter});
                againObject.set("skssqq", (Object)startdate);
                againObject.set("skssqz", (Object)enddate);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{againObject});
            } else if (this.isAccdetModify(rentid)) {
                DynamicObject object = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcret_zjcj_accdet"));
                object.set("serialno", dynamicObject.get("serialno"));
                object.set(ORG, dynamicObject.get(ORG));
                object.set("skssqq", (Object)startdate);
                object.set("skssqz", (Object)enddate);
                object.set("bizname", dynamicObject.get("bizname"));
                object.set("table", dynamicObject.get("table"));
                object.set("amountfield", dynamicObject.get("amountfield"));
                object.set("datatype", dynamicObject.get("datatype"));
                object.set("taxperiod", dynamicObject.get("taxperiod"));
                object.set("datadirection", dynamicObject.get("datadirection"));
                object.set("amount", dynamicObject.get("amount"));
                object.set("fetchamount", dynamicObject.get("fetchamount"));
                object.set("filtercondition", dynamicObject.get("filtercondition"));
                object.set("ruleid", dynamicObject.get("ruleid"));
                object.set("absolute", dynamicObject.get("absolute"));
                object.set("rentid", (Object)(dynamicObject.get("rentid") + "_modifyagain"));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            } else {
                DynamicObject object = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcret_zjcj_accdet"));
                object.set("serialno", dynamicObject.get("serialno"));
                object.set(ORG, dynamicObject.get(ORG));
                object.set("skssqq", (Object)startdate);
                object.set("skssqz", (Object)enddate);
                object.set("bizname", dynamicObject.get("bizname"));
                object.set("table", dynamicObject.get("table"));
                object.set("amountfield", dynamicObject.get("amountfield"));
                object.set("datatype", dynamicObject.get("datatype"));
                object.set("taxperiod", dynamicObject.get("taxperiod"));
                object.set("datadirection", dynamicObject.get("datadirection"));
                object.set("amount", dynamicObject.get("amount"));
                object.set("fetchamount", dynamicObject.get("fetchamount"));
                object.set("filtercondition", dynamicObject.get("filtercondition"));
                object.set("ruleid", dynamicObject.get("ruleid"));
                object.set("absolute", dynamicObject.get("absolute"));
                object.set("rentid", (Object)(dynamicObject.get("rentid") + "_modify"));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            }
        }
    }

    private boolean isModify(String rentid) {
        QFilter rentidFilter = new QFilter("rentid", "=", (Object)(rentid + "_modify"));
        return QueryServiceHelper.exists((String)"tcret_adjust_detail", (QFilter[])new QFilter[]{rentidFilter});
    }

    private boolean isModifyAgain(String rentid) {
        QFilter rentidFilter = new QFilter("rentid", "=", (Object)(rentid + "_modifyagain"));
        return QueryServiceHelper.exists((String)"tcret_adjust_detail", (QFilter[])new QFilter[]{rentidFilter});
    }

    private boolean isAccdetModify(String rentid) {
        QFilter rentidFilter = new QFilter("rentid", "=", (Object)(rentid + "_modify"));
        return QueryServiceHelper.exists((String)"tcret_zjcj_accdet", (QFilter[])new QFilter[]{rentidFilter});
    }

    private boolean isAccdetAgain(String rentid) {
        QFilter rentidFilter = new QFilter("rentid", "=", (Object)(rentid + "_modifyagain"));
        return QueryServiceHelper.exists((String)"tcret_zjcj_accdet", (QFilter[])new QFilter[]{rentidFilter});
    }
}

