/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.taxSourceInfo;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tdm.common.license.ExtendIImportPlugin;
import kd.taxc.tdm.common.util.BigDecimalUtil;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.formplugin.dataintegration.ierp.servicehelper.FcsImportService;
import kd.taxc.tdm.formplugin.taxSourceInfo.constant.SourceInfoConstant;
import kd.taxc.tdm.formplugin.utils.FcsByHireSourceInfoUtils;
import kd.taxc.tdm.formplugin.utils.TaxTimePointUtils;

public class FcsByHireSourceInfoImportPlugin
extends ExtendIImportPlugin {
    private static final String TAX_TIME_POINT = "taxtimepoint";
    private static final String MONTH = "month";
    private static final String SEASON = "season";
    private static final String YEAR = "year";
    private static final String HALF_YEAR = "halfyear";
    private static final String FCS_BYHIRE_LIMIT = "fcsbyhirelimit";
    public static final String MONTHNUMBER = "monthnumber";
    public static final String EACHINCOME = "eachincome";
    private static final String SKSSQ = "skperiod";
    private static final String RENT = "rental";
    private static final String ORG = "org";
    private static final Map<String, Integer> MAP = new HashMap<String, Integer>();

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        Map fcsbasicinfo = (Map)data.get("fcsbasicinfo");
        QFilter filter = new QFilter("number", "=", fcsbasicinfo.get("number"));
        DynamicObject tdmFcsBasicInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"tdm_fcs_basic_info", (QFilter[])new QFilter[]{filter});
        if (tdmFcsBasicInfo == null) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u51fa\u79df\u623f\u4ea7\u672a\u5728\u623f\u4ea7\u57fa\u7840\u4fe1\u606f\u4e2d\u8fdb\u884c\u623f\u4ea7\u5c5e\u5730\u7ba1\u7406\u5212\u5206", (String)"FcsByHireSourceInfoImportPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            return false;
        }
        long orgId = tdmFcsBasicInfo.getLong("org.id");
        DynamicObject dynamicObject = tdmFcsBasicInfo.getDynamicObject("basedatafield");
        JSONArray rententryentity = (JSONArray)data.get("rententryentity");
        String limitStr = (String)data.get(FCS_BYHIRE_LIMIT);
        if (dynamicObject != null) {
            JSONObject jsonObject;
            if ("0".equals(dynamicObject.getString("enable"))) {
                importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"\u201c\u623f\u4ea7\u5c5e\u5730\u7ba1\u7406\u201d\u4e0b\u201c\u623f\u4ea7\u5c5e\u5730\u7ba1\u7406\u540d\u79f0=%s\u201d\u5f15\u5165\u4e0d\u6210\u529f\u3002\u53ef\u80fd\u7684\u539f\u56e0\u662f\uff1a1\u3001\u623f\u4ea7\u5c5e\u5730\u7ba1\u7406\u540d\u79f0\u4e0d\u6b63\u786e\uff1b2\u3001\u4e0d\u7b26\u5408\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u67e5\u8be2\u6761\u4ef6\u3002", (String)"FcsByHireSourceInfoImportPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), dynamicObject.getString("name"))));
                return false;
            }
            if (StringUtil.isBlank((CharSequence)limitStr)) {
                limitStr = dynamicObject.getString(FCS_BYHIRE_LIMIT);
                data.put(FCS_BYHIRE_LIMIT, limitStr);
                SourceInfoConstant.setTaxTimePoint(data, dynamicObject, FCS_BYHIRE_LIMIT);
            } else {
                FcsImportService.checkDataByTaxPayLimit(data, importlogs, limitStr);
            }
            for (Object object : rententryentity) {
                jsonObject = (JSONObject)object;
                boolean success1 = this.checkDate(importlogs, jsonObject, "startdate");
                if (!success1) {
                    return false;
                }
                boolean success2 = this.checkDate(importlogs, jsonObject, "enddate");
                if (!success2) {
                    return false;
                }
                boolean success3 = this.checkBigDecimal(importlogs, jsonObject, "rentincome");
                if (!success3) {
                    return false;
                }
                Map<String, Object> map = FcsByHireSourceInfoUtils.validDate(jsonObject.getDate("startdate"), jsonObject.getDate("enddate"), this.filterBySelf(rententryentity, jsonObject));
                if (!map.get("success").equals("no")) continue;
                importlogs.add(new ImportLogger.ImportLog((String)map.get("msg")));
                return false;
            }
            for (Object object : rententryentity) {
                jsonObject = (JSONObject)object;
                this.putOrgId(jsonObject, orgId);
                Date startdate = jsonObject.getDate("startdate");
                Date enddate = jsonObject.getDate("enddate");
                int month = DateUtils.getMonthDiff((Date)startdate, (Date)enddate);
                BigDecimal contractincome = jsonObject.getBigDecimal("rentincome");
                BigDecimal eachincome = BigDecimal.ZERO;
                if (month > 0 && contractincome != null) {
                    eachincome = FcsByHireSourceInfoUtils.getEachIncome(contractincome, month, MAP.getOrDefault(dynamicObject.getString(FCS_BYHIRE_LIMIT), 0));
                }
                JSONArray subentryentity = this.addRentRecord(orgId, jsonObject, limitStr, month, BigDecimalUtil.setScale((Object)eachincome, (int)2));
                jsonObject.put("subentryentity", (Object)subentryentity);
            }
        } else if (StringUtil.isBlank((CharSequence)limitStr)) {
            data.put(TAX_TIME_POINT, TaxTimePointUtils.adapter("", "false"));
            data.put(MONTHNUMBER, 0);
            data.put(EACHINCOME, BigDecimal.ZERO);
        }
        HashMap<String, Object> org = new HashMap<String, Object>();
        org.put("importprop", "number");
        org.put("number", tdmFcsBasicInfo.get("org.number"));
        data.put(ORG, org);
        return super.beforeImportData(data, option, importlogs);
    }

    private boolean checkDate(List<ImportLogger.ImportLog> importlogs, JSONObject jsonObject, String fieldName) {
        try {
            jsonObject.getDate(fieldName);
        }
        catch (Exception e) {
            importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"%s\uff1a\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a: YYYY-MM-DD", (String)"FcsByHireSourceInfoImportPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), jsonObject.getString(fieldName))));
            return false;
        }
        return true;
    }

    private boolean checkBigDecimal(List<ImportLogger.ImportLog> importlogs, JSONObject jsonObject, String fieldName) {
        try {
            jsonObject.getBigDecimal(fieldName);
        }
        catch (Exception e) {
            importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"\u79df\u91d1\u6536\u5165\uff08\u5143\uff09\u683c\u5f0f\u9519\u8bef\uff1a%s", (String)"FcsByHireSourceInfoImportPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), jsonObject.getString(fieldName))));
            return false;
        }
        return true;
    }

    private JSONArray filterBySelf(JSONArray rententryentity, JSONObject filter) {
        JSONArray array = new JSONArray();
        for (Object object : rententryentity) {
            JSONObject jsonObject = (JSONObject)object;
            if (jsonObject.equals((Object)filter)) continue;
            array.add((Object)jsonObject);
        }
        return array;
    }

    public JSONArray addRentRecord(long orgId, JSONObject jsonObject, String limit, int month, BigDecimal eachincome) {
        BigDecimal rentincome = jsonObject.getBigDecimal("rentincome") == null ? BigDecimal.ZERO : jsonObject.getBigDecimal("rentincome");
        Date startdate = jsonObject.getDate("startdate");
        Date enddate = jsonObject.getDate("enddate");
        jsonObject.put("rentmonth", (Object)month);
        jsonObject.put("eachrentincome", (Object)eachincome);
        JSONArray subentryentity = this.calc(rentincome, eachincome, limit, startdate, enddate, month);
        return subentryentity;
    }

    public JSONArray calc(BigDecimal income, BigDecimal eachIncome, String limit, Date start, Date end, int month) {
        JSONArray subentryentity = new JSONArray();
        List<String> allSkssq = FcsByHireSourceInfoUtils.getAllSkssq(limit, start, end);
        if (null == allSkssq) {
            return null;
        }
        if (allSkssq.size() == 1) {
            JSONObject object = new JSONObject();
            object.put(SKSSQ, (Object)allSkssq.get(0));
            object.put(RENT, (Object)income);
            subentryentity.add((Object)object);
        } else if (allSkssq.size() == 2) {
            JSONObject object1 = new JSONObject();
            BigDecimal firstPeriodMonth = BigDecimal.valueOf(FcsByHireSourceInfoUtils.getFirstMonthNum(limit, start));
            BigDecimal firstPeriodAmount = BigDecimalUtil.divideObject((Object)income.multiply(firstPeriodMonth), (Object)month, (int)2) == null ? BigDecimal.ZERO : BigDecimalUtil.divideObject((Object)income.multiply(firstPeriodMonth), (Object)month, (int)2);
            object1.put(SKSSQ, (Object)allSkssq.get(0));
            object1.put(RENT, (Object)firstPeriodAmount);
            JSONObject object2 = new JSONObject();
            object2.put(SKSSQ, (Object)allSkssq.get(1));
            object2.put(RENT, (Object)income.subtract(firstPeriodAmount));
            subentryentity.add((Object)object1);
            subentryentity.add((Object)object2);
        } else {
            BigDecimal currentEachIncome = eachIncome;
            for (int row = 0; row < allSkssq.size(); ++row) {
                JSONObject object = new JSONObject();
                if (row == allSkssq.size() - 1) {
                    BigDecimal lastPeriodAmount;
                    BigDecimal firstPeriodMonth = BigDecimal.valueOf(FcsByHireSourceInfoUtils.getFirstMonthNum(limit, start));
                    BigDecimal firstPeriodAmount = BigDecimalUtil.divideObject((Object)income.multiply(firstPeriodMonth), (Object)month, (int)2) == null ? BigDecimal.ZERO : BigDecimalUtil.divideObject((Object)income.multiply(firstPeriodMonth), (Object)month, (int)2);
                    eachIncome = lastPeriodAmount = BigDecimalUtil.subtractObject((Object)BigDecimalUtil.subtractObject((Object)income, (Object)currentEachIncome.multiply(new BigDecimal(allSkssq.size() - 2))), (Object)firstPeriodAmount);
                    ((JSONObject)subentryentity.get(0)).put(RENT, (Object)firstPeriodAmount);
                } else {
                    eachIncome = currentEachIncome;
                }
                object.put(SKSSQ, (Object)allSkssq.get(row));
                object.put(RENT, (Object)eachIncome);
                subentryentity.add((Object)object);
            }
        }
        return subentryentity;
    }

    private void putOrgId(JSONObject object, long orgId) {
        HashMap<String, Object> org = new HashMap<String, Object>();
        org.put("importprop", "id");
        org.put("id", orgId);
        object.put("accountorg", org);
    }

    static {
        MAP.put(MONTH, 1);
        MAP.put(SEASON, 3);
        MAP.put(HALF_YEAR, 6);
        MAP.put(YEAR, 12);
    }
}

