/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.taxSourceInfo;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tdm.common.license.ExtendAbstractBillPlugin;
import kd.taxc.tdm.formplugin.utils.FcsByHireSourceInfoUtils;
import kd.taxc.tdm.formplugin.utils.TaxTimePointUtils;
import org.apache.commons.lang3.StringUtils;

public class FcsByHireSourceInfoPlugin
extends ExtendAbstractBillPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener,
SelectRowsEventListener {
    private static final String RENTAL_EDIT_ENTITY_NAME = "tdm_house_rental_edit";
    private static final String CONTRACT_INCOME = "contractincome";
    private static final String EACH_INCOME = "eachincome";
    private static final String START = "contractstart";
    private static final String END = "contractend";
    private static final String MONTH_NO = "monthnumber";
    private static final String FCS_BY_HIRE_LIMIT = "fcsbyhirelimit";
    private static final String MONTH = "month";
    private static final String SEASON = "season";
    private static final String YEAR = "year";
    private static final String HALF_YEAR = "halfyear";
    private static final String SKSSQ = "skssq";
    private static final String RENT = "rent";
    private static final String MONTHLY = "monthly";
    private static final String MONTHLIMIT = "monthlimit";
    private static final String JMSTART = "start";
    private static final String JMEND = "end";
    private static final String RATIO = "ratio";
    private static final int MONTH_VALUE = 1;
    private static final int DEFAULT_VALUE_1 = 1;
    private static final int SEASON_VALUE = 3;
    private static final int YEAR_VALUE = 12;
    private static final int HALF_MONTH_VALUE = 15;
    private static final int MINUS_HALF_MONTH_VALUE = -15;
    private static final int HALF_YEAR_VALUE = 6;
    private static final int DEFAULT_VALUE = 0;
    private static final int SEASON_LENGTH = 90;
    private static final int HALF_YEAR_LENGTH = 183;
    private static final int YEAR_LENGTH = 365;
    private static final String TAX_TIME_POINT = "taxtimepoint";
    private static final String FCSAPANAGE = "fcsapanage";
    private static final String END_MONTH = "endmonth";
    private static final String YEAR_BEFORE = "yearbefore";
    private static final String RENT_ENTRY_ENTITY = "rententryentity";
    private static final String TDM_HOUSE_RENTAL_ADD = "tdm_house_rent_add";
    private static final String SEASON_BEFORE = "seasonbefore";
    private static final String HALFYEAR_BEFORE = "halfyearbefore";
    private static final String FIRSTHALF_MONTH = "firsthalfmonth";
    private static final String SECONDHALF_MONTH = "secondhalfmonth";
    private static final String FIRSTQUARTER_MONTH = "firstquartermonth";
    private static final String SECONDQUARTER_MONTH = "secondquartermonth";
    private static final String THIRDQUARTER_MONTH = "thirdquartermonth";
    private static final String FOURTHQUARTER_MONTH = "fourthquartermonth";
    private static final List<String> JZJMCODE_LIST = Lists.newArrayList((Object[])new String[]{"08011707", "08011708", "08011709", "08011710", "08129917"});
    private static final List<String> QTJMCODE_LIST = Lists.newArrayList((Object[])new String[]{"08019902", "08129999"});

    public void initialize() {
        BasedataEdit fcsbasicinfo = (BasedataEdit)this.getControl("fcsbasicinfo");
        fcsbasicinfo.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(RENT_ENTRY_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if ("fcsbasicinfo".equals(evt.getProperty().getName())) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u5148\u586b\u5199\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"FcsByHireSourceInfoPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter idsFilter = new QFilter("org", "=", (Object)org.getLong("id"));
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(idsFilter);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        IDataModel model = this.getModel();
        Object limit = model.getValue(FCS_BY_HIRE_LIMIT);
        Object start = model.getValue(START);
        Object end = model.getValue(END);
        if (null != limit && null != start && null != end) {
            this.showCurrentYearValue(limit, start, end, null);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(TAX_TIME_POINT);
        comboEdit.setComboItems(TaxTimePointUtils.getTaxTimePoints((String)limit));
        EntryGrid entryEntity = (EntryGrid)this.getControl(RENT_ENTRY_ENTITY);
        entryEntity.setCellStyle(this.getCellStyles());
        if (SEASON_BEFORE.equals(this.getModel().getValue(TAX_TIME_POINT))) {
            this.visibleSwitch(Boolean.TRUE, FIRSTQUARTER_MONTH, SECONDQUARTER_MONTH, THIRDQUARTER_MONTH, FOURTHQUARTER_MONTH);
        } else {
            this.visibleSwitch(Boolean.FALSE, FIRSTQUARTER_MONTH, SECONDQUARTER_MONTH, THIRDQUARTER_MONTH, FOURTHQUARTER_MONTH);
        }
        if (HALFYEAR_BEFORE.equals(this.getModel().getValue(TAX_TIME_POINT))) {
            this.visibleSwitch(Boolean.TRUE, FIRSTHALF_MONTH, SECONDHALF_MONTH);
        } else {
            this.visibleSwitch(Boolean.FALSE, FIRSTHALF_MONTH, SECONDHALF_MONTH);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject org;
        super.beforeDoOperation(args);
        BillShowParameter BillShowParameter2 = (BillShowParameter)this.getView().getFormShowParameter();
        String pkid = String.valueOf(BillShowParameter2.getPkId());
        Object source = args.getSource();
        String operateKey = ((AbstractOperate)source).getOperateKey();
        ArrayList<String> adjustItem = new ArrayList<String>();
        ArrayList<String> adjustAccdet = new ArrayList<String>();
        if (operateKey.equals("save")) {
            DynamicObject[] adjustAccdetdata;
            QFilter rentFilter;
            DynamicObject[] adjustdata;
            DynamicObject orgObj = (DynamicObject)this.getModel().getValue("org");
            if (orgObj != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)orgObj.getLong("id")).isSuccess()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"FcsByHireSourceInfoPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (null != (adjustdata = BusinessDataServiceHelper.load((String)"tcret_adjust_detail", (String)"rentid", (QFilter[])new QFilter[]{rentFilter = new QFilter("rentid", "like", (Object)"%modify")}))) {
                for (DynamicObject data : adjustdata) {
                    data.set("rentid", (Object)data.getString("rentid").replace("_modify", ""));
                    adjustItem.add(data.getString("rentid"));
                }
                QFilter rentidFilter = new QFilter("rentid", "in", adjustItem);
                DeleteServiceHelper.delete((String)"tcret_adjust_detail", (QFilter[])new QFilter[]{rentidFilter});
                SaveServiceHelper.save((DynamicObject[])adjustdata);
            }
            if (null != (adjustAccdetdata = BusinessDataServiceHelper.load((String)"tcret_zjcj_accdet", (String)"rentid", (QFilter[])new QFilter[]{rentFilter}))) {
                for (DynamicObject data : adjustAccdetdata) {
                    data.set("rentid", (Object)data.getString("rentid").replace("_modify", ""));
                    adjustAccdet.add(data.getString("rentid"));
                }
                QFilter rentidFilter = new QFilter("rentid", "in", adjustAccdet);
                DeleteServiceHelper.delete((String)"tcret_zjcj_accdet", (QFilter[])new QFilter[]{rentidFilter});
                SaveServiceHelper.save((DynamicObject[])adjustAccdetdata);
            }
            DynamicObjectCollection rententryentity = this.getModel().getEntryEntity(RENT_ENTRY_ENTITY);
            List id = rententryentity.stream().map(s -> s.getString("id")).collect(Collectors.toList());
            String rentidList = this.getPageCache().get("rentidList");
            if (null != rentidList) {
                List list = SerializationUtils.fromJsonStringToList((String)rentidList, String.class);
                list.removeAll(id);
                if (null != list && list.size() > 0) {
                    for (String rentid : list) {
                        QFilter rentidFilter = new QFilter("rentid", "=", (Object)rentid);
                        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tcret_zjcj_accdet", (String)"skssqq,skssqz,org", (QFilter[])new QFilter[]{rentidFilter});
                        if (null == dynamicObject) continue;
                        Long org2 = dynamicObject.getLong("org");
                        Date skssqq = dynamicObject.getDate("skssqq");
                        Date skssqz = dynamicObject.getDate("skssqz");
                        QFilter orgFilter = new QFilter("org", "=", (Object)org2);
                        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)skssqq);
                        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)skssqz);
                        DeleteServiceHelper.delete((String)"tcret_zjcj_accdet", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter});
                        DeleteServiceHelper.delete((String)"tcret_adjust_detail", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter});
                    }
                }
            }
        }
        if ("rentaddentry".equals(operateKey) && (org = (DynamicObject)this.getModel().getValue("org")) != null) {
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("pkid", pkid);
            customParams.put("orgid", org.getString("id"));
            customParams.put(FCS_BY_HIRE_LIMIT, this.getModel().getValue(FCS_BY_HIRE_LIMIT));
            customParams.put("entrydatelist", this.getEntryDateList("add", 0));
            customParams.put("isadd", "true");
            customParams.put("saved", this.getPageCache().get("saved"));
            this.showForm("add", customParams);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        String isclosed = this.getPageCache().get("isclosed");
        if (null == isclosed && this.getModel().getDataChanged()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("bar_close", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"FcsByHireSourceInfoPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"FcsByHireSourceInfoPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.YesNo;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"FcsByHireSourceInfoPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            String changeDesc = this.getModel().getChangeDesc();
            if (null != changeDesc) {
                String str1 = ResManager.loadKDString((String)"\u7f16\u7801\uff0c", (String)"FcsByHireSourceInfoPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                String str2 = ResManager.loadKDString((String)"\u540d\u79f0\uff0c", (String)"FcsByHireSourceInfoPlugin_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                String modifyString = changeDesc.replace(str1, "").replace(str2, "");
                this.getView().showConfirm(msg, modifyString, options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
                e.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            QFilter rentidFilter = new QFilter("rentid", "like", (Object)"%modify");
            DeleteServiceHelper.delete((String)"tcret_adjust_detail", (QFilter[])new QFilter[]{rentidFilter});
            DeleteServiceHelper.delete((String)"tcret_zjcj_accdet", (QFilter[])new QFilter[]{rentidFilter});
            this.getPageCache().put("isclosed", "true");
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String id = event.getActionId();
        Map returnData = (Map)event.getReturnData();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (id.equals("rent_add_call_back") && returnData != null) {
            BillShowParameter BillShowParameter2 = (BillShowParameter)this.getView().getFormShowParameter();
            Object pkId = BillShowParameter2.getPkId();
            DynamicObject dynamicObject = (DynamicObject)returnData.get("result");
            this.getPageCache().put("saved", (String)returnData.get("saved"));
            Integer rowIndex = (Integer)returnData.get("rowIndex");
            if (rowIndex != null) {
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(RENT_ENTRY_ENTITY, rowIndex.intValue());
                entryRowEntity.set("hirearea", dynamicObject.get("hirearea"));
                entryRowEntity.set("startdate", dynamicObject.get("startdate"));
                entryRowEntity.set("enddate", dynamicObject.get("enddate"));
                entryRowEntity.set("hiretaxcode", dynamicObject.get("hiretaxcode"));
                entryRowEntity.set("tenantry", dynamicObject.get("tenantry"));
                entryRowEntity.set("rentincome", dynamicObject.get("rentincome"));
                entryRowEntity.set("modifiername", (Object)RequestContext.get().getUserId());
                entryRowEntity.set("rentmonth", dynamicObject.get(MONTH_NO));
                entryRowEntity.set("eachrentincome", dynamicObject.get(EACH_INCOME));
                entryRowEntity.set("accountorg", (Object)org.getLong("id"));
                DynamicObjectCollection entryentityDetails = dynamicObject.getDynamicObjectCollection("entryentity");
                this.getModel().deleteEntryData("subentryentity");
                DynamicObjectCollection subentryentity = entryRowEntity.getDynamicObjectCollection("subentryentity");
                for (DynamicObject entryentityDetail : entryentityDetails) {
                    DynamicObject object = subentryentity.addNew();
                    object.set("skperiod", entryentityDetail.get(SKSSQ));
                    object.set("rental", entryentityDetail.get(RENT));
                }
                this.getView().updateView(RENT_ENTRY_ENTITY);
            } else {
                IDataModel model = this.getModel();
                this.getModel().beginInit();
                int parentIndex = model.createNewEntryRow(RENT_ENTRY_ENTITY);
                model.setEntryCurrentRowIndex(RENT_ENTRY_ENTITY, parentIndex);
                model.setValue("rententryentity.id", (Object)Long.valueOf((String)returnData.get("id")));
                model.setValue("hirearea", dynamicObject.get("hirearea"), parentIndex);
                model.setValue("startdate", dynamicObject.get("startdate"), parentIndex);
                model.setValue("enddate", dynamicObject.get("enddate"), parentIndex);
                model.setValue("hiretaxcode", dynamicObject.get("hiretaxcode"), parentIndex);
                model.setValue("tenantry", dynamicObject.get("tenantry"), parentIndex);
                model.setValue("rentincome", dynamicObject.get("rentincome"), parentIndex);
                model.setValue("modifiername", (Object)RequestContext.get().getUserId(), parentIndex);
                model.setValue("rentmonth", dynamicObject.get(MONTH_NO), parentIndex);
                model.setValue("eachrentincome", dynamicObject.get(EACH_INCOME), parentIndex);
                model.setValue("houserentalinfo", pkId);
                model.setValue("accountorg", (Object)org.getLong("id"));
                DynamicObjectCollection entryentityDetails = dynamicObject.getDynamicObjectCollection("entryentity");
                model.deleteEntryData("subentryentity");
                for (DynamicObject entryentityDetail : entryentityDetails) {
                    int subRow = model.createNewEntryRow("subentryentity");
                    this.getModel().setValue("skperiod", entryentityDetail.get(SKSSQ), subRow, parentIndex);
                    this.getModel().setValue("rental", entryentityDetail.get(RENT), subRow, parentIndex);
                }
                this.getModel().endInit();
                this.getView().updateView(RENT_ENTRY_ENTITY);
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            for (int i = 0; i < entryEntity.size(); ++i) {
                this.updateMonthLimit(i);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        BillShowParameter BillShowParameter2 = (BillShowParameter)this.getView().getFormShowParameter();
        String pkid = String.valueOf(BillShowParameter2.getPkId());
        String modify = this.getPageCache().get("modify");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(RENT_ENTRY_ENTITY, rowIndex);
        this.getPageCache().put("currentmodifyid", entryRowEntity.getString("id"));
        this.getPageCache().put("currentrentincome", entryRowEntity.getString("rentincome"));
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        int seq = entryRowEntity.getInt("seq");
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("saved", this.getPageCache().get("saved"));
        customParams.put("pkid", pkid);
        customParams.put("modify", modify);
        customParams.put("rowIndex", rowIndex);
        customParams.put("orgid", org.getString("id"));
        customParams.put(FCS_BY_HIRE_LIMIT, this.getModel().getValue(FCS_BY_HIRE_LIMIT));
        customParams.put("entrydatelist", this.getEntryDateList("edit", seq));
        customParams.put("data", entryRowEntity);
        this.showForm("edit", customParams);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        int taxLimitNo = this.getTaxLimitNo(this.getModel().getValue(FCS_BY_HIRE_LIMIT));
        IDataModel model = this.getModel();
        Object monthNo = this.getModel().getValue(MONTH_NO);
        Object income = this.getModel().getValue(CONTRACT_INCOME);
        DynamicObject fcsapanage = (DynamicObject)this.getModel().getValue(FCSAPANAGE);
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        int focusRow = entryentity.getEntryState().getFocusRow();
        switch (name) {
            case "fcsapanage": {
                String limitValue = fcsapanage.getString(FCS_BY_HIRE_LIMIT);
                this.getModel().setValue(FCS_BY_HIRE_LIMIT, (Object)limitValue);
                ComboEdit pointComboEdit = (ComboEdit)this.getControl(TAX_TIME_POINT);
                ArrayList<ComboItem> pointcomboItems = TaxTimePointUtils.getTaxTimePoints(limitValue);
                pointComboEdit.setComboItems(pointcomboItems);
                String pointValue0 = TaxTimePointUtils.getTaxTimePointValue(pointcomboItems, fcsapanage, limitValue);
                this.getModel().setValue(TAX_TIME_POINT, (Object)pointValue0);
                break;
            }
            case "fcsbyhirelimit": {
                this.updateEachIncome(income, monthNo, this.getTaxLimitNo(newValue));
                String value = (String)this.getModel().getValue(FCS_BY_HIRE_LIMIT);
                ComboEdit comboEdit = (ComboEdit)this.getControl(TAX_TIME_POINT);
                ArrayList<ComboItem> comboItems = TaxTimePointUtils.getTaxTimePoints(value);
                comboEdit.setComboItems(comboItems);
                String pointValue = TaxTimePointUtils.getTaxTimePointValue(comboItems, fcsapanage, value);
                this.getModel().setValue(TAX_TIME_POINT, (Object)pointValue);
                if (SEASON_BEFORE.equals(pointValue)) {
                    this.visibleSwitch(Boolean.TRUE, FIRSTQUARTER_MONTH, SECONDQUARTER_MONTH, THIRDQUARTER_MONTH, FOURTHQUARTER_MONTH);
                    break;
                }
                if (!HALFYEAR_BEFORE.equals(pointValue)) break;
                this.visibleSwitch(Boolean.TRUE, FIRSTHALF_MONTH, SECONDHALF_MONTH);
                break;
            }
            case "contractincome": {
                this.updateEachIncome(newValue, monthNo, taxLimitNo);
                break;
            }
            case "contractstart": {
                if (null == this.getModel().getValue(END) || null == this.getModel().getValue(START)) break;
                this.updateMonthNo((Date)newValue, (Date)this.getModel().getValue(END));
                break;
            }
            case "contractend": {
                if (null == this.getModel().getValue(START) || null == this.getModel().getValue(END)) break;
                this.updateMonthNo((Date)this.getModel().getValue(START), (Date)newValue);
                break;
            }
            case "monthnumber": {
                Object monthNumber = this.getModel().getValue(MONTH_NO);
                this.updateEachIncome(income, monthNumber, taxLimitNo);
                break;
            }
            case "eachincome": {
                Object limit = model.getValue(FCS_BY_HIRE_LIMIT);
                Object start = model.getValue(START);
                Object end = model.getValue(END);
                if (null != limit && null != start && null != end) {
                    this.showCurrentYearValue(limit, start, end, newValue);
                }
            }
            case "taxtimepoint": {
                if (!this.getModel().getValue(TAX_TIME_POINT).equals(YEAR_BEFORE)) {
                    this.getModel().setValue(END_MONTH, (Object)"");
                } else {
                    this.getModel().setValue(END_MONTH, (Object)TaxTimePointUtils.getEndMonth(fcsapanage));
                }
                if (SEASON_BEFORE.equals(this.getModel().getValue(TAX_TIME_POINT))) {
                    this.visibleSwitch(Boolean.TRUE, FIRSTQUARTER_MONTH, SECONDQUARTER_MONTH, THIRDQUARTER_MONTH, FOURTHQUARTER_MONTH);
                } else {
                    this.visibleSwitch(Boolean.FALSE, FIRSTQUARTER_MONTH, SECONDQUARTER_MONTH, THIRDQUARTER_MONTH, FOURTHQUARTER_MONTH);
                }
                if (HALFYEAR_BEFORE.equals(this.getModel().getValue(TAX_TIME_POINT))) {
                    this.visibleSwitch(Boolean.TRUE, FIRSTHALF_MONTH, SECONDHALF_MONTH);
                    break;
                }
                this.visibleSwitch(Boolean.FALSE, FIRSTHALF_MONTH, SECONDHALF_MONTH);
                break;
            }
            case "monthly": {
                if (newValue.equals(false)) {
                    this.getModel().setValue(MONTHLIMIT, null, focusRow);
                    break;
                }
                this.updateMonthLimit(focusRow);
                break;
            }
            case "start": 
            case "end": 
            case "ratio": {
                Date jmstart = (Date)this.getModel().getValue(JMSTART, focusRow);
                if (JMSTART.equals(name) && jmstart != null && !jmstart.equals(DateUtils.getFirstDateOfMonth((Date)jmstart))) {
                    this.getModel().setValue(JMSTART, (Object)DateUtils.getFirstDateOfMonth((Date)jmstart), focusRow);
                    return;
                }
                Date jmend = (Date)this.getModel().getValue(JMEND, focusRow);
                if (JMEND.equals(name) && jmend != null && !jmend.equals(DateUtils.getLastDateOfMonth2((Date)jmend))) {
                    this.getModel().setValue(JMEND, (Object)DateUtils.getLastDateOfMonth2((Date)jmend), focusRow);
                    return;
                }
                this.updateMonthLimit(focusRow);
                break;
            }
        }
    }

    private void updateMonthLimit(int focusRow) {
        if (this.getModel().getValue(MONTHLY, focusRow).equals(true)) {
            BigDecimal ratio = (BigDecimal)this.getModel().getValue(RATIO, focusRow);
            DynamicObject taxdeduction = (DynamicObject)this.getModel().getValue("taxdeduction", focusRow);
            Date jmstart = (Date)this.getModel().getValue(JMSTART, focusRow);
            Date jmend = (Date)this.getModel().getValue(JMEND, focusRow);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(RENT_ENTRY_ENTITY);
            DynamicObjectCollection fitCollection = entryEntity.stream().filter(s -> this.includeTime(s.getDate("startdate"), s.getDate("enddate"), jmstart, jmend)).collect(Collectors.toCollection(DynamicObjectCollection::new));
            if (fitCollection.size() > 0 && taxdeduction != null) {
                BigDecimal sumRentincome = fitCollection.stream().map(s -> s.getBigDecimal("rentincome")).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
                DynamicObject maxEnddate = fitCollection.stream().max(Comparator.comparing(s -> s.getDate("enddate"))).get();
                DynamicObject minStartdate = fitCollection.stream().min(Comparator.comparing(s -> s.getDate("startdate"))).get();
                int monthDiff = DateUtils.getMonthDiff((Date)maxEnddate.getDate("enddate"), (Date)minStartdate.getDate("startdate"));
                BigDecimal averageAmount = sumRentincome.divide(new BigDecimal(monthDiff + 1), 2, 4);
                if (JZJMCODE_LIST.contains(taxdeduction.getString("number"))) {
                    this.getModel().setValue(MONTHLIMIT, (Object)averageAmount.multiply(ratio), focusRow);
                } else if (QTJMCODE_LIST.contains(taxdeduction.getString("number"))) {
                    this.getModel().setValue(MONTHLIMIT, (Object)BigDecimal.ZERO, focusRow);
                } else {
                    this.getModel().setValue(MONTHLIMIT, (Object)averageAmount.multiply(ratio).multiply(new BigDecimal("0.12")), focusRow);
                }
            } else {
                this.getModel().setValue(MONTHLIMIT, (Object)BigDecimal.ZERO, focusRow);
            }
        }
    }

    private boolean includeTime(Date effectivestart, Date effectiveend, Date validfrom, Date expired) {
        LocalDate startDate1 = this.formatDate(DateUtils.format((Date)effectivestart));
        LocalDate endDate1 = this.formatDate(DateUtils.format((Date)effectiveend));
        LocalDate startDate2 = this.formatDate(DateUtils.format((Date)validfrom));
        LocalDate endDate2 = this.formatDate(DateUtils.format((Date)expired));
        if (Objects.isNull(startDate1) || Objects.isNull(startDate2) || Objects.isNull(endDate1)) {
            return false;
        }
        if (Objects.isNull(endDate2)) {
            return startDate1.isAfter(startDate2) || startDate1.isEqual(startDate2);
        }
        return !(!startDate1.isAfter(startDate2) && !startDate1.isEqual(startDate2) || !endDate2.isAfter(endDate1) && !endDate1.isEqual(endDate2));
    }

    private LocalDate formatDate(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        return LocalDate.parse(date);
    }

    private void visibleSwitch(boolean onOff, String ... keys) {
        for (String key : keys) {
            this.getView().setVisible(Boolean.valueOf(onOff), new String[]{key});
        }
    }

    public List<CellStyle> getCellStyles() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(RENT_ENTRY_ENTITY);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject object = (DynamicObject)entryEntity.get(i);
            DynamicObjectCollection subentryentity = object.getDynamicObjectCollection("subentryentity");
            BigDecimal reduce = subentryentity.stream().map(s -> s.getBigDecimal("rental")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (object.getBigDecimal("rentincome").compareTo(reduce) == 0) continue;
            CellStyle cellStyle = new CellStyle();
            cellStyle.setFieldKey("rentincome");
            cellStyle.setBackColor("#fbda03");
            cellStyle.setRow(i);
            cellStyles.add(cellStyle);
        }
        return cellStyles;
    }

    private void showForm(String openModel, Map<String, Object> customParams) {
        FormShowParameter param = new FormShowParameter();
        customParams.put("openModel", openModel);
        param.setCustomParams(customParams);
        param.setFormId(TDM_HOUSE_RENTAL_ADD);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "rent_add_call_back"));
        param.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(param);
    }

    private List<DynamicObject> getEntryDateList(String model, int seq) {
        List<Object> result = new ArrayList<DynamicObject>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(RENT_ENTRY_ENTITY);
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return result;
        }
        if ("add".equals(model)) {
            result = entryEntity.stream().collect(Collectors.toList());
        }
        if ("edit".equals(model)) {
            result = entryEntity.stream().filter(s -> s.getInt("seq") != seq).collect(Collectors.toList());
        }
        return result;
    }

    private void showCurrentYearValue(Object limit, Object start, Object end, Object newValue) {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(RENTAL_EDIT_ENTITY_NAME);
        if (rowCount == 0 || null != newValue) {
            this.loadCurrnetData(limit, start, end);
        }
    }

    private void loadCurrnetData(Object limit, Object start, Object end) {
        int totalCount;
        IDataModel model = this.getModel();
        List<String> allSkssq = FcsByHireSourceInfoUtils.getAllSkssq((String)limit, (Date)start, (Date)end);
        if (null == allSkssq) {
            return;
        }
        this.getModel().deleteEntryData(RENTAL_EDIT_ENTITY_NAME);
        if (totalCount < allSkssq.size()) {
            model.batchCreateNewEntryRow(RENTAL_EDIT_ENTITY_NAME, allSkssq.size() - totalCount);
        } else if (totalCount > allSkssq.size()) {
            for (totalCount = model.getEntryRowCount(RENTAL_EDIT_ENTITY_NAME); totalCount != allSkssq.size(); --totalCount) {
                model.deleteEntryRow(RENTAL_EDIT_ENTITY_NAME, totalCount - 1);
            }
        }
        BigDecimal income = (BigDecimal)model.getValue(CONTRACT_INCOME);
        int monthNo = (Integer)model.getValue(MONTH_NO);
        if (allSkssq.size() == 1) {
            model.setValue(SKSSQ, (Object)allSkssq.get(0), 0);
            model.setValue(RENT, model.getValue(CONTRACT_INCOME), 0);
        } else if (allSkssq.size() == 2) {
            income = income == null ? BigDecimal.ZERO : income;
            BigDecimal firstPeriodMonth = BigDecimal.valueOf(FcsByHireSourceInfoUtils.getFirstMonthNum((String)limit, (Date)start));
            BigDecimal firstPeriodAmount = BigDecimalUtil.divideObject((Object)income.multiply(firstPeriodMonth), (Object)monthNo, (int)2) == null ? BigDecimal.ZERO : BigDecimalUtil.divideObject((Object)income.multiply(firstPeriodMonth), (Object)monthNo, (int)2);
            model.setValue(SKSSQ, (Object)allSkssq.get(0), 0);
            model.setValue(RENT, (Object)firstPeriodAmount, 0);
            model.setValue(SKSSQ, (Object)allSkssq.get(1), 1);
            model.setValue(RENT, (Object)income.subtract(firstPeriodAmount), 1);
        } else {
            for (int row = 0; row < allSkssq.size(); ++row) {
                BigDecimal eachIncome;
                BigDecimal currentEachIncome = (BigDecimal)model.getValue(EACH_INCOME);
                if (row == allSkssq.size() - 1) {
                    BigDecimal lastPeriodAmount;
                    income = income == null ? BigDecimal.ZERO : income;
                    currentEachIncome = currentEachIncome == null ? BigDecimal.ZERO : currentEachIncome;
                    BigDecimal firstPeriodMonth = BigDecimal.valueOf(FcsByHireSourceInfoUtils.getFirstMonthNum((String)limit, (Date)start));
                    BigDecimal firstPeriodAmount = BigDecimalUtil.divideObject((Object)income.multiply(firstPeriodMonth), (Object)monthNo, (int)2) == null ? BigDecimal.ZERO : BigDecimalUtil.divideObject((Object)income.multiply(firstPeriodMonth), (Object)monthNo, (int)2);
                    eachIncome = lastPeriodAmount = BigDecimalUtil.subtractObject((Object)BigDecimalUtil.subtractObject((Object)income, (Object)currentEachIncome.multiply(new BigDecimal(allSkssq.size() - 2))), (Object)firstPeriodAmount);
                    model.setValue(RENT, (Object)firstPeriodAmount, 0);
                } else {
                    eachIncome = currentEachIncome;
                }
                model.setValue(SKSSQ, (Object)allSkssq.get(row), row);
                model.setValue(RENT, (Object)eachIncome, row);
            }
        }
    }

    private int getTaxLimitNo(Object taxLimit) {
        if (null == taxLimit) {
            return 0;
        }
        switch ((String)taxLimit) {
            case "month": {
                return 1;
            }
            case "season": {
                return 3;
            }
            case "year": {
                return 12;
            }
            case "halfyear": {
                return 6;
            }
        }
        return 0;
    }

    private void updateMonthNo(Date start, Date end) {
        int dateNo = FcsByHireSourceInfoUtils.getLocalDate(end).getDayOfMonth() - FcsByHireSourceInfoUtils.getLocalDate(start).getDayOfMonth();
        dateNo = dateNo > 15 ? 1 : (dateNo < -15 ? -1 : 0);
        int monthNo = (end.getYear() - start.getYear()) * 12 + (end.getMonth() - start.getMonth()) + dateNo;
        if (monthNo >= 0) {
            this.getModel().setValue(MONTH_NO, (Object)monthNo);
            this.getView().updateView();
        }
    }

    private void updateEachIncome(Object income, Object monthNo, int taxLimitNo) {
        if (null == income || null == monthNo || ((BigDecimal)income).intValue() == 0 || (Integer)monthNo == 0 || taxLimitNo == 0) {
            this.getModel().setValue(EACH_INCOME, (Object)0);
        } else {
            this.getModel().setValue(EACH_INCOME, (Object)FcsByHireSourceInfoUtils.getEachIncome((BigDecimal)income, (Integer)monthNo, taxLimitNo));
        }
        this.getView().updateView();
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        DynamicObjectCollection rententry = this.getView().getModel().getEntryEntity(e.getEntryProp().getName());
        int[] rowIndexs = e.getRowIndexs();
        ArrayList<String> rentidList = new ArrayList<String>(rowIndexs.length);
        for (int rowIndex : rowIndexs) {
            DynamicObject entry = (DynamicObject)rententry.get(rowIndex);
            String rentid = entry.getString("id");
            rentidList.add(rentid);
        }
        this.getPageCache().put("rentidList", SerializationUtils.toJsonString(rentidList));
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if (e.getEntryProp().getName().equals(RENT_ENTRY_ENTITY)) {
            this.getView().updateView(RENT_ENTRY_ENTITY);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            for (int i = 0; i < entryEntity.size(); ++i) {
                this.updateMonthLimit(i);
            }
        }
    }
}

