/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.taxSourceInfo;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.opplugin.validator.SourceInfoDimensionSaveValidator;
import kd.taxc.tdm.common.util.StringUtil;
import kd.taxc.tdm.formplugin.taxSourceInfo.constant.SourceInfoDateValidator;
import kd.taxc.tdm.formplugin.taxSourceInfo.constant.SourceInfoSaveValidator;
import org.apache.commons.lang3.StringUtils;

public class FcsByHireSourceInfoSaveOp
extends AbstractOperationServicePlugIn {
    private static final String LOCATION_ENTITY_NAME = "bd_admindivision";
    private static final String ID = "id";
    private static final String MONTH_NO = "monthnumber";
    private static final String START = "contractstart";
    private static final String END = "contractend";
    private static final String FCS_APANAGE = "fcsapanage";
    private static final String FCS_BY_HIRE = "fcsbyhire";
    private static final String PROVINCE = "province";
    private static final String CITY = "city";
    private static final String COUNTRY = "country";
    private static final String FULL_NAME = "fullname";
    private static final String LOCATION = "location";
    private static final String REGEX = "_";

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject currentObj = dataEntity.getDataEntity();
                    DynamicObject apanageObj = currentObj.getDynamicObject(FcsByHireSourceInfoSaveOp.FCS_APANAGE);
                    DynamicObjectCollection houseRentalEdit = currentObj.getDynamicObjectCollection("tdm_house_rental_edit");
                    BigDecimal contractincome = currentObj.getBigDecimal("contractincome");
                    if (null == apanageObj) {
                        this.addErrorMessage(dataEntity, FcsByHireSourceInfoSaveOp.this.getWrongErrorMsg());
                        return;
                    }
                    FcsByHireSourceInfoSaveOp.this.addAddr(currentObj);
                }
            }
        });
        e.getValidators().add(new SourceInfoSaveValidator());
        e.getValidators().add(new SourceInfoDateValidator());
        e.getValidators().add(new SourceInfoDimensionSaveValidator(BaseTaxCategory.FCS));
    }

    private void addAddr(DynamicObject currentObj) {
        String[] splitName;
        DynamicObject addr;
        String names;
        String fieldId = (String)currentObj.get(LOCATION);
        if (StringUtils.isNotEmpty((CharSequence)fieldId) && !StringUtil.isEmpty((CharSequence)(names = (String)(addr = QueryServiceHelper.queryOne((String)LOCATION_ENTITY_NAME, (String)FULL_NAME, (QFilter[])new QFilter(ID, "=", (Object)Long.parseLong(fieldId)).toArray())).get(0))) && (splitName = names.split(REGEX)).length >= 3) {
            currentObj.set(PROVINCE, (Object)splitName[0]);
            currentObj.set(CITY, (Object)splitName[1]);
            currentObj.set(COUNTRY, (Object)splitName[2]);
        }
    }

    private String getWrongErrorMsg() {
        return ResManager.loadKDString((String)"\u8be5\u51fa\u79df\u623f\u4ea7\u672a\u5728\u623f\u4ea7\u57fa\u7840\u4fe1\u606f\u4e2d\u8fdb\u884c\u623f\u4ea7\u5c5e\u5730\u7ba1\u7406\u5212\u5206", (String)"FcsByHireSourceInfoSaveOp_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
    }
}

