/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.taxSourceInfo;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tdm.common.util.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class FcsRentalAccountListPlugin
extends AbstractListPlugin {
    private static final String RENTCOLLECTION = "rentcollection";
    private static final String TOOLBARID = "toolbar";
    private static final String TCRET_HOUSE_AUTOCOLLECT = "tcret_house_autocollect";
    private static final String TDM_HOUSE_RENTAL = "tdm_house_rental";
    private static final String TDM_HOUSE_RENTAL_INFO = "tdm_house_rental_info";
    public static final String STARTDATE = "startdate";
    public static final String ENDDATE = "enddate";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{TOOLBARID, RENTCOLLECTION});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumnList) {
            List defaultValues = filterColumn.getDefaultValues();
            if (null == defaultValues || defaultValues.isEmpty()) continue;
            String orgid = (String)defaultValues.get(0);
            this.getPageCache().put("defaultorgid", orgid);
        }
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if (STARTDATE.equals(columnDesc.getKey())) {
            String startdate = DateUtils.format((Date)data.getDate(STARTDATE), (String)DateUtils.YYYYMMDD_CHINESE);
            String enddate = DateUtils.format((Date)data.getDate(ENDDATE), (String)DateUtils.YYYYMMDD_CHINESE);
            e.setFormatValue((Object)(startdate + "-" + enddate));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        String fieldName = args.getFieldName();
        if ("houserentalinfo_leasecontractno".equals(fieldName)) {
            Object pkid = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
            QFilter qFilter = new QFilter("id", "=", pkid);
            DynamicObject row = QueryServiceHelper.queryOne((String)TDM_HOUSE_RENTAL, (String)"houserentalinfo", (QFilter[])new QFilter[]{qFilter});
            if (null != row) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId(TDM_HOUSE_RENTAL_INFO);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setPkId((Object)row.getLong("houserentalinfo"));
                parameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"FcsRentalAccountListPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        BillList billlist;
        ListSelectedRowCollection collection;
        boolean hasDelete;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"exportlist_expt") && (hasDelete = (collection = (billlist = (BillList)this.getControl("billlistap")).getSelectedRows()).stream().anyMatch(e -> !QueryServiceHelper.exists((String)TDM_HOUSE_RENTAL, (Object)e.getPrimaryKeyValue())))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"FcsRentalAccountListPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String itemKey = args.getOperateKey();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Optional<Object> orgid = this.getControlFilters().getFilter("houserentalinfo.org.id").stream().filter(s -> StringUtils.isNotEmpty((CharSequence)s.toString())).findFirst();
        if (orgid.isPresent()) {
            customParams.put("orgid", orgid.get());
        } else {
            customParams.put("orgid", this.getPageCache().get("defaultorgid"));
        }
        if (RENTCOLLECTION.equals(itemKey)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(TCRET_HOUSE_AUTOCOLLECT);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, RENTCOLLECTION));
            parameter.setCustomParams(customParams);
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (RENTCOLLECTION.equals(closedCallBackEvent.getActionId())) {
            this.getView().invokeOperation("refresh");
        }
    }
}

