/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.taxSourceInfo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.orgtakerelation.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tdm.business.taxsource.FcsTdsTaxsourceServiceHelper;
import kd.taxc.tdm.common.license.ExtendAbstractBillPlugin;
import kd.taxc.tdm.formplugin.utils.TaxTimePointUtils;

public class FcsSourceInfoFormPlugin
extends ExtendAbstractBillPlugin
implements BeforeF7SelectListener {
    private static final String TPO_TCVAT_ASSIST_ENTITY = "tpo_tcvat_assist";
    private static final String ORG = "org";
    private static final String TAX_RATIO = "taxratio";
    private static final String TAX_TYPE = "taxtype";
    private static final String VALUE = "fvalue1";
    private static final String STATUS = "fstatus1";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final int DEFAULT_ZERO = 0;
    private static final String FCS_CODE = "6";
    private static final String TAX_PAY_LIMIT = "taxpaylimit";
    private static final String TAX_TIME_POINT = "taxtimepoint";
    private static final String END_MONTH = "endmonth";
    private static final String YEAR_BEFORE = "yearbefore";
    private static final String FCSDGL = "basedatafield";
    private static final String AREA = "area";
    private static final String MONTHLY = "monthly";
    private static final String MONTHLIMIT = "monthlimit";
    private static final String SELECTED_FIELDS = "entryentity.fvalue1,entryentity.startdate,entryentity.enddate,entryentity.fstatus1";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit assetdata = (BasedataEdit)this.getControl("assetdata");
        assetdata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object assetdata;
        DynamicObject fcsbasicinfo = (DynamicObject)this.getModel().getValue(FCSDGL);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        EntryGrid entryentity = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int focusRow = entryentity.getEntryState().getFocusRow();
        if (name.equals(ORG)) {
            this.getModel().setValue(TAX_RATIO, (Object)this.getTaxRate());
        } else if (name.equals(TAX_PAY_LIMIT)) {
            String value = (String)this.getModel().getValue(TAX_PAY_LIMIT);
            ComboEdit comboEdit = (ComboEdit)this.getControl(TAX_TIME_POINT);
            ArrayList<ComboItem> comboItems = TaxTimePointUtils.getTaxTimePoints(value);
            comboEdit.setComboItems(comboItems);
            this.getModel().setValue(TAX_TIME_POINT, (Object)TaxTimePointUtils.getTaxTimePointValue(comboItems, fcsbasicinfo, value));
        } else if (name.equals(TAX_TIME_POINT)) {
            if (!this.getModel().getValue(TAX_TIME_POINT).equals(YEAR_BEFORE)) {
                this.getModel().setValue(END_MONTH, (Object)"");
            } else {
                this.getModel().setValue(END_MONTH, (Object)TaxTimePointUtils.getEndMonth(fcsbasicinfo));
            }
        } else if (FCSDGL.equals(name)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValue != null && "SZSSWJ".equals(newValue.getString("number"))) {
                this.getModel().setValue("hireassertvalue", (Object)0);
                this.getModel().setValue("hirearea", (Object)0);
            }
            if (newValue != null) {
                String taxLimit = newValue.getString("fcsbypricelimit");
                this.getModel().setValue(TAX_PAY_LIMIT, (Object)taxLimit);
            }
            String value = (String)this.getModel().getValue(TAX_PAY_LIMIT);
            ComboEdit comboEdit = (ComboEdit)this.getControl(TAX_TIME_POINT);
            ArrayList<ComboItem> comboItems = TaxTimePointUtils.getTaxTimePoints(value);
            comboEdit.setComboItems(comboItems);
            this.getModel().setValue(TAX_TIME_POINT, (Object)TaxTimePointUtils.getTaxTimePointValue(comboItems, fcsbasicinfo, value));
        } else if (AREA.equals(name)) {
            Boolean assertvalueform;
            if (org != null && (assertvalueform = (Boolean)SystemParamUtil.getAppParameter((String)"tcret", (String)"assertvalueform", (long)org.getLong("id"))) != null && assertvalueform.booleanValue()) {
                BigDecimal oldValue = (BigDecimal)changeData.getOldValue();
                BigDecimal newValue = (BigDecimal)changeData.getNewValue();
                if (newValue.compareTo(oldValue) != 0) {
                    this.getPageCache().put("areachange", "true");
                }
            }
        } else if (MONTHLY.equals(name)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (newValue.equals(false)) {
                this.getModel().setValue(MONTHLIMIT, null, rowIndex);
            } else {
                this.getModel().setValue(MONTHLIMIT, (Object)BigDecimal.ZERO, rowIndex);
            }
        } else if ("accountorg".equals(name)) {
            this.getModel().setValue("assetdata", null);
        } else if ("start".equals(name)) {
            Date jmstart = (Date)this.getModel().getValue("start", focusRow);
            if (jmstart != null && !jmstart.equals(DateUtils.getFirstDateOfMonth((Date)jmstart))) {
                this.getModel().setValue("start", (Object)DateUtils.getFirstDateOfMonth((Date)jmstart), focusRow);
                return;
            }
        } else if ("end".equals(name)) {
            Date jmend = (Date)this.getModel().getValue("end", focusRow);
            if (jmend != null && !jmend.equals(DateUtils.getLastDateOfMonth2((Date)jmend))) {
                this.getModel().setValue("end", (Object)DateUtils.getLastDateOfMonth2((Date)jmend), focusRow);
                return;
            }
        } else if ("assetdata".equals(name) && (assetdata = this.getModel().getValue("assetdata")) != null) {
            Object acquiredate = this.getModel().getValue("acquiredate");
            BigDecimal housevalue = (BigDecimal)this.getModel().getValue("housevalue");
            Object changedate = this.getModel().getValue("changedate");
            if (acquiredate != null || housevalue != null && housevalue.compareTo(BigDecimal.ZERO) != 0 || changedate != null) {
                String msg = ResManager.loadKDString((String)"\u5173\u8054\u201c\u8d44\u4ea7\u7f16\u7801\u201d\u5c06\u8986\u76d6\u5df2\u586b\u5199\u7684\u201c\u623f\u4ea7\u539f\u503c\uff08\u521d\u59cb\u4ef7\u503c\uff09\u3001\u623f\u4ea7\u53d6\u5f97\u65f6\u95f4\u3001\u7eb3\u7a0e\u4e49\u52a1\u7ec8\u6b62\u65f6\u95f4\u201d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"FcsSourceInfoFormPlugin_13", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                String leftDesc = ResManager.loadKDString((String)"\u53d6\u6d88", (String)"FcsSourceInfoFormPlugin_14", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                String rightDesc = ResManager.loadKDString((String)"\u786e\u8ba4", (String)"FcsSourceInfoFormPlugin_15", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("updateassetdata", (IFormPlugin)this);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(8);
                btnNameMaps.put(MessageBoxResult.No.getValue(), leftDesc);
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), rightDesc);
                MessageBoxOptions options = MessageBoxOptions.YesNo;
                this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
            } else {
                DynamicObject assetdataObj = (DynamicObject)assetdata;
                this.getModel().setValue("acquiredate", (Object)assetdataObj.getDate(START_DATE));
                Boolean assertvalueform = (Boolean)SystemParamUtil.getAppParameter((String)"tcret", (String)"assertvalueform", (long)org.getLong("id"));
                BigDecimal assetsvalue = assetdataObj.getBigDecimal("initval");
                if (assetsvalue == null || assetsvalue.compareTo(BigDecimal.ZERO) == 0) {
                    assetsvalue = assetdataObj.getBigDecimal("assetsvalue");
                }
                if (assertvalueform != null && assertvalueform.booleanValue()) {
                    this.getModel().setValue("housevalue", (Object)assetsvalue);
                } else {
                    this.getModel().setValue("assertvalue", (Object)assetsvalue);
                }
                this.getModel().setValue("changedate", (Object)DateUtils.getLastDateOfMonth((Date)assetdataObj.getDate("cleaningdate")));
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.setTaxOfficeVal();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String value = (String)this.getModel().getValue(TAX_PAY_LIMIT);
        ComboEdit comboEditTaxpaylimit = (ComboEdit)this.getControl(TAX_PAY_LIMIT);
        comboEditTaxpaylimit.setComboItems(TaxTimePointUtils.getTaxpaylimitPoints());
        ComboEdit comboEdit = (ComboEdit)this.getControl(TAX_TIME_POINT);
        comboEdit.setComboItems(TaxTimePointUtils.getTaxTimePoints(value));
        this.setVisableEnable();
    }

    private void setVisableEnable() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"calculate"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"calculate", "fieldsetpanelap", "bghousevalue", "bgequipmentvalue", "bgvalue"});
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org != null) {
            Boolean assertvalueform = (Boolean)SystemParamUtil.getAppParameter((String)"tcret", (String)"assertvalueform", (long)org.getLong("id"));
            if (assertvalueform != null && assertvalueform.booleanValue()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"calculate"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"calculate", "fieldsetpanelap", "bghousevalue", "bgequipmentvalue", "bgvalue"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"calculate"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"calculate", "fieldsetpanelap", "bghousevalue", "bgequipmentvalue", "bgvalue"});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (StringUtil.equals((CharSequence)operate.getOperateKey(), (CharSequence)"calculate")) {
            String enable;
            DynamicObject landtaxsource = (DynamicObject)this.getModel().getValue("landtaxsource");
            if (landtaxsource != null && "0".equals(landtaxsource.getString("enable"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u571f\u5730\u7a0e\u6e90\u7f16\u53f7%s\u5df2\u7981\u7528", (String)"FcsSourceInfoFormPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), landtaxsource.getString("number")));
                args.setCancel(true);
            }
            if ("0".equals(enable = (String)this.getModel().getValue("enable"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u623f\u4ea7\u7f16\u53f7%s\u5df2\u7981\u7528", (String)"FcsSourceInfoFormPlugin_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), this.getModel().getValue("number")));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        Boolean assertvalueform;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        DynamicObject landtaxsource = (DynamicObject)this.getModel().getValue("landtaxsource");
        if ("calculate".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("calculateConfirm", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"FcsSourceInfoFormPlugin_14", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"FcsSourceInfoFormPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            String msg = String.format(ResManager.loadKDString((String)"\u6240\u6709\u5173\u8054\u571f\u5730\u7f16\u53f7%s\uff08\u571f\u5730\u7f16\u53f7\uff09\u7684\u623f\u4ea7\u5e94\u644a\u5165\u571f\u5730\u4ef7\u503c\u7b49\u5373\u5c06\u53d1\u751f\u8054\u52a8\u8c03\u6574\uff0c\u662f\u5426\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"FcsSourceInfoFormPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), landtaxsource != null ? landtaxsource.getString("number") : "");
            this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
        if ("save".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess() && org != null && (assertvalueform = (Boolean)SystemParamUtil.getAppParameter((String)"tcret", (String)"assertvalueform", (long)org.getLong("id"))) != null && assertvalueform.booleanValue()) {
            BigDecimal value;
            BigDecimal equipmentvalue;
            BigDecimal housevalue;
            BigDecimal assertvalue;
            if (StringUtil.isNotEmpty((CharSequence)this.getPageCache().get("areachange")) && "true".equals(this.getPageCache().get("areachange")) && landtaxsource != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u623f\u4ea7\u5efa\u7b51\u9762\u79ef\u53d1\u751f\u53d8\u5316\uff0c\u5c1a\u672a\u91cd\u65b0\u8ba1\u7b97\u644a\u5165\u571f\u5730\u4ef7\u503c\uff0c\u8bf7\u6ce8\u610f\u6838\u5b9e\u6570\u636e\u7684\u51c6\u786e\u6027", (String)"FcsSourceInfoFormPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            }
            if ((assertvalue = (BigDecimal)this.getModel().getValue("assertvalue")).compareTo((housevalue = (BigDecimal)this.getModel().getValue("housevalue")).add((equipmentvalue = (BigDecimal)this.getModel().getValue("equipmentvalue")).add(value = (BigDecimal)this.getModel().getValue("value")))) != 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u3010\u623f\u4ea7\u539f\u503c\uff08\u5143\uff09\u3011\u4e0d\u7b49\u4e8e\u623f\u5c4b\u539f\u503c\u3001\u623f\u5c4b\u9644\u5c5e\u8bbe\u5907\u53ca\u914d\u5957\u8bbe\u5907\u3001\u5e94\u644a\u5165\u571f\u5730\u4ef7\u503c\u7684\u521d\u59cb\u4ef7\u503c\u5408\u8ba1\u503c\uff0c\u8bf7\u6821\u9a8c\u6570\u636e\u7684\u51c6\u786e\u6027", (String)"FcsSourceInfoFormPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        BigDecimal area = (BigDecimal)this.getModel().getValue(AREA);
        Long id = this.getModel().getDataEntity().getLong("id");
        DynamicObject landtaxsource = (DynamicObject)this.getModel().getValue("landtaxsource");
        if ("calculateConfirm".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            StringBuilder stringBuilder = new StringBuilder();
            if (landtaxsource != null) {
                FcsTdsTaxsourceServiceHelper.updateTdsFcsInfo((StringBuilder)stringBuilder, (Long)landtaxsource.getLong("id"), (Long)id, (BigDecimal)area);
                String operateDescription = String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u571f\u5730\u7f16\u53f7%1$s\u5173\u8054\u623f\u4ea7\u7684\u5e94\u644a\u5165\u571f\u5730\u4ef7\u503c\uff0c\u623f\u4ea7\u7f16\u53f7\u3010%2$s\u3011\u5e94\u644a\u5165\u571f\u5730\u4ef7\u503c\u6570\u636e\u63a8\u9001\u6210\u529f\u3002", (String)"FcsSourceInfoFormPlugin_8", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), landtaxsource.getString("number"), this.getModel().getValue("number"));
                this.getPageCache().put("areachange", "false");
                this.getView().invokeOperation("refresh");
                this.getModel().setValue(AREA, (Object)area);
                if (StringUtil.isNotBlank((CharSequence)stringBuilder.toString())) {
                    this.getView().showErrorNotification(stringBuilder.toString());
                    operateDescription = String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u571f\u5730\u7f16\u53f7%1$s\u5173\u8054\u623f\u4ea7\u7684\u5e94\u644a\u5165\u571f\u5730\u4ef7\u503c\uff0c\u623f\u4ea7\u7f16\u53f7\u3010%2$s\u3011\u5e94\u644a\u5165\u571f\u5730\u4ef7\u503c\u6570\u636e\u63a8\u9001\u5931\u8d25\u3002", (String)"FcsSourceInfoFormPlugin_9", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), landtaxsource.getString("number"), this.getModel().getValue("number"));
                }
                String operateName = ResManager.loadKDString((String)"\u8ba1\u7b97\u5e94\u644a\u5165\u571f\u5730\u4ef7\u503c", (String)"FcsSourceInfoFormPlugin_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                OperatorDialogUtils.operateDialog((String)"ccxws", (String)"tdm_fcs_basic_info", (String)operateName, (String)operateDescription);
            }
        }
        if ("updateassetdata".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            DynamicObject assetdata = (DynamicObject)this.getModel().getValue("assetdata");
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            if (assetdata != null && org != null) {
                this.getModel().setValue("acquiredate", (Object)assetdata.getDate(START_DATE));
                Boolean assertvalueform = (Boolean)SystemParamUtil.getAppParameter((String)"tcret", (String)"assertvalueform", (long)org.getLong("id"));
                BigDecimal assetsvalue = assetdata.getBigDecimal("initval");
                if (assetsvalue == null || assetsvalue.compareTo(BigDecimal.ZERO) == 0) {
                    assetsvalue = assetdata.getBigDecimal("assetsvalue");
                }
                if (assertvalueform != null && assertvalueform.booleanValue()) {
                    this.getModel().setValue("housevalue", (Object)assetsvalue);
                } else {
                    this.getModel().setValue("assertvalue", (Object)assetsvalue);
                }
                this.getModel().setValue("changedate", (Object)DateUtils.getLastDateOfMonth((Date)assetdata.getDate("cleaningdate")));
            }
        }
    }

    private double getTaxRate() {
        QFilter taxTypefilter = new QFilter(TAX_TYPE, "=", (Object)FCS_CODE);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)TPO_TCVAT_ASSIST_ENTITY, (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{taxTypefilter});
        if (null == dynamicObjects || dynamicObjects.length == 0) {
            return 0.0;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject obj = this.getValidObj(dynamicObject);
            if (null == obj) continue;
            return Double.parseDouble(obj.getString(VALUE));
        }
        return 0.0;
    }

    private DynamicObject getValidObj(DynamicObject dynamicObject) {
        Date now = new Date();
        DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
        for (DynamicObject sonObj : dynamicObjects) {
            Date start = sonObj.getDate(START_DATE);
            Date end = sonObj.getDate(END_DATE);
            boolean status = sonObj.getBoolean(STATUS);
            if (null == start || !now.after(start) || null != end && !now.before(end) || !status) continue;
            return sonObj;
        }
        return null;
    }

    private void setTaxOfficeVal() {
        DynamicObject taxOrg;
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (null != org && null != (taxOrg = QueryServiceHelper.queryOne((String)"tctb_tax_main", (String)"id,taxoffice", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)org.getString("number"))}))) {
            this.getModel().setValue("taxauthority", (Object)taxOrg.getString("taxoffice"));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if ("assetdata".equals(evt.getProperty().getName())) {
            ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(new QFilter("assetstatus", "!=", (Object)"clean"));
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("accountorg");
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            Long orgId = EmptyCheckUtils.isNotEmpty((Object)org) ? org.getLong("id") : 0L;
            if (FcsSourceInfoFormPlugin.isDimensionByAccountOrg(orgId, BaseTaxCategory.FCS)) {
                if (EmptyCheckUtils.isNotEmpty((Object)accountorg)) {
                    filters.add(new QFilter("taxorg", "=", (Object)accountorg.getLong("id")));
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FcsSourceInfoFormPlugin_16", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                }
            } else {
                Date now = new Date();
                List accountOrgs = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(orgId), (Date)now, (Date)now);
                filters.add(new QFilter("taxorg", "in", (Object)accountOrgs));
            }
            listFilterParameter.setQFilters(filters);
        }
    }

    public static boolean isDimensionByAccountOrg(Long orgId, Long baseTaxId) {
        TaxResult result = ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange(Collections.singletonList(orgId), (Long)baseTaxId, (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)new Date(), (Date)new Date());
        if (EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            DynamicObject object = (DynamicObject)((DynamicObjectCollection)result.getData()).get(0);
            boolean isdimprovision = object.getBoolean("ruleentity.rule.isdimprovision");
            String provisiondimension = object.getString("ruleentity.rule.provisiondimension");
            if (isdimprovision && EmptyCheckUtils.isNotEmpty((Object)provisiondimension) && provisiondimension.contains("accountorg")) {
                return true;
            }
        }
        return false;
    }

    private void setAssetdata() {
    }
}

