/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.taxSourceInfo;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tdm.common.license.ExtendIImportPlugin;
import kd.taxc.tdm.formplugin.dataintegration.ierp.servicehelper.FcsImportService;
import kd.taxc.tdm.formplugin.taxSourceInfo.constant.SourceInfoConstant;
import kd.taxc.tdm.formplugin.utils.TaxTimePointUtils;

public class FcsSourceInfoImportPlugin
extends ExtendIImportPlugin {
    private static final String DATA_FLAG = "dataflag";
    private static final String BY_FRONT = "byFront";
    private static final String TAX_TIME_POINT = "taxtimepoint";
    private static final String TAX_PAY_LIMIT = "taxpaylimit";

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        JSONObject org = (JSONObject)data.get("org");
        if (org != null && StringUtils.isNotEmpty((CharSequence)org.getString("number")) && !TaxcMainDataServiceHelper.isTaxcMainByOrgNum((String)org.getString("number")).isSuccess()) {
            importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u5f15\u5165\u6570\u636e\uff1a\u7f16\u7801%s", (String)"FcsSourceInfoImportPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), org.get((Object)"number"))));
        }
        data.put(DATA_FLAG, BY_FRONT);
        String taxpaylimit = (String)data.get(TAX_PAY_LIMIT);
        if (StringUtil.isNotBlank((CharSequence)taxpaylimit)) {
            FcsImportService.checkDataByTaxPayLimit(data, importlogs, taxpaylimit);
        }
        Map basedatafield = (Map)data.get("basedatafield");
        String name = null;
        if (basedatafield != null && (name = (String)basedatafield.get("name")) != null) {
            String selectFields = "id,name,fcsbypricelimit,declarebymonth,declarebyseason,declarebyyeartype,declarebyhalfyear,declarebyyearlimit,enable";
            QFilter filter = new QFilter("name", "=", (Object)name.trim());
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tpo_tcret_fcs_apanage", (String)selectFields, (QFilter[])new QFilter[]{filter});
            if (dynamicObject != null) {
                if ("0".equals(dynamicObject.getString("enable"))) {
                    importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"\u201c\u623f\u4ea7\u5c5e\u5730\u7ba1\u7406\u201d\u4e0b\u201c\u623f\u4ea7\u5c5e\u5730\u7ba1\u7406\u540d\u79f0=%s\u201d\u5f15\u5165\u4e0d\u6210\u529f\u3002\u53ef\u80fd\u7684\u539f\u56e0\u662f\uff1a1\u3001\u623f\u4ea7\u5c5e\u5730\u7ba1\u7406\u540d\u79f0\u4e0d\u6b63\u786e\uff1b2\u3001\u4e0d\u7b26\u5408\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u67e5\u8be2\u6761\u4ef6\u3002", (String)"FcsSourceInfoImportPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), name)));
                } else if (StringUtil.isBlank((CharSequence)taxpaylimit)) {
                    String taxLimit = dynamicObject.getString("fcsbypricelimit");
                    data.put(TAX_PAY_LIMIT, taxLimit);
                    SourceInfoConstant.setTaxTimePoint(data, dynamicObject, "fcsbypricelimit");
                }
            }
        } else if (StringUtil.isBlank((CharSequence)taxpaylimit)) {
            data.put(TAX_PAY_LIMIT, "false");
            data.put(TAX_TIME_POINT, TaxTimePointUtils.adapter("", "false"));
        }
        JSONObject assetdata = (JSONObject)data.get("assetdata");
        JSONObject accountorg = (JSONObject)data.get("accountorg");
        if (assetdata != null && accountorg == null) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FcsSourceInfoImportPlugin_11", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        }
        if (assetdata != null && accountorg != null && org != null) {
            DynamicObject accorgObj = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgNum((String)accountorg.getString("number")).getData();
            if (accorgObj == null) {
                importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u5f15\u5165\u6570\u636e\uff1a\u7f16\u7801%s", (String)"FcsSourceInfoImportPlugin_12", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), accountorg.get((Object)"number"))));
            } else {
                DynamicObject object = QueryServiceHelper.queryOne((String)"tdm_asset_data", (String)"id,startdate,initval,assetsvalue,cleaningdate,assetcode", (QFilter[])new QFilter[]{new QFilter("taxorg", "=", (Object)accorgObj.getDynamicObject("orgid").getLong("id")), new QFilter("assetcode", "=", (Object)assetdata.getString("assetcode")), new QFilter("enable", "=", (Object)"1"), new QFilter("assetstatus", "!=", (Object)"clean")});
                if (object != null) {
                    assetdata.put("id", object.get("id"));
                    if (data.get("acquiredate") == null) {
                        data.put("acquiredate", object.getDate("startdate"));
                    }
                    if (data.get("housevalue") == null) {
                        DynamicObject orgObj = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgNum((String)org.getString("number")).getData();
                        Boolean assertvalueform = (Boolean)SystemParamUtil.getAppParameter((String)"tcret", (String)"assertvalueform", (long)orgObj.getDynamicObject("orgid").getLong("id"));
                        Object assetsvalue = object.get("initval");
                        if (assetsvalue == null || object.getBigDecimal("initval").compareTo(BigDecimal.ZERO) == 0) {
                            assetsvalue = object.getBigDecimal("assetsvalue");
                        }
                        if (assertvalueform != null && assertvalueform.booleanValue()) {
                            data.put("housevalue", assetsvalue);
                        } else {
                            data.putIfAbsent("assertvalue", assetsvalue);
                        }
                    }
                    if (data.get("changedate") == null) {
                        data.put("changedate", DateUtils.getLastDateOfMonth((Date)object.getDate("cleaningdate")));
                    }
                } else {
                    importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u53ef\u7528\u8d44\u4ea7\u7f16\u7801\uff1a%s", (String)"FcsSourceInfoImportPlugin_13", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), assetdata.getString("assetcode"))));
                }
            }
        }
        return super.beforeImportData(data, option, importlogs);
    }
}

