/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.taxSourceInfo;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxorg.TaxNameUtil;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.tdm.business.taxsource.FcsTdsTaxsourceServiceHelper;
import kd.taxc.tdm.formplugin.showpage.PageShowCommon;
import kd.taxc.tdm.formplugin.utils.TaxTimePointUtils;

public class FcsSourceInfoPlugin
extends AbstractListPlugin {
    private static final String INFO_QUERY = "hireinfoquery";
    private static final String FCS_APANAGE = "fcsapanage";
    private static final String FCS_FCCZXXCX = "fcsfcczxxcx";
    private static final String FCS_FCSDGL = "fcsfcsdgl";
    private static final String ORG = "org";
    private static final String TOOL_BAR = "toolbarap";
    private static final String TPO_FCS_APANAGE_ENTITY = "tpo_tcret_fcs_apanage";
    private static final String TDM_FCS_HIRE_INFO_ENTITY = "tdm_house_rental_info";
    private static final String TDM_FCS_BASIC_INFO_ENTITY = "tdm_fcs_basic_info";
    public static final String FCS_PRICE = "fcs_price";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{TOOL_BAR});
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        List successPkIds;
        super.afterDoOperation(afterDoOperationEventArgs);
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (FCS_FCSDGL.equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.loadFcsApanage();
        } else if (FCS_FCCZXXCX.equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.loadFcsHireInfo();
        } else if ("disableconfirm".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            DynamicObject[] dynamicObjects = FcsTdsTaxsourceServiceHelper.findFcsTaxsource((Object[])list.getPrimaryKeyValues());
            List numbers = Arrays.stream(dynamicObjects).filter(a -> a.getDynamicObject("landtaxsource") != null).map(a -> a.getString("number")).collect(Collectors.toList());
            if (numbers.size() > 0) {
                String msg = String.format(ResManager.loadKDString((String)"\u623f\u4ea7\u7f16\u53f7%s\u5df2\u5173\u8054\u571f\u5730\u7a0e\u6e90\u4fe1\u606f\uff0c\u7981\u7528\u72b6\u6001\u5c06\u5f71\u54cd\u623f\u4ea7\u57fa\u7840\u4fe1\u606f\u5e94\u644a\u5165\u571f\u5730\u4ef7\u503c\u8ba1\u7b97\u7ed3\u679c", (String)"FcsSourceInfoPlugin_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", numbers));
                List ids = Arrays.stream(list.getPrimaryKeyValues()).map(String::valueOf).collect(Collectors.toList());
                this.getView().showConfirm(msg, "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("disableconfirm"), null, String.join((CharSequence)",", ids));
            }
            Arrays.stream(dynamicObjects).filter(a -> a.getDynamicObject("landtaxsource") == null).forEach(d -> d.set("enable", (Object)"0"));
            Object[] objects = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            billlist.refresh();
            if (objects.length > 0 && numbers.size() == 0) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"FcsSourceInfoPlugin_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            }
        }
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ("sycnassetdata".equals(operateKey) && operationResult != null && !CollectionUtils.isEmpty((Collection)(successPkIds = operationResult.getSuccessPkIds()))) {
            FcsTdsTaxsourceServiceHelper.sycnAssetdata((List)successPkIds);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u3002", (String)"FcsSourceInfoPlugin_8", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
    }

    private void loadFcsHireInfo() {
        BillList list = (BillList)this.getControl("billlistap");
        if (CollectionUtils.isEmpty((Collection)list.getSelectedRows())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"FcsSourceInfoPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openFcsHireInfoBill(list.getSelectedRows());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (CollectionUtils.isEmpty((Collection)returnData)) {
            return;
        }
        if (FCS_APANAGE.equals(actionId)) {
            this.updateFcsApanage(returnData);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("disableconfirm".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String ids = messageBoxClosedEvent.getCustomVaule();
            List idlist = Arrays.stream(ids.split(",")).map(Long::parseLong).collect(Collectors.toList());
            DynamicObject[] dynamicObjects = FcsTdsTaxsourceServiceHelper.findFcsTaxsource((Object[])idlist.toArray());
            Arrays.stream(dynamicObjects).forEach(d -> d.set("enable", (Object)"0"));
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            BillList billlist = (BillList)this.getControl("billlistap");
            billlist.refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"FcsSourceInfoPlugin_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
    }

    private void loadFcsApanage() {
        BillList list = (BillList)this.getControl("billlistap");
        if (CollectionUtils.isEmpty((Collection)list.getSelectedRows())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"FcsSourceInfoPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return;
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        String operateName = ResManager.loadKDString((String)"\u623f\u4ea7\u5c5e\u5730\u7ba1\u7406", (String)"FcsSourceInfoPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
        String operateDescription = ResManager.loadKDString((String)"\u623f\u4ea7\u5c5e\u5730\u7ba1\u7406\u5217\u8868\u9875\u9762\u6253\u5f00\u6210\u529f", (String)"FcsSourceInfoPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
        OperatorDialogUtils.operateDialog((String)TaxNameUtil.getTaxName((String)appId), (String)TDM_FCS_BASIC_INFO_ENTITY, (String)operateName, (String)operateDescription);
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)TPO_FCS_APANAGE_ENTITY, (boolean)false, (int)2);
        parameter.setCaption(ResManager.loadKDString((String)"\u623f\u4ea7\u5c5e\u5730\u7ba1\u7406\u5217\u8868", (String)"FcsSourceInfoPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FCS_APANAGE));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void updateFcsApanage(ListSelectedRowCollection returnData) {
        DynamicObject[] landTaxSources;
        ListSelectedRow row = returnData.get(0);
        Long fcsApanage = (Long)row.getPrimaryKeyValue();
        String selectFields = "fcsbyhirelimit,fcsbypricelimit,declarebymonth,declarebyseason,declarebyhalfyear,declarebyyeartype,declarebyyearlimit";
        DynamicObject fcsinfo = QueryServiceHelper.queryOne((String)TPO_FCS_APANAGE_ENTITY, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)fcsApanage)});
        Map<String, String> taxTimeData = TaxTimePointUtils.getTaxTimeData(FCS_PRICE, fcsinfo);
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        for (DynamicObject o : landTaxSources = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TDM_FCS_BASIC_INFO_ENTITY))) {
            String appId = this.getView().getFormShowParameter().getAppId();
            String billFormId = TPO_FCS_APANAGE_ENTITY;
            String number = (String)o.get("number");
            String operateName = String.format(ResManager.loadKDString((String)"\u786e\u5b9a", (String)"FcsSourceInfoPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), new Object[0]);
            String operateDescription = String.format(ResManager.loadKDString((String)"\u623f\u4ea7\u7f16\u53f7%s,\u66f4\u6539\u623f\u4ea7\u5c5e\u5730\u7ba1\u7406\u4fe1\u606f\u6210\u529f", (String)"FcsSourceInfoPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), number);
            OperatorDialogUtils.operateDialog((String)TaxNameUtil.getTaxName((String)appId), (String)billFormId, (String)operateName, (String)operateDescription);
            o.set("basedatafield", (Object)fcsApanage);
            o.set("taxpaylimit", (Object)taxTimeData.get("limit"));
            o.set("taxtimepoint", (Object)taxTimeData.get("taxtimepoint"));
            if ("halfyearbefore".equals(taxTimeData.get("taxtimepoint"))) {
                o.set("firsthalfmonth", (Object)"6");
                o.set("secondhalfmonth", (Object)"12");
                continue;
            }
            if ("seasonbefore".equals(taxTimeData.get("taxtimepoint"))) {
                o.set("firstquartermonth", (Object)"3");
                o.set("secondquartermonth", (Object)"6");
                o.set("thirdquartermonth", (Object)"9");
                o.set("fourthquartermonth", (Object)"12");
                continue;
            }
            if (!"yearbefore".equals(taxTimeData.get("taxtimepoint"))) continue;
            o.set("endmonth", (Object)taxTimeData.get("endMonth"));
        }
        SaveServiceHelper.save((DynamicObject[])landTaxSources);
        billList.refresh();
    }

    private void openFcsHireInfoBill(ListSelectedRowCollection selectedRows) {
        DynamicObject[] fcsBasinInfos = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TDM_FCS_BASIC_INFO_ENTITY));
        List orgList = Arrays.stream(fcsBasinInfos).map(d -> d.getDynamicObject(ORG).getString("id")).collect(Collectors.toList());
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put("orgid", String.join((CharSequence)",", orgList));
        PageShowCommon.showBillList(ShowType.MainNewTabPage, TDM_FCS_HIRE_INFO_ENTITY, this.getView(), customParam);
    }
}

