/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.taxSourceInfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.helper.tctb.orgtakerelation.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.opplugin.validator.SourceInfoDimensionSaveValidator;
import kd.taxc.tdm.common.util.StringUtil;
import kd.taxc.tdm.formplugin.taxSourceInfo.constant.SourceInfoChangeValidator;
import kd.taxc.tdm.formplugin.taxSourceInfo.constant.SourceInfoDateValidator;
import kd.taxc.tdm.formplugin.taxSourceInfo.constant.SourceInfoSaveValidator;

public class FcsSourceInfoSaveOp
extends AbstractOperationServicePlugIn {
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String APANAGE = "basedatafield";
    private static final String FCS_BY_PRICE = "fcsbyprice";
    private static final String ACQUIRE_DATE = "acquiredate";
    private static final String HOUSE_RENTAL_INFO_ENTITY_NAME = "tdm_house_rental_info";
    private static final String DATA_FLAG = "dataflag";
    private static final String BY_FRONT = "byFront";
    private static final String FCS_BASIC_INFO = "fcsbasicinfo";
    private static final String ORG = "org";
    private static final String FCS_APANAGE = "fcsapanage";
    private static final String BUILDING_NAME = "buildingname";
    private static final String TAX_AUTHORITY = "taxauthority";
    private static final String BUILDING_USAGE = "buildingusage";
    private static final String LOCATION = "location";
    private static final String DETAIL_ADDR = "detailaddr";
    private static final String SELECTED_FIELDS = "org,fcsapanage,buildingname,taxauthority,buildingusage,location,detailaddr";
    private static final Map<String, String> items = new HashMap<String, String>();

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    Object id;
                    QFilter filter;
                    DynamicObject[] genericObjects;
                    DynamicObject currentObj = dataEntity.getDataEntity();
                    DynamicObject org = currentObj.getDynamicObject(FcsSourceInfoSaveOp.ORG);
                    if (org != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong(FcsSourceInfoSaveOp.ID)).isSuccess()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"FcsSourceInfoSaveOp_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject apanageObj = currentObj.getDynamicObject(FcsSourceInfoSaveOp.APANAGE);
                    if (null == apanageObj && !FcsSourceInfoSaveOp.BY_FRONT.equals(currentObj.getString(FcsSourceInfoSaveOp.DATA_FLAG))) {
                        this.addErrorMessage(dataEntity, FcsSourceInfoSaveOp.this.getErrorInfo(FcsSourceInfoSaveOp.this.getFcsApanageCn()));
                        return;
                    }
                    currentObj.set(FcsSourceInfoSaveOp.DATA_FLAG, null);
                    if (null == apanageObj || apanageObj.getBoolean(FcsSourceInfoSaveOp.FCS_BY_PRICE)) {
                        ArrayList<String> errors = new ArrayList<String>(items.size());
                        for (Map.Entry item : items.entrySet()) {
                            if (!FcsSourceInfoSaveOp.this.checkIsNull(item, currentObj)) continue;
                            errors.add(FcsSourceInfoSaveOp.this.getErrorInfo((String)item.getValue()));
                        }
                        if (errors.size() != 0) {
                            errors.stream().forEach(s -> this.addErrorMessage(dataEntity, (String)s));
                            return;
                        }
                    }
                    if (null != (genericObjects = BusinessDataServiceHelper.load((String)FcsSourceInfoSaveOp.HOUSE_RENTAL_INFO_ENTITY_NAME, (String)FcsSourceInfoSaveOp.SELECTED_FIELDS, (QFilter[])new QFilter[]{filter = new QFilter(FcsSourceInfoSaveOp.FCS_BASIC_INFO, "=", id = currentObj.get(FcsSourceInfoSaveOp.ID))})) && genericObjects.length != 0) {
                        FcsSourceInfoSaveOp.this.updateFcsHireInfo(genericObjects, currentObj);
                    }
                    DynamicObject assetdata = currentObj.getDynamicObject("assetdata");
                    DynamicObject accountorg = currentObj.getDynamicObject("accountorg");
                    if (assetdata == null || org == null) continue;
                    if (FcsSourceInfoSaveOp.this.checkAssetdata(assetdata, accountorg, org)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u8d44\u4ea7\u7f16\u7801\u201d\u6570\u636e\u4e0d\u5b58\u5728\uff1a\u7f16\u7801%s\u3002", (String)"FcsSourceInfoSaveOp_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), assetdata.getString("assetcode")));
                        return;
                    }
                    long basicInfoId = assetdata.getLong(FcsSourceInfoSaveOp.ID);
                    DynamicObject object = QueryServiceHelper.queryOne((String)"tdm_fcs_basic_info", (String)"number", (QFilter[])new QFilter[]{new QFilter("assetdata", "=", (Object)basicInfoId)});
                    if (object != null && !object.getString("number").equals(currentObj.getString("number"))) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u8d44\u4ea7\u7f16\u7801\u201d\u5df2\u88ab\u623f\u4ea7\u7f16\u53f7\u201c%s\u201d\u4f7f\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FcsSourceInfoSaveOp_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), object.getString("number")));
                        return;
                    }
                    Date acquiredate = currentObj.getDate(FcsSourceInfoSaveOp.ACQUIRE_DATE);
                    Date changedate = currentObj.getDate("changedate");
                    if (changedate == null || acquiredate.compareTo(changedate) <= 0) continue;
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7eb3\u7a0e\u4e49\u52a1\u7ec8\u6b62\u65f6\u95f4\u4e0d\u5f97\u65e9\u4e8e\u623f\u4ea7\u53d6\u5f97\u65f6\u95f4\u3002", (String)"FcsSourceInfoSaveOp_8", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                }
            }
        });
        e.getValidators().add(new SourceInfoSaveValidator());
        e.getValidators().add(new SourceInfoDateValidator());
        e.getValidators().add(new SourceInfoChangeValidator(ACQUIRE_DATE, "changedate", ResManager.loadKDString((String)"\u623f\u4ea7", (String)"FcsSourceInfoSaveOp_9", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        e.getValidators().add(new SourceInfoDimensionSaveValidator(BaseTaxCategory.FCS));
    }

    private boolean checkAssetdata(DynamicObject assetdata, DynamicObject accountorg, DynamicObject org) {
        String assetstatus = assetdata.getString("assetstatus");
        Long assetOrgId = assetdata.getDynamicObject("taxorg").getLong(ID);
        Long orgId = org.getLong(ID);
        if ("clean".equals(assetstatus)) {
            return true;
        }
        if (accountorg == null) {
            Date now = new Date();
            List orgids = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(orgId), (Date)now, (Date)now);
            if (!CollectionUtils.isEmpty((Collection)orgids)) {
                return !orgids.contains(assetOrgId);
            }
            return true;
        }
        Long accountorgId = accountorg.getLong(ID);
        return !accountorgId.equals(assetOrgId);
    }

    private void updateFcsHireInfo(DynamicObject[] genericObjects, DynamicObject dynamicObject) {
        for (DynamicObject object : genericObjects) {
            object.set(ORG, dynamicObject.get(ORG));
            object.set(FCS_APANAGE, dynamicObject.get(APANAGE));
            object.set(BUILDING_NAME, dynamicObject.get(NAME));
            object.set(TAX_AUTHORITY, dynamicObject.get(TAX_AUTHORITY));
            object.set(BUILDING_USAGE, dynamicObject.get(BUILDING_USAGE));
            object.set(LOCATION, dynamicObject.get(LOCATION));
            object.set(DETAIL_ADDR, dynamicObject.get(DETAIL_ADDR));
        }
        SaveServiceHelper.save((DynamicObject[])genericObjects);
    }

    private boolean checkIsNull(Map.Entry<String, String> item, DynamicObject currentObj) {
        if (item.getKey().equals(ACQUIRE_DATE)) {
            return null == currentObj.get(item.getKey());
        }
        if (item.getKey().equals("endmonth")) {
            return "yearbefore".equals(currentObj.getString("taxtimepoint")) && StringUtil.isBlank((CharSequence)currentObj.getString("endmonth"));
        }
        if (item.getKey().equals("taxpaylimit")) {
            return StringUtil.isBlank((CharSequence)currentObj.getString("taxpaylimit"));
        }
        if (item.getKey().equals("taxtimepoint")) {
            return StringUtil.isBlank((CharSequence)currentObj.getString("taxtimepoint"));
        }
        return false;
    }

    private String getErrorInfo(String value) {
        return String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\uff1a \"%s\"\u3002", (String)"FcsSourceInfoSaveOp_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), value);
    }

    private String getFcsApanageCn() {
        return ResManager.loadKDString((String)"\u623f\u4ea7\u5c5e\u5730\u7ba1\u7406", (String)"FcsSourceInfoSaveOp_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
    }

    static {
        items.put("endmonth", ResManager.loadKDString((String)"\u7ec8\u4e86\u524d\u6708\u4efd\u6570", (String)"FcsSourceInfoSaveOp_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        items.put("taxpaylimit", ResManager.loadKDString((String)"\u7eb3\u7a0e\u671f\u9650", (String)"FcsSourceInfoSaveOp_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        items.put("taxtimepoint", ResManager.loadKDString((String)"\u7eb3\u7a0e\u65f6\u70b9", (String)"FcsSourceInfoSaveOp_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
    }
}

