/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.taxSourceInfo;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxorg.TaxNameUtil;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.tdm.business.taxsource.FcsTdsTaxsourceServiceHelper;
import kd.taxc.tdm.formplugin.utils.TaxTimePointUtils;

public class LandTaxSourceListPlugin
extends AbstractListPlugin {
    private static final String CALLBACKID_1 = "callback1";
    private static final String TOOL_BAR_NAME = "toolbarap";
    private static final String BILL_NAME = "billlistap";
    private static final String TDS_APANAGE = "tdsapanage";
    private static final String TDS_TDSDGL = "tdsdgl";
    private static final String TDS_APANAGE_ENTITY_NAME = "tpo_tcret_tds_apanage";
    private static final String TDS_BASIC_INFO_ENTITY_NAME = "tdm_tds_basic_info";
    public static final String TDS_BASIC = "tds_basic";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOL_BAR_NAME});
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        DynamicObject[] dynamicObjects;
        List numbers;
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        BillList billlist = (BillList)this.getControl(BILL_NAME);
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (TDS_TDSDGL.equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.loadTdsapanage();
        } else if ("disable".equals(key) && afterDoOperationEventArgs.getOperationResult().isSuccess() && (numbers = Arrays.stream(dynamicObjects = FcsTdsTaxsourceServiceHelper.findTdsTaxsource((Object[])list.getPrimaryKeyValues())).filter(a -> !a.getDynamicObjectCollection("houseentryentity").isEmpty()).map(a -> a.getString("number")).collect(Collectors.toList())).size() > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u571f\u5730\u7f16\u53f7%s\u5df2\u5173\u8054\u623f\u4ea7\u57fa\u7840\uff0c\u7981\u7528\u72b6\u6001\u5c06\u5f71\u54cd\u623f\u4ea7\u57fa\u7840\u4fe1\u606f\u5e94\u644a\u5165\u571f\u5730\u4ef7\u503c\u8ba1\u7b97\u7ed3\u679c", (String)"LandTaxSourceListPlugin_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", numbers)));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (CollectionUtils.isEmpty((Collection)returnData)) {
            return;
        }
        if (CALLBACKID_1.equals(actionId)) {
            this.updateTdsapanage(returnData);
        }
    }

    private void loadTdsapanage() {
        BillList list = (BillList)this.getControl(BILL_NAME);
        if (CollectionUtils.isEmpty((Collection)list.getSelectedRows())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u6570\u636e\u3002", (String)"LandTaxSourceListPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return;
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParams().get("billFormId");
        String operateName = ResManager.loadKDString((String)"\u571f\u5730\u5c5e\u5730\u7ba1\u7406", (String)"LandTaxSourceListPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
        String operateDescription = ResManager.loadKDString((String)"\u571f\u5730\u5c5e\u5730\u7ba1\u7406\u5217\u8868\u9875\u9762\u6253\u5f00\u6210\u529f", (String)"LandTaxSourceListPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
        OperatorDialogUtils.operateDialog((String)TaxNameUtil.getTaxName((String)appId), (String)billFormId, (String)operateName, (String)operateDescription);
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)TDS_APANAGE_ENTITY_NAME, (boolean)false, (int)2);
        parameter.setCaption(ResManager.loadKDString((String)"\u571f\u5730\u5c5e\u5730\u7ba1\u7406\u5217\u8868", (String)"LandTaxSourceListPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACKID_1));
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        QFilter tdsyslimitFilter = new QFilter("tdsyslimit", "!=", (Object)"false");
        listFilterParameter.getQFilters().add(tdsyslimitFilter);
        parameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void updateTdsapanage(ListSelectedRowCollection returnData) {
        DynamicObject[] landTaxSources;
        ListSelectedRow row = returnData.get(0);
        Long tdsapanage = (Long)row.getPrimaryKeyValue();
        String selectFields = "tdsyslimit,declarebymonth,declarebyseason,declarebyhalfyear,declarebyyeartype,declarebyyearlimit";
        DynamicObject fcsinfo = QueryServiceHelper.queryOne((String)TDS_APANAGE_ENTITY_NAME, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tdsapanage)});
        Map<String, String> taxTimeData = TaxTimePointUtils.getTaxTimeData(TDS_BASIC, fcsinfo);
        BillList billList = (BillList)this.getControl(BILL_NAME);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        for (DynamicObject o : landTaxSources = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TDS_BASIC_INFO_ENTITY_NAME))) {
            String appId = this.getView().getFormShowParameter().getAppId();
            String billFormId = TDS_APANAGE_ENTITY_NAME;
            String number = (String)o.get("number");
            String operateName = String.format(ResManager.loadKDString((String)"\u786e\u5b9a", (String)"LandTaxSourceListPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), new Object[0]);
            String operateDescription = String.format(ResManager.loadKDString((String)"\u571f\u5730\u7f16\u53f7%s,\u66f4\u6539\u571f\u5730\u5c5e\u5730\u7ba1\u7406\u4fe1\u606f\u6210\u529f", (String)"LandTaxSourceListPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), number);
            OperatorDialogUtils.operateDialog((String)TaxNameUtil.getTaxName((String)appId), (String)billFormId, (String)operateName, (String)operateDescription);
            o.set(TDS_APANAGE, (Object)tdsapanage);
            o.set("taxtimelimit", (Object)taxTimeData.get("limit"));
            o.set("taxtimepoint", (Object)taxTimeData.get("taxtimepoint"));
            if ("halfyearbefore".equals(taxTimeData.get("taxtimepoint"))) {
                o.set("firsthalfmonth", (Object)"6");
                o.set("secondhalfmonth", (Object)"12");
                continue;
            }
            if ("seasonbefore".equals(taxTimeData.get("taxtimepoint"))) {
                o.set("firstquartermonth", (Object)"3");
                o.set("secondquartermonth", (Object)"6");
                o.set("thirdquartermonth", (Object)"9");
                o.set("fourthquartermonth", (Object)"12");
                continue;
            }
            if (!"yearbefore".equals(taxTimeData.get("taxtimepoint"))) continue;
            o.set("endmonth", (Object)taxTimeData.get("endMonth"));
        }
        SaveServiceHelper.save((DynamicObject[])landTaxSources);
        billList.refresh();
    }
}

