/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.taxSourceInfo;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tdm.business.taxsource.FcsTdsTaxsourceServiceHelper;
import kd.taxc.tdm.common.license.ExtendAbstractBillPlugin;
import kd.taxc.tdm.formplugin.utils.TaxTimePointUtils;
import org.apache.commons.lang3.ObjectUtils;

public class TdsSourceInfoFormPlugin
extends ExtendAbstractBillPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String TAX_PAY_LIMIT = "taxtimelimit";
    private static final String TAX_TIME_POINT = "taxtimepoint";
    private static final String ORG = "org";
    private static final String END_MONTH = "endmonth";
    private static final String YEAR_BEFORE = "yearbefore";
    private static final String TDSAPANAGE = "tdsapanage";
    private static final String HOUSENUMBER = "housenumber";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit levelTextEdit = (TextEdit)this.getControl("level");
        TextEdit bglevelTextEdit = (TextEdit)this.getControl("bglevel");
        levelTextEdit.addClickListener((ClickListener)this);
        bglevelTextEdit.addClickListener((ClickListener)this);
        BasedataEdit housenumber = (BasedataEdit)this.getControl(HOUSENUMBER);
        housenumber.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        housenumber.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Boolean assertvalueform;
        Date jmend;
        String name = e.getProperty().getName();
        DynamicObject tdsapanage = (DynamicObject)this.getModel().getValue(TDSAPANAGE);
        ArrayList unitpriceList = Lists.newArrayList((Object[])new String[]{"price", "usagerightamount", "landdevcost", "landarea", "bglandarea", "bgdate"});
        ArrayList plotratioList = Lists.newArrayList((Object[])new String[]{"housearea", "landarea", "bglandarea", "bgdate"});
        ArrayList valueList = Lists.newArrayList((Object[])new String[]{"price", "usagerightamount", "landdevcost", "landunitprice", "housearea", "landarea", "bglandarea", "bgdate"});
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        int focusRow = entryentity.getEntryState().getFocusRow();
        if (TDSAPANAGE.equals(name) || TAX_PAY_LIMIT.equals(name)) {
            String value = (String)this.getModel().getValue(TAX_PAY_LIMIT);
            if (TDSAPANAGE.equals(name)) {
                value = tdsapanage.getString("tdsyslimit");
                this.getModel().setValue(TAX_PAY_LIMIT, (Object)value);
            }
            ComboEdit comboEdit = (ComboEdit)this.getControl(TAX_TIME_POINT);
            ArrayList<ComboItem> comboItems = TaxTimePointUtils.getTaxTimePoints(value);
            comboEdit.setComboItems(comboItems);
            this.getModel().setValue(TAX_TIME_POINT, (Object)TaxTimePointUtils.getTaxTimePointValue(comboItems, tdsapanage, value));
        } else if (name.equals(TAX_TIME_POINT)) {
            if (!this.getModel().getValue(TAX_TIME_POINT).equals(YEAR_BEFORE)) {
                this.getModel().setValue(END_MONTH, (Object)"");
            } else {
                this.getModel().setValue(END_MONTH, (Object)TaxTimePointUtils.getEndMonth(tdsapanage));
            }
        } else if ("start".equals(name)) {
            Date jmstart = (Date)this.getModel().getValue("start", focusRow);
            if (jmstart != null && !jmstart.equals(DateUtils.getFirstDateOfMonth((Date)jmstart))) {
                this.getModel().setValue("start", (Object)DateUtils.getFirstDateOfMonth((Date)jmstart), focusRow);
                return;
            }
        } else if ("end".equals(name) && (jmend = (Date)this.getModel().getValue("end", focusRow)) != null && !jmend.equals(DateUtils.getLastDateOfMonth2((Date)jmend))) {
            this.getModel().setValue("end", (Object)DateUtils.getLastDateOfMonth2((Date)jmend), focusRow);
            return;
        }
        if (org != null && (assertvalueform = (Boolean)SystemParamUtil.getAppParameter((String)"tcret", (String)"assertvalueform", (long)org.getLong("id"))) != null && assertvalueform.booleanValue()) {
            if (unitpriceList.contains(name)) {
                this.updataUnitprice();
            }
            if (plotratioList.contains(name)) {
                this.updataPlotratio();
            }
            if (valueList.contains(name)) {
                this.updataValue();
            }
        }
    }

    private void updataUnitprice() {
        DynamicObjectCollection bgentryentity = this.getModel().getEntryEntity("bgentryentity");
        BigDecimal price = (BigDecimal)this.getModel().getValue("price");
        BigDecimal usagerightamount = (BigDecimal)this.getModel().getValue("usagerightamount");
        BigDecimal landdevcost = (BigDecimal)this.getModel().getValue("landdevcost");
        BigDecimal landarea = (BigDecimal)this.getModel().getValue("landarea");
        BigDecimal landunitprice = FcsTdsTaxsourceServiceHelper.updateLandUnitPrice((DynamicObjectCollection)bgentryentity, (BigDecimal)price, (BigDecimal)usagerightamount, (BigDecimal)landdevcost, (BigDecimal)landarea);
        this.getModel().setValue("landunitprice", (Object)landunitprice);
    }

    private void updataPlotratio() {
        DynamicObjectCollection houseentryentity = this.getModel().getEntryEntity("houseentryentity");
        DynamicObjectCollection bgentryentity = this.getModel().getEntryEntity("bgentryentity");
        BigDecimal landarea = (BigDecimal)this.getModel().getValue("landarea");
        BigDecimal landplotratio = FcsTdsTaxsourceServiceHelper.updateLandPlotRatio((DynamicObjectCollection)houseentryentity, (DynamicObjectCollection)bgentryentity, (BigDecimal)landarea);
        this.getModel().setValue("landplotratio", (Object)landplotratio);
    }

    private void updataValue() {
        BigDecimal landplotratio = (BigDecimal)this.getModel().getValue("landplotratio");
        BigDecimal landunitprice = (BigDecimal)this.getModel().getValue("landunitprice");
        BigDecimal price = (BigDecimal)this.getModel().getValue("price");
        BigDecimal usagerightamount = (BigDecimal)this.getModel().getValue("usagerightamount");
        BigDecimal landdevcost = (BigDecimal)this.getModel().getValue("landdevcost");
        BigDecimal sumPrice = price.add(usagerightamount).add(landdevcost);
        DynamicObjectCollection houseentryentity = this.getModel().getEntryEntity("houseentryentity");
        for (DynamicObject house : houseentryentity) {
            BigDecimal housearea = house.getBigDecimal("housearea");
            BigDecimal value = FcsTdsTaxsourceServiceHelper.updateValue((DynamicObjectCollection)houseentryentity, (BigDecimal)landplotratio, (BigDecimal)housearea, (BigDecimal)landunitprice, (BigDecimal)sumPrice);
            this.getModel().setValue("value", (Object)value, house.getInt("seq") - 1);
        }
        if (houseentryentity.size() > 0 && landplotratio.compareTo(BigDecimal.valueOf(0.5)) >= 0) {
            BigDecimal sumValue = houseentryentity.stream().filter(a -> a.getInt("seq") != houseentryentity.size()).map(a -> a.getBigDecimal("value")).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal value = BigDecimalUtil.subtractObject((Object)sumPrice, (Object)sumValue);
            this.getModel().setValue("value", (Object)value, houseentryentity.size() - 1);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.setTaxOfficeVal();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String value = (String)this.getModel().getValue(TAX_PAY_LIMIT);
        ComboEdit comboEdit = (ComboEdit)this.getControl(TAX_TIME_POINT);
        comboEdit.setComboItems(TaxTimePointUtils.getTaxTimePoints(value));
        this.setVisableEnable();
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (HOUSENUMBER.equals(key) && evt.getListSelectedRow() != null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u571f\u5730\u7f16\u53f7%s\u5bf9\u5e94\u7684\u623f\u4ea7\u4fe1\u606f\u5e94\u644a\u5165\u571f\u5730\u4ef7\u503c\u53d1\u751f\u8c03\u6574", (String)"TdsSourceInfoFormPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), this.getModel().getValue("number")));
        }
    }

    private void setVisableEnable() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"fieldsetpanelap1", "advconap2"});
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org != null) {
            Boolean assertvalueform = (Boolean)SystemParamUtil.getAppParameter((String)"tcret", (String)"assertvalueform", (long)org.getLong("id"));
            if (assertvalueform != null && assertvalueform.booleanValue()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"fieldsetpanelap1", "advconap2"});
                BasedataEdit housenumber = (BasedataEdit)this.getControl(HOUSENUMBER);
                housenumber.setMustInput(true);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"fieldsetpanelap1", "advconap2"});
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (HOUSENUMBER.equals(fieldKey)) {
            QFilter qFilter = new QFilter(ORG, "=", (Object)(org == null ? 0L : org.getLong("id"))).and(new QFilter("landtaxsource", "=", (Object)0L).or(new QFilter("landtaxsource", "=", null))).and(new QFilter("enable", "=", (Object)"1"));
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        DynamicObject org;
        if (StringUtil.equalsIgnoreCase((CharSequence)evt.getItemKey(), (CharSequence)"bar_save") && (org = (DynamicObject)this.getModel().getValue(ORG)) != null) {
            Boolean assertvalueform = (Boolean)SystemParamUtil.getAppParameter((String)"tcret", (String)"assertvalueform", (long)org.getLong("id"));
            DynamicObjectCollection houseentryentity = this.getModel().getEntryEntity("houseentryentity");
            if (assertvalueform != null && assertvalueform.booleanValue()) {
                if (houseentryentity.size() > 0) {
                    evt.setCancel(true);
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("saveConfirm", (IFormPlugin)this);
                    HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
                    btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"TdsSourceInfoFormPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"TdsSourceInfoFormPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    String msg = String.format(ResManager.loadKDString((String)"\u6240\u6709\u5173\u8054\u571f\u5730\u7f16\u53f7%s\u7684\u623f\u4ea7\u5e94\u644a\u5165\u571f\u5730\u4ef7\u503c\u7b49\u5373\u5c06\u53d1\u751f\u8054\u52a8\u8c03\u6574\uff0c\u662f\u5426\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"TdsSourceInfoFormPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), this.getModel().getValue("number"));
                    this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
                }
                this.checkChangeData();
            }
        }
    }

    private void checkChangeData() {
        DynamicObject oldObject;
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.equals((Object)status) && (oldObject = FcsTdsTaxsourceServiceHelper.findTdsTaxsource((Long)this.getModel().getDataEntity().getLong("id"))) != null) {
            List oldHouseIdList = oldObject.getDynamicObjectCollection("houseentryentity").stream().map(o -> o.getLong("housenumber.id")).collect(Collectors.toList());
            DynamicObjectCollection houseentryentity = this.getModel().getEntryEntity("houseentryentity");
            List newHouseIdList = houseentryentity.stream().map(o -> o.getLong("housenumber.id")).collect(Collectors.toList());
            List updateHouseIdList = oldHouseIdList.stream().filter(a -> !newHouseIdList.contains(a)).collect(Collectors.toList());
            if (updateHouseIdList.size() > 0) {
                this.getPageCache().put("updateHouseIdList", SerializationUtils.toJsonString(updateHouseIdList));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if ("saveConfirm".equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("save");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        long userId;
        Boolean hasPermOrgResult;
        super.beforeDoOperation(args);
        String appId = this.getView().getFormShowParameter().getAppId();
        FormOperate operate = (FormOperate)args.getSource();
        if (!(!"deletehouseentry".equals(operate.getOperateKey()) && !"newhouseentry".equals(operate.getOperateKey()) || (hasPermOrgResult = Boolean.valueOf(PermissionServiceHelper.hasSpecificPerm((long)(userId = RequestContext.get().getCurrUserId()), (String)appId, (String)"tdm_fcs_basic_info", (String)"3T93RK3PYUW8"))) != null && hasPermOrgResult.booleanValue())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u623f\u4ea7\u57fa\u7840\u4fe1\u606f\u201d\u7684\u201c\u8ba1\u7b97\u5e94\u644a\u5165\u571f\u5730\u4ef7\u503c\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"TdsSourceInfoFormPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        String operateKey = args.getOperateKey();
        if (operationResult != null && operationResult.isSuccess() && "save".equals(operateKey)) {
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList updateCollection = new ArrayList();
            DynamicObjectCollection houseentryentity = this.getModel().getEntryEntity("houseentryentity");
            List unableList = houseentryentity.stream().filter(a -> "0".equals(a.getString("housenumber.enable"))).map(a -> a.getString("housenumber.number")).collect(Collectors.toList());
            if (unableList.size() > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u623f\u4ea7\u7f16\u53f7%s\u72b6\u6001\u4e3a\u7981\u7528\uff0c\u8bf7\u6838\u5b9e\u5e94\u644a\u5165\u571f\u5730\u4ef7\u503c\u6570\u636e\u7684\u51c6\u786e\u6027\u3002", (String)"TdsSourceInfoFormPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", unableList)));
            }
            Long id = this.getModel().getDataEntity().getLong("id");
            Map fcsMaps = FcsTdsTaxsourceServiceHelper.findFcsTaxsource((DynamicObjectCollection)houseentryentity);
            for (DynamicObject object : houseentryentity) {
                String msg = FcsTdsTaxsourceServiceHelper.convert(updateCollection, (DynamicObject)((DynamicObject)fcsMaps.get(object.getLong("housenumber.id"))), (BigDecimal)object.getBigDecimal("value"), (Long)id);
                if (!StringUtil.isNotEmpty((CharSequence)msg)) continue;
                String tabLine = "\n";
                stringBuilder.append(msg).append(tabLine);
            }
            if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("updateHouseIdList"))) {
                List updateHouseIdList = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("updateHouseIdList"), Long.class);
                FcsTdsTaxsourceServiceHelper.updateLandtaxsource((List)updateHouseIdList);
                this.getPageCache().put("updateHouseIdList", "");
            }
            SaveServiceHelper.save((DynamicObject[])updateCollection.toArray(new DynamicObject[updateCollection.size()]));
            if (StringUtil.isNotBlank((CharSequence)stringBuilder.toString())) {
                this.getView().showErrorNotification(stringBuilder.toString());
            }
        }
        if ("deletehouseentry".equals(operateKey)) {
            this.updataPlotratio();
            this.updataValue();
        }
        if ("deletebgentry".equals(operateKey)) {
            this.updataUnitprice();
            this.updataPlotratio();
            this.updataValue();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        String key = ((Control)source).getKey();
        DynamicObject taxauthority = (DynamicObject)this.getModel().getValue("taxauthority");
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"level") || StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"bglevel")) {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId("tcret_landlevel");
            listShowParameter.setFormId("bos_listf7");
            listShowParameter.setMultiSelect(false);
            StyleCss css = new StyleCss();
            css.setWidth("960px");
            css.setHeight("580px");
            listShowParameter.getOpenStyle().setInlineStyleCss(css);
            listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            listShowParameter.setShowTitle(false);
            listShowParameter.setLookUp(true);
            if (taxauthority != null) {
                QFilter qFilter = new QFilter("group", "=", taxauthority.get("id")).and(new QFilter("enable", "=", (Object)"1"));
                listShowParameter.getListFilterParameter().setFilter(qFilter);
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
            listShowParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection listDatas;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ((StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)"level") || StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)"bglevel")) && !ObjectUtils.isEmpty((Object)(listDatas = (ListSelectedRowCollection)closedCallBackEvent.getReturnData())) && listDatas.size() > 0) {
            for (ListSelectedRow row : listDatas) {
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tcret_landlevel", (String)"id,landlevel,taxstandard", (QFilter[])new QFilter[]{new QFilter("id", "=", row.getPrimaryKeyValue())});
                this.getModel().setValue(actionId, (Object)dynamicObject.getString("landlevel"));
                if (StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)"level")) {
                    this.getModel().setValue("taxstandard", (Object)dynamicObject.getString("taxstandard"));
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)"bglevel")) continue;
                this.getModel().setValue("bgtaxstandard", (Object)dynamicObject.getString("taxstandard"));
            }
        }
    }

    private void setTaxOfficeVal() {
        DynamicObject taxOrg;
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (null != org && null != (taxOrg = QueryServiceHelper.queryOne((String)"tctb_tax_main", (String)"id,taxoffice", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)org.getString("number"))}))) {
            this.getModel().setValue("taxauthority", (Object)taxOrg.getString("taxoffice"));
        }
    }
}

