/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.taxSourceInfo;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.opplugin.validator.SourceInfoDimensionSaveValidator;
import kd.taxc.tdm.common.util.StringUtil;
import kd.taxc.tdm.formplugin.taxSourceInfo.constant.SourceInfoChangeValidator;
import kd.taxc.tdm.formplugin.taxSourceInfo.constant.SourceInfoDateValidator;
import kd.taxc.tdm.formplugin.taxSourceInfo.constant.SourceInfoHouseEntityValidator;
import kd.taxc.tdm.formplugin.taxSourceInfo.constant.SourceInfoSaveValidator;
import org.apache.commons.lang3.StringUtils;

public class TdsSourceInfoSaveOp
extends AbstractOperationServicePlugIn {
    private static final String LOCATION_ENTITY_NAME = "bd_admindivision";
    private static final String LOCATION = "addr";
    private static final String PROVINCE = "province";
    private static final String CITY = "city";
    private static final String COUNTRY = "country";
    private static final String REGEX = "_";

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject currentObj = dataEntity.getDataEntity();
                    DynamicObject org = currentObj.getDynamicObject("org");
                    if (org != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"TdsSourceInfoSaveOp_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    TdsSourceInfoSaveOp.this.addAddr(currentObj);
                }
            }
        });
        e.getValidators().add(new SourceInfoSaveValidator());
        e.getValidators().add(new SourceInfoDateValidator());
        e.getValidators().add(new SourceInfoChangeValidator("obtaintime", "changetime", ResManager.loadKDString((String)"\u571f\u5730", (String)"TdsSourceInfoSaveOp_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        e.getValidators().add(new SourceInfoDimensionSaveValidator(BaseTaxCategory.CZTDSYS));
        e.getValidators().add(new SourceInfoHouseEntityValidator("houseentryentity"));
    }

    private void addAddr(DynamicObject currentObj) {
        String[] splitName;
        DynamicObject addr;
        String names;
        String fieldId = (String)currentObj.get(LOCATION);
        if (StringUtils.isNotEmpty((CharSequence)fieldId) && !StringUtil.isEmpty((CharSequence)(names = (String)(addr = QueryServiceHelper.queryOne((String)LOCATION_ENTITY_NAME, (String)"fullname", (QFilter[])new QFilter("id", "=", (Object)Long.parseLong(fieldId)).toArray())).get(0))) && (splitName = names.split(REGEX)).length >= 3) {
            currentObj.set(PROVINCE, (Object)splitName[0]);
            currentObj.set(CITY, (Object)splitName[1]);
            currentObj.set(COUNTRY, (Object)splitName[2]);
        }
    }
}

