/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.taxSourceInfo.constant;

import java.util.Date;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.tdm.common.util.DateUtils;

public class SourceInfoChangeValidator
extends AbstractValidator {
    private String acquireDateKey;
    private String changeDateKey;
    private String name;

    public SourceInfoChangeValidator(String acquireDateKey, String changeDateKey, String name) {
        this.acquireDateKey = acquireDateKey;
        this.changeDateKey = changeDateKey;
        this.name = name;
    }

    public void validate() {
        for (ExtendedDataEntity object : this.dataEntities) {
            DynamicObject dataEntity = object.getDataEntity();
            Date acquiredate = dataEntity.getDate(this.acquireDateKey);
            Date changedate = dataEntity.getDate(this.changeDateKey);
            HashSet<String> periods = new HashSet<String>();
            boolean hasSameMonthDate = false;
            for (DynamicObject entry : dataEntity.getDynamicObjectCollection("bgentryentity")) {
                Date bgdate = entry.getDate("bgdate");
                if (bgdate != null) {
                    String month = DateUtils.formatMonth((Date)bgdate);
                    if (periods.contains(month)) {
                        hasSameMonthDate = true;
                    } else {
                        periods.add(month);
                    }
                }
                if (this.checkDates(acquiredate, changedate, bgdate)) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u53d8\u66f4\u767b\u8bb0\u53f0\u8d26\u201d\u7b2c%1$s\u884c\uff1a%2$s\u53d6\u5f97\u65f6\u95f4<\u53d8\u66f4\u65f6\u95f4<\u7eb3\u7a0e\u4e49\u52a1\u7ec8\u6b62\u65f6\u95f4\u3002", (String)"SourceInfoChangeValidator_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), entry.getInt("seq"), this.name);
                this.addFatalErrorMessage(object, msg);
            }
            if (!hasSameMonthDate) continue;
            this.addErrorMessage(object, ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u6708\u5185\u4e0d\u80fd\u4fdd\u5b58\u591a\u6761\u53d8\u66f4\u53f0\u8d26\u6570\u636e\u3002", (String)"SourceInfoChangeValidator_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkDates(Date acquiredate, Date changedate, Date bgdate) {
        Date firstDateOfMontnbgdate;
        if (acquiredate == null || bgdate == null) {
            return true;
        }
        Date acquiredatenextmonth = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)acquiredate, (int)1));
        if (acquiredatenextmonth.compareTo(firstDateOfMontnbgdate = DateUtils.getFirstDateOfMonth((Date)bgdate)) > 0) {
            return false;
        }
        if (changedate != null) {
            Date changedatepremonth = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)changedate, (int)-1));
            return changedatepremonth.compareTo(firstDateOfMontnbgdate) >= 0;
        }
        return true;
    }
}

