/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.taxSourceInfo.constant;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tdm.common.util.DateFilterUtils;
import kd.taxc.tdm.formplugin.utils.FcsByHireSourceInfoUtils;

public class SourceInfoDateValidator
extends AbstractValidator {
    public void validate() {
        DateFilterUtils dateFilterUtils = new DateFilterUtils();
        HashMap map = new HashMap();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject currentObj = dataEntity.getDataEntity();
            DynamicObjectCollection entryEntitys = currentObj.getDynamicObjectCollection("entryentity");
            int rowIndex = 0;
            for (DynamicObject obj : entryEntitys) {
                LocalDate endLocalDate;
                ++rowIndex;
                String number = obj.getString("taxdeduction.number");
                List<DynamicObject> list = map.get(number) != null ? (List)map.get(number) : new ArrayList();
                list.add(obj);
                map.put(number, list);
                Date start = obj.getDate("start");
                if (start == null) {
                    return;
                }
                Date end = obj.getDate("end");
                LocalDate startLocalDate = FcsByHireSourceInfoUtils.date2LocalDate(start);
                if (!FcsByHireSourceInfoUtils.isFirstOrLastDay("start", startLocalDate)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51cf\u514d\u8d77\u59cb\u65f6\u95f4\u53ea\u80fd\u9009\u62e9\u6708\u521d1\u53f7\u3002", (String)"SourceInfoDateValidator_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (end != null && !FcsByHireSourceInfoUtils.isFirstOrLastDay("end", endLocalDate = FcsByHireSourceInfoUtils.date2LocalDate(end))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51cf\u514d\u7ec8\u6b62\u65f6\u95f4\u53ea\u80fd\u9009\u62e9\u6708\u672b\u6700\u540e1\u5929\u3002", (String)"SourceInfoDateValidator_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (end != null && (start.after(end) || start.equals(end))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u914d\u7f6e\u7684\u201c\u51cf\u514d\u8d77\u59cb\u65f6\u95f4\u201d\u4e0d\u5f97\u5927\u4e8e\u7b49\u4e8e\u201c\u51cf\u514d\u7ec8\u6b62\u65f6\u95f4\u201d\uff0c\u8bf7\u4fee\u6539\u201c\u51cf\u514d\u8d77\u59cb\u65f6\u95f4\u201d\u6216\u201c\u51cf\u514d\u7ec8\u6b62\u65f6\u95f4\u201d\u3002", (String)"SourceInfoDateValidator_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                String entityName = dataEntity.getDataEntity().getDataEntityType().getName();
                if (!"tdm_fcs_basic_info".equals(entityName)) continue;
                Date acquiredate = currentObj.getDate("acquiredate");
                if (acquiredate != null && start.compareTo(acquiredate) <= 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u51cf\u514d\u767b\u8bb0\u53f0\u8d26\u201d\u7b2c%s\u884c\uff1a\u51cf\u514d\u8d77\u59cb\u65f6\u95f4\uff08\u5e74\u3001\u6708\uff09\u53ea\u80fd\u665a\u4e8e\u623f\u4ea7\u53d6\u5f97\u65f6\u95f4", (String)"SourceInfoDateValidator_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), rowIndex));
                    return;
                }
                Date changedate = currentObj.getDate("changedate");
                if ((end == null || changedate == null || DateUtils.getLastDateOfMonth1((Date)end).compareTo(DateUtils.getLastDateOfMonth1((Date)changedate)) <= 0) && (changedate == null || end != null)) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u51cf\u514d\u767b\u8bb0\u53f0\u8d26\u201d\u7b2c%s\u884c\uff1a\u51cf\u514d\u7ec8\u6b62\u65f6\u95f4\uff08\u5e74\u3001\u6708\uff09\u53ea\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u7eb3\u7a0e\u4e49\u52a1\u7ec8\u6b62\u65f6\u95f4", (String)"SourceInfoDateValidator_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), rowIndex));
                return;
            }
            if (dateFilterUtils.hasOverlap(map.values())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u914d\u7f6e\u7684\u51cf\u514d\u8d77\u6b62\u65f6\u95f4\u5185\u5df2\u5b58\u5728\u76f8\u540c\u51cf\u514d\u9879\u76ee\uff0c\u8bf7\u4fee\u6539\u51cf\u514d\u9879\u76ee\u6216\u8005\u51cf\u514d\u8d77\u6b62\u65f6\u95f4\u3002", (String)"SourceInfoDateValidator_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return;
            }
            map.clear();
        }
    }
}

