/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.taxSourceInfo.constant;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class SourceInfoSaveValidator
extends AbstractValidator {
    public void validate() {
        BigDecimal zero = new BigDecimal(0);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            ArrayList<String> errorMsg = new ArrayList<String>();
            DynamicObject currentObj = dataEntity.getDataEntity();
            DynamicObjectCollection entryEntitys = currentObj.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < entryEntitys.size(); ++i) {
                DynamicObject obj = (DynamicObject)entryEntitys.get(i);
                Object taxductiontype = obj.get("taxdeduction.deductiontype");
                if ("6".equals(taxductiontype)) {
                    Object monthlimit = obj.get("monthlimit");
                    if (monthlimit == null) {
                        errorMsg.add(ResManager.loadKDString((String)"\u6bcf\u6708\u51cf\u514d\u7a0e\u989d", (String)"SourceInfoSaveValidator_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    String entityName;
                    Object ratio = obj.get("ratio");
                    if (ratio == null || zero.compareTo((BigDecimal)ratio) == 0) {
                        errorMsg.add(ResManager.loadKDString((String)"\u51cf\u514d\u6bd4\u4f8b", (String)"SourceInfoSaveValidator_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    }
                    if ("tdm_fcs_basic_info".equals(entityName = dataEntity.getDataEntity().getDataEntityType().getName()) || "tdm_house_rental_info".equals(entityName)) {
                        boolean monthly = obj.getBoolean("monthly");
                        BigDecimal monthlimit = obj.getBigDecimal("monthlimit");
                        if (monthly && monthlimit == null) {
                            errorMsg.add(ResManager.loadKDString((String)"\u6bcf\u6708\u51cf\u514d\u7a0e\u989d", (String)"SourceInfoSaveValidator_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                        }
                    }
                }
                Object registerule = obj.get("registerule");
                if ("3".equals(registerule)) {
                    Object entervalue = obj.get("entervalue");
                    if (entervalue == null || zero.compareTo((BigDecimal)entervalue) == 0) {
                        errorMsg.add(ResManager.loadKDString((String)"\u5f55\u5165\u767b\u8bb0\u503c", (String)"SourceInfoSaveValidator_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    Object registeretio = obj.get("registeretio");
                    if (registeretio == null || zero.compareTo((BigDecimal)registeretio) == 0) {
                        errorMsg.add(ResManager.loadKDString((String)"\u767b\u8bb0\u51cf\u514d\u6bd4\u4f8b", (String)"SourceInfoSaveValidator_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    }
                }
                if (errorMsg.size() > 0) {
                    String msg = (String)errorMsg.stream().reduce((acc, item) -> acc + "," + item).get();
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199 \u51cf\u514d\u767b\u8bb0\u53f0\u8d26\u7b2c%d\u884c: %s", (String)"SourceInfoSaveValidator_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), i + 1, msg));
                }
                errorMsg.clear();
            }
        }
    }
}

