/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.upgrade;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.tdm.common.util.DBUtils;
import kd.taxc.tdm.common.util.StringUtil;
import kd.taxc.tdm.formplugin.constant.DataTypeSelectSqlConstant;
import kd.taxc.tdm.formplugin.element.enums.DataMigrationTypeEnum;

public class DataMigrationUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(DataMigrationUpgradeService.class);
    UpgradeResult result = new UpgradeResult();
    boolean success = true;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        this.result.setLog(DataMigrationUpgradeService.doUpgrade(ver));
        this.result.setSuccess(this.success);
        return this.result;
    }

    public static String doUpgrade(String taxTypeSelect) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            logger.info(DataMigrationTypeEnum.getTaxNameByType(taxTypeSelect) + "\u63d2\u5165\u5f00\u59cb\u6267\u884c");
            long start = System.currentTimeMillis();
            DBUtils.execute((String)DataMigrationTypeEnum.getZiinsertByTaxTypeSelect(taxTypeSelect));
            logger.info(DataMigrationTypeEnum.getTaxNameByType(taxTypeSelect) + "\u63d2\u5165\u5b50\u8868\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            if (StringUtil.isNotEmpty((CharSequence)DataMigrationTypeEnum.getZidjtinsertByTaxTypeSelect(taxTypeSelect))) {
                DBUtils.execute((String)DataMigrationTypeEnum.getZidjtinsertByTaxTypeSelect(taxTypeSelect));
            }
            logger.info(DataMigrationTypeEnum.getTaxNameByType(taxTypeSelect) + "\u63d2\u5165\u5b50\u8868\u548c\u5355\u636e\u4f53\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            if ("1".equals(taxTypeSelect)) {
                DBUtils.execute((String)DataTypeSelectSqlConstant.getTAX_ZZSPTP3());
                logger.info(DataMigrationTypeEnum.getTaxNameByType(taxTypeSelect) + "\u66f4\u65b0\u5b50\u8868\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            }
            DBUtils.execute((String)DataMigrationTypeEnum.getZhuinsertByTaxTypeSelect(taxTypeSelect));
            logger.info(DataMigrationTypeEnum.getTaxNameByType(taxTypeSelect) + "\u63d2\u5165\u603b\u4f53\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            String string = String.format(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\uff1a%s", (String)"DataMigrationUpgradeService_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), DataMigrationTypeEnum.getTaxNameByType(taxTypeSelect));
            return string;
        }
        catch (Throwable t) {
            try {
                logger.info(DataMigrationTypeEnum.getTaxNameByType(taxTypeSelect) + "\u5f02\u5e38\u62a5\u9519");
                h.markRollback();
                throw t;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

