/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tdm.common.util.EmptyCheckUtils;
import kd.taxc.tdm.formplugin.element.util.ElementUtil;

public class ElementDataSourceUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        ElementDataSourceUpgradeService.upgrade();
        return result;
    }

    public static void upgrade() {
        QFilter qFilter = new QFilter("bottom", "=", (Object)Character.valueOf('1'));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tdm_element_group", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (EmptyCheckUtils.isEmpty((Object)dynamicObjects)) {
            return;
        }
        ArrayList<DynamicObject> updates = new ArrayList<DynamicObject>();
        for (DynamicObject ele : dynamicObjects) {
            List<Map<String, String>> oldEleRuleMapList;
            DynamicObject eleAllInfo = BusinessDataServiceHelper.loadSingle((Object)ele.get("id"), (String)"tdm_element_group");
            String json = eleAllInfo.getString("json_tag");
            if (EmptyCheckUtils.isEmpty((Object)json) || json.contains("datasoucejson") || EmptyCheckUtils.isEmpty(oldEleRuleMapList = ElementUtil.parseJson(json))) continue;
            Boolean isdefaultrule = oldEleRuleMapList.size() == 1;
            ArrayList newEleRuleMapList = new ArrayList(oldEleRuleMapList.size());
            for (Map<String, String> oldRuleMap : oldEleRuleMapList) {
                HashMap<String, String> newRuleMap = new HashMap<String, String>(16);
                if (isdefaultrule.booleanValue()) {
                    newRuleMap.put("rulename", ResManager.loadKDString((String)"\u9ed8\u8ba4\u89c4\u5219", (String)"ElementDataSourceUpgradeService_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    newRuleMap.put("isdefaultrule", "1");
                } else {
                    newRuleMap.put("rulename", oldRuleMap.get("rulename"));
                    newRuleMap.put("isdefaultrule", oldRuleMap.get("isdefaultrule"));
                }
                newRuleMap.put("orgs", oldRuleMap.get("orgs"));
                ArrayList newEleDataSourceMapList = new ArrayList(10);
                HashMap<String, String> newEleDataSourceMap = new HashMap<String, String>(16);
                newEleDataSourceMap.put("tableidd", oldRuleMap.get("tableid"));
                newEleDataSourceMap.put("fieldidd", oldRuleMap.get("fieldid"));
                newEleDataSourceMap.put("filterjsond", oldRuleMap.get("filterJson"));
                newEleDataSourceMap.put("startdated", "1990-01-01");
                newEleDataSourceMap.put("filtertextd", oldRuleMap.get("filterText"));
                newEleDataSourceMap.put("datasourced", oldRuleMap.get("tableid") + "." + oldRuleMap.get("fieldid"));
                newEleDataSourceMapList.add(newEleDataSourceMap);
                newRuleMap.put("datasoucejson", SerializationUtils.toJsonString(newEleDataSourceMapList));
                newEleRuleMapList.add(newRuleMap);
            }
            String newJson = SerializationUtils.toJsonString(newEleRuleMapList);
            eleAllInfo.set("json_tag", (Object)newJson);
            updates.add(eleAllInfo);
        }
        SaveServiceHelper.save((DynamicObject[])updates.toArray(new DynamicObject[updates.size()]));
    }
}

