/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.upgrade;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class FcsByHireRentalUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(FcsByHireRentalUpgradeService.class);
    private static final String TDM_HOUSE_RENTAL_INFO = "tdm_house_rental_info";
    UpgradeResult result = new UpgradeResult();
    boolean success = true;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        this.result.setLog(FcsByHireRentalUpgradeService.doUpgrade());
        this.result.setSuccess(this.success);
        return this.result;
    }

    public static String doUpgrade() {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            DynamicObject[] datas;
            logger.info(ResManager.loadKDString((String)"\u5347\u7ea7\u5f00\u59cb\uff1a", (String)"FcsByHireRentalUpgradeService_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            long start = System.currentTimeMillis();
            QFilter filter = new QFilter("rententryentity.id", "is null", null);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)TDM_HOUSE_RENTAL_INFO, (String)"id", (QFilter[])new QFilter[]{filter});
            if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
                String string = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5347\u7ea7\u7684\u6570\u636e", (String)"FcsByHireRentalUpgradeService_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), new Object[0]);
                return string;
            }
            for (DynamicObject dynamicObject : datas = BusinessDataServiceHelper.load((Object[])dynamicObjects.stream().map(s -> s.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TDM_HOUSE_RENTAL_INFO))) {
                DynamicObjectCollection rententryentity = dynamicObject.getDynamicObjectCollection("rententryentity");
                DynamicObject row = rententryentity.addNew();
                row.set("hirearea", dynamicObject.get("leasearea"));
                row.set("startdate", dynamicObject.get("contractstart"));
                row.set("enddate", dynamicObject.get("contractend"));
                row.set("hiretaxcode", dynamicObject.get("leaseetaxcode"));
                row.set("tenantry", dynamicObject.get("leaseename"));
                row.set("rentincome", dynamicObject.get("contractincome"));
                row.set("modifiername", dynamicObject.get("modifier"));
                row.set("modifydatetime", dynamicObject.get("modifytime"));
                row.set("rentmonth", dynamicObject.get("monthnumber"));
                row.set("eachrentincome", dynamicObject.get("eachincome"));
                DynamicObjectCollection sources = dynamicObject.getDynamicObjectCollection("tdm_house_rental_edit");
                DynamicObjectCollection subentryentity = row.getDynamicObjectCollection("subentryentity");
                for (DynamicObject source : sources) {
                    DynamicObject subRow = subentryentity.addNew();
                    subRow.set("skperiod", source.get("skssq"));
                    subRow.set("rental", source.get("rent"));
                }
            }
            SaveServiceHelper.save((DynamicObject[])datas);
            logger.info(ResManager.loadKDString((String)"\u5347\u7ea7\u8017\u65f6\uff1a", (String)"FcsByHireRentalUpgradeService_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]) + (System.currentTimeMillis() - start));
            String string = String.format(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f", (String)"FcsByHireRentalUpgradeService_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), new Object[0]);
            return string;
        }
        catch (Throwable t) {
            try {
                logger.info("\u5f02\u5e38\u62a5\u9519");
                h.markRollback();
                throw t;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

