/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;

public class FinanceReportItemUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(FinanceReportItemUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.required();){
            try {
                this.doUpgrade(dbKey, "t_tdm_lrb");
                this.doUpgrade(dbKey, "t_tdm_hblrb");
                this.doUpgrade(dbKey, "t_tdm_xjllb");
                this.doUpgrade(dbKey, "t_tdm_hbxjllb");
                this.doUpgrade(dbKey, "t_tdm_zcfzb");
                this.doUpgrade(dbKey, "t_tdm_hbzcfzb");
                this.doUpgrade(dbKey, "t_tdm_fanance_qybdb");
                this.doUpgrade(dbKey, "t_tdm_fanance_hbqybdb");
                result.setSuccess(true);
            }
            catch (Exception e) {
                tx.markRollback();
                result.setSuccess(false);
                logger.error("FinanceReportItemUpgradeService Faild:" + e.getMessage());
                result.setErrorInfo("FinanceReportItemUpgradeService Failed:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
        return result;
    }

    private void doUpgrade(String dbKey, String table) {
        StringBuilder sb = new StringBuilder();
        sb.append("select fid,fewblxh from ").append(table).append(" where fewblxh is not null and (freportitem is null or freportitem = 0) ");
        Map dataList = (Map)DB.query((DBRoute)DBRoute.of((String)dbKey), (String)sb.toString(), resultSet -> {
            HashMap<Long, String> map = new HashMap<Long, String>();
            while (resultSet.next()) {
                String ewblxh = resultSet.getString("fewblxh");
                if (!StringUtils.isNotBlank((CharSequence)ewblxh)) continue;
                map.put(resultSet.getLong("fid"), ewblxh);
            }
            return map;
        });
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update ").append(table).append(" set freportitem = ? where fid = ?");
        if (dataList != null && dataList.size() > 0) {
            ArrayList<Object[]> updateList = new ArrayList<Object[]>(dataList.size());
            for (Map.Entry entry : dataList.entrySet()) {
                Long reportitem = Long.valueOf((String)entry.getValue());
                updateList.add(new Object[]{reportitem, entry.getKey()});
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)dbKey), (String)updateSql.toString(), updateList);
        }
    }
}

