/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.upgrade;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.tdm.common.util.DBUtils;
import org.apache.commons.lang3.ObjectUtils;

public class WithholdUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(WithholdUpgradeService.class);
    UpgradeResult result = new UpgradeResult();
    boolean success = true;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        this.result.setLog(WithholdUpgradeService.doUpgrade());
        this.result.setSuccess(this.success);
        return this.result;
    }

    public static String doUpgrade() {
        final ArrayList params = new ArrayList(64);
        final HashMap taxOrganMap = new HashMap(512);
        String updateSql = "update t_tdm_withholding_tax set fofficetax = ? where fid  = ? ";
        String sql = " select fid,fname from t_bastax_taxorgan_l where flocaleid = 'zh_CN' ";
        try {
            List taxOrganList = DBUtils.query((String)"sys", (String)sql);
            if (ObjectUtils.isNotEmpty((Object)taxOrganList)) {
                taxOrganList.stream().forEach(o -> taxOrganMap.put(String.valueOf(o.get("FNAME")), o.get("FID")));
            }
            logger.info("\u5347\u7ea7\u4ee3\u6263\u4ee3\u7f34\u7a0e\u6536\u7f34\u6b3e\u51ed\u8bc1\u7684\u7a0e\u52a1\u673a\u5173 \u5f00\u59cb\u6267\u884c");
            long start = System.currentTimeMillis();
            DB.query((DBRoute)DBRoute.of((String)"taxc"), (String)"select fid,ftaxoffice from t_tdm_withholding_tax where fofficetax = 0 or fofficetax is null ", (ResultSetHandler)new ResultSetHandler<DynamicObject>(){

                public DynamicObject handle(ResultSet resultSet) throws Exception {
                    while (resultSet.next()) {
                        String name = resultSet.getString("ftaxoffice");
                        Long id = resultSet.getLong("fid");
                        if (!taxOrganMap.containsKey(name)) continue;
                        params.add(new Object[]{taxOrganMap.get(name), id});
                    }
                    return null;
                }
            });
            if (ObjectUtils.isNotEmpty(params)) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)updateSql, params);
            }
            logger.info("\u5347\u7ea7\u4ee3\u6263\u4ee3\u7f34\u7a0e\u6536\u7f34\u6b3e\u51ed\u8bc1\u7684\u7a0e\u52a1\u673a\u5173 \u603b\u4f53\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            return String.format(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\uff1a%s", (String)"WithholdUpgradeService_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), params.size());
        }
        catch (Throwable t) {
            logger.info("\u5347\u7ea7\u4ee3\u6263\u4ee3\u7f34\u7a0e\u6536\u7f34\u6b3e\u51ed\u8bc1\u7684\u7a0e\u52a1\u673a\u5173 \u5f02\u5e38\u62a5\u9519" + t.getMessage());
            throw t;
        }
    }
}

