/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.utils;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.tdm.formplugin.constant.ReportItemTreeEnum;
import kd.taxc.tdm.formplugin.utils.FinanceTemplateUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportFinanceItemUtils {
    public static String downloadExcelFile(String nodeId, Map<String, List<String>> selectedItems) {
        String entityId = ReportItemTreeEnum.getEntityNameById(nodeId);
        String entityName = String.format(ResManager.loadKDString((String)"%s\u9879\u76ee", (String)"ExportFinanceItemUtils_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), ReportItemTreeEnum.getTextById(nodeId));
        String fileName = String.format(ResManager.loadKDString((String)"\u5f15\u51fa\u6570\u636e_%s", (String)"ExportFinanceItemUtils_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), entityName);
        String title = entityName + " # " + entityId;
        XSSFWorkbook workbook = ExportFinanceItemUtils.buildExcel(title, selectedItems);
        String path = FinanceTemplateUtils.upload(fileName, workbook);
        return path;
    }

    public static XSSFWorkbook buildExcel(String title, Map<String, List<String>> selectedItems) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        XSSFCellStyle cellStyle = ExportFinanceItemUtils.getTextCellStyle(workbook, (short)0, (short)0);
        XSSFCellStyle greyStyle = ExportFinanceItemUtils.getTextCellStyle(workbook, (short)0, IndexedColors.GREY_25_PERCENT.getIndex());
        XSSFCellStyle redStyle = ExportFinanceItemUtils.getTextCellStyle(workbook, (short)10, (short)0);
        XSSFCellStyle redGreyStyle = ExportFinanceItemUtils.getTextCellStyle(workbook, (short)10, IndexedColors.GREY_25_PERCENT.getIndex());
        String commetText = ResManager.loadKDString((String)"\u6587\u672c", (String)"ExportFinanceItemUtils_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
        String pText = ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\uff0c\u652f\u6301\u5f55\u5165\u7f16\u7801", (String)"ExportFinanceItemUtils_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
        sheet.setColumnWidth(0, 19000);
        sheet.setColumnWidth(1, 6000);
        sheet.setColumnWidth(2, 6000);
        sheet.setColumnWidth(3, 6000);
        sheet.setColumnWidth(4, 6000);
        sheet.setColumnWidth(5, 6000);
        XSSFRow headRow1 = sheet.createRow(0);
        XSSFRow headRow2 = sheet.createRow(1);
        XSSFRow headRow3 = sheet.createRow(2);
        XSSFRow headRow4 = sheet.createRow(3);
        ExportFinanceItemUtils.createCell(title, headRow1, cellStyle, 0);
        ExportFinanceItemUtils.createCell(ResManager.loadKDString((String)"1\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\r\n2\u3001\u7ea2\u8272\u5e26\u661f\u53f7\uff08*\uff09\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5\r\n3\u3001\u7b2c\u4e8c\u884c\u7b2c\u4e00\u4e2a\u5355\u5143\u683c\u8f93\u5165#SetNULL\uff0c\u542f\u7528\u5355\u5143\u683c\u8f93\u5165NULL\u6e05\u7a7a\u5b57\u6bb5", (String)"ExportFinanceItemUtils_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), headRow2, redStyle, 0);
        ExportFinanceItemUtils.createCell("number", headRow3, cellStyle, 0);
        ExportFinanceItemUtils.createCell("name.zh_CN", headRow3, cellStyle, 1);
        ExportFinanceItemUtils.createCell("name.en_US", headRow3, cellStyle, 2);
        ExportFinanceItemUtils.createCell("name.zh_TW", headRow3, cellStyle, 3);
        ExportFinanceItemUtils.createCell("parent.number", headRow3, cellStyle, 4);
        ExportFinanceItemUtils.createCell("parent.name", headRow3, cellStyle, 5);
        XSSFCell numbercell = ExportFinanceItemUtils.createCell(ResManager.loadKDString((String)"*\u7f16\u7801", (String)"ExportFinanceItemUtils_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), headRow4, redGreyStyle, 0);
        ExportFinanceItemUtils.buildCellComment(numbercell, commetText);
        XSSFCell cncell = ExportFinanceItemUtils.createCell(ResManager.loadKDString((String)"*\u540d\u79f0.\u7b80\u4f53\u4e2d\u6587", (String)"ExportFinanceItemUtils_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), headRow4, redGreyStyle, 1);
        ExportFinanceItemUtils.buildCellComment(cncell, commetText);
        XSSFCell encell = ExportFinanceItemUtils.createCell(ResManager.loadKDString((String)"\u540d\u79f0.English", (String)"ExportFinanceItemUtils_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), headRow4, greyStyle, 2);
        ExportFinanceItemUtils.buildCellComment(encell, commetText);
        XSSFCell twcell = ExportFinanceItemUtils.createCell(ResManager.loadKDString((String)"\u540d\u79f0.\u7e41\u9ad4\u4e2d\u6587", (String)"ExportFinanceItemUtils_8", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), headRow4, greyStyle, 3);
        ExportFinanceItemUtils.buildCellComment(twcell, commetText);
        XSSFCell pnumbercell = ExportFinanceItemUtils.createCell(ResManager.loadKDString((String)"\u4e0a\u7ea7\u9879\u76ee.\u7f16\u7801", (String)"ExportFinanceItemUtils_9", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), headRow4, greyStyle, 4);
        ExportFinanceItemUtils.buildCellComment(pnumbercell, pText);
        ExportFinanceItemUtils.createCell(ResManager.loadKDString((String)"\u4e0a\u7ea7\u9879\u76ee.\u540d\u79f0", (String)"ExportFinanceItemUtils_10", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), headRow4, greyStyle, 5);
        int rowIndex = 4;
        for (Map.Entry<String, List<String>> entry : selectedItems.entrySet()) {
            XSSFRow itemRow = sheet.createRow(rowIndex);
            ExportFinanceItemUtils.createCell(entry.getKey(), itemRow, cellStyle, 0);
            List<String> values = entry.getValue();
            for (int i = 0; i < values.size(); ++i) {
                String value = values.get(i);
                ExportFinanceItemUtils.createCell(value, itemRow, cellStyle, i + 1);
            }
            itemRow.setHeightInPoints(16.0f);
            ++rowIndex;
        }
        return workbook;
    }

    public static XSSFComment buildCellComment(XSSFCell cell, String desc) {
        XSSFSheet sheet = cell.getSheet();
        XSSFClientAnchor anchor = new XSSFClientAnchor();
        anchor.setDx1(0);
        anchor.setDx2(0);
        anchor.setDy1(0);
        anchor.setDy2(0);
        anchor.setCol1(cell.getColumnIndex());
        anchor.setRow1(cell.getRowIndex());
        anchor.setCol2(cell.getColumnIndex() + 5);
        anchor.setRow2(cell.getRowIndex() + 6);
        XSSFDrawing draw = sheet.createDrawingPatriarch();
        XSSFComment comment = draw.createCellComment((ClientAnchor)anchor);
        comment.setString((RichTextString)new XSSFRichTextString(desc));
        return comment;
    }

    public static XSSFCellStyle getTextCellStyle(XSSFWorkbook workbook, short fontColor, short groundColor) {
        XSSFCellStyle commonStyle = workbook.createCellStyle();
        commonStyle.setAlignment(HorizontalAlignment.LEFT);
        XSSFDataFormat fmt = workbook.createDataFormat();
        commonStyle.setDataFormat(fmt.getFormat("TEXT"));
        if (groundColor > 0) {
            commonStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            commonStyle.setFillForegroundColor(groundColor);
        }
        commonStyle.setWrapText(true);
        commonStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        if (fontColor > 0) {
            XSSFFont font = workbook.createFont();
            font.setColor(fontColor);
            commonStyle.setFont((Font)font);
        }
        return commonStyle;
    }

    public static XSSFCell createCell(String value, XSSFRow row, XSSFCellStyle cellStyle, int index) {
        XSSFCell cell = row.createCell(index);
        cell.setCellValue(value);
        if (cellStyle != null) {
            cell.setCellStyle((CellStyle)cellStyle);
        }
        return cell;
    }
}

