/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;

public class FcsByHireSourceInfoUtils {
    private static final String MONTH = "month";
    private static final String SEASON = "season";
    private static final String YEAR = "year";
    private static final String HALF_YEAR = "halfyear";
    private static final int DEFAULT_VALUE_1 = 1;
    private static final int SEASON_VALUE = 3;
    private static final int HALF_YEAR_VALUE = 6;
    private static final int YEAR_VALUE = 12;
    private static final int SEASON_LENGTH = 90;
    private static final int HALF_YEAR_LENGTH = 183;
    private static final int YEAR_LENGTH = 365;

    public static List<String> getAllSkssq(String taxLimit, Date start, Date end) {
        ArrayList<String> allSkssq = new ArrayList<String>();
        LocalDate startDate = FcsByHireSourceInfoUtils.getLocalDate(start);
        LocalDate endDate = FcsByHireSourceInfoUtils.getLocalDate(end);
        switch (taxLimit) {
            case "month": {
                while (!endDate.isBefore(startDate)) {
                    allSkssq.add(endDate.getYear() + FcsByHireSourceInfoUtils.getYearCn() + FcsByHireSourceInfoUtils.getMonthString(endDate) + FcsByHireSourceInfoUtils.getMonthCn());
                    endDate = endDate.minusMonths(1L);
                }
                break;
            }
            case "season": {
                while (startDate.compareTo(endDate) < 0) {
                    if (!allSkssq.contains(startDate.getYear() + FcsByHireSourceInfoUtils.getYearCn() + FcsByHireSourceInfoUtils.getSeasonNow(startDate) + FcsByHireSourceInfoUtils.getSeasonCn())) {
                        allSkssq.add(startDate.getYear() + FcsByHireSourceInfoUtils.getYearCn() + FcsByHireSourceInfoUtils.getSeasonNow(startDate) + FcsByHireSourceInfoUtils.getSeasonCn());
                    }
                    startDate = startDate.plusMonths(1L);
                }
                break;
            }
            case "year": {
                int yearStart = startDate.getYear();
                for (int endYear = endDate.getYear(); yearStart <= endYear; --endYear) {
                    allSkssq.add(endYear + FcsByHireSourceInfoUtils.getYearCn());
                }
                break;
            }
            case "halfyear": {
                while (!endDate.isBefore(startDate)) {
                    allSkssq.add(endDate.getYear() + FcsByHireSourceInfoUtils.getYearCn() + FcsByHireSourceInfoUtils.getHalfYearNow(endDate));
                    endDate = endDate.minusMonths(6L);
                }
                String last = startDate.getYear() + FcsByHireSourceInfoUtils.getYearCn() + FcsByHireSourceInfoUtils.getHalfYearNow(startDate);
                if (allSkssq.contains(last)) break;
                allSkssq.add(last);
                break;
            }
            default: {
                return null;
            }
        }
        Collections.sort(allSkssq);
        return allSkssq;
    }

    public static Function<BigDecimal, BigDecimal> calculateFristValue(String limit, Date startdate, Date enddate) {
        int endDuration;
        int startDuration;
        LocalDate start = FcsByHireSourceInfoUtils.getLocalDate(startdate);
        LocalDate end = FcsByHireSourceInfoUtils.getLocalDate(enddate);
        switch (limit) {
            case "month": {
                startDuration = 1;
                endDuration = 1;
                break;
            }
            case "season": {
                startDuration = FcsByHireSourceInfoUtils.getSeasonDaysBefore(start);
                endDuration = FcsByHireSourceInfoUtils.getSeasonDaysAfter(end);
                break;
            }
            case "year": {
                startDuration = 12 - start.getMonthValue() + 1;
                endDuration = end.getMonthValue();
                break;
            }
            case "halfyear": {
                startDuration = FcsByHireSourceInfoUtils.getHalfYearDaysBefore(start);
                endDuration = FcsByHireSourceInfoUtils.getHalfYearDaysAfter(end);
                break;
            }
            default: {
                startDuration = 1;
                endDuration = 1;
            }
        }
        return amount -> amount.multiply(new BigDecimal(startDuration)).divide(new BigDecimal(startDuration + endDuration), 2, 4);
    }

    public static int getSeasonDaysAfter(LocalDate end) {
        int season = FcsByHireSourceInfoUtils.getSeasonNow(end);
        int monthValue = end.getMonthValue();
        return monthValue - (season - 1) * 3;
    }

    public static int getSeasonDaysBefore(LocalDate start) {
        int season = FcsByHireSourceInfoUtils.getSeasonNow(start);
        int monthValue = start.getMonthValue();
        return 3 * season - monthValue + 1;
    }

    public static int getHalfYearDaysAfter(LocalDate end) {
        int days = end.getDayOfYear();
        int duration = days < 183 ? days : days - 183;
        return duration;
    }

    public static int getHalfYearDaysBefore(LocalDate start) {
        int days = start.getDayOfYear();
        int duration = days < 183 ? 183 - days : 365 - days;
        return duration;
    }

    public static LocalDate getLocalDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        return localDateTime.toLocalDate();
    }

    public static String getMonthString(LocalDate endDate) {
        int month = endDate.getMonth().getValue();
        return String.format("%02d", month);
    }

    public static int getSeasonNow(LocalDate date) {
        return (date.getMonth().getValue() + 2) / 3;
    }

    public static String getHalfYearNow(LocalDate date) {
        if (date.getMonth().getValue() <= 6) {
            return FcsByHireSourceInfoUtils.getFirstHalfYearCn();
        }
        return FcsByHireSourceInfoUtils.getSecondHalfYearCN();
    }

    public static BigDecimal getEachIncome(BigDecimal income, int monthNo, int taxLimitNo) {
        if (monthNo <= taxLimitNo) {
            return income;
        }
        if (income != null) {
            return BigDecimalUtil.divideObject((Object)income.multiply(new BigDecimal(taxLimitNo)), (Object)monthNo, (int)2);
        }
        return BigDecimal.ZERO;
    }

    public static int getFirstMonthNum(String taxlimit, Date start) {
        if (start == null) {
            return 0;
        }
        Map skssqzMap = DateUtils.getPeriodByTaxLimit((Date)start, (String)taxlimit);
        if (EmptyCheckUtils.isNotEmpty((Object)skssqzMap) && skssqzMap.get("endDate") != null) {
            List monthList = DateUtils.getMonthBetween((Date)start, (Date)((Date)skssqzMap.get("endDate")));
            return monthList.size();
        }
        return 0;
    }

    public static String getYearCn() {
        return ResManager.loadKDString((String)"\u5e74", (String)"FcsByHireSourceInfoUtils_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
    }

    public static String getMonthCn() {
        return ResManager.loadKDString((String)"\u6708\u4efd", (String)"FcsByHireSourceInfoUtils_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
    }

    public static String getSeasonCn() {
        return ResManager.loadKDString((String)"\u5b63\u5ea6", (String)"FcsByHireSourceInfoUtils_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
    }

    public static String getFirstHalfYearCn() {
        return ResManager.loadKDString((String)"\u4e0a\u534a\u5e74", (String)"FcsByHireSourceInfoUtils_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
    }

    public static String getSecondHalfYearCN() {
        return ResManager.loadKDString((String)"\u4e0b\u534a\u5e74", (String)"FcsByHireSourceInfoUtils_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
    }

    public static boolean isFirstOrLastDay(String flag, LocalDate date) {
        int dayOfMonth;
        boolean result = false;
        if (date == null) {
            return false;
        }
        if ("start".equals(flag)) {
            dayOfMonth = date.with(TemporalAdjusters.firstDayOfMonth()).getDayOfMonth();
            boolean bl = result = date.getDayOfMonth() == dayOfMonth;
        }
        if ("end".equals(flag)) {
            dayOfMonth = date.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth();
            result = date.getDayOfMonth() == dayOfMonth;
        }
        return result;
    }

    public static boolean startBeforeEnd(LocalDate startdate, LocalDate enddate) {
        if (startdate == null || enddate == null) {
            return true;
        }
        return startdate.isBefore(enddate);
    }

    public static boolean hasIntersection(Date start, Date end, JSONArray entrydatelist) {
        if (entrydatelist.isEmpty()) {
            return false;
        }
        return entrydatelist.stream().map(s -> (JSONObject)s).filter(e -> null != e.getDate("startdate") || null != e.getDate("enddate")).anyMatch(object -> {
            Date startdate = object.getDate("startdate");
            Date enddate = object.getDate("enddate");
            if (start == null || end == null) {
                return false;
            }
            return !end.before(startdate) && !start.after(enddate);
        });
    }

    public static LocalDate date2LocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static Map<String, Object> validDate(Date startdate, Date enddate, JSONArray entrydatelist) {
        LocalDate startLocalDate = FcsByHireSourceInfoUtils.date2LocalDate(startdate);
        LocalDate endLocalDate = FcsByHireSourceInfoUtils.date2LocalDate(enddate);
        if (!FcsByHireSourceInfoUtils.isFirstOrLastDay("start", startLocalDate)) {
            return FcsByHireSourceInfoUtils.error(ResManager.loadKDString((String)"\u7533\u62a5\u79df\u8d41\u671f\u8d77\u53ea\u80fd\u9009\u62e9\u6708\u521d1\u53f7\u3002", (String)"FcsByHireSourceInfoUtils_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
        if (!FcsByHireSourceInfoUtils.isFirstOrLastDay("end", endLocalDate)) {
            return FcsByHireSourceInfoUtils.error(ResManager.loadKDString((String)"\u7533\u62a5\u79df\u8d41\u671f\u6b62\u53ea\u80fd\u9009\u62e9\u6708\u672b\u6700\u540e1\u5929\u3002", (String)"FcsByHireSourceInfoUtils_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
        if (!FcsByHireSourceInfoUtils.startBeforeEnd(startLocalDate, endLocalDate)) {
            return FcsByHireSourceInfoUtils.error(ResManager.loadKDString((String)"\u7533\u62a5\u79df\u91d1\u6240\u5c5e\u79df\u8d41\u671f\u8d77\u5fc5\u987b\u5c0f\u4e8e\u7533\u62a5\u79df\u91d1\u6240\u5c5e\u79df\u8d41\u671f\u6b62\u3002", (String)"FcsByHireSourceInfoUtils_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
        if (FcsByHireSourceInfoUtils.hasIntersection(startdate, enddate, entrydatelist)) {
            return FcsByHireSourceInfoUtils.error(ResManager.loadKDString((String)"\u7533\u62a5\u79df\u91d1\u6240\u5c5e\u79df\u8d41\u671f\u8d77\u3001\u6b62\u8303\u56f4\u5185\u5df2\u5b58\u5728\u5176\u4ed6\u79df\u8d41\u8bb0\u5f55\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FcsByHireSourceInfoUtils_8", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
        return FcsByHireSourceInfoUtils.success();
    }

    public static Map<String, Object> error(String msg) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", "no");
        result.put("msg", msg);
        return result;
    }

    public static Map<String, Object> success() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", "ok");
        result.put("msg", "");
        return result;
    }
}

