/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.utils;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.StringUtil;
import kd.taxc.tdm.formplugin.constant.FinanceReportMappingEnum;
import kd.taxc.tdm.formplugin.constant.MainTableFieldEnum;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FinanceTemplateUtils {
    private static Log logger = LogFactory.getLog(FinanceTemplateUtils.class);
    private static final String TDM_FINANCE_TEMPLATE = "tdm_finance_template";
    private static final String TCTB_TEMPLATE_TYPE = "tctb_template_type";

    public static DynamicObject getTemplateObject(Long templateId) {
        if (templateId == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)templateId, (String)TDM_FINANCE_TEMPLATE);
    }

    public static DynamicObject getTemplateTypeByName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        QFilter filter = new QFilter("name", "=", (Object)name);
        return QueryServiceHelper.queryOne((String)TCTB_TEMPLATE_TYPE, (String)"id,number,name", (QFilter[])new QFilter[]{filter});
    }

    public static Map<String, DynamicObject> queryReportDatas(String type, Long sbbid) {
        String entityName = FinanceReportMappingEnum.getEntityNameByType(type);
        if (StringUtils.isNotBlank((CharSequence)entityName)) {
            QFilter filter = new QFilter("sbbid", "=", (Object)String.valueOf(sbbid));
            DynamicObject[] colls = BusinessDataServiceHelper.load((String)entityName, (String)FinanceReportMappingEnum.getSelectFieldByType(type), (QFilter[])new QFilter[]{filter});
            HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>(colls.length);
            String rowKey = FinanceReportMappingEnum.getRowFieldByType(type);
            for (DynamicObject obj : colls) {
                result.put(obj.getString(rowKey), obj);
            }
            return result;
        }
        return new HashMap<String, DynamicObject>();
    }

    public static Map<String, LocaleString> queryEntityFieldName(String type) {
        List<String> amountFields = FinanceReportMappingEnum.getAmountFieldByType(type);
        String entityName = FinanceReportMappingEnum.getEntityNameByType(type);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        Map entityMap = mainEntityType.getAllEntities();
        DataEntityPropertyCollection pros = ((EntityType)entityMap.get(entityName)).getProperties();
        LinkedHashMap<String, LocaleString> nameMap = new LinkedHashMap<String, LocaleString>(pros.size());
        pros.forEach(r -> {
            String fieldKey = r.getName();
            if (amountFields.contains(fieldKey)) {
                nameMap.put(fieldKey, r.getDisplayName());
            }
        });
        return nameMap;
    }

    public static String downFinanceExcelFile(String type, String typeName, DynamicObject headDatas, Map<String, DynamicObject> reportDatas, DynamicObjectCollection templateItems) {
        Map<String, LocaleString> fieldNameMap = FinanceTemplateUtils.queryEntityFieldName(type);
        String name = headDatas == null ? typeName : headDatas.getString("templatetype.name");
        XSSFWorkbook workbook = FinanceTemplateUtils.buildExcel(type, name, headDatas, reportDatas, templateItems, fieldNameMap);
        String path = FinanceTemplateUtils.upload(typeName, workbook);
        return path;
    }

    public static XSSFWorkbook buildExcel(String type, String typeName, DynamicObject headDatas, Map<String, DynamicObject> reportDatas, DynamicObjectCollection templateItems, Map<String, LocaleString> fieldNameMap) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        sheet.setDefaultColumnWidth(18);
        XSSFCellStyle textStyle = FinanceTemplateUtils.getTextCellStyle(workbook, HorizontalAlignment.CENTER, (short)0);
        XSSFCellStyle leftStyle = FinanceTemplateUtils.getTextCellStyle(workbook, HorizontalAlignment.LEFT, (short)0);
        XSSFCellStyle itemStyle = FinanceTemplateUtils.getTextCellStyle(workbook, HorizontalAlignment.LEFT, (short)0);
        itemStyle.setWrapText(true);
        itemStyle.setVerticalAlignment(VerticalAlignment.TOP);
        XSSFCellStyle redStyle = FinanceTemplateUtils.getTextCellStyle(workbook, HorizontalAlignment.LEFT, (short)10);
        XSSFDrawing draw = sheet.createDrawingPatriarch();
        XSSFComment comment1 = draw.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, 3, 3, 5, 6));
        XSSFComment comment2 = draw.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, 4, 4, 6, 7));
        XSSFComment comment3 = draw.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, 5, 5, 7, 8));
        comment1.setString((RichTextString)new XSSFRichTextString(ResManager.loadKDString((String)"\u793a\u4f8b\uff1a2018-08", (String)"FinanceTemplateUtils_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        comment2.setString((RichTextString)new XSSFRichTextString(ResManager.loadKDString((String)"\u9009\u9879\uff0c\u662f/\u5426", (String)"FinanceTemplateUtils_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        comment3.setString((RichTextString)new XSSFRichTextString(ResManager.loadKDString((String)"\u6587\u672c", (String)"FinanceTemplateUtils_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        XSSFRow headRow1 = sheet.createRow(0);
        XSSFRow headRow2 = sheet.createRow(1);
        XSSFRow headRow3 = sheet.createRow(2);
        XSSFRow headRow4 = sheet.createRow(3);
        String orgnumbertext = ResManager.loadKDString((String)"\u7f16\u5236\u7ec4\u7ec7\u7f16\u7801\uff1a", (String)"FinanceTemplateUtils_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
        String orgnametext = ResManager.loadKDString((String)"\u7f16\u5236\u7ec4\u7ec7\u540d\u79f0\uff1a", (String)"FinanceTemplateUtils_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
        String orgnumbervalue = "";
        String orgnumbernamevalue = "";
        String periodvalue = "";
        String accountbookstype = "";
        String isAdjust = ResManager.loadKDString((String)"\u5426", (String)"FinanceTemplateUtils_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
        String adjPeri = "";
        if (headDatas != null) {
            orgnumbervalue = headDatas.getString(MainTableFieldEnum.getFieldKeyByCode("org"));
            orgnumbernamevalue = headDatas.getString("org.name");
            periodvalue = DateUtils.format((Date)headDatas.getDate(MainTableFieldEnum.getFieldKeyByCode("period")), (String)"yyyy-MM");
            accountbookstype = headDatas.getString(MainTableFieldEnum.getFieldKeyByCode("accountbookstype"));
            isAdjust = FinanceTemplateUtils.convertForExport(headDatas.getString(MainTableFieldEnum.getFieldKeyByCode("isadjust")));
            adjPeri = headDatas.getString(MainTableFieldEnum.getFieldKeyByCode("adjperi"));
        }
        FinanceTemplateUtils.createHeadCell(orgnumbertext, orgnumbervalue, headRow1, redStyle, leftStyle, 0);
        FinanceTemplateUtils.createHeadCell(orgnametext, orgnumbernamevalue, headRow1, leftStyle, leftStyle, 2);
        FinanceTemplateUtils.createHeadCell(MainTableFieldEnum.getDescByCode("type"), typeName, headRow2, redStyle, leftStyle, 0);
        XSSFCell periodCell = FinanceTemplateUtils.createHeadCell(MainTableFieldEnum.getDescByCode("period"), periodvalue, headRow2, redStyle, leftStyle, 2);
        periodCell.setCellComment((Comment)comment1);
        XSSFCell isadjustCell = FinanceTemplateUtils.createHeadCell(MainTableFieldEnum.getDescByCode("isadjust"), isAdjust, headRow3, redStyle, leftStyle, 0);
        String[] options = new String[]{ResManager.loadKDString((String)"\u662f", (String)"FinanceTemplateUtils_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5426", (String)"FinanceTemplateUtils_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0])};
        DataValidationHelper dvHelper = sheet.getDataValidationHelper();
        CellRangeAddressList addressList = new CellRangeAddressList(2, 2, 1, 1);
        DataValidationConstraint dvConstraint = dvHelper.createExplicitListConstraint(options);
        DataValidation dataValidation = dvHelper.createValidation(dvConstraint, addressList);
        dataValidation.setShowErrorBox(true);
        dataValidation.setSuppressDropDownArrow(true);
        sheet.addValidationData(dataValidation);
        isadjustCell.setCellComment((Comment)comment2);
        XSSFCell adjperiCell = FinanceTemplateUtils.createHeadCell(MainTableFieldEnum.getDescByCode("adjperi"), adjPeri, headRow3, leftStyle, leftStyle, 2);
        adjperiCell.setCellComment((Comment)comment3);
        FinanceTemplateUtils.createHeadCell(MainTableFieldEnum.getDescByCode("accountbookstype"), accountbookstype, headRow4, leftStyle, leftStyle, 0);
        FinanceTemplateUtils.createHeadCell("", "", headRow4, leftStyle, leftStyle, 2);
        headRow1.setHeightInPoints(20.0f);
        headRow2.setHeightInPoints(20.0f);
        headRow3.setHeightInPoints(20.0f);
        headRow4.setHeightInPoints(20.0f);
        XSSFRow itemTitleRow = sheet.createRow(4);
        XSSFCellStyle titleStyle = FinanceTemplateUtils.getCommonCellStyle(workbook, "TEXT");
        titleStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        titleStyle.setAlignment(HorizontalAlignment.CENTER);
        titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        String itemnumbertext = ResManager.loadKDString((String)"\u9879\u76ee\u7f16\u7801", (String)"FinanceTemplateUtils_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
        String itemnamevalue = ResManager.loadKDString((String)"\u9879\u76ee\u540d\u79f0", (String)"FinanceTemplateUtils_8", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
        FinanceTemplateUtils.createCell(itemnumbertext, itemTitleRow, titleStyle, 0);
        FinanceTemplateUtils.createCell(itemnamevalue, itemTitleRow, titleStyle, 1);
        int titleIndex = 2;
        List<String> amountFields = FinanceReportMappingEnum.getAmountFieldByType(type);
        for (String field : amountFields) {
            String fieldName = "";
            if (fieldNameMap.containsKey(field)) {
                fieldName = fieldNameMap.get(field).getLocaleValue();
            }
            FinanceTemplateUtils.createCell(fieldName, itemTitleRow, titleStyle, titleIndex);
            ++titleIndex;
        }
        if (templateItems != null && templateItems.size() > 0) {
            int rowIndex = 5;
            XSSFCellStyle amountStyle = FinanceTemplateUtils.getCommonCellStyle(workbook, "0.00");
            for (DynamicObject item : templateItems) {
                XSSFRow itemRow = sheet.createRow(rowIndex);
                String itemNumber = item.getString("item.number");
                FinanceTemplateUtils.createCell(itemNumber, itemRow, textStyle, 0);
                String itemName = item.getString("item.name");
                FinanceTemplateUtils.createCell(itemName, itemRow, itemStyle, 1);
                DynamicObject reportData = null;
                String itemkey = item.getString("item_id");
                if (reportDatas != null && reportDatas.containsKey(itemkey)) {
                    reportData = reportDatas.get(itemkey);
                }
                int cellIndex = 2;
                for (String field : amountFields) {
                    BigDecimal value;
                    if (reportDatas == null || reportDatas.size() == 0) {
                        FinanceTemplateUtils.createAmountCell(null, itemRow, amountStyle, cellIndex);
                    } else if (reportData != null) {
                        value = reportData.getBigDecimal(field).setScale(2, 4);
                        FinanceTemplateUtils.createAmountCell(value, itemRow, amountStyle, cellIndex);
                    } else {
                        value = BigDecimal.ZERO.setScale(2, 4);
                        FinanceTemplateUtils.createAmountCell(value, itemRow, amountStyle, cellIndex);
                    }
                    ++cellIndex;
                }
                itemRow.setHeightInPoints(16.0f);
                ++rowIndex;
            }
        }
        return workbook;
    }

    public static XSSFCellStyle getTextCellStyle(XSSFWorkbook workbook, HorizontalAlignment align, short color) {
        XSSFCellStyle commonStyle = FinanceTemplateUtils.getCommonCellStyle(workbook, "TEXT");
        commonStyle.setAlignment(align);
        commonStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        if (color > 0) {
            XSSFFont font = workbook.createFont();
            font.setColor(color);
            commonStyle.setFont((Font)font);
        }
        return commonStyle;
    }

    public static XSSFCellStyle getCommonCellStyle(XSSFWorkbook workbook, String format) {
        XSSFCellStyle commonStyle = workbook.createCellStyle();
        commonStyle.setBorderTop(BorderStyle.THIN);
        commonStyle.setBorderRight(BorderStyle.THIN);
        commonStyle.setBorderBottom(BorderStyle.THIN);
        commonStyle.setBorderLeft(BorderStyle.THIN);
        XSSFColor color = new XSSFColor(Color.BLACK, null);
        commonStyle.setTopBorderColor(color);
        commonStyle.setRightBorderColor(color);
        commonStyle.setBottomBorderColor(color);
        commonStyle.setLeftBorderColor(color);
        commonStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        XSSFDataFormat fmt = workbook.createDataFormat();
        commonStyle.setDataFormat(fmt.getFormat(format));
        commonStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        return commonStyle;
    }

    public static XSSFCell createHeadCell(String cellName, String cellValue, XSSFRow row, XSSFCellStyle cellStyle1, XSSFCellStyle cellStyle2, int index) {
        XSSFCell cell = FinanceTemplateUtils.createCell(cellName, row, cellStyle1, index);
        FinanceTemplateUtils.createCell(cellValue, row, cellStyle2, index + 1);
        return cell;
    }

    public static XSSFCell createCell(String value, XSSFRow row, XSSFCellStyle cellStyle, int index) {
        XSSFCell cell = row.createCell(index);
        cell.setCellValue(value);
        if (cellStyle != null) {
            cell.setCellStyle((CellStyle)cellStyle);
        }
        return cell;
    }

    public static XSSFCell createAmountCell(BigDecimal value, XSSFRow row, XSSFCellStyle cellStyle, int index) {
        XSSFCell cell = row.createCell(index);
        if (value != null) {
            cell.setCellValue(value.doubleValue());
        }
        if (cellStyle != null) {
            cell.setCellStyle((CellStyle)cellStyle);
        }
        return cell;
    }

    public static String upload(String name, XSSFWorkbook workbook) {
        String fileName = name + "_" + DateUtils.format((Date)new Date(), (String)"MMdd") + ".xlsx";
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)outputStream);
            ByteArrayInputStream inputStream = FinanceTemplateUtils.parse(outputStream);
            String path = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inputStream, 5000);
            return path;
        }
        catch (Exception e) {
            logger.error("FinanceTemplateUtils upload", (Throwable)e);
            return "";
        }
    }

    public static ByteArrayInputStream parse(OutputStream out) throws Exception {
        ByteArrayOutputStream baos = (ByteArrayOutputStream)out;
        ByteArrayInputStream swapStream = new ByteArrayInputStream(baos.toByteArray());
        return swapStream;
    }

    public static String convertForImport(String str) {
        String res = StringUtil.equals((CharSequence)str, (CharSequence)ResManager.loadKDString((String)"\u662f", (String)"FinanceTemplateUtils_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0])) ? "1" : (StringUtil.equals((CharSequence)str, (CharSequence)ResManager.loadKDString((String)"\u5426", (String)"FinanceTemplateUtils_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0])) ? "0" : null);
        return res;
    }

    public static String convertForExport(String str) {
        String res = StringUtil.equals((CharSequence)str, (CharSequence)"true") ? ResManager.loadKDString((String)"\u662f", (String)"FinanceTemplateUtils_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"FinanceTemplateUtils_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
        return res;
    }
}

