/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.field.ComboItem;
import kd.bos.util.CollectionUtils;
import kd.taxc.tdm.common.util.StringUtil;

public class TaxTimePointUtils {
    public static final String MONTH = "month";
    public static final String YEAR = "year";
    public static final String SEASON = "season";
    public static final String HALFYEAR = "halfyear";
    public static final String SEASON_BEFORE = "seasonbefore";
    public static final String HALFYEAR_BEFORE = "halfyearbefore";
    public static final String YEAR_BEFORE = "yearbefore";
    public static final String FIRSTQUARTER_MONTH = "firstquartermonth";
    public static final String SECONDQUARTER_MONTH = "secondquartermonth";
    public static final String THIRDQUARTER_MONTH = "thirdquartermonth";
    public static final String FOURTHQUARTER_MONTH = "fourthquartermonth";
    public static final List<String> FIRSTQUARTER_MONTH_LIST = Arrays.asList("1", "2", "3");
    public static final List<String> SECONDQUARTER_MONTH_LIST = Arrays.asList("4", "5", "6");
    public static final List<String> THIRDQUARTER_MONTH_LIST = Arrays.asList("7", "8", "9");
    public static final List<String> FOURTHQUARTER_MONTH_LIST = Arrays.asList("10", "11", "12");
    public static final List<String> YEAR_MONTH_LIST = Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12");
    public static final List<String> FIRST_HALFYEAR_MONTH_LIST = Arrays.asList("1", "2", "3", "4", "5", "6");
    public static final List<String> SECOND_HALFYEAR_MONTH_LIST = Arrays.asList("7", "8", "9", "10", "11", "12");
    public static final String FIRSTHALF_MONTH = "firsthalfmonth";
    public static final String SECONDHALF_MONTH = "secondhalfmonth";
    public static final String FCS_PRICE = "fcs_price";
    public static final String FCS_HIRE = "fcs_hire";
    public static final String TDS_BASIC = "tds_basic";
    public static final String TAX_TIME_LIMIT = "limit";
    public static final String TAX_TIME_POINT = "taxtimepoint";
    public static final String END_MONTH = "endMonth";
    public static final List<String> TAX_PAY_LIMIT_LIST = Arrays.asList("month", "season", "year", "halfyear", "false");
    public static final List<String> TAX_TIME_POINT_LIST = Arrays.asList("monthbefore", "monthafter", "seasonbefore", "seasonafter", "halfyearbefore", "halfyearafter", "yearbefore", "yearafter");
    private static final Map<String, List<String>> TAX_PAY_LIMIT_POINT_MAPPING = new HashMap<String, List<String>>(){
        {
            for (String str : TAX_PAY_LIMIT_LIST) {
                ArrayList<String> list = new ArrayList<String>();
                for (String s : TAX_TIME_POINT_LIST) {
                    if (!s.startsWith(str)) continue;
                    list.add(s);
                }
                this.put(str, list);
            }
        }
    };
    private static final Map<String, String> TIME_TYPE_NAME = new HashMap<String, String>(){
        {
            this.put(TaxTimePointUtils.MONTH, ResManager.loadKDString((String)"\u6708", (String)"TaxTimePointUtils_12", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            this.put(TaxTimePointUtils.SEASON, ResManager.loadKDString((String)"\u5b63", (String)"TaxTimePointUtils_13", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            this.put(TaxTimePointUtils.HALFYEAR, ResManager.loadKDString((String)"\u534a\u5e74", (String)"TaxTimePointUtils_14", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            this.put(TaxTimePointUtils.YEAR, ResManager.loadKDString((String)"\u5e74", (String)"TaxTimePointUtils_15", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
    };

    public static ArrayList<ComboItem> getTaxTimePoints(String value) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        if (MONTH.equals(value)) {
            items.add(TaxTimePointUtils.getComboItem(ResManager.loadKDString((String)"\u6708\u5ea6\u7ec8\u4e86\u540e", (String)"TaxTimePointUtils_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), "monthafter", "TaxTimePointUtils_0"));
            items.add(TaxTimePointUtils.getComboItem(ResManager.loadKDString((String)"\u6708\u5ea6\u7ec8\u4e86\u524d", (String)"TaxTimePointUtils_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), "monthbefore", "TaxTimePointUtils_1"));
        } else if (YEAR.equals(value)) {
            items.add(TaxTimePointUtils.getComboItem(ResManager.loadKDString((String)"\u5e74\u5ea6\u7ec8\u4e86\u540e", (String)"TaxTimePointUtils_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), "yearafter", "TaxTimePointUtils_2"));
            items.add(TaxTimePointUtils.getComboItem(ResManager.loadKDString((String)"\u5e74\u5ea6\u7ec8\u4e86\u524d", (String)"TaxTimePointUtils_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), YEAR_BEFORE, "TaxTimePointUtils_3"));
        } else if (SEASON.equals(value)) {
            items.add(TaxTimePointUtils.getComboItem(ResManager.loadKDString((String)"\u5b63\u5ea6\u7ec8\u4e86\u540e", (String)"TaxTimePointUtils_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), "seasonafter", "TaxTimePointUtils_4"));
            items.add(TaxTimePointUtils.getComboItem(ResManager.loadKDString((String)"\u5b63\u5ea6\u7ec8\u4e86\u524d", (String)"TaxTimePointUtils_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), SEASON_BEFORE, "TaxTimePointUtils_5"));
        } else if (HALFYEAR.equals(value)) {
            items.add(TaxTimePointUtils.getComboItem(ResManager.loadKDString((String)"\u534a\u5e74\u7ec8\u4e86\u540e", (String)"TaxTimePointUtils_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), "halfyearafter", "TaxTimePointUtils_6"));
            items.add(TaxTimePointUtils.getComboItem(ResManager.loadKDString((String)"\u534a\u5e74\u7ec8\u4e86\u524d", (String)"TaxTimePointUtils_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), HALFYEAR_BEFORE, "TaxTimePointUtils_7"));
        } else {
            items.add(TaxTimePointUtils.getComboItem("", "\u2014\u2014", "FcsSourceInfoFormPlugin_8"));
        }
        return items;
    }

    public static ArrayList<ComboItem> getTaxpaylimitPoints() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        items.add(TaxTimePointUtils.getComboItem(ResManager.loadKDString((String)"\u6309\u6708\u7533\u62a5", (String)"TaxTimePointUtils_8", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), MONTH, "TaxTimePointUtils_8"));
        items.add(TaxTimePointUtils.getComboItem(ResManager.loadKDString((String)"\u6309\u5b63\u7533\u62a5", (String)"TaxTimePointUtils_9", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), SEASON, "TaxTimePointUtils_9"));
        items.add(TaxTimePointUtils.getComboItem(ResManager.loadKDString((String)"\u6309\u5e74\u7533\u62a5", (String)"TaxTimePointUtils_10", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), YEAR, "TaxTimePointUtils_10"));
        items.add(TaxTimePointUtils.getComboItem(ResManager.loadKDString((String)"\u534a\u5e74\u7533\u62a5", (String)"TaxTimePointUtils_11", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), HALFYEAR, "TaxTimePointUtils_11"));
        return items;
    }

    public static String adapter(String type, String value) {
        if (value.equals("false")) {
            return "\u2014\u2014";
        }
        return type + value;
    }

    public static ComboItem getComboItem(String desc, String value, String resourceID) {
        return new ComboItem(new LocaleString(ResManager.loadKDString((String)desc, (String)resourceID, (String)"taxc-tdm-formplugin", (Object[])new Object[0])), value);
    }

    public static String getTaxTimePointValue(ArrayList<ComboItem> comboItems, DynamicObject fcsinfo, String limit) {
        String value = comboItems.get(0).getValue();
        if (fcsinfo != null) {
            if (MONTH.equals(limit) && StringUtil.isNotEmpty((CharSequence)fcsinfo.getString("declarebymonth"))) {
                value = MONTH + fcsinfo.getString("declarebymonth");
            } else if (YEAR.equals(limit) && StringUtil.isNotEmpty((CharSequence)fcsinfo.getString("declarebyyeartype"))) {
                value = YEAR + fcsinfo.getString("declarebyyeartype");
            } else if (SEASON.equals(limit) && StringUtil.isNotEmpty((CharSequence)fcsinfo.getString("declarebyseason"))) {
                value = SEASON + fcsinfo.getString("declarebyseason");
            } else if (HALFYEAR.equals(limit) && StringUtil.isNotEmpty((CharSequence)fcsinfo.getString("declarebyhalfyear"))) {
                value = HALFYEAR + fcsinfo.getString("declarebyhalfyear");
            }
        }
        return value;
    }

    public static String getEndMonth(DynamicObject fcsinfo) {
        String value = "1";
        if (fcsinfo != null) {
            value = fcsinfo.getString("declarebyyearlimit");
        }
        return value;
    }

    public static Map<String, String> getTaxTimeData(String type, DynamicObject info) {
        HashMap<String, String> map = new HashMap<String, String>();
        String limit = null;
        if (null != info && FCS_PRICE.equals(type)) {
            limit = info.getString("fcsbypricelimit");
            map.put(TAX_TIME_LIMIT, limit);
        } else if (null != info && FCS_HIRE.equals(type)) {
            limit = info.getString("fcsbyhirelimit");
            map.put(TAX_TIME_LIMIT, limit);
        } else if (null != info && TDS_BASIC.equals(type)) {
            limit = info.getString("tdsyslimit");
            map.put(TAX_TIME_LIMIT, limit);
        }
        if (MONTH.equals(limit)) {
            map.put(TAX_TIME_POINT, MONTH + info.getString("declarebymonth"));
        } else if (SEASON.equals(limit)) {
            map.put(TAX_TIME_POINT, SEASON + info.getString("declarebyseason"));
        } else if (HALFYEAR.equals(limit)) {
            map.put(TAX_TIME_POINT, HALFYEAR + info.getString("declarebyhalfyear"));
        } else if (YEAR.equals(limit)) {
            map.put(TAX_TIME_POINT, YEAR + info.getString("declarebyyeartype"));
            map.put(END_MONTH, TaxTimePointUtils.getEndMonth(info));
        } else {
            map.put(TAX_TIME_POINT, "\u2014\u2014");
        }
        return map;
    }

    public static List<String> getTaxTimePointsByPayLimit(String taxPayLimit) {
        return TAX_PAY_LIMIT_POINT_MAPPING.get(taxPayLimit);
    }

    public static String getTaxTimePointNameByValue(String taxPayLimit) {
        if (StringUtil.isBlank((CharSequence)taxPayLimit)) {
            return "";
        }
        for (String s : TAX_PAY_LIMIT_LIST) {
            ArrayList<ComboItem> items = TaxTimePointUtils.getTaxTimePoints(s);
            if (!CollectionUtils.isNotEmpty(items)) continue;
            for (ComboItem item : items) {
                if (!taxPayLimit.equals(item.getValue())) continue;
                return item.getCaption().toString();
            }
        }
        return taxPayLimit;
    }

    public static String getTimeTypeNameByType(String timeType) {
        return TIME_TYPE_NAME.get(timeType);
    }
}

