/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.tdm.common.util.DBUtils;
import org.apache.commons.lang3.StringUtils;

public class TreeUtils {
    private static final String SEPARATOR = ",";
    private static Log logger = LogFactory.getLog(TreeUtils.class);
    public static final String DEFAULT_ROOT_ID = "-1";
    private static final String LEVEL = "level";

    public static void expandAll(TreeView treeView, TreeNode treeNode) {
        if (treeNode != null) {
            if (treeNode.getChildren() != null) {
                treeNode.setIsOpened(true);
                TreeUtils.expandChild(treeView, treeNode, 10);
            }
            treeView.deleteNode(treeNode.getId());
            treeView.addNode(treeNode);
        }
    }

    public static void expandChild(final TreeView treeView, TreeNode treeNode, final int expendLevel) {
        if (treeNode != null) {
            Map data = (Map)treeNode.getData();
            int currentLevel = 0;
            if (data != null) {
                currentLevel = Integer.parseInt(data.getOrDefault(LEVEL, "0"));
            }
            if (currentLevel < expendLevel) {
                treeNode.getChildren().forEach(new Consumer<TreeNode>(){

                    @Override
                    public void accept(TreeNode t) {
                        if (t.getChildren() != null) {
                            t.setIsOpened(true);
                            TreeUtils.expandChild(treeView, t, expendLevel);
                        }
                    }
                });
            }
        }
    }

    public static void putCache(IPageCache pageCache, String cacheName, Object cacheObj) {
        if (cacheObj != null) {
            pageCache.put(cacheName, SerializationUtils.toJsonString((Object)cacheObj));
        }
    }

    public static <T> T getCache(IPageCache pageCache, String cacheName, Class<T> dstClazz) {
        String cacheStr = pageCache.get(cacheName);
        if (StringUtils.isNotEmpty((CharSequence)cacheStr)) {
            Object dstObject = SerializationUtils.fromJsonString((String)cacheStr, dstClazz);
            return (T)dstObject;
        }
        return null;
    }

    public static void build(TreeView treeView, List<TreeNode> treeNodes, IPageCache pageCache, boolean expand) {
        List<TreeNode> roots = TreeUtils.findRoot(treeNodes);
        for (TreeNode root : roots) {
            root.setLongNumber(root.getId());
            TreeUtils.findChildren(root, treeNodes, TreeUtils.getSonItems(root, treeNodes));
            treeView.addNode(root);
            if (!expand) continue;
            TreeUtils.expandAll(treeView, root);
        }
        if (pageCache != null && !roots.isEmpty()) {
            if (roots.size() > 1) {
                TreeNode node = new TreeNode();
                node.setId(DEFAULT_ROOT_ID);
                node.setText("");
                node.setChildren(roots);
                TreeUtils.putCache(pageCache, treeView.getKey(), node);
            } else {
                TreeUtils.putCache(pageCache, treeView.getKey(), roots.get(0));
            }
        }
    }

    public static TreeNode getTreeNode(IPageCache pageCache, TreeView treeView, String nodeId) {
        TreeNode root = TreeUtils.getCache(pageCache, treeView.getKey(), TreeNode.class);
        if (root != null) {
            TreeNode node = root.getTreeNode(nodeId, 20);
            return node;
        }
        return null;
    }

    public static List<TreeNode> findRoot(List<TreeNode> treeNodes) {
        ArrayList<String> idList = new ArrayList<String>(treeNodes.size());
        for (TreeNode node : treeNodes) {
            idList.add(node.getId());
        }
        ArrayList<TreeNode> trees = new ArrayList<TreeNode>();
        for (TreeNode node : treeNodes) {
            HashMap<String, String> data = (HashMap<String, String>)node.getData();
            if (data == null) {
                data = new HashMap<String, String>();
            }
            data.put(LEVEL, "1");
            if (StringUtils.isEmpty((CharSequence)node.getParentid())) {
                node.setParentid("");
                node.setData(data);
                trees.add(node);
                continue;
            }
            if (idList.contains(node.getParentid())) continue;
            node.setParentid("");
            node.setData(data);
            trees.add(node);
        }
        return trees;
    }

    public static TreeNode findChildren(TreeNode treeNode, List<TreeNode> allNodes, List<TreeNode> sonItems) {
        int parLevel = TreeUtils.getLevel(treeNode);
        for (TreeNode it : sonItems) {
            HashMap<String, String> data;
            if (treeNode.getChildren() == null) {
                treeNode.setChildren(new ArrayList());
            }
            if ((data = (HashMap<String, String>)it.getData()) == null) {
                data = new HashMap<String, String>();
            }
            data.put(LEVEL, String.valueOf(parLevel + 1));
            it.setData(data);
            it.setLongNumber(treeNode.getLongNumber() + "." + it.getId());
            TreeNode child = TreeUtils.findChildren(it, allNodes, TreeUtils.getSonItems(it, allNodes));
            child.setParentid(treeNode.getId());
            treeNode.getChildren().add(child);
        }
        return treeNode;
    }

    public static List<TreeNode> getSonItems(TreeNode root, List<TreeNode> allNodes) {
        ArrayList<TreeNode> sonItems = new ArrayList<TreeNode>();
        for (TreeNode treeNode : allNodes) {
            if (!root.getId().equals(treeNode.getParentid())) continue;
            sonItems.add(treeNode);
        }
        allNodes.removeAll(sonItems);
        return sonItems;
    }

    private static int getLevel(TreeNode treeNode) {
        Map data = (Map)treeNode.getData();
        int currentLevel = Integer.parseInt(data.getOrDefault(LEVEL, "1"));
        return currentLevel;
    }

    public static DynamicObjectCollection getOrgLists() {
        StringBuilder sqlBuilderString = TreeUtils.getBaseStringBuilderByViewId(TreeUtils.getDefaultViewId());
        return TreeUtils.getOrgCollection(sqlBuilderString.toString());
    }

    public static DynamicObjectCollection queryOrgListByCondition(Map<String, List<Object>> condition) {
        Long defaultViewId = TreeUtils.getDefaultViewId();
        StringBuilder where = TreeUtils.getBaseStringBuilderByViewId(defaultViewId);
        if (condition.isEmpty()) {
            List orgIds = OrgUnitServiceHelper.getAllOrgByViewId((long)defaultViewId, (boolean)false);
            condition.put("id", orgIds.stream().map(v -> v).collect(Collectors.toList()));
        }
        TreeUtils.extractQueryCondition(condition, where);
        return TreeUtils.getOrgCollection(where.toString());
    }

    public static DynamicObjectCollection queryOrgListHasPermission(HasPermOrgResult hasPermOrgResult, boolean isQueryEnabled) {
        DynamicObjectCollection col;
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            HashMap<String, List<Object>> map = new HashMap<String, List<Object>>(16);
            TreeUtils.convertParam("id", hasPermOrgResult.getHasPermOrgs(), map);
            if (isQueryEnabled) {
                TreeUtils.convertParam("status", "1", map);
            }
            col = TreeUtils.queryOrgListByCondition(map);
        } else {
            col = TreeUtils.getOrgLists();
        }
        return col;
    }

    private static Long getDefaultViewId() {
        return Long.parseLong("40");
    }

    private static DynamicObject getOrgDynamicObject(Map<String, Object> map) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"tctb_org_entity");
        obj.set("id", (Object)map.getOrDefault("FID", 0).toString());
        obj.set("number", (Object)map.getOrDefault("FNUMBER", "").toString());
        obj.set("name", (Object)map.getOrDefault("FNAME", "").toString());
        obj.set("parentid", (Object)map.getOrDefault("FPARENTID", "").toString());
        obj.set("status", (Object)("1".equalsIgnoreCase(map.getOrDefault("FENABLE", "").toString()) ? "2" : "3"));
        obj.set("longnumber", (Object)map.getOrDefault("FLONGNUMBER", "").toString());
        return obj;
    }

    private static DynamicObject initOrgObject() {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"tctb_org_entity");
        obj.set("id", (Object)0);
        obj.set("number", (Object)"");
        obj.set("name", (Object)"");
        obj.set("parentid", (Object)-1);
        obj.set("status", (Object)2);
        obj.set("longnumber", (Object)"");
        return obj;
    }

    public static Map<String, List<Object>> convertParam(String key, Object value, Map<String, List<Object>> map) {
        if (List.class.isAssignableFrom(value.getClass())) {
            map.put(key, (List)value);
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            map.put(key, list);
        }
        return map;
    }

    public static Map<String, List<Object>> convertParam(String key, Object value) {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>(16);
        if (List.class.isAssignableFrom(value.getClass())) {
            map.put(key, (List)value);
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            map.put(key, list);
        }
        return map;
    }

    private static StringBuilder getBaseStringBuilderByViewId(Long defaultViewId) {
        StringBuilder where = new StringBuilder();
        where.append("select a.flongnumber,b.fid, b.fnumber, c.fname, a.fparentid, b.fenable from t_org_structure a, t_org_org b,t_org_org_l c where a.forgid = b.fid  and b.fid = c.fid and c.Flocaleid = 'zh_CN' and b.fenable = '1'  and a.fviewid = ").append(defaultViewId);
        return where;
    }

    private static DynamicObjectCollection getOrgCollection(String where) {
        List list = DBUtils.query((String)DBRoute.basedata.getRouteKey(), (String)where);
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (Map map : list) {
                DynamicObject obj = TreeUtils.getOrgDynamicObject(map);
                dynamicObjectCollection.add((Object)obj);
            }
        } else {
            dynamicObjectCollection.add((Object)TreeUtils.initOrgObject());
        }
        return dynamicObjectCollection;
    }

    private static void extractQueryCondition(Map<String, List<Object>> condition, StringBuilder where) {
        List<Object> orgIdList = condition.get("id");
        List<Object> numberList = condition.get("number");
        List<Object> nameList = condition.get("name");
        List<Object> statusList = condition.get("status");
        if (!CollectionUtils.isEmpty(orgIdList)) {
            where.append(" and b.fid in (").append(StringUtils.join(orgIdList, (String)SEPARATOR)).append(')');
        }
        if (!CollectionUtils.isEmpty(numberList)) {
            where.append(" and b.fnumber in (").append(numberList.stream().map(s -> "'" + s + "'").collect(Collectors.joining(SEPARATOR))).append(')');
        }
        if (!CollectionUtils.isEmpty(nameList)) {
            where.append(" and c.fname in (").append(nameList.stream().map(s -> "'" + s + "'").collect(Collectors.joining(SEPARATOR))).append(')');
        }
        if (!CollectionUtils.isEmpty(statusList)) {
            where.append(" and b.fenable in (").append(statusList.stream().map(s -> "'" + s + "'").collect(Collectors.joining(SEPARATOR))).append(')');
        }
    }
}

