/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.waterresource;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tdm.common.license.ExtendAbstractBillPlugin;
import kd.taxc.tdm.common.util.EmptyCheckUtils;

public class WaterResourceEdit
extends ExtendAbstractBillPlugin
implements BeforeF7SelectListener {
    private static final String JNQX_AYSB = "aysb";
    private static final String JNQX_AJSB = "ajsb";
    private final Map<String, String> JNQXMAP = new HashMap<String, String>(){
        {
            this.put(WaterResourceEdit.JNQX_AYSB, "month");
            this.put(WaterResourceEdit.JNQX_AJSB, "season");
        }
    };

    public void registerListener(EventObject e) {
        BasedataEdit taxsource = (BasedataEdit)this.getControl("taxsource");
        BasedataEdit zszm = (BasedataEdit)this.getControl("zszm");
        taxsource.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        zszm.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params.get("orgid") != null) {
            this.getModel().setValue("org", params.get("orgid"));
            this.getView().setEnable(Boolean.FALSE, new String[]{"org"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (this.isInValidInput()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u4e0d\u6ee1\u8db3\u5f53\u524d\u7533\u62a5\u65e5\u671f\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WaterResourceEdit_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private boolean isInValidInput() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Date declaremonth = DateUtils.stringToDate((String)((String)params.get("declaremonth")));
        if (declaremonth == null) {
            return false;
        }
        int month = DateUtils.getMonthOfDate((Date)declaremonth);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String jnqx = dataEntity.getDynamicObject("taxsource").getString("jnqx");
        if (month % 3 != 1 && JNQX_AJSB.equals(jnqx)) {
            return true;
        }
        Date skssqq = dataEntity.getDate("skssqq");
        Date skssqz = dataEntity.getDate("skssqz");
        Date lastmonth = DateUtils.addMonth((Date)declaremonth, (int)-1);
        Date ajsbStart = DateUtils.getFirstDateOfSeason((Date)lastmonth);
        Date aysbStart = DateUtils.getFirstDateOfMonth((Date)lastmonth);
        Date end = DateUtils.getLastDateOfMonth((Date)lastmonth);
        if (JNQX_AJSB.equals(jnqx) && (skssqq.compareTo(end) > 0 || skssqz.compareTo(ajsbStart) < 0)) {
            return true;
        }
        return JNQX_AYSB.equals(jnqx) && (skssqq.compareTo(end) > 0 || skssqz.compareTo(aysbStart) < 0);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("zszm".equals(key)) {
            DynamicObject taxsource = (DynamicObject)this.getModel().getValue("taxsource");
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.setCustomParam("menu", (Object)"watersource");
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u5f81\u6536\u5b50\u76ee", (String)"WaterResourceEdit_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            if (taxsource != null) {
                DynamicObjectCollection zszm = taxsource.getDynamicObjectCollection("entryentity1");
                List zszmIds = zszm.stream().map(m -> m.getDynamicObject("zszm").getLong("id")).collect(Collectors.toList());
                QFilter qFilter = new QFilter("id", "in", zszmIds);
                listShowParameter.getListFilterParameter().setFilter(qFilter);
            }
        } else {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"WaterResourceEdit_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter qFilter = new QFilter("org", "=", org.get("id"));
            listShowParameter.getListFilterParameter().setFilter(qFilter);
            String taxauthority = (String)this.getView().getFormShowParameter().getCustomParams().get("taxauthority");
            if (taxauthority != null) {
                QFilter q1 = new QFilter("taxauthority", "=", (Object)Long.parseLong(taxauthority));
                listShowParameter.getListFilterParameter().setFilter(q1);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        DynamicObject dataEntity = e.getChangeSet()[0].getDataEntity();
        if ("org".equals(name)) {
            this.getModel().setValue("taxsource", null);
        } else if ("taxsource".equals(name) || "skssqq".equals(name) || "skssqz".equals(name)) {
            DynamicObject taxsource;
            if (("skssqq".equals(name) || "skssqz".equals(name)) && (taxsource = dataEntity.getDynamicObject("taxsource")) != null) {
                String jnqx = taxsource.getString("jnqx");
                String taxlimit = this.JNQXMAP.get(jnqx);
                Date date = (Date)this.getModel().getValue(name);
                if (date != null && StringUtil.isNotBlank((CharSequence)taxlimit)) {
                    Map period = DateUtils.getPeriodByTaxLimit((Date)date, (String)taxlimit);
                    this.getModel().setValue("skssqq", period.get("startDate"));
                    this.getModel().setValue("skssqz", period.get("endDate"));
                }
            }
            this.refreshSqljqsl(dataEntity, name);
        }
    }

    private void refreshSqljqsl(DynamicObject dataEntity, String name) {
        long orgId = dataEntity.getLong("org_id");
        String number = null;
        Long taxauthority = null;
        String jnqx = null;
        String sysbb = null;
        DynamicObjectCollection entity = null;
        DynamicObject taxsource = dataEntity.getDynamicObject("taxsource");
        if (EmptyCheckUtils.isNotEmpty((Object)taxsource)) {
            number = taxsource.getString("number");
            taxauthority = taxsource.getLong("taxauthority_id");
            jnqx = taxsource.getString("jnqx");
            sysbb = taxsource.getString("sysbb");
            entity = taxsource.getDynamicObjectCollection("entryentity1");
        }
        Date skssqq = dataEntity.getDate("skssqq");
        Date skssqz = dataEntity.getDate("skssqz");
        if (sysbb != null && sysbb.equals("A")) {
            BigDecimal sqljqsl = this.getSqljqsl(orgId, number, taxauthority, jnqx, skssqq, skssqz, "szys_a", null);
            if (sqljqsl != null) {
                this.getModel().setValue("sqljqsl", (Object)sqljqsl);
            }
        } else if (sysbb != null && sysbb.equals("B") && entity.size() > 0) {
            this.getModel().beginInit();
            this.getModel().deleteEntryData("entryentity");
            this.getModel().batchCreateNewEntryRow("entryentity", entity.size());
            int rowIndex = 0;
            for (DynamicObject dynamicObject : entity) {
                DynamicObject zszm = (DynamicObject)dynamicObject.get("zszm");
                this.getModel().setValue("zszm", (Object)zszm, rowIndex);
                BigDecimal sqljqslb = this.getSqljqsl(orgId, number, taxauthority, jnqx, skssqq, skssqz, "szys_b", zszm.getString("projectname"));
                if (sqljqslb != null) {
                    this.getModel().setValue("sqljqslb", (Object)sqljqslb, rowIndex);
                }
                ++rowIndex;
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    private BigDecimal getSqljqsl(Long orgId, String number, Long taxauthority, String jnqx, Date skssqq, Date skssqz, String type, String zszm) {
        if (orgId != 0L && EmptyCheckUtils.isNotEmpty((Object)number) && EmptyCheckUtils.isNotEmpty((Object)skssqq) && EmptyCheckUtils.isNotEmpty((Object)skssqz)) {
            int count = 0;
            if (JNQX_AYSB.equals(jnqx)) {
                count = -1;
            } else if (JNQX_AJSB.equals(jnqx)) {
                count = -3;
            }
            Date startdate = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)skssqq, (int)count));
            Date enddate = DateUtils.getLastDateOfMonth2((Date)DateUtils.addMonth((Date)skssqz, (int)count));
            QFilter q1 = new QFilter("org", "=", (Object)orgId);
            QFilter q2 = new QFilter("skssqq", "=", (Object)startdate);
            QFilter q3 = new QFilter("skssqz", "=", (Object)enddate);
            QFilter q4 = new QFilter("type", "=", (Object)type);
            QFilter q5 = new QFilter("taxauthority", "=", (Object)taxauthority);
            QFilter q6 = new QFilter("businessno", "=", (Object)number);
            DynamicObject nsrxx = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5, q6});
            if (EmptyCheckUtils.isNotEmpty((Object)nsrxx)) {
                DynamicObject object;
                QFilter q8 = new QFilter("sbbid", "=", (Object)nsrxx.getString("id"));
                QFilter q9 = new QFilter("ewblxh", "=", (Object)"resourcetax");
                if (type.equals("szys_b")) {
                    q9 = new QFilter("zszm", "=", (Object)zszm);
                }
                if (EmptyCheckUtils.isNotEmpty((Object)(object = QueryServiceHelper.queryOne((String)"tcwat_declare_a_tax", (String)"bqljqsl,ljqsfdl,bqqsl", (QFilter[])new QFilter[]{q8, q9})))) {
                    if (type.equals("szys_a")) {
                        return object.getBigDecimal("bqljqsl");
                    }
                    return object.getBigDecimal("ljqsfdl").add(object.getBigDecimal("bqqsl"));
                }
            }
        }
        return null;
    }
}

