/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.yhgl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.perm.PermDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.tdm.business.yhgl.TsqtReductService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TsqtReductPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final Map<String, String> TYPE_HJ_MAP = new HashMap<String, String>(){
        {
            this.put("1", "zzjytysb");
            this.put("2", "jdlkpkrk");
            this.put("3", "djsybnysry");
        }
    };
    private static final Map<String, String> HJ_TYPE_MAP = new HashMap<String, String>(){
        {
            this.put("zzjytysb", "1");
            this.put("jdlkpkrk", "2");
            this.put("djsybnysry3", "3");
        }
    };
    private TsqtReductService service = new TsqtReductService();

    public void registerListener(EventObject e) {
        BasedataEdit sjgzyfs;
        super.registerListener(e);
        BasedataEdit base = (BasedataEdit)this.getView().getControl("org");
        if (Objects.nonNull(base)) {
            base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (Objects.nonNull(sjgzyfs = (BasedataEdit)this.getView().getControl("sjgzyfs"))) {
            sjgzyfs.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setEnable(Boolean.FALSE, new String[]{"tb_new", "tb_del"});
        IFormView view = this.getView();
        Long orgId = RequestContext.get().getOrgId();
        String inited = this.getPageCache().get("inited");
        if (StringUtils.isBlank((CharSequence)inited)) {
            long userId = RequestContext.get().getCurrUserId();
            String entityid = view.getEntityId();
            String appid = view.getFormShowParameter().getAppId();
            this.getModel().setValue("org", (Object)this.service.defualtOrg(orgId, userId, appid, entityid));
            this.getPageCache().put("inited", "true");
        }
        Date now = new Date();
        Date startDate = DateUtils.getFirstDateOfMonth((Date)now);
        Date endDate = DateUtils.getLastDateOfMonth2((Date)now);
        this.getModel().beginInit();
        this.getModel().setValue("startdate", (Object)startDate);
        this.getModel().setValue("enddate", (Object)endDate);
        this.getModel().endInit();
        this.getModel().updateCache();
        this.getView().updateView("startdate");
        this.getView().updateView("enddate");
        if (this.getModel().getValue("org") != null) {
            FieldTip fieldTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "org", "");
            fieldTip.setSuccess(true);
            this.getView().showFieldTip(fieldTip);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        if (model.getValue("org") != null && model.getValue("startdate") != null && model.getValue("enddate") != null && model.getValue("tsqttype") != null) {
            if ("startdate".equals(name) || "enddate".equals(name) || "tsqttype".equals(name)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"tb_new", "tb_del"});
                String msg = this.service.checkData(model.getDataEntity());
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    this.getModel().deleteEntryData(ENTRYENTITY);
                    this.getView().setEnable(Boolean.FALSE, new String[]{"tb_new", "tb_del"});
                    this.updateSumData();
                    this.getView().showErrorNotification(msg);
                    return;
                }
                long orgId = ((DynamicObject)model.getValue("org")).getLong("id");
                Date startdate = (Date)model.getValue("startdate");
                Date enddate = (Date)model.getValue("enddate");
                String tsqttype = (String)model.getValue("tsqttype");
                Long pkid = this.service.queryTsqtReductId(Long.valueOf(orgId), startdate, enddate, tsqttype);
                this.showBill(pkid);
                if (pkid != null) {
                    return;
                }
                BigDecimal dekcbzje = this.service.queryDekcbzje(Long.valueOf(orgId), startdate, tsqttype);
                this.getModel().setValue("dekcbzje", (Object)dekcbzje);
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"tb_new", "tb_del"});
        }
        if ("startdate".equals(name) || "enddate".equals(name)) {
            Date startdate = (Date)model.getValue("startdate");
            Date enddate = (Date)model.getValue("enddate");
            if (startdate != null && enddate != null && !this.service.validDate(startdate, enddate)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5b8c\u6574\u6708\u4efd", (String)"TsqtReductPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            }
        } else if ("dekcbzje".equals(name) || "sjgzyfs".equals(name)) {
            int count = this.getModel().getEntryRowCount(ENTRYENTITY);
            this.getModel().beginInit();
            for (int i = 0; i < count; ++i) {
                this.updateEntryJmed((BigDecimal)this.getModel().getValue("dekcbzje"), i);
            }
            this.getModel().endInit();
            this.getView().updateView(ENTRYENTITY);
            this.updateSumData();
        } else if (HJ_TYPE_MAP.containsKey(name)) {
            String type = HJ_TYPE_MAP.get(name);
            int sumEntryIndex = this.findSumEntryIndex(type, false);
            if (sumEntryIndex != -1) {
                this.getModel().setValue("bqcjjmed", this.getModel().getValue(name), sumEntryIndex);
            }
        } else if ("tsqttype".equals(name)) {
            this.getModel().deleteEntryData(ENTRYENTITY);
            this.updateSumData();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate opt = (FormOperate)args.getSource();
        String operateKey = opt.getOperateKey();
        if ("newentry".equals(operateKey)) {
            args.setCancel(true);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                return;
            }
            long orgId = org.getLong("id");
            long currUserId = RequestContext.get().getCurrUserId();
            String appId = this.getView().getFormShowParameter().getAppId();
            TaxResult rs = PermDataServiceHelper.checkPermission((Long)currUserId, (Long)orgId, (String)appId, (String)"tdm_tsqt_reduct", (String)"1/P6D+PRBN4Z");
            if (rs.getData() == null || !((Boolean)rs.getData()).booleanValue()) {
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("orgId", org.getString("id"));
            customParams.put("tsqttype", this.getModel().getValue("tsqttype"));
            customParams.put("startdate", DateUtils.format((Date)((Date)this.getModel().getValue("startdate")), (String)"yyyy-MM-dd"));
            customParams.put("selectIds", this.getModel().getEntryEntity(ENTRYENTITY).stream().map(o -> o.getString("specialid")).collect(Collectors.joining(",")));
            customParams.put("mainId", this.getModel().getDataEntity().getString("id"));
            CloseCallBack sbbSelect = new CloseCallBack((IFormPlugin)this, "tdm_tsqtxx_dialog");
            parameter.setCloseCallBack(sbbSelect);
            parameter.setCustomParams(customParams);
            parameter.setFormId("tdm_tsqtxx_dialog");
            parameter.getOpenStyle().setShowType(ShowType.NonModal);
            this.getView().showForm(parameter);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("org".equals(name)) {
            long userId = RequestContext.get().getCurrUserId();
            String entityid = this.getView().getEntityId();
            String appid = this.getView().getFormShowParameter().getAppId();
            List orgList = this.service.queryOrgIdsWithPermWithoutSubOrg(userId, appid, entityid);
            evt.getCustomQFilters().add(new QFilter("id", "in", (Object)orgList));
        } else if ("sjgzyfs".equals(name)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            int bndkcjyfs = (Integer)this.getModel().getValue("bndkcjyfs", rowIndex);
            String maxBndycjyfsStr = this.service.queryMaxBndycjyfs((Long)this.getModel().getValue("specialid", rowIndex), Long.valueOf(this.getModel().getDataEntity().getLong("id")));
            int maxBndycjyfs = Integer.parseInt(maxBndycjyfsStr);
            evt.getCustomQFilters().add(new QFilter("id", "in", (Object)IntStream.range(maxBndycjyfs + 1, bndkcjyfs + 1).toArray()));
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if (ENTRYENTITY.equals(e.getEntryProp().getName())) {
            this.updateSumData();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String idsStr;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("tdm_tsqtxx_dialog".equals(actionId) && StringUtils.isNotBlank((CharSequence)(idsStr = (String)evt.getReturnData()))) {
            List ret = JsonUtil.fromJsonList((String)idsStr, Map.class);
            ArrayList ids = new ArrayList(ret.size());
            Map<Long, Integer> bndsykcjyfsMap = ret.stream().peek(o -> ids.add(Long.valueOf(o.get("id").toString()))).collect(Collectors.toMap(o -> Long.valueOf(o.get("id").toString()), o -> Integer.valueOf(o.get("bndsykcjyfs").toString()), (v1, v2) -> v1));
            DynamicObject[] data = this.service.loadSpecialGroupData(ids);
            this.setEntryData(data, bndsykcjyfsMap);
        }
    }

    private void showBill(Object pkId) {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (pkId != null) {
            billShowParameter.setPkId(pkId);
            this.getModel().setValue("id", pkId);
            billShowParameter.setBillStatus(BillOperationStatus.EDIT);
            billShowParameter.setStatus(OperationStatus.EDIT);
            this.getView().invokeOperation("refresh");
        }
    }

    private void setEntryData(DynamicObject[] data, Map<Long, Integer> bndsykcjyfsMap) {
        this.getModel().beginInit();
        Date startdate = (Date)this.getModel().getValue("startdate");
        int collectYear = DateUtils.getYearOfDate((Date)startdate);
        BigDecimal dekcbzje = (BigDecimal)this.getModel().getValue("dekcbzje");
        long id = this.getModel().getDataEntity().getLong("id");
        for (DynamicObject datum : data) {
            Date ssstartmonth = datum.getDate("ssstartmonth");
            Date leavedate = datum.getDate("leavedate");
            int index = this.getModel().createNewEntryRow(ENTRYENTITY);
            long specialId = datum.getLong("id");
            this.getModel().setValue("specialid", (Object)specialId, index);
            this.getModel().setValue("bndsykcjyfs", (Object)bndsykcjyfsMap.getOrDefault(specialId, 0), index);
            this.getModel().setValue("taxorg", datum.get("org"), index);
            String staffname = datum.getString("staffname");
            this.getModel().setValue("staffname", (Object)staffname, index);
            this.getModel().setValue("idnumber", datum.get("idnumber"), index);
            this.getModel().setValue("type", datum.get("type"), index);
            this.getModel().setValue("certcode", datum.get("certcode"), index);
            this.getModel().setValue("ssstartmonth", (Object)ssstartmonth, index);
            String nd = ResManager.loadKDString((String)"\u5e74\u5ea6", (String)"TsqtReductPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            String workyear = collectYear + nd;
            this.getModel().setValue("workyear", (Object)workyear, index);
            this.getModel().setValue("leavedate", (Object)leavedate, index);
            int bndkcjyfs = this.service.getBndkcjyfs(collectYear, ssstartmonth, leavedate);
            this.getModel().setValue("bndkcjyfs", (Object)bndkcjyfs, index);
            int sjgzyfs = this.service.getSjgzyfs(startdate, ssstartmonth, leavedate);
            this.getModel().setValue("sjgzyfs", (Object)sjgzyfs, index);
            this.getView().setEnable(Boolean.valueOf(!this.service.sjgzyfsEditCheck(staffname, workyear, sjgzyfs, Long.valueOf(id))), index, new String[]{"sjgzyfs"});
            this.updateEntryJmed(dekcbzje, index);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY);
        this.updateSumData();
    }

    private void updateEntryJmed(BigDecimal dekcbzje, int index) {
        String workyear = (String)this.getModel().getValue("workyear", index);
        int bndkcjyfs = (Integer)this.getModel().getValue("bndkcjyfs", index);
        DynamicObject sjgzyfsObj = (DynamicObject)this.getModel().getValue("sjgzyfs", index);
        int sjgzyfs = 0;
        if (sjgzyfsObj != null) {
            sjgzyfs = sjgzyfsObj.getInt("id");
        }
        Long specialId = (Long)this.getModel().getValue("specialid", index);
        long id = this.getModel().getDataEntity().getLong("id");
        BigDecimal bnkjmed = dekcbzje.multiply(new BigDecimal(bndkcjyfs)).divide(new BigDecimal("12"), 2, RoundingMode.HALF_UP);
        this.getModel().setValue("bnkjmed", (Object)bnkjmed, index);
        BigDecimal ycjjmed = this.service.queryYcjjmed(specialId, workyear, Long.valueOf(id));
        this.getModel().setValue("ycjjmed", (Object)ycjjmed, index);
        BigDecimal bqkcjjmed = dekcbzje.multiply(new BigDecimal(sjgzyfs)).divide(new BigDecimal("12"), 2, RoundingMode.HALF_UP).subtract(ycjjmed);
        this.getModel().setValue("bqkcjjmed", (Object)bqkcjjmed, index);
        this.getModel().setValue("sykcjjmed", (Object)bnkjmed.subtract(ycjjmed).subtract(bqkcjjmed), index);
    }

    private void updateSumData() {
        DynamicObjectCollection entryData = this.getModel().getEntryEntity(ENTRYENTITY);
        Map<String, List<DynamicObject>> typeDataMap = entryData.stream().collect(Collectors.groupingBy(o -> o.getString("type")));
        List<DynamicObject> zzjysb = typeDataMap.get("1");
        this.setSum(zzjysb, "1");
        List<DynamicObject> jdlkpkrk = typeDataMap.get("2");
        this.setSum(jdlkpkrk, "2");
        List<DynamicObject> djsybnysry = typeDataMap.get("3");
        this.setSum(djsybnysry, "3");
    }

    private void setSum(List<DynamicObject> collection, String type) {
        int index = this.findSumEntryIndex(type, true);
        String sumKey = TYPE_HJ_MAP.get(type);
        if (CollectionUtils.isNotEmpty(collection)) {
            BigDecimal jmedSum = BigDecimal.ZERO;
            this.getModel().beginInit();
            this.getModel().setValue("type1", (Object)type, index);
            this.getModel().setValue("cjrs", (Object)collection.size(), index);
            BigDecimal bndsykcjyfs = BigDecimal.ZERO;
            for (DynamicObject obj : collection) {
                jmedSum = jmedSum.add(obj.getBigDecimal("bqkcjjmed"));
                bndsykcjyfs = bndsykcjyfs.add(obj.getBigDecimal("bndsykcjyfs"));
            }
            this.getModel().setValue(sumKey, (Object)jmedSum);
            this.getModel().setValue("bqcjjmed", (Object)jmedSum, index);
            this.getModel().setValue("sywcjjmed", (Object)bndsykcjyfs.multiply((BigDecimal)this.getModel().getValue("dekcbzje")).divide(new BigDecimal("12"), 2, RoundingMode.HALF_UP), index);
            this.getModel().endInit();
            this.getModel().updateCache();
            this.getView().updateView(sumKey);
            this.getView().updateView("entryentity1");
        } else {
            this.getModel().setValue(sumKey, (Object)BigDecimal.ZERO);
            this.getModel().deleteEntryRow("entryentity1", index);
        }
    }

    private int findSumEntryIndex(String type, boolean needCreate) {
        int count = this.getModel().getEntryRowCount("entryentity1");
        int index = -1;
        for (int i = 0; i < count; ++i) {
            String type1 = (String)this.getModel().getValue("type1", i);
            if (!type.equals(type1)) continue;
            index = i;
            break;
        }
        if (needCreate && index == -1) {
            index = this.getModel().createNewEntryRow("entryentity1");
        }
        return index;
    }
}

