/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.yhgl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tdm.business.yhgl.TsqtReductService;
import kd.taxc.tdm.common.util.JsonUtil;
import org.apache.commons.lang3.ObjectUtils;

public class TsqtxxDialogFormPlugin
extends AbstractFormPlugin {
    private TsqtReductService service = new TsqtReductService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btok"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        String orgId = (String)customParams.get("orgId");
        String tsqttype = (String)customParams.get("tsqttype");
        String startdate = (String)customParams.get("startdate");
        String selectIds = (String)customParams.get("selectIds");
        if (ObjectUtils.anyNull((Object[])new Object[]{orgId, tsqttype, startdate, selectIds})) {
            return;
        }
        Date startDate = DateUtils.stringToDate2((String)startdate, (String)"yyyy-MM-dd");
        int collectYear = DateUtils.getYearOfDate((Date)startDate);
        List ids = this.service.queryTsqtxxDialogIds(orgId, startDate, selectIds, tsqttype);
        this.loadEntryData(ids, collectYear);
    }

    private void loadEntryData(List<Long> ids, int collectYear) {
        DynamicObject[] queryData = this.service.loadSpecialGroupData(ids);
        String mainId = (String)this.getView().getFormShowParameter().getCustomParam("mainId");
        Long id = StringUtils.isNotBlank((CharSequence)mainId) ? Long.valueOf(mainId) : null;
        this.getModel().beginInit();
        this.getModel().deleteEntryData("entryentity");
        for (DynamicObject queryDatum : queryData) {
            int bndsykcjyfs;
            int index = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("specialid", queryDatum.get("id"), index);
            this.getModel().setValue("org", queryDatum.get("org"), index);
            this.getModel().setValue("staffname", queryDatum.get("staffname"), index);
            this.getModel().setValue("type", queryDatum.get("type"), index);
            this.getModel().setValue("ssstartmonth", queryDatum.get("ssstartmonth"), index);
            this.getModel().setValue("leavedate", queryDatum.get("leavedate"), index);
            this.getModel().setValue("idnumber", queryDatum.get("idnumber"), index);
            this.getModel().setValue("certcode", queryDatum.get("certcode"), index);
            String nd = ResManager.loadKDString((String)"\u5e74\u5ea6", (String)"TsqtxxDialogFormPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            this.getModel().setValue("gznd", (Object)(collectYear + nd), index);
            this.getModel().setValue("bndycjyfs", (Object)this.service.queryMaxBndycjyfs(Long.valueOf(queryDatum.getLong("id")), collectYear + nd, id), index);
            this.getModel().setValue("bndsykcjyfs", (Object)"0", index);
            int bndycjyfs = (Integer)this.getModel().getValue("bndycjyfs", index);
            Date leavedate = queryDatum.getDate("leavedate");
            Date ssstartmonth = queryDatum.getDate("ssstartmonth");
            int bndkcjyfs = this.service.getBndkcjyfs(collectYear, ssstartmonth, leavedate);
            if (bndycjyfs > bndkcjyfs) {
                EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                CellStyle cellStyle = new CellStyle();
                cellStyle.setRow(index);
                cellStyle.setFieldKey("bndycjyfs");
                cellStyle.setBackColor("#FFDBE0");
                entryGrid.setCellStyle(Collections.singletonList(cellStyle));
                bndsykcjyfs = 0;
            } else {
                bndsykcjyfs = bndkcjyfs - bndycjyfs;
            }
            this.getModel().setValue("bndsykcjyfs", (Object)bndsykcjyfs, index);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button source = (Button)evt.getSource();
        if ("btok".equals(source.getKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length > 0) {
                ArrayList ret = new ArrayList(selectRows.length);
                for (int selectRow : selectRows) {
                    Integer bndsykcjyfs = (Integer)this.getModel().getValue("bndsykcjyfs", selectRow);
                    if (bndsykcjyfs == 0) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u52fe\u9009\u5931\u8d25\u3002\u7b2c%s\u884c\u7684\u672c\u5e74\u5ea6\u5269\u4f59\u53ef\u91c7\u96c6\u6708\u4efd\u6570\u4e3a0\uff0c\u672c\u5e74\u5ea6\u5185\u5df2\u65e0\u53ef\u91c7\u96c6\u989d\u5ea6", (String)"TsqtxxDialogFormPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), selectRow + 1));
                        return;
                    }
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", this.getModel().getValue("specialid", selectRow).toString());
                    map.put("bndsykcjyfs", this.getModel().getValue("bndsykcjyfs", selectRow).toString());
                    ret.add(map);
                }
                this.getView().returnDataToParent((Object)JsonUtil.toJson(ret));
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u6570\u636e", (String)"TsqtxxDialogFormPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

