/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.business.tio;

import java.util.Date;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class InTransferOutAllocateService {
    private static final String PAGE_ACCOUNT_SUMMARY = "tcvat_account_summary";

    public static DynamicObjectCollection getIncomeSummary(DynamicObject dynamicObject) {
        QFilter orgIdFilter = new QFilter("orgid", "=", dynamicObject.get("org"));
        QFilter statusFilter = new QFilter("status", "!=", (Object)"0");
        QFilter reportperiodFilter = new QFilter("reportperiod", "=", (Object)dynamicObject.getDate("transferdate"));
        QFilter draftPurposeFilter = new QFilter("draftpurpose", "=", (Object)"nssb");
        DynamicObject tcvatPolicyConfirm = QueryServiceHelper.queryOne((String)"tcvat_policy_confirm", (String)" * ", (QFilter[])new QFilter[]{orgIdFilter, reportperiodFilter, statusFilter, draftPurposeFilter});
        DynamicObjectCollection summarys = new DynamicObjectCollection();
        QFilter taxperiodFilter = new QFilter("taxperiod", "=", (Object)DateUtils.formatMonth((Date)dynamicObject.getDate("transferdate")));
        QFilter orgFilter = new QFilter("org", "=", dynamicObject.get("org"));
        summarys = QueryServiceHelper.query((String)PAGE_ACCOUNT_SUMMARY, (String)"taxamount,taxmethodtype", (QFilter[])new QFilter[]{orgFilter, taxperiodFilter});
        if (tcvatPolicyConfirm == null) {
            InTransferOutAllocateService.runTask(dynamicObject);
        }
        return summarys;
    }

    private static void runTask(DynamicObject dynamicObject) {
        HashMap<String, String> params = new HashMap<String, String>();
        Date date = dynamicObject.getDate("transferdate");
        String firstDateOfMonthStr = DateUtils.getFirstDateOfMonthStr((Date)date, (String)"yyyy-MM-dd");
        String lastDateOfMonthStr = DateUtils.getLastDateOfMonthStr((Date)date, (String)"yyyy-MM-dd");
        params.put("org", dynamicObject.getString("org"));
        params.put("startDate", firstDateOfMonthStr);
        params.put("endDate", lastDateOfMonthStr);
        params.put("taxperiod", DateUtils.formatMonth((Date)date));
        params.put("requestcontext", (String)RequestContext.getOrCreate());
        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tcvat", (String)"RunEngineService", (String)"execute", (Object[])new Object[]{params});
    }
}

