/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.common.enums;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.taxc.til.common.util.MultiLangEnumBridge;

public enum InputInvoiceTypeEnum {
    ALL_INVOICE(0L, new MultiLangEnumBridge("\u8f6c\u51fa\u603b\u89c8", "InputInvoiceTypeEnum_9", "taxc-til"), Arrays.asList(961639304377984000L, 961640097369875456L, 961634333825754112L, 961642468384760832L, 961641829533496320L, 961640926684439552L, 961641064953820160L, 961642651029877760L, 961642939052733440L, 1376129725579325440L), new QFilter("real_output_amount", ">", (Object)BigDecimal.ZERO)),
    SPECIAL_ELECTRON(961639304377984000L, new MultiLangEnumBridge("\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968", "InputInvoiceTypeEnum_0", "taxc-til"), Arrays.asList(961639304377984000L, 961640097369875456L), new QFilter("deduction_purpose", "=", (Object)"1").and(new QFilter("authenticate_flag", "in", Arrays.asList("1", "2", "3")))),
    ORDINARY_ELECTRON(961634333825754112L, new MultiLangEnumBridge("\u7535\u5b50\u666e\u901a\u53d1\u7968", "InputInvoiceTypeEnum_1", "taxc-til"), Collections.singletonList(961634333825754112L), new QFilter("transport_deduction", "=", (Object)"1")),
    TOLL_ELECTRON(961642468384760832L, new MultiLangEnumBridge("\u901a\u884c\u8d39\u53d1\u7968", "InputInvoiceTypeEnum_2", "taxc-til"), Collections.singletonList(961642468384760832L), new QFilter("deduction_purpose", "=", (Object)"1")),
    MOTOR_INVOICE(961641829533496320L, new MultiLangEnumBridge("\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968", "InputInvoiceTypeEnum_3", "taxc-til"), Collections.singletonList(961641829533496320L), new QFilter("deduction_purpose", "=", (Object)"1")),
    TRAIN_INVOICE(961640926684439552L, new MultiLangEnumBridge("\u706b\u8f66/\u9ad8\u94c1\u7968", "InputInvoiceTypeEnum_4", "taxc-til"), Collections.singletonList(961640926684439552L), new QFilter("transport_deduction", "=", (Object)"1")),
    AIR_INVOICE(961641064953820160L, new MultiLangEnumBridge("\u98de\u673a\u7968", "InputInvoiceTypeEnum_5", "taxc-til"), Collections.singletonList(961641064953820160L), new QFilter("transport_deduction", "=", (Object)"1")),
    TRANSPORT_INVOICE(961642651029877760L, new MultiLangEnumBridge("\u6c7d\u8f66\u7968", "InputInvoiceTypeEnum_10", "taxc-til"), Collections.singletonList(961642651029877760L), new QFilter("transport_deduction", "=", (Object)"1")),
    SHIP_INVOICE(961642939052733440L, new MultiLangEnumBridge("\u8f6e\u8239\u7968", "InputInvoiceTypeEnum_8", "taxc-til"), Collections.singletonList(961642939052733440L), new QFilter("transport_deduction", "=", (Object)"1")),
    IM_INV_ELECTRIC_SPECIAL(1376129725579325440L, new MultiLangEnumBridge("\u5168\u7535\u4e13\u7968 ", "InputInvoiceTypeEnum_11", "taxc-til"), Collections.singletonList(1376129725579325440L), new QFilter("deduction_purpose", "=", (Object)"1").and(new QFilter("authenticate_flag", "in", Arrays.asList("1", "2", "3"))).and("invoice_status", "in", Arrays.asList("0", "7", "8")));

    private Long code;
    private MultiLangEnumBridge bridge;
    private List<Long> codeList;
    private QFilter filter;

    private InputInvoiceTypeEnum(Long code, MultiLangEnumBridge bridge, List<Long> codeList, QFilter filter) {
        this.code = code;
        this.codeList = codeList;
        this.bridge = bridge;
        this.filter = filter;
    }

    public static InputInvoiceTypeEnum getInvoiceType(Long code) {
        for (InputInvoiceTypeEnum invoiceType : InputInvoiceTypeEnum.values()) {
            if (!invoiceType.getCode().equals(code)) continue;
            return invoiceType;
        }
        return null;
    }

    public Long getCode() {
        return this.code;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public List<Long> getCodeList() {
        return this.codeList;
    }

    public QFilter getFilter() {
        return this.filter;
    }
}

