/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.customs;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.til.formplugin.customs.enums.InSubEntityMappingEnum;
import org.apache.commons.collections.CollectionUtils;

public class InCustomsPaymentImportPlugin
implements IImportPlugin {
    private Map<String, Long> orgMap = new HashMap<String, Long>();
    private String entryEntityName = null;

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        JSONArray entities;
        DynamicObject dynamicObject;
        String orgNumber = (String)((Map)data.get("org")).get("number");
        Long orgId = this.orgMap.get(orgNumber);
        if (orgId == null) {
            DynamicObjectCollection col = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"number", (Object)orgNumber));
            if (CollectionUtils.isNotEmpty((Collection)col) && ((DynamicObject)col.get(0)).getLong("id") != 0L) {
                orgId = ((DynamicObject)col.get(0)).getLong("id");
                this.orgMap.put(orgNumber, orgId);
            } else {
                String msg = ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u6570\u636e\u4e0d\u5b58\u5728\uff1a\u7ec4\u7ec7 # org.number\u201c%s\u201d", (String)"InCustomsPaymentImportPlugin_0", (String)"taxc-til", (Object[])new Object[0]);
                importlogs.add(new ImportLogger.ImportLog(String.format(msg, orgNumber)));
                return false;
            }
        }
        data.put("datasource", "income");
        data.put("sourcesystem", ResManager.loadKDString((String)"\u82cd\u7a79", (String)"InCustomsPaymentImportPlugin_1", (String)"taxc-til", (Object[])new Object[0]));
        Object specialtaxcode = data.get("specialtaxcode");
        data.put("billno", String.valueOf(specialtaxcode));
        if ("new".equals(option.get("importtype")) && (dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tdm_customs_payment", (String)"specialtaxcode", (QFilter[])new QFilter[]{new QFilter("specialtaxcode", "=", specialtaxcode)})) != null) {
            String msg = ResManager.loadKDString((String)"\u4e13\u7528\u7f34\u6b3e\u4e66\u53f7\u7801\u91cd\u590d # specialtaxcode\u201c%s\u201d", (String)"InCustomsPaymentImportPlugin_2", (String)"taxc-til", (Object[])new Object[0]);
            importlogs.add(new ImportLogger.ImportLog(String.format(msg, dynamicObject.getString("specialtaxcode"))));
            return false;
        }
        data.put("period", DateUtils.stringToDate((String)((String)data.get("period")), (String)"yyyy-MM"));
        if (StringUtils.isNotEmpty((CharSequence)this.entryEntityName) && (entities = (JSONArray)data.get(this.entryEntityName)).size() == 0) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("seq", (Object)1);
            entities.add((Object)jsonObject);
            data.put(this.entryEntityName, entities);
        }
        return super.beforeImportData(data, option, importlogs);
    }

    public List<Object> importData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        return super.importData(data, option, importlogs);
    }

    public BillEntityType getImportMainEntityType(String billFormId) {
        this.entryEntityName = null;
        this.entryEntityName = InSubEntityMappingEnum.getSubEntityNameByEntityName(billFormId);
        return super.getImportMainEntityType(billFormId);
    }
}

