/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.helper;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;

public class PointIncomeChartHelper {
    private static final List<String> TYPES = Arrays.asList("0", "1", "2", "3", "4");

    public Map<String, List> drawChart(PointLineChart pointLineChart, PointLineChart pointLineChart1, List<String> monthList, List<BigDecimal> totalHJDkseList, List<Integer> fpTotalList) {
        this.loadPointLineChart(pointLineChart, monthList, totalHJDkseList, fpTotalList, "1");
        this.loadPointLineChart(pointLineChart1, monthList, totalHJDkseList, fpTotalList, "2");
        return null;
    }

    private void loadPointLineChart(PointLineChart pointLineChart, List<String> monthList, List<BigDecimal> totalHJDkseList, List<Integer> fpTotalList, String type) {
        boolean isX = true;
        Axis categoryAxis = this.createCategoryAxis(pointLineChart, "", isX);
        HashMap nametextstyle = Maps.newHashMap();
        nametextstyle.put("color", "#000000");
        nametextstyle.put("fontSize", 16);
        categoryAxis.setPropValue("nameTextStyle", (Object)nametextstyle);
        categoryAxis.setPropValue("nameLocation", (Object)"end");
        categoryAxis.setPropValue("position", (Object)"bottom");
        HashMap axislabel = Maps.newHashMap();
        HashMap textstyle = Maps.newHashMap();
        textstyle.put("color", "#000000");
        textstyle.put("fontSize", "16");
        axislabel.put("textStyle", textstyle);
        categoryAxis.setPropValue("axisLabel", (Object)axislabel);
        categoryAxis.setCategorys(monthList);
        Axis ValueAxis = this.createValueAxis(pointLineChart, ResManager.loadKDString((String)"\u4e07\u5143", (String)"PointIncomeChartHelper_0", (String)"taxc-til", (Object[])new Object[0]), TYPES, !isX);
        this.createLineSeries(pointLineChart, ResManager.loadKDString((String)"\u7a0e\u671f", (String)"PointIncomeChartHelper_1", (String)"taxc-til", (Object[])new Object[0]), "1".equalsIgnoreCase(type) ? totalHJDkseList.toArray(new Number[0]) : (Number[])fpTotalList.toArray(new Integer[0]), "#666666");
        pointLineChart.setMargin(Position.right, "80px");
        pointLineChart.setMargin(Position.top, "80px");
        pointLineChart.setMargin(Position.left, "80px");
        pointLineChart.setLegendPropValue("top", (Object)"8%");
        pointLineChart.setShowTooltip(false);
        pointLineChart.refresh();
    }

    private Axis createCategoryAxis(PointLineChart pointLineChart, String name, boolean isx) {
        Axis axis = null;
        axis = isx ? pointLineChart.createXAxis(name, AxisType.category) : pointLineChart.createYAxis(name, AxisType.category);
        HashMap axisTick = Maps.newHashMap();
        axisTick.put("interval", 0);
        axisTick.put("show", Boolean.FALSE);
        axisTick.put("grid", Position.left);
        axis.setPropValue("axisTick", (Object)axisTick);
        return axis;
    }

    private Axis createValueAxis(PointLineChart pointLineChart, String name, List<String> demensions, boolean isx) {
        Axis axis = null;
        axis = isx ? pointLineChart.createXAxis(name, AxisType.value) : pointLineChart.createYAxis(name, AxisType.value);
        axis.setMax((Number)4);
        axis.setMin((Number)0);
        axis.setCategorys(demensions);
        HashMap axisTick = Maps.newHashMap();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", (Object)axisTick);
        HashMap splitLine = Maps.newHashMap();
        HashMap lineStyle = Maps.newHashMap();
        HashMap axisLabel = Maps.newHashMap();
        axisLabel.put("show", Boolean.FALSE);
        axis.setPropValue("axisLabel", (Object)axisLabel);
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", (Object)splitLine);
        return axis;
    }

    private void createLineSeries(PointLineChart pointLineChart, String name, Number[] values, String color) {
        LineSeries expireSeries = pointLineChart.createSeries(name);
        Label label = new Label();
        label.setShow(false);
        label.setColor("#666666");
        expireSeries.setLabel(label);
        expireSeries.setItemColor(color);
        for (int i = 0; i < values.length; ++i) {
            Number n = values[i];
            if (n.intValue() != 0) continue;
            values[i] = null;
        }
        expireSeries.setData(values);
    }
}

