/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.inputdeduction;

import com.google.common.collect.Lists;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.list.plugin.IListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.address.RegisterAddressUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.til.formplugin.inputdeduction.enums.LkysdkCheckCertBoardEnum;
import kd.taxc.til.formplugin.inputdeduction.enums.LkysdkCheckCertEnum;
import kd.taxc.til.formplugin.utils.VoucherOperationEnum;
import kd.taxc.til.formplugin.utils.VoucherUtils;
import org.apache.commons.lang3.StringUtils;

public class LkysdkListFormPlugin
extends AbstractListPlugin
implements TabSelectListener,
IListPlugin {
    private static final String FILTER_CONTAINER_AP = "filtercontainerap";
    private static final String TAX_AMOUNT = "taxamount";
    private static final String TAB_AP = "tabap";
    private static final String CARD_TITLE = "cardtitle";
    private static final String SELECTED_FLEX_KEY = "selectedflexkey";
    private static final String SEL_COUNT = "selcount";
    private static final String SEL_TOTAL = "seltotal";
    private static final String SEL_CAN_COUNT = "selcancount";
    private static final String SEL_CAN_TOTAL = "selcantotal";
    private static final String AUTH_SEL_TOTAL = "authseltotal";
    public static final String TAXPERIOD = "taxperiod";
    public static final String VERIFY_ORG = "verifyOrg";
    public static final String DOPERIOD = "doperiod";
    public static final String CANCELPERIOD = "cancelperiod";
    public static final String GENERATEVOUCHER = "generatevoucher";
    public static final String DELETEVOUCHER = "deletevoucher";
    public static final String PREVIEWVOUCHER = "previewvoucher";
    public static final String REFRESH = "refresh";
    public static final String TIL_JXDK_SSQQ_SELECT = "til_jxdk_ssqq_select";
    public static final String TAXPERIODDATE = "taxperioddate";
    public static final String TDM_INPUT_ARIPORT = "tdm_input_ariport";
    private static Log log = LogFactory.getLog(LkysdkListFormPlugin.class);
    private static final String FILTER_TAB = "filterTab";
    private static Date specialDate = DateUtils.stringToDate((String)"2019-04-01");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"toolbarap"});
        this.addTabSelectListener(this, TAB_AP);
        for (LkysdkCheckCertEnum tioCheckCertEnum : LkysdkCheckCertEnum.values()) {
            this.addBoardClickListener(tioCheckCertEnum);
        }
    }

    public void initialize() {
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl(FILTER_CONTAINER_AP);
        filterContainer.setBillFormId("tdm_input_ariport_inh");
        filterContainer.addFilterContainerInitListener(event -> this.filterContainerInit(event));
        filterContainer.addSearchClickListener(event -> this.filterSearchClickEvent(event));
        filterContainer.addBeforeF7SelectListener(this::filterContainerBeforeF7Select);
        for (LkysdkCheckCertEnum tioCheckCertEnum : LkysdkCheckCertEnum.values()) {
            BillList billList = (BillList)this.getControl(tioCheckCertEnum.getBillap());
            billList.addSetFilterListener(this::setFilter);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("bos_org".equals(args.getRefEntityId())) {
            HasPermOrgResult result = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            if (result == null || result.hasAllOrgPerm()) {
                return;
            }
            OrgUtils.addFilterByConditionBeforeF7Select((Object)args, (IFormView)this.getView(), (String[])new String[]{"til_jxdk_lkysdk_list"}, null, null);
        }
    }

    private void addBoardClickListener(LkysdkCheckCertEnum tioCheckCertEnum) {
        for (LkysdkCheckCertBoardEnum tioCheckCertBoardEnum : LkysdkCheckCertBoardEnum.values()) {
            this.addClickListeners(new String[]{tioCheckCertEnum.getCode() + tioCheckCertBoardEnum.getFlexKey()});
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put("init_flag", "true");
    }

    public void click(EventObject evt) {
        this.getPageCache().remove("init_flag");
        String key = ((Control)evt.getSource()).getKey();
        LkysdkCheckCertEnum tioCheckCertEnum = this.getCurrentCheckCertEnum();
        LkysdkCheckCertBoardEnum boardEnum = LkysdkCheckCertBoardEnum.getEnumByKey(tioCheckCertEnum.getCode(), key);
        if (EmptyCheckUtils.isEmpty((Object)((Object)boardEnum))) {
            return;
        }
        if (EmptyCheckUtils.isNotEmpty((Object)this.getPageCache().get(SELECTED_FLEX_KEY))) {
            String oldselectflexkey = this.getPageCache().get(SELECTED_FLEX_KEY);
            if (!oldselectflexkey.equalsIgnoreCase(key)) {
                this.removeOldSelectFlex(oldselectflexkey);
                this.addNewSelectFlex(key);
            }
        } else {
            this.addNewSelectFlex(key);
        }
        this.displayDataByBoardSelected(boardEnum, tioCheckCertEnum);
    }

    public void destory() {
        super.destory();
    }

    private void filterSearchClickEvent(SearchClickEvent searchClickEvent) {
        this.getPageCache().remove("init_flag");
        LkysdkCheckCertEnum tioCheckCertEnum = this.getCurrentCheckCertEnum();
        BillList billList = (BillList)this.getView().getControl(tioCheckCertEnum.getBillap());
        Map map = searchClickEvent.getFilterValues();
        List customlist = (List)map.get("customfilter");
        List schemelist = (List)map.get("schemefilter");
        List fastlist = (List)map.get("fastfilter");
        FilterParameter fastFilterParameter = searchClickEvent.getFilterModel().getFastFilterParameter(fastlist);
        List fastQFilterList = fastFilterParameter.getQFilters();
        FilterParameter commonFilterParameter = searchClickEvent.getFilterModel().getCommonFilterParameter(customlist);
        List commonQFilterList = commonFilterParameter.getQFilters();
        FilterParameter schemaFilterParameter = searchClickEvent.getFilterModel().getSchemeFilterParameter(schemelist);
        List schemaQFilterList = schemaFilterParameter.getQFilters();
        fastQFilterList.addAll(commonQFilterList);
        fastQFilterList.addAll(schemaQFilterList);
        QFilter orgFilter = this.getOrgFilter(commonQFilterList, billList.getFilterParameter().getQFilters());
        if (EmptyCheckUtils.isNotEmpty((Object)orgFilter)) {
            fastQFilterList.add(orgFilter);
        }
        Tab tabap = (Tab)this.getControl(TAB_AP);
        String currentTab = tabap.getCurrentTab();
        this.getPageCache().put(FILTER_TAB, currentTab);
        billList.setFilterParameter(fastFilterParameter);
        billList.clearSelection();
        billList.refresh();
    }

    private QFilter getOrgFilter(List<QFilter> commonQFilterList, List<QFilter> qFilters) {
        for (QFilter qFilter : commonQFilterList) {
            if (!qFilter.getProperty().equalsIgnoreCase("org.id")) continue;
            return null;
        }
        for (int i = qFilters.size() - 1; i >= 0; --i) {
            if (!qFilters.get(i).getProperty().equalsIgnoreCase("org")) continue;
            return qFilters.get(i);
        }
        return null;
    }

    public void setFilter(SetFilterEvent e) {
        String billListKey = ((BillList)e.getSource()).getKey();
        LkysdkCheckCertEnum tioCheckCertEnum = this.getCurrentCheckCertEnum();
        String selectFlexKey = this.getPageCache().get(SELECTED_FLEX_KEY);
        String orgid = this.getPageCache().get(VERIFY_ORG);
        String taxperiod = this.getPageCache().get(TAXPERIOD);
        String initFlag = this.getPageCache().get("init_flag");
        if (tioCheckCertEnum.getBillap().equalsIgnoreCase(billListKey)) {
            if (EmptyCheckUtils.isNotEmpty((Object)selectFlexKey)) {
                if (selectFlexKey.length() < 4) {
                    return;
                }
                LkysdkCheckCertBoardEnum boardEnum = LkysdkCheckCertBoardEnum.getEnumByKey(tioCheckCertEnum.getCode(), selectFlexKey.substring(3));
                if (EmptyCheckUtils.isEmpty((Object)((Object)boardEnum))) {
                    return;
                }
                List qFilters = e.getQFilters();
                qFilters.clear();
                if (EmptyCheckUtils.isNotEmpty((Object)boardEnum.getqFilter())) {
                    qFilters.add(boardEnum.getqFilter());
                }
                if (EmptyCheckUtils.isEmpty((Object)orgid)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7ec4\u7ec7\u7a0e\u52a1\u4fe1\u606f", (String)"LkysdkListFormPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
                }
                QFilter orgFilter1 = new QFilter("org", "=", (Object)Long.parseLong(orgid));
                qFilters.add(orgFilter1);
                if (EmptyCheckUtils.isEmpty((Object)taxperiod)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7ec4\u7ec7\u7a0e\u52a1\u4fe1\u606f", (String)"LkysdkListFormPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
                }
                this.addTaxperiodFilter(tioCheckCertEnum, boardEnum, qFilters, taxperiod);
            } else {
                List qFilters = e.getQFilters();
                if (EmptyCheckUtils.isEmpty((Object)orgid)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7ec4\u7ec7\u7a0e\u52a1\u4fe1\u606f", (String)"LkysdkListFormPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
                }
                QFilter orgFilter1 = new QFilter("org", "=", (Object)Long.parseLong(orgid));
                qFilters.add(orgFilter1);
                if ("true".equals(initFlag)) {
                    Date date = new Date();
                    Date startdate = DateUtils.getFirstDateOfMonth((Date)date);
                    Date enddate = DateUtils.getLastDateOfMonth((Date)date);
                    QFilter taxperioddateS = new QFilter(TAXPERIODDATE, ">=", (Object)startdate).and(TAXPERIODDATE, "<=", (Object)enddate);
                    qFilters.add(taxperioddateS);
                }
            }
            if (tioCheckCertEnum.getqFilter() != null) {
                e.getQFilters().add(tioCheckCertEnum.getqFilter());
            }
        }
    }

    private void displayDataByBoardSelected(LkysdkCheckCertBoardEnum boardEnum, LkysdkCheckCertEnum tioCheckCertEnum) {
        BillList billList = (BillList)this.getControl(tioCheckCertEnum.getBillap());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        String taxperiod = this.getPageCache().get(TAXPERIOD);
        String orgid = this.getPageCache().get(VERIFY_ORG);
        if (EmptyCheckUtils.isEmpty((Object)orgid)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7ec4\u7ec7\u7a0e\u52a1\u4fe1\u606f", (String)"LkysdkListFormPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
        }
        if (EmptyCheckUtils.isEmpty((Object)taxperiod)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7ec4\u7ec7\u7a0e\u52a1\u4fe1\u606f", (String)"LkysdkListFormPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
        }
        if (EmptyCheckUtils.isNotEmpty((Object)boardEnum.getqFilter())) {
            qFilters.add(boardEnum.getqFilter());
        }
        this.addTaxperiodFilter(tioCheckCertEnum, boardEnum, qFilters, taxperiod);
        QFilter orgFilter1 = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        qFilters.add(orgFilter1);
        billList.getFilterParameter().setQFilters(qFilters);
        billList.clearSelection();
        billList.refresh();
    }

    private void addTaxperiodFilter(LkysdkCheckCertEnum tioCheckCertEnum, LkysdkCheckCertBoardEnum boardEnum, List<QFilter> qFilters, String taxperiod) {
        Date currentPeriod = DateUtils.stringToDate((String)taxperiod, (String)"yyyy-MM");
        Date start = DateUtils.getFirstDateOfMonth((Date)currentPeriod);
        Date date = new Date();
        switch (boardEnum.getFlexKey()) {
            case "selflex": {
                Date lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)currentPeriod);
                qFilters.add(new QFilter(TAXPERIODDATE, ">=", (Object)start).and(TAXPERIODDATE, "<=", (Object)lastDateOfMonth));
                break;
            }
            case "selcanflex": {
                if (tioCheckCertEnum.getEntityCode().equals(TDM_INPUT_ARIPORT)) {
                    qFilters.add(new QFilter("issuedate", ">=", (Object)specialDate).and(QFilter.isNull((String)TAXPERIODDATE)));
                    break;
                }
                qFilters.add(new QFilter("invoicedate", ">=", (Object)specialDate).and(QFilter.isNull((String)TAXPERIODDATE)));
                break;
            }
            case "authselflex": {
                Date lastDateOfMonth1 = DateUtils.getLastDateOfMonth((Date)date);
                Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)date);
                QFilter qFilter = new QFilter(TAXPERIODDATE, ">=", (Object)firstDateOfYear).and(TAXPERIODDATE, "<=", (Object)lastDateOfMonth1);
                qFilters.add(qFilter);
            }
        }
    }

    private LkysdkCheckCertEnum getCurrentCheckCertEnum() {
        Tab tabap = (Tab)this.getControl(TAB_AP);
        if (tabap != null) {
            String currentTab = tabap.getCurrentTab();
            return LkysdkCheckCertEnum.getEnumByPageAp(currentTab);
        }
        throw new KDBizException("tab is not exist");
    }

    private void addNewSelectFlex(String key) {
        HashMap stylemap1 = new HashMap(8);
        String selectedlinestyle = "2px_solid_#5582F3";
        HashMap style = new HashMap();
        HashMap<String, String> border = new HashMap<String, String>();
        border.put("b", selectedlinestyle);
        style.put("b", border);
        stylemap1.put("s", style);
        this.getView().updateControlMetadata(key, stylemap1);
        this.getPageCache().put(SELECTED_FLEX_KEY, key);
    }

    private void removeOldSelectFlex(String oldselectflexkey) {
        HashMap stylemap1 = new HashMap(8);
        String selectedlinestyle = "1px_solid_#d9d9d9";
        HashMap style = new HashMap();
        HashMap<String, String> border = new HashMap<String, String>();
        border.put("b", selectedlinestyle);
        style.put("b", border);
        stylemap1.put("s", style);
        this.getView().updateControlMetadata(oldselectflexkey, stylemap1);
    }

    public void addTabSelectListener(TabSelectListener form, String ... tabName) {
        int len = tabName.length;
        for (int i = 0; i < len; ++i) {
            Tab tab = (Tab)this.getControl(tabName[i]);
            if (tab == null) continue;
            tab.addTabSelectListener(form);
        }
    }

    private void filterContainerInit(FilterContainerInitEvent event) {
        List filterColumnList = event.getCommonFilterColumns();
        CommonFilterColumn orgColumn = null;
        for (FilterColumn column : filterColumnList) {
            if (!column.getFieldName().startsWith("org.")) continue;
            orgColumn = (CommonFilterColumn)column;
        }
        String oldselectflexkey = this.getPageCache().get(SELECTED_FLEX_KEY);
        if (EmptyCheckUtils.isNotEmpty((Object)oldselectflexkey)) {
            this.getPageCache().remove(SELECTED_FLEX_KEY);
            this.removeOldSelectFlex(oldselectflexkey);
        }
        QFilter qFilter = null;
        if (orgColumn != null) {
            List<ComboItem> orgCombos = this.getOrgComboItem();
            if (!orgCombos.isEmpty()) {
                orgColumn.setDefaultValue(orgCombos.get(0).getValue());
                qFilter = new QFilter("org", "=", (Object)Long.parseLong(orgCombos.get(0).getValue()));
            } else {
                qFilter = new QFilter("org", "=", (Object)Long.parseLong("-1"));
            }
            orgColumn.setType("enum");
            orgColumn.setMustInput(true);
            orgColumn.setComboItems(orgCombos);
        }
        LkysdkCheckCertEnum tioCheckCertEnum = this.getCurrentCheckCertEnum();
        BillList billlist = (BillList)this.getControl(tioCheckCertEnum.getBillap());
        if (qFilter != null) {
            Class<CommonFilterColumn> clas = CommonFilterColumn.class;
            try {
                Field field = clas.getDeclaredField("selectedCommomFilterFieldValues");
                AccessibleObject.setAccessible(new AccessibleObject[]{field}, true);
                List list = (List)field.get(orgColumn);
                if (EmptyCheckUtils.isNotEmpty((Object)list)) {
                    qFilter = new QFilter("org", "=", (Object)Long.parseLong(String.valueOf(list.get(0))));
                }
                String newOrgValTemp = String.valueOf(qFilter.getValue());
                String oldOrgVal = this.getPageCache().get(VERIFY_ORG);
                if (EmptyCheckUtils.isEmpty((Object)oldOrgVal)) {
                    this.getPageCache().put(VERIFY_ORG, newOrgValTemp);
                } else if (EmptyCheckUtils.isNotEmpty((Object)oldOrgVal) && !oldOrgVal.equalsIgnoreCase(newOrgValTemp) && this.initBoard(this.getCurrentCheckCertEnum(), newOrgValTemp)) {
                    this.getPageCache().put(VERIFY_ORG, newOrgValTemp);
                }
                billlist.getFilterParameter().setFilter(qFilter);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                log.error("\u83b7\u53d6\u591a\u9009\u7ec4\u7ec7\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private List<ComboItem> getOrgComboItem() {
        String orgListCache = "orgListCache";
        String orgListCacheString = this.getPageCache().get(orgListCache);
        List orgList = new ArrayList();
        if (orgListCacheString == null || StringUtils.equals((CharSequence)orgListCacheString, (CharSequence)"[]")) {
            orgList = OrgUtils.queryOrgListForInitOrgComboItems((IFormView)this.getView(), (String[])new String[]{"til_jxdk_lkysdk_list"}, null, null);
            this.getPageCache().put(orgListCache, SerializationUtils.toJsonString(orgList));
        } else {
            orgList = (List)SerializationUtils.fromJsonString((String)orgListCacheString, orgList.getClass());
        }
        return OrgUtils.getComboItems(orgList);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        LkysdkCheckCertEnum currentCheckCertEnum = this.getCurrentCheckCertEnum();
        BillList billList = (BillList)this.getControl(currentCheckCertEnum.getBillap());
        ArrayList strings = Lists.newArrayList((Object[])new String[]{DOPERIOD, CANCELPERIOD, GENERATEVOUCHER, DELETEVOUCHER, PREVIEWVOUCHER, REFRESH});
        if (strings.contains(itemKey) || VoucherOperationEnum.getKeys().contains(itemKey)) {
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (!itemKey.equals(REFRESH) && selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"LkysdkListFormPlugin_1", (String)"taxc-til", (Object[])new Object[0]));
                return;
            }
            if (VoucherOperationEnum.getKeys().contains(itemKey)) {
                List<Object> pklist = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
                Set<Object> billIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
                VoucherUtils.doVoucherOperation(itemKey, currentCheckCertEnum.getEntityCode(), billIds, pklist, this.getView(), (IFormPlugin)this);
            } else if (DOPERIOD.equalsIgnoreCase(itemKey)) {
                List ids = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)currentCheckCertEnum.getEntityCode()));
                Date taxperiod = DateUtils.stringToDate((String)this.getPageCache().get(TAXPERIOD), (String)"yyyy-MM");
                for (DynamicObject dynamicObject : dynamicObjects) {
                    Date firstDateOfMonth;
                    Date taxperioddate = dynamicObject.getDate(TAXPERIODDATE);
                    if (taxperioddate != null && (firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)taxperioddate)).before(taxperiod)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4e0d\u80fd\u64cd\u4f5c\u5386\u53f2\u7a0e\u671f\u7684\u53d1\u7968\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002 ", (String)"LkysdkListFormPlugin_2", (String)"taxc-til", (Object[])new Object[0]));
                        return;
                    }
                    Date kprq = currentCheckCertEnum.getEntityCode().equals(TDM_INPUT_ARIPORT) ? dynamicObject.getDate("issuedate") : dynamicObject.getDate("invoicedate");
                    if (kprq != null && !kprq.before(specialDate)) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u62b5\u62632019\u5e744\u67081\u65e5\u4ee5\u540e\u5f00\u5177\u7684\u53d1\u7968\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"LkysdkListFormPlugin_3", (String)"taxc-til", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId(TIL_JXDK_SSQQ_SELECT);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TIL_JXDK_SSQQ_SELECT));
                HashMap<String, String> customParams = new HashMap<String, String>();
                customParams.put(TAXPERIOD, this.getPageCache().get(TAXPERIOD));
                parameter.setCustomParams(customParams);
                this.getView().showForm(parameter);
            } else if (CANCELPERIOD.equalsIgnoreCase(itemKey)) {
                List ids = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)currentCheckCertEnum.getEntityCode()));
                Date taxperiod = DateUtils.stringToDate((String)this.getPageCache().get(TAXPERIOD), (String)"yyyy-MM");
                for (DynamicObject dynamicObject : dynamicObjects) {
                    Date taxperioddate = dynamicObject.getDate(TAXPERIODDATE);
                    if (taxperioddate != null) {
                        Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)taxperioddate);
                        if (!firstDateOfMonth.before(taxperiod)) continue;
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4e0d\u80fd\u53d6\u6d88\u5386\u53f2\u7a0e\u671f\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"LkysdkListFormPlugin_4", (String)"taxc-til", (Object[])new Object[0]));
                        return;
                    }
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4e0d\u80fd\u53d6\u6d88\u6240\u5c5e\u671f\u4e3a\u7a7a\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"LkysdkListFormPlugin_5", (String)"taxc-til", (Object[])new Object[0]));
                    return;
                }
                for (DynamicObject dynamicObject : dynamicObjects) {
                    dynamicObject.set(TAXPERIOD, null);
                    dynamicObject.set(TAXPERIODDATE, null);
                }
                SaveServiceHelper.update((DynamicObject[])dynamicObjects);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"LkysdkListFormPlugin_6", (String)"taxc-til", (Object[])new Object[0]));
                billList.clearSelection();
            } else if (REFRESH.equalsIgnoreCase(itemKey)) {
                billList.clearSelection();
            }
            billList.refresh();
            this.initBoard(currentCheckCertEnum, this.getPageCache().get(VERIFY_ORG));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        LkysdkCheckCertEnum currentCheckCertEnum;
        BillList billList;
        ListSelectedRowCollection selectedRows;
        List ids;
        String actionid = closedCallBackEvent.getActionId();
        if (TIL_JXDK_SSQQ_SELECT.equalsIgnoreCase(actionid) && null != closedCallBackEvent.getReturnData() && (ids = (selectedRows = (billList = (BillList)this.getControl((currentCheckCertEnum = this.getCurrentCheckCertEnum()).getBillap())).getSelectedRows()).stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList())).size() > 0) {
            DynamicObject[] dynamicObjects;
            Map map = (Map)closedCallBackEvent.getReturnData();
            Date period = (Date)map.get("period");
            String format = DateUtils.format((Date)period, (String)"yyyy-MM");
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)currentCheckCertEnum.getEntityCode()))) {
                dynamicObject.set(TAXPERIOD, (Object)format);
                dynamicObject.set(TAXPERIODDATE, (Object)period);
            }
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
            this.initBoard(currentCheckCertEnum, this.getPageCache().get(VERIFY_ORG));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"LkysdkListFormPlugin_6", (String)"taxc-til", (Object[])new Object[0]));
            billList.clearSelection();
            billList.refresh();
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String filterTab;
        String tabkey = tabSelectEvent.getTabKey();
        LkysdkCheckCertEnum tioCheckCertEnum = LkysdkCheckCertEnum.getEnumByPageAp(tabkey);
        String orgid = this.getPageCache().get(VERIFY_ORG);
        this.initBoard(tioCheckCertEnum, orgid);
        String oldselectflexkey = this.getPageCache().get(SELECTED_FLEX_KEY);
        if (EmptyCheckUtils.isNotEmpty((Object)oldselectflexkey)) {
            this.getPageCache().remove(SELECTED_FLEX_KEY);
            this.removeOldSelectFlex(oldselectflexkey);
        }
        if (null != (filterTab = this.getPageCache().get(FILTER_TAB))) {
            this.refreshCurrentBill(tioCheckCertEnum);
        } else {
            this.refreshCurrentBillWithDefaultCondition(tioCheckCertEnum);
        }
    }

    private void refreshCurrentBillWithDefaultCondition(LkysdkCheckCertEnum tioCheckCertEnum) {
        BillList billList = (BillList)this.getControl(tioCheckCertEnum.getBillap());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        String orgid = this.getPageCache().get(VERIFY_ORG);
        if (EmptyCheckUtils.isEmpty((Object)orgid)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7ec4\u7ec7\u7a0e\u52a1\u4fe1\u606f", (String)"LkysdkListFormPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
        }
        Date date = new Date();
        Date startdate = DateUtils.getFirstDateOfMonth((Date)date);
        Date enddate = DateUtils.getLastDateOfMonth((Date)date);
        QFilter taxperioddateS = new QFilter(TAXPERIODDATE, ">=", (Object)startdate).and(TAXPERIODDATE, "<=", (Object)enddate);
        qFilters.add(taxperioddateS);
        QFilter orgFilter1 = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        qFilters.add(orgFilter1);
        billList.getFilterParameter().setQFilters(qFilters);
        billList.clearSelection();
        billList.refresh();
    }

    private void refreshCurrentBill(LkysdkCheckCertEnum tioCheckCertEnum) {
        String filterTab = this.getPageCache().get(FILTER_TAB);
        BillList filterBillList = (BillList)this.getControl(LkysdkCheckCertEnum.getEnumByPageAp(filterTab).getBillap());
        FilterParameter filterParameter = filterBillList.getFilterParameter();
        BillList billList = (BillList)this.getControl(tioCheckCertEnum.getBillap());
        billList.clearSelection();
        billList.setFilterParameter(filterParameter);
        billList.refresh();
    }

    private boolean initBoard(LkysdkCheckCertEnum tioCheckCertEnum, String orgid) {
        List<QFilter> qFilterList = this.getQFilterList(tioCheckCertEnum, orgid);
        if (EmptyCheckUtils.isEmpty(qFilterList)) {
            return false;
        }
        String fileds = "id,taxperiod,taxamount,taxperioddate";
        fileds = tioCheckCertEnum.getEntityCode().equals(TDM_INPUT_ARIPORT) ? fileds + ",issuedate" : fileds + ",invoicedate";
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)tioCheckCertEnum.getEntityCode(), (String)fileds, (QFilter[])qFilterList.toArray(new QFilter[0]));
        this.doInitBoard(tioCheckCertEnum, dynamicObjects);
        return true;
    }

    private List<QFilter> getQFilterList(LkysdkCheckCertEnum tioCheckCertEnum, String orgid) {
        if (EmptyCheckUtils.isEmpty((Object)orgid) && EmptyCheckUtils.isEmpty((Object)(orgid = this.getPageCache().get(VERIFY_ORG)))) {
            return new ArrayList<QFilter>();
        }
        Date date = new Date();
        int month = DateUtils.getMonthOfDate((Date)date);
        int year = DateUtils.getYearOfDate((Date)date);
        Date endDate = null;
        try {
            endDate = RegisterAddressUtil.findZZSMonthApplyEndDate((Object)orgid);
        }
        catch (KDBizException e) {
            this.getView().showErrorNotification(e.getMessage());
            return new ArrayList<QFilter>();
        }
        if (null == endDate) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7ec4\u7ec7\u7a0e\u52a1\u4fe1\u606f", (String)"LkysdkListFormPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
        }
        endDate = DateUtils.stringToDate((String)DateUtils.format((Date)endDate));
        date = DateUtils.stringToDate((String)DateUtils.format((Date)date));
        if (endDate.getTime() >= date.getTime() && --month == 0) {
            month = 12;
            --year;
        }
        String cardTitleFormat = ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708\u7a0e\u671f\u770b\u677f", (String)"LkysdkListFormPlugin_7", (String)"taxc-til", (Object[])new Object[0]);
        String preFlag = tioCheckCertEnum.getCode();
        this.getModel().setValue(preFlag + CARD_TITLE, (Object)String.format(cardTitleFormat, year, month));
        String months = StringUtil.fillCharAtLeft((Object)month, (int)2, (char)'0');
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        String taxperiod = Stream.of(Integer.valueOf(year), months).map(v -> String.valueOf(v)).collect(Collectors.joining("-"));
        this.getPageCache().put(TAXPERIOD, taxperiod);
        Date date1 = DateUtils.stringToDate((String)taxperiod, (String)"yyyy-MM");
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)date1);
        QFilter taxperiodQFilter = new QFilter(TAXPERIODDATE, ">=", (Object)firstDateOfYear).or(QFilter.isNull((String)TAXPERIODDATE));
        qFilters.add(taxperiodQFilter);
        QFilter orgFilter1 = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        qFilters.add(orgFilter1);
        if (tioCheckCertEnum.getqFilter() != null) {
            qFilters.add(tioCheckCertEnum.getqFilter());
        }
        return qFilters;
    }

    private void doInitBoard(LkysdkCheckCertEnum tioCheckCertEnum, DynamicObjectCollection dynamicObjects) {
        Long selcount = 0L;
        BigDecimal seltotal = BigDecimal.ZERO;
        Long selcancount = 0L;
        BigDecimal selcantotal = BigDecimal.ZERO;
        BigDecimal authseltotal = BigDecimal.ZERO;
        String taxperiodCache = this.getPageCache().get(TAXPERIOD);
        try {
            for (DynamicObject dynamicObject : dynamicObjects) {
                Long l;
                Long l2;
                Date ccrq = tioCheckCertEnum.getEntityCode().equals(TDM_INPUT_ARIPORT) ? dynamicObject.getDate("issuedate") : dynamicObject.getDate("invoicedate");
                Date taxperiod = dynamicObject.getDate(TAXPERIODDATE);
                if (this.isSYDk(taxperiod, ccrq)) {
                    l2 = selcancount;
                    l = selcancount = Long.valueOf(selcancount + 1L);
                    selcantotal = BigDecimalUtil.addObject((Object)selcantotal, (Object)dynamicObject.get(TAX_AMOUNT));
                }
                if (this.isDQDK(taxperiod, taxperiodCache)) {
                    seltotal = BigDecimalUtil.addObject((Object)seltotal, (Object)dynamicObject.get(TAX_AMOUNT));
                    l2 = selcount;
                    l = selcount = Long.valueOf(selcount + 1L);
                }
                if (!this.isBYDK(taxperiod)) continue;
                authseltotal = BigDecimalUtil.addObject((Object)authseltotal, (Object)dynamicObject.get(TAX_AMOUNT));
            }
        }
        catch (Exception e) {
            log.error("Exception:", (Throwable)e);
        }
        String preFlag = tioCheckCertEnum.getCode();
        this.getModel().setValue(preFlag + SEL_COUNT, (Object)selcount);
        this.getModel().setValue(preFlag + SEL_TOTAL, (Object)seltotal);
        this.getModel().setValue(preFlag + SEL_CAN_COUNT, (Object)selcancount);
        this.getModel().setValue(preFlag + SEL_CAN_TOTAL, (Object)selcantotal);
        this.getModel().setValue(preFlag + AUTH_SEL_TOTAL, (Object)authseltotal);
    }

    private boolean isSYDk(Date taxperiod, Date ccrq) {
        return taxperiod == null && ccrq != null && !ccrq.before(specialDate);
    }

    private boolean isDQDK(Date taxperiod, String taxperiodCache) {
        if (taxperiod == null) {
            return false;
        }
        Date date1 = DateUtils.stringToDate((String)taxperiodCache, (String)"yyyy-MM");
        Date firstDateOfMonth1 = DateUtils.getFirstDateOfMonth((Date)date1);
        Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)taxperiod);
        return firstDateOfMonth1.equals(firstDateOfMonth);
    }

    private boolean isBYDK(Date taxperiod) {
        if (taxperiod == null) {
            return false;
        }
        Date date = new Date();
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)date);
        Date lastDateOfMonth = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)date, (int)1));
        return taxperiod.compareTo(firstDateOfYear) >= 0 && taxperiod.before(lastDateOfMonth);
    }
}

