/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.inputdeduction;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.events.ListRowSelectAllEvent;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.til.formplugin.inputdeduction.enums.NcpJsdkFormEnum;
import kd.taxc.til.formplugin.queryscheme.SchemeSaveHolder;

public class NcpJsdkFormPlugin
extends AbstractFormPlugin
implements ListRowClickListener {
    private Log Logger = LogFactory.getLog(NcpJsdkFormPlugin.class);
    public static final String BILL_ENTITY = "til_jxdk_ncpjsdk_bill";
    public static final String CACHE_CHANGE_FLAGE = "cache_change_flag";
    public static final String CACHE_ID_FLAGE = "cache_id_flag";
    public static final String FALSE = "false";
    public static final String TRUE = "true";
    public static final String ZYFPPANLE = "zyfppanle";
    public static final String FLEXPANELAP = "advconap";
    public static final String FLEXPANELAP_1 = "advconap1";
    public static final String FLEXPANELAP_2 = "advconap2";
    public static final String FLEXPANELAP_3 = "advconap3";
    public static final String DKTAX = "dktax";
    public static final String NCPMJ = "ncpmj";
    public static final String ISSDXZ = "issdxz";
    public static final String TAXRATE = "taxrate";
    public static final String ORG = "org";
    public static final String TAXPERIOD = "taxperiod";
    public static final double PERCENT10 = 0.1;
    private static final String SAVE = "save";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (NcpJsdkFormEnum value : NcpJsdkFormEnum.values()) {
            BillList billList = (BillList)this.getControl(value.getFlexKey());
            if (null == billList) continue;
            billList.addListRowClickListener((ListRowClickListener)this);
            billList.addSetFilterListener(this::setFilter);
            billList.addListRowSelectAllListeners(this::acceptSelectAll);
            billList.addClearSelectionListener(this::acceptClearSelect);
        }
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap", "advcontoolbarap1", "advcontoolbarap2", "advcontoolbarap3"});
    }

    public void acceptSelectAll(ListRowSelectAllEvent event) {
        this.calPanelData(this.getDataSourceNumber());
    }

    public void acceptClearSelect(EventObject event) {
        this.calPanelData(this.getDataSourceNumber());
    }

    public void setFilter(SetFilterEvent e) {
        String orgid;
        List qFilters = e.getQFilters();
        DynamicObject value = (DynamicObject)this.getModel().getValue(ORG);
        if (value != null && StringUtil.isNotEmpty((CharSequence)(orgid = value.getString("id")))) {
            QFilter orgFilter1 = new QFilter("tax_org", "=", (Object)Long.valueOf(orgid));
            qFilters.add(orgFilter1);
            qFilters.add(NcpJsdkFormEnum.getEnumByDataSource(this.getDataSourceNumber()).getFilter());
            QFilter queryConditionPlanFilter = this.getQueryPlanFilter();
            if (null != queryConditionPlanFilter) {
                qFilters.add(queryConditionPlanFilter);
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        Object source = evt.getSource();
        if (source instanceof BillList) {
            this.calPanelData(this.getDataSourceNumber());
        }
    }

    private void calPanelData(String dataSource) {
        NcpJsdkFormEnum enumByDataSource = NcpJsdkFormEnum.getEnumByDataSource(dataSource);
        if ("" == enumByDataSource.getFlexKey()) {
            return;
        }
        BigDecimal sumAmount = BigDecimal.ZERO;
        BigDecimal deductAmount = BigDecimal.ZERO;
        ListSelectedRowCollection selectedRows = this.getSelectedRows(enumByDataSource.getFlexKey());
        if (selectedRows.size() > 0) {
            Object taxrate = this.getModel().getValue(TAXRATE);
            BigDecimal taxrateDecimal = new BigDecimal(taxrate.toString());
            List<Object> collect = selectedRows.stream().map(a -> a.getPrimaryKeyValue()).distinct().collect(Collectors.toList());
            BigDecimal amount = this.caculateSumAmount(enumByDataSource, collect);
            sumAmount = sumAmount.add(amount);
            deductAmount = deductAmount.add(amount.multiply(taxrateDecimal).setScale(2, 4));
            this.getModel().setValue("ygxfp", (Object)collect.size());
            this.getModel().setValue("sumamount", (Object)sumAmount.setScale(2, 4));
            this.getModel().setValue(NCPMJ, (Object)sumAmount.setScale(2, 4));
            if (taxrate != null && StringUtils.isNotEmpty((CharSequence)taxrate.toString())) {
                this.getModel().setValue("jsdke", (Object)deductAmount);
                this.getModel().setValue(DKTAX, (Object)deductAmount);
            } else {
                this.getModel().setValue("jsdke", (Object)BigDecimal.ZERO);
                this.getModel().setValue(DKTAX, (Object)BigDecimal.ZERO);
            }
        } else {
            this.getModel().setValue("jsdke", (Object)BigDecimal.ZERO);
            this.getModel().setValue("sumamount", (Object)BigDecimal.ZERO);
            this.getModel().setValue(DKTAX, (Object)BigDecimal.ZERO);
            this.getModel().setValue(NCPMJ, (Object)BigDecimal.ZERO);
            this.getModel().setValue("ygxfp", (Object)0);
        }
    }

    private ListSelectedRowCollection getSelectedRows(String billlistap) {
        BillList billList = (BillList)this.getControl(billlistap);
        return billList.getSelectedRows();
    }

    private BigDecimal caculateSumAmount(NcpJsdkFormEnum enu, List<Object> id) {
        DynamicObjectCollection collection = QueryServiceHelper.query((String)enu.getEntityName(), (String)enu.getSelectFields(), (QFilter[])new QFilter("id", "in", id).toArray());
        BigDecimal amount = collection.stream().map(a -> a.getBigDecimal("detailamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return amount;
    }

    public DynamicObjectCollection queryDatasourceByIds(List<Object> ids, NcpJsdkFormEnum enu) {
        return QueryServiceHelper.query((String)enu.getEntityName(), (String)enu.getSelectFields(), (QFilter[])new QFilter("id", "in", ids).toArray());
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (Objects.isNull(customParams.get("primaryKey"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{ZYFPPANLE, FLEXPANELAP_1});
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAP, FLEXPANELAP_2, FLEXPANELAP_3});
            this.getView().setVisible(Boolean.TRUE, new String[]{"datasources"});
            this.getView().setVisible(Boolean.FALSE, new String[]{NCPMJ, DKTAX});
            this.getModel().setValue(TAXPERIOD, (Object)DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-1)));
            String org = (String)this.getView().getFormShowParameter().getCustomParam(ORG);
            if (StringUtil.isNotEmpty((CharSequence)org)) {
                boolean checkResult = LicenseCheckServiceHelper.check((Object)org, (IFormView)this.getView(), (String)"tcvat");
                if (checkResult) {
                    this.getModel().setValue(ORG, null);
                    this.setFiltersAndRefresh(0L);
                    return;
                }
                this.getModel().setValue(ORG, (Object)Long.valueOf(org));
                this.setFiltersAndRefresh(Long.valueOf(org));
            }
        } else {
            boolean checkResult;
            Long primaryKey = (Long)customParams.get("primaryKey");
            DynamicObject one = BusinessDataServiceHelper.loadSingle((Object)primaryKey, (String)BILL_ENTITY);
            DynamicObject orgObj = one.getDynamicObject(ORG);
            if (orgObj != null && (checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgObj.get("id").toString(), (String)"tcvat", (String)"zzs"))) {
                this.getModel().setValue(ORG, null);
                return;
            }
            this.getModel().setValue(ORG, (Object)orgObj);
            this.getModel().setValue(TAXPERIOD, one.get(TAXPERIOD));
            this.getModel().setValue(TAXRATE, one.get(TAXRATE));
            this.getModel().setValue(ISSDXZ, one.get(ISSDXZ));
            if (one.getBoolean(ISSDXZ)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{SAVE, "datasources", ZYFPPANLE});
                this.getModel().setValue(NCPMJ, one.get(NCPMJ));
                this.getModel().setValue(DKTAX, one.get(DKTAX));
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{SAVE, NCPMJ, DKTAX});
                this.getModel().setValue("datasources", one.get("datasources"));
                this.getView().setEnable(Boolean.FALSE, new String[]{ZYFPPANLE});
            }
            DynamicObjectCollection entryentity = one.getDynamicObjectCollection("entryentity");
            List<Long> ids = entryentity.stream().map(o -> o.getLong("dataid")).collect(Collectors.toList());
            String opend = this.setFiltersAndRefresh(ids);
            ArrayList list = Lists.newArrayList((Object[])new String[]{FLEXPANELAP, FLEXPANELAP_1, FLEXPANELAP_2, FLEXPANELAP_3});
            list.remove(opend);
            this.getView().setVisible(Boolean.valueOf(false), list.toArray(new String[0]));
        }
    }

    private Map<String, String> getCacheValue(String cacheKey) {
        String cacheValueStr = this.getPageCache().get(cacheKey);
        if (StringUtils.isEmpty((CharSequence)cacheValueStr)) {
            return new HashMap<String, String>(1);
        }
        Map cacheValueMap = (Map)SerializationUtils.fromJsonString((String)cacheValueStr, Map.class);
        return cacheValueMap;
    }

    private Map<String, String> getAllQueryPlanCache(String cacheKey) {
        String cacheValueStr = this.getPageCache().get(cacheKey);
        if (StringUtils.isBlank((CharSequence)cacheValueStr)) {
            return null;
        }
        return (Map)SerializationUtils.fromJsonString((String)cacheValueStr, Map.class);
    }

    private String getPageFilterCacheValue(String cacheKey, String pageKey) {
        if (!"writeOffPageFilter".equals(cacheKey)) {
            return null;
        }
        Map<String, String> cacheValueMap = this.getAllQueryPlanCache(cacheKey);
        if (cacheValueMap == null || cacheValueMap.isEmpty()) {
            return null;
        }
        String filterText = cacheValueMap.get(pageKey);
        if (null == filterText) {
            return null;
        }
        Map filterRowMap = (Map)SerializationUtils.fromJsonString((String)filterText, Map.class);
        List filterRow = (List)filterRowMap.get("filterRow");
        if (filterRow.size() == 0) {
            return null;
        }
        return filterText;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String customVaule = event.getCustomVaule();
        String callBackId = event.getCallBackId();
        if (ORG.equals(callBackId)) {
            if (event.getResult() == MessageBoxResult.Yes) {
                Object value = this.getModel().getValue(ORG);
                if (value != null) {
                    this.setFiltersAndRefresh(((DynamicObject)value).get("id"));
                    if (Boolean.FALSE.equals(this.getModel().getValue(ISSDXZ))) {
                        this.calPanelData(this.getDataSourceNumber());
                    } else {
                        this.calDktax(this.getModel().getValue(TAXRATE), this.getModel().getValue(NCPMJ));
                    }
                }
            } else {
                this.getPageCache().put(CACHE_CHANGE_FLAGE, FALSE);
                this.getModel().setValue(ORG, (Object)Long.valueOf(customVaule));
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        DynamicObject org;
        String itemKey = evt.getItemKey();
        if (SAVE.equals(itemKey) && (org = (DynamicObject)this.getModel().getValue(ORG)) != null && !((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).getData()).booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"NcpJsdkFormPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        if (ORG.equals(e.getProperty().getName())) {
            boolean checkResult;
            if (FALSE.equals(this.getPageCache().get(CACHE_CHANGE_FLAGE))) {
                this.getPageCache().put(CACHE_CHANGE_FLAGE, TRUE);
                return;
            }
            DynamicObject newValue1 = (DynamicObject)newValue;
            if (newValue1 != null && newValue1.get("id") != null && (checkResult = LicenseCheckServiceHelper.check((Object)newValue1.get("id"), (IFormView)this.getView(), (String)"tcvat"))) {
                this.getModel().setValue(ORG, oldValue);
                return;
            }
            if (oldValue != null) {
                this.showConfirmTips(ORG, ResManager.loadKDString((String)"\u7ec4\u7ec7\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"NcpJsdkFormPlugin_1", (String)"taxc-til", (Object[])new Object[0]), ((DynamicObject)oldValue).getString("id"));
            } else if (newValue != null) {
                this.setFiltersAndRefresh(newValue1.get("id"));
                if (Boolean.FALSE.equals(this.getModel().getValue(ISSDXZ))) {
                    this.calPanelData(this.getDataSourceNumber());
                } else {
                    this.calDktax(this.getModel().getValue(TAXRATE), this.getModel().getValue(NCPMJ));
                }
            }
        } else if (NCPMJ.equals(e.getProperty().getName())) {
            Object taxrate = this.getModel().getValue(TAXRATE);
            if (newValue != null && taxrate != null) {
                BigDecimal taxrateDecimal = new BigDecimal(taxrate.toString());
                BigDecimal dktax = taxrateDecimal.multiply((BigDecimal)newValue).setScale(2, 4);
                this.getModel().setValue(DKTAX, (Object)dktax);
            }
        } else if (TAXRATE.equals(e.getProperty().getName())) {
            if (Boolean.FALSE.equals(this.getModel().getValue(ISSDXZ))) {
                this.calPanelData(this.getDataSourceNumber());
            } else {
                Object ncpmj = this.getModel().getValue(NCPMJ);
                if (newValue != null && ncpmj != null) {
                    this.calDktax(newValue, ncpmj);
                }
            }
        } else if (ISSDXZ.equals(e.getProperty().getName())) {
            FieldEdit control;
            if (Boolean.FALSE.equals(newValue)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{ZYFPPANLE, FLEXPANELAP_1});
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAP, FLEXPANELAP_2});
                this.getView().setVisible(Boolean.TRUE, new String[]{"datasources"});
                this.getView().setVisible(Boolean.FALSE, new String[]{NCPMJ, DKTAX});
                this.getModel().setValue("datasources", (Object)"3");
                control = (FieldEdit)this.getControl(NCPMJ);
                control.setMustInput(false);
                BillList billList = (BillList)this.getControl(NcpJsdkFormEnum.getEnumByDataSource("3").getFlexKey());
                billList.clearSelection();
                this.calPanelData("3");
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{ZYFPPANLE, "datasources"});
                this.getView().setVisible(Boolean.TRUE, new String[]{NCPMJ, DKTAX});
                control = (FieldEdit)this.getControl(NCPMJ);
                control.setMustInput(true);
                this.getModel().setValue(NCPMJ, (Object)BigDecimal.ZERO);
                this.getModel().setValue(DKTAX, (Object)BigDecimal.ZERO);
            }
        } else if ("datasources".equals(e.getProperty().getName())) {
            String number = newValue == null ? "" : newValue.toString();
            Object value = this.getModel().getValue(ORG);
            if (Objects.isNull(value)) {
                return;
            }
            switch (number) {
                case "3": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{ZYFPPANLE, FLEXPANELAP_1});
                    this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAP, FLEXPANELAP_2, FLEXPANELAP_3});
                    break;
                }
                case "4": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{ZYFPPANLE, FLEXPANELAP});
                    this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAP_1, FLEXPANELAP_2, FLEXPANELAP_3});
                    break;
                }
                case "26": 
                case "27": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{ZYFPPANLE, FLEXPANELAP_3});
                    this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAP, FLEXPANELAP_1, FLEXPANELAP_2});
                    break;
                }
                default: {
                    return;
                }
            }
            this.setFiltersAndRefresh(((DynamicObject)value).getLong("id"));
            this.calPanelData(number);
        }
        if (TAXPERIOD.equals(e.getProperty().getName())) {
            Object value = this.getModel().getValue(ORG);
            if (Objects.isNull(value)) {
                return;
            }
            this.setFiltersAndRefresh(((DynamicObject)value).getLong("id"));
            this.calPanelData(this.getDataSourceNumber());
        }
        this.getPageCache().put(CACHE_ID_FLAGE, null);
    }

    private void calDktax(Object taxrateObj, Object ncpmj) {
        if (taxrateObj != null && StringUtil.isNotEmpty((CharSequence)taxrateObj.toString()) && ncpmj != null) {
            BigDecimal taxrate = new BigDecimal(taxrateObj.toString());
            BigDecimal dktax = taxrate.multiply((BigDecimal)ncpmj).setScale(2, 4);
            this.getModel().setValue(DKTAX, (Object)dktax);
        }
    }

    private void showConfirmTips(String backKey, String msg, String customValue) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(backKey, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"NcpJsdkFormPlugin_2", (String)"taxc-til", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"NcpJsdkFormPlugin_3", (String)"taxc-til", (Object[])new Object[0]));
        this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps, customValue);
    }

    private void setFiltersAndRefresh(Object id) {
        String source = this.getModel().getValue("datasources").toString();
        NcpJsdkFormEnum enumByDataSource = NcpJsdkFormEnum.getEnumByDataSource(source);
        BillList billList = (BillList)this.getControl(enumByDataSource.getFlexKey());
        billList.clearSelection();
        billList.getFilterParameter().setFilter(new QFilter("tax_org", "=", id));
        billList.getFilterParameter().setFilter(enumByDataSource.getFilter());
        this.setCacheQueryPlanFilter(billList);
    }

    private void setCacheQueryPlanFilter(BillList billList) {
        QFilter queryConditionPlanFilter = this.getQueryPlanFilter();
        this.Logger.info("billListQueryPlan ====={}", (Object)queryConditionPlanFilter);
        if (null != queryConditionPlanFilter) {
            billList.getFilterParameter().setFilter(queryConditionPlanFilter);
        }
        billList.refresh();
    }

    private QFilter getQueryPlanFilter() {
        String datasources = (String)this.getModel().getValue("datasources");
        QFilter cacheQueryPlanFilter = this.queryCacheQueryPlanFilter(datasources);
        if (null != cacheQueryPlanFilter) {
            return cacheQueryPlanFilter;
        }
        return this.queryDefaultSchemeFilter(datasources);
    }

    private QFilter queryCacheQueryPlanFilter(String datasources) {
        NcpJsdkFormEnum enumByDataSource = NcpJsdkFormEnum.getEnumByDataSource(datasources);
        String entryVaule = enumByDataSource.getFlexKey();
        String billEntity = enumByDataSource.getEntityName();
        String pageFilterCacheValue = this.getPageFilterCacheValue("writeOffPageFilter", datasources + entryVaule);
        if (StringUtil.isNotBlank((CharSequence)pageFilterCacheValue)) {
            return FilterBuilderUtils.filterTextToQfilter((String)billEntity, (String)pageFilterCacheValue);
        }
        return null;
    }

    private QFilter queryDefaultSchemeFilter(String datasources) {
        NcpJsdkFormEnum enumByDataSource = NcpJsdkFormEnum.getEnumByDataSource(datasources);
        String billEntity = enumByDataSource.getEntityName();
        SchemeSaveHolder schemeSaveHolder = new SchemeSaveHolder(this.getView());
        schemeSaveHolder.setFormId("til_query_condition");
        DynamicObjectCollection saveSchemeListDataExt = schemeSaveHolder.getDefaultScheme("til_query_condition", datasources + enumByDataSource.getFlexKey());
        if (!CollectionUtils.isEmpty((Collection)saveSchemeListDataExt)) {
            String filterValue = ((DynamicObject)saveSchemeListDataExt.get(0)).getString("schemestr_tag");
            DynamicObject dbFormDataDyc = schemeSaveHolder.toDynamicObject(filterValue);
            return FilterBuilderUtils.filterTextToQfilter((String)billEntity, (String)dbFormDataDyc.getString("filtervalue"));
        }
        return null;
    }

    private String setFiltersAndRefresh(List<Long> ids) {
        String source = this.getModel().getValue("datasources").toString();
        NcpJsdkFormEnum enumByDataSource = NcpJsdkFormEnum.getEnumByDataSource(source);
        BillList billList = (BillList)this.getControl(enumByDataSource.getFlexKey());
        billList.clearSelection();
        billList.getFilterParameter().setFilter(new QFilter("id", "in", ids));
        billList.refresh();
        return enumByDataSource.getFlexpanelap();
    }

    private String getDataSourceNumber() {
        Object value = this.getModel().getValue("datasources");
        if (!ObjectUtils.isEmpty((Object)value)) {
            return value.toString();
        }
        return "";
    }

    public void itemClick(ItemClickEvent evt) {
        block37: {
            Object[] save;
            List<Object> collect;
            DynamicObjectCollection collection;
            NcpJsdkFormEnum enumByDataSource;
            ListSelectedRowCollection selectedRows;
            block40: {
                block38: {
                    block39: {
                        super.itemClick(evt);
                        if (!SAVE.equals(evt.getItemKey())) break block37;
                        selectedRows = null;
                        String number = this.getDataSourceNumber();
                        enumByDataSource = NcpJsdkFormEnum.getEnumByDataSource(number);
                        if (!Boolean.FALSE.equals(this.getModel().getValue(ISSDXZ))) break block38;
                        selectedRows = this.getSelectedRows(enumByDataSource.getFlexKey());
                        if (selectedRows.size() <= 0) break block39;
                        String taxrate = (String)this.getModel().getValue(TAXRATE);
                        BigDecimal taxrateBig = new BigDecimal(taxrate);
                        List<Object> idset = selectedRows.stream().map(a -> a.getPrimaryKeyValue()).distinct().collect(Collectors.toList());
                        switch (number) {
                            case "3": {
                                if (!this.checkPTFP(idset, taxrateBig)) {
                                    return;
                                }
                                break block40;
                            }
                            case "4": {
                                DynamicObjectCollection dynamicObjectCollection = this.queryDatasourceByIds(idset, enumByDataSource);
                                Map<String, List<DynamicObject>> deductionpurpose = dynamicObjectCollection.stream().collect(Collectors.groupingBy(a -> a.getString("deductionpurpose")));
                                ArrayList<Object> hgIds = new ArrayList<Object>(16);
                                ArrayList<Object> ptfpIds = new ArrayList<Object>(16);
                                for (Map.Entry<String, List<DynamicObject>> entry : deductionpurpose.entrySet()) {
                                    List<DynamicObject> value = entry.getValue();
                                    List ids = value.stream().map(a -> a.get("id")).distinct().collect(Collectors.toList());
                                    if ("1".equals(entry.getKey())) {
                                        hgIds.addAll(ids);
                                        continue;
                                    }
                                    ptfpIds.addAll(ids);
                                }
                                if (!CollectionUtils.isEmpty(hgIds) && !this.checkHG(hgIds)) {
                                    return;
                                }
                                if (!CollectionUtils.isEmpty(ptfpIds) && !this.checkPTFP(ptfpIds, taxrateBig)) {
                                    return;
                                }
                                break block40;
                            }
                            case "26": {
                                if (!this.checkPTFP(idset, taxrateBig)) {
                                    return;
                                }
                                break block40;
                            }
                            case "27": {
                                if (!this.checkPTFP(idset, taxrateBig)) {
                                    return;
                                }
                                break block40;
                            }
                            case "21": {
                                if (!this.checkHG(idset)) {
                                    return;
                                }
                                break block40;
                            }
                            default: {
                                return;
                            }
                        }
                    }
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u8ba1\u7b97\u62b5\u6263\u7a0e\u989d\u4e0d\u80fd\u4e3a0", (String)"NcpJsdkFormPlugin_4", (String)"taxc-til", (Object[])new Object[0]));
                    return;
                }
                Object ncpmj = this.getModel().getValue(NCPMJ);
                if (ncpmj == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u519c\u4ea7\u54c1\u4e70\u4ef7\u3002\u201d", (String)"NcpJsdkFormPlugin_5", (String)"taxc-til", (Object[])new Object[0]));
                    return;
                }
                if (BigDecimal.ZERO.compareTo((BigDecimal)this.getModel().getValue(NCPMJ)) == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u4e70\u4ef7\u4e0d\u80fd\u4e3a0", (String)"NcpJsdkFormPlugin_6", (String)"taxc-til", (Object[])new Object[0]));
                    return;
                }
            }
            if (BigDecimal.ZERO.compareTo((BigDecimal)this.getModel().getValue(NCPMJ)) > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u603b\u91d1\u989d\u4e0d\u80fd\u4e3a0", (String)"NcpJsdkFormPlugin_7", (String)"taxc-til", (Object[])new Object[0]));
                return;
            }
            String id = this.getPageCache().get(CACHE_ID_FLAGE);
            DynamicObject dynamicObject = StringUtil.isEmpty((CharSequence)id) ? BusinessDataServiceHelper.newDynamicObject((String)BILL_ENTITY) : BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(id), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)BILL_ENTITY));
            dynamicObject.set(ORG, this.getModel().getValue(ORG));
            dynamicObject.set(TAXPERIOD, this.getModel().getValue(TAXPERIOD));
            dynamicObject.set(TAXRATE, this.getModel().getValue(TAXRATE));
            dynamicObject.set(ISSDXZ, this.getModel().getValue(ISSDXZ));
            if (Boolean.FALSE.equals(this.getModel().getValue(ISSDXZ))) {
                dynamicObject.set("datasources", this.getModel().getValue("datasources"));
            } else {
                dynamicObject.set("datasources", (Object)"xz");
            }
            dynamicObject.set(NCPMJ, this.getModel().getValue(NCPMJ));
            dynamicObject.set(DKTAX, this.getModel().getValue(DKTAX));
            dynamicObject.set("billstatus", (Object)"A");
            String userId = RequestContext.get().getUserId();
            Long userID = StringUtil.isEmpty((CharSequence)userId) ? Long.valueOf(0L) : Long.valueOf(userId);
            Date today = new Date();
            dynamicObject.set("creator", (Object)userID);
            dynamicObject.set("modifier", (Object)userID);
            dynamicObject.set("createtime", (Object)today);
            dynamicObject.set("modifytime", (Object)today);
            dynamicObject.set(DKTAX, this.getModel().getValue(DKTAX));
            dynamicObject.set("number", (Object)DeclareServiceHelper.generateSBBNo((String)BILL_ENTITY, (String)((DynamicObject)this.getModel().getValue(ORG)).getString("id")));
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            entryentity.clear();
            if (selectedRows != null && !CollectionUtils.isEmpty((Collection)(collection = this.queryDatasourceByIds(collect = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList()), enumByDataSource)))) {
                Map<Long, List<DynamicObject>> map = collection.stream().collect(Collectors.groupingBy(c -> c.getLong("id")));
                for (Map.Entry<Object, List<DynamicObject>> entry : map.entrySet()) {
                    DynamicObject entity = entryentity.addNew();
                    entity.set("dataid", entry.getKey());
                    BigDecimal fpje = entry.getValue().stream().map(a -> a.getBigDecimal("detailamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal effectiveTaxAmount = entry.getValue().stream().map(a -> a.getBigDecimal("effective_tax_amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    entity.set("effectivetaxamount", (Object)effectiveTaxAmount.setScale(2, 4));
                    entity.set("fpje", (Object)fpje.setScale(2, 4));
                    Object taxrate = this.getModel().getValue(TAXRATE);
                    if (taxrate != null && StringUtils.isNotEmpty((CharSequence)taxrate.toString())) {
                        BigDecimal taxrateDecimal = new BigDecimal(taxrate.toString());
                        BigDecimal calDkse = fpje.multiply(taxrateDecimal).setScale(2, 4);
                        entity.set("fpdkse", (Object)calDkse);
                        continue;
                    }
                    entity.set("fpdkse", (Object)BigDecimal.ZERO);
                }
            }
            if ((save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject})).length == 1) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"NcpJsdkFormPlugin_8", (String)"taxc-til", (Object[])new Object[0]));
                DynamicObject bill = (DynamicObject)save[0];
                this.getPageCache().put(CACHE_ID_FLAGE, bill.getString("id"));
                AppLogInfo appLogInfo = new AppLogInfo();
                appLogInfo.setBizAppID("/RFP+MBMR+I6");
                appLogInfo.setBizObjID("til_jxdk_ncpjsdk_form");
                ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
                DynamicObject dynamicObject2 = (DynamicObject)this.getModel().getValue(ORG);
                String orgName = null;
                if (null != dynamicObject2) {
                    orgName = dynamicObject2.getString("name");
                }
                Date period = (Date)this.getModel().getValue(TAXPERIOD);
                String taxperiod = DateUtils.format((Date)period, (String)"yyyy-MM");
                appLogInfo.setOpName(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"NcpJsdkFormPlugin_9", (String)"taxc-til", (Object[])new Object[0]));
                appLogInfo.setOpDescription(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s,\u5c5e\u671f%2$s\u7684\u6570\u636e\u5df2\u4fdd\u5b58", (String)"NcpJsdkFormPlugin_10", (String)"taxc-til", (Object[])new Object[0]), orgName, taxperiod));
                service.addLog(appLogInfo);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"NcpJsdkFormPlugin_11", (String)"taxc-til", (Object[])new Object[0]));
            }
        }
        if ("querycondition".equals(evt.getItemKey())) {
            this.openConditonPage("");
        }
        if ("querycondition1".equals(evt.getItemKey())) {
            this.openConditonPage("1");
        }
        if ("querycondition2".equals(evt.getItemKey())) {
            this.openConditonPage("2");
        }
        if ("querycondition3".equals(evt.getItemKey())) {
            this.openConditonPage("3");
        }
    }

    private void openConditonPage(String suffix) {
        String schemeid;
        FormShowParameter parameter = new FormShowParameter();
        String curEntryKey = "billlistap" + suffix;
        parameter.setFormId("til_query_condition");
        parameter.setCustomParam("entryKey", (Object)curEntryKey);
        String datasources = (String)this.getModel().getValue("datasources");
        parameter.setCustomParam("datasources", (Object)datasources);
        NcpJsdkFormEnum ncpJsdkFormEnum = NcpJsdkFormEnum.getEnumByDataSource(datasources);
        parameter.setCustomParam("billType", (Object)ncpJsdkFormEnum.getEntityName());
        parameter.setCustomParam("filterConditonField", new ArrayList(16));
        Map<String, String> allQueryPlanCache = this.getAllQueryPlanCache("writeOffPageFilter");
        String pageKey = datasources + curEntryKey;
        if (allQueryPlanCache != null && !allQueryPlanCache.isEmpty() && null != (schemeid = allQueryPlanCache.get(pageKey + "schemeid"))) {
            parameter.setCustomParam("schemeid", (Object)schemeid);
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "queryConditionCallBack"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object object = e.getReturnData();
        if (object != null && "queryConditionCallBack".equals(actionId)) {
            JSONObject returnData = (JSONObject)object;
            String filterValue = returnData.getString("filtervalue");
            String pageKey = returnData.getString("pagekey");
            String billEntity = returnData.getString("billEntity");
            String isDBData = returnData.getString("DBData");
            String schemeid = returnData.getString("schemeid");
            this.updateQueryPlanCache(filterValue, pageKey, billEntity, schemeid);
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            this.setFiltersAndRefresh(org.getLong("id"));
            this.calPanelData(this.getDataSourceNumber());
            if (FALSE.equals(isDBData)) {
                this.updateQueryPlanCache(null, pageKey, billEntity, schemeid);
            }
            this.Logger.info("closeCallBackQueryPlan ==pagekey=={}==filter=={}", (Object)pageKey, (Object)this.getPageCache().get("writeOffPageFilter"));
        }
    }

    void updateQueryPlanCache(String filterValue, String pageKey, String billEntity, String schemeid) {
        Map<String, String> filterMap = this.getCacheValue("writeOffPageFilter");
        filterMap.put(pageKey, filterValue);
        filterMap.put(pageKey + "billEntity", billEntity);
        filterMap.put(pageKey + "schemeid", schemeid);
        this.getPageCache().put("writeOffPageFilter", SerializationUtils.toJsonString(filterMap));
    }

    private boolean checkHG(List<Object> ids) {
        DynamicObjectCollection query = this.queryHistory(ids);
        if (query.size() > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u53d1\u7968\u6570\u636e\u5df2\u8ba1\u7b97\u62b5\u6263\uff0c\u4e0d\u80fd\u518d\u6b21\u62b5\u6263\u3002", (String)"NcpJsdkFormPlugin_12", (String)"taxc-til", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkPTFP(List<Object> ids, BigDecimal taxrate) {
        DynamicObjectCollection query = this.queryHistory(ids);
        String id = this.getPageCache().get(CACHE_ID_FLAGE);
        if (query.size() > 0) {
            Map<String, List<DynamicObject>> dataid = query.stream().collect(Collectors.groupingBy(a -> a.getString("dataid")));
            for (Map.Entry<String, List<DynamicObject>> entry : dataid.entrySet()) {
                List<DynamicObject> value = entry.getValue();
                if (value == null) continue;
                BigDecimal bigDecimal = value.stream().map(a -> new BigDecimal(a.getString(TAXRATE))).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4);
                if (StringUtil.isEmpty((CharSequence)id)) {
                    bigDecimal = bigDecimal.add(taxrate);
                }
                if (!(bigDecimal.doubleValue() > 0.1)) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u53d1\u7968\u6570\u636e\u7d2f\u8ba1\u8ba1\u7b97\u62b5\u6263\u7a0e\u989d\u4e0d\u5f97\u8d85\u8fc7\u53d1\u7968\u91d1\u989d\u768410%", (String)"NcpJsdkFormPlugin_13", (String)"taxc-til", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private DynamicObjectCollection queryHistory(List<Object> collect) {
        List collect1 = collect.stream().map(a -> String.valueOf(a)).collect(Collectors.toList());
        QFilter qFilter = new QFilter("entryentity.dataid", "in", collect1);
        return QueryServiceHelper.query((String)BILL_ENTITY, (String)"taxrate,entryentity.dataid as dataid", (QFilter[])qFilter.toArray());
    }
}

