/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.inputdeduction;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.list.plugin.IListPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.address.RegisterAddressUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.til.formplugin.inputdeduction.enums.NcpCheckCertBoardEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class NcpJsdkListPlugin
extends AbstractListPlugin
implements IListPlugin,
BeforeFilterF7SelectListener {
    public static final String XZ = "xz";
    public static final String TPO_TAX_CALENDAR = "tpo_tax_calendar";
    private static Log LOGGER = LogFactory.getLog(NcpJsdkListPlugin.class);
    public static final String VERIFY_ORG = "verifyOrg";
    public static final String NCPJSDK_FORM = "til_jxdk_ncpjsdk_form";
    public static final String BILL_ENTITY = "til_jxdk_ncpjsdk_bill";
    private static final String FILTER_CONTAINER_AP = "filtercontainerap";
    public static final String DATASOURCES = "datasources";
    public static final String BILLLISTAP = "billlistap";
    private static final String CARD_TITLE = "cardtitle";
    public static final String TOOLBARAP = "toolbarap";
    private static final String SELECTED_FLEX_KEY = "selectedflexkey";
    private static final String[] clickPanels = new String[]{"fpyrflex", "sgxzflex", "ygrzjeflex", "fpyrjeflex", "sgxzjeflex", "dkzseflex"};

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{TOOLBARAP});
        this.addClickListeners(new String[]{TOOLBARAP});
    }

    public void initialize() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addPackageDataListener(this::packageData);
        for (String clickPanel : clickPanels) {
            this.addClickListeners(new String[]{clickPanel});
        }
    }

    public void afterBindData(EventObject e) {
        if (StringUtil.isEmpty((CharSequence)this.getPageCache().get("init"))) {
            this.initBoard(this.getPageCache().get(VERIFY_ORG));
            this.getPageCache().put("init", "true");
        }
    }

    private String getValue(String datasources) {
        LinkedHashMap<String, String> nameToBill = new LinkedHashMap<String, String>(4);
        nameToBill.put("4", ResManager.loadKDString((String)"\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968", (String)"NcpJsdkListPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
        nameToBill.put("3", ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968\u548c\u9500\u552e\u53d1\u7968\uff08\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\uff09", (String)"NcpJsdkListPlugin_1", (String)"taxc-til", (Object[])new Object[0]));
        return (String)nameToBill.get(datasources);
    }

    public void packageData(PackageDataEvent e) {
        ColumnDesc columnDesc;
        Object source = e.getSource();
        if (source instanceof ColumnDesc && "billno".equals((columnDesc = (ColumnDesc)source).getKey())) {
            String datasources = e.getRowData().getString(DATASOURCES);
            if (XZ.equals(datasources)) {
                e.setFormatValue((Object)ResManager.loadKDString((String)"\u624b\u5de5\u65b0\u589e", (String)"NcpJsdkListPlugin_2", (String)"taxc-til", (Object[])new Object[0]));
            } else {
                e.setFormatValue((Object)this.getValue(datasources));
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs event) {
        List filterColumnList = event.getCommonFilterColumns();
        CommonFilterColumn orgColumn = null;
        for (FilterColumn column : filterColumnList) {
            if (!column.getFieldName().startsWith("org.")) continue;
            orgColumn = (CommonFilterColumn)column;
        }
        String oldselectflexkey = this.getPageCache().get(SELECTED_FLEX_KEY);
        if (EmptyCheckUtils.isNotEmpty((Object)oldselectflexkey)) {
            this.getPageCache().remove(SELECTED_FLEX_KEY);
            this.removeOldSelectFlex(oldselectflexkey);
        }
        QFilter qFilter = null;
        if (orgColumn != null) {
            List<ComboItem> orgCombos = this.getOrgComboItem();
            if (!orgCombos.isEmpty()) {
                orgColumn.setDefaultValue(orgCombos.get(0).getValue());
                qFilter = new QFilter("org", "=", (Object)Long.valueOf(orgCombos.get(0).getValue()));
            } else {
                qFilter = new QFilter("org", "=", (Object)"-1");
            }
            orgColumn.setType("enum");
            orgColumn.setMustInput(true);
            orgColumn.setComboItems(orgCombos);
        }
        BillList billlist = (BillList)this.getControl(BILLLISTAP);
        if (qFilter != null) {
            Class<CommonFilterColumn> clas = CommonFilterColumn.class;
            try {
                Field field = clas.getDeclaredField("selectedCommomFilterFieldValues");
                AccessibleObject.setAccessible(new AccessibleObject[]{field}, true);
                List list = (List)field.get(orgColumn);
                if (EmptyCheckUtils.isNotEmpty((Object)list)) {
                    qFilter = new QFilter("org", "=", (Object)Long.valueOf(String.valueOf(list.get(0))));
                }
                String newOrgValTemp = String.valueOf(qFilter.getValue());
                String oldOrgVal = this.getPageCache().get(VERIFY_ORG);
                if (EmptyCheckUtils.isEmpty((Object)oldOrgVal)) {
                    this.getPageCache().put(VERIFY_ORG, newOrgValTemp);
                } else if (EmptyCheckUtils.isNotEmpty((Object)oldOrgVal) && !oldOrgVal.equalsIgnoreCase(newOrgValTemp) && this.initBoard(newOrgValTemp)) {
                    this.getPageCache().put(VERIFY_ORG, newOrgValTemp);
                }
                this.getPageCache().put(VERIFY_ORG, newOrgValTemp);
                billlist.getFilterParameter().setFilter(qFilter);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                LOGGER.error(ResManager.loadKDString((String)"\u83b7\u53d6\u591a\u9009\u7ec4\u7ec7\u5931\u8d25", (String)"NcpJsdkListPlugin_9", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    private List<ComboItem> getOrgComboItem() {
        String orgListCache = "orgListCache";
        String orgListCacheString = this.getPageCache().get(orgListCache);
        List orgList = new ArrayList();
        if (orgListCacheString == null || StringUtils.equals((CharSequence)orgListCacheString, (CharSequence)"[]")) {
            orgList = OrgUtils.queryOrgListForInitOrgComboItems((IFormView)this.getView(), (String[])new String[]{"tctrc_risk_run_list"}, null, null);
            this.getPageCache().put(orgListCache, SerializationUtils.toJsonString(orgList));
        } else {
            orgList = (List)SerializationUtils.fromJsonString((String)orgListCacheString, orgList.getClass());
        }
        return OrgUtils.getComboItems(orgList);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs searchClickEvent) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        Map map = searchClickEvent.getFilterValues();
        List customlist = (List)map.get("customfilter");
        List schemelist = (List)map.get("schemefilter");
        List fastlist = (List)map.get("fastfilter");
        FilterParameter fastFilterParameter = searchClickEvent.getFilterModel().getFastFilterParameter(fastlist);
        List fastQFilterList = fastFilterParameter.getQFilters();
        FilterParameter commonFilterParameter = searchClickEvent.getFilterModel().getCommonFilterParameter(customlist);
        List commonQFilterList = commonFilterParameter.getQFilters();
        FilterParameter schemaFilterParameter = searchClickEvent.getFilterModel().getSchemeFilterParameter(schemelist);
        List schemaQFilterList = schemaFilterParameter.getQFilters();
        fastQFilterList.addAll(commonQFilterList);
        fastQFilterList.addAll(schemaQFilterList);
        billList.setFilterParameter(fastFilterParameter);
        billList.clearSelection();
        billList.refresh();
    }

    public void afterCreateNewData(EventObject e) {
        BigDecimal zero = BigDecimal.ZERO;
        this.getModel().setValue("fpyr", (Object)zero);
        this.getModel().setValue("fpyrje", (Object)zero);
        this.getModel().setValue("sgxz", (Object)zero);
        this.getModel().setValue("sgxzje", (Object)zero);
        this.getModel().setValue("ygrzje", (Object)zero);
        this.getModel().setValue("bqjsdkse", (Object)zero);
        String cardTitleFormat = ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708\u7a0e\u671f\u770b\u677f", (String)"NcpJsdkListPlugin_3", (String)"taxc-til", (Object[])new Object[0]);
        Date date = DateUtils.addMonth((Date)new Date(), (int)-1);
        this.getModel().setValue(CARD_TITLE, (Object)String.format(cardTitleFormat, DateUtils.getYearOfDate((Date)date), DateUtils.getMonthOfDate((Date)date)));
    }

    public void setFilter(SetFilterEvent e) {
        if (EmptyCheckUtils.isNotEmpty((Object)this.getPageCache().get(SELECTED_FLEX_KEY))) {
            NcpCheckCertBoardEnum boardEnum = NcpCheckCertBoardEnum.getEnumByKey("", this.getPageCache().get(SELECTED_FLEX_KEY));
            List qFilters = e.getQFilters();
            int size = qFilters.size();
            for (int i = 0; i < size; ++i) {
                qFilters.remove(0);
            }
            this.addFilters(qFilters, boardEnum);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if (evt.getItemKey().equals("addnew")) {
            String orgid = this.getPageCache().get(VERIFY_ORG);
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put("org", orgid);
            PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)NCPJSDK_FORM, (IFormView)this.getView(), customParams, (IFormPlugin)this);
            AppLogInfo appLogInfo = new AppLogInfo();
            appLogInfo.setBizAppID("/RFP+MBMR+I6");
            appLogInfo.setBizObjID(BILL_ENTITY);
            ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
            appLogInfo.setOpName(ResManager.loadKDString((String)"\u65b0\u589e", (String)"NcpJsdkListPlugin_4", (String)"taxc-til", (Object[])new Object[0]));
            appLogInfo.setOpDescription(ResManager.loadKDString((String)"\u6253\u5f00\u519c\u4ea7\u54c1\u8ba1\u7b97\u62b5\u6263\u65b0\u589e\u9875\u9762", (String)"NcpJsdkListPlugin_5", (String)"taxc-til", (Object[])new Object[0]));
            service.addLog(appLogInfo);
        } else if (evt.getItemKey().equals("refresh")) {
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            billList.refresh();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (NCPJSDK_FORM.equals(closedCallBackEvent.getActionId())) {
            this.refreshData();
        }
    }

    private void refreshData() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.refresh();
        this.initBoard(this.getPageCache().get(VERIFY_ORG));
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String operateKey = eventArgs.getOperateKey();
        if ("delete".equals(operateKey)) {
            this.refreshData();
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (!Arrays.asList(clickPanels).contains(key)) {
            return;
        }
        NcpCheckCertBoardEnum boardEnum = NcpCheckCertBoardEnum.getEnumByKey("", key);
        if (EmptyCheckUtils.isNotEmpty((Object)this.getPageCache().get(SELECTED_FLEX_KEY))) {
            String oldselectflexkey = this.getPageCache().get(SELECTED_FLEX_KEY);
            if (!oldselectflexkey.equalsIgnoreCase(key)) {
                this.removeOldSelectFlex(oldselectflexkey);
                this.addNewSelectFlex(key);
            }
        } else {
            this.addNewSelectFlex(key);
        }
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        this.addFilters(qFilters, boardEnum);
        billList.getFilterParameter().setQFilters(qFilters);
        billList.getClientQueryFilterParameter().setQFilters(qFilters);
        billList.getQueryFilterParameter().setQFilters(qFilters);
        billList.clearSelection();
        billList.refresh();
    }

    private void addFilters(List<QFilter> qFilters, NcpCheckCertBoardEnum boardEnum) {
        String orgid;
        if (EmptyCheckUtils.isNotEmpty((Object)boardEnum.getqFilter())) {
            qFilters.add(boardEnum.getqFilter());
        }
        if (EmptyCheckUtils.isEmpty((Object)(orgid = this.getPageCache().get(VERIFY_ORG)))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7ec4\u7ec7\u7a0e\u52a1\u4fe1\u606f", (String)"NcpJsdkListPlugin_6", (String)"taxc-til", (Object[])new Object[0]));
        }
        String taxperiod = this.getPageCache().get("taxperiod");
        if (EmptyCheckUtils.isEmpty((Object)taxperiod)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7ec4\u7ec7\u7a0e\u52a1\u4fe1\u606f", (String)"NcpJsdkListPlugin_6", (String)"taxc-til", (Object[])new Object[0]));
        }
        Date date = DateUtils.stringToDate((String)taxperiod, (String)"yyyy-MM");
        QFilter taxperiodQFilter = new QFilter("taxperiod", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)date)).and("taxperiod", "<=", (Object)DateUtils.getLastDateOfMonth((Date)date));
        qFilters.add(taxperiodQFilter);
        QFilter orgFilter1 = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        qFilters.add(orgFilter1);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (CollectionUtils.isEmpty((Collection)rows)) {
                    return rows;
                }
                DataEntityPropertyCollection properties = rows.getDynamicObjectType().getProperties();
                for (DynamicObject row : rows) {
                    String datasource;
                    if (!properties.containsKey((Object)NcpJsdkListPlugin.DATASOURCES) || !NcpJsdkListPlugin.XZ.equals(datasource = row.getString(NcpJsdkListPlugin.DATASOURCES))) continue;
                    if (properties.containsKey((Object)"entryentity.fpje") && properties.containsKey((Object)"ncpmj")) {
                        row.set("entryentity.fpje", row.get("ncpmj"));
                    }
                    if (!properties.containsKey((Object)"entryentity.fpdkse") || !properties.containsKey((Object)"dktax")) continue;
                    row.set("entryentity.fpdkse", row.get("dktax"));
                }
                return rows;
            }
        });
    }

    private boolean initBoard(String orgid) {
        try {
            List<QFilter> qFilterList = this.getQFilterList(orgid);
            if (EmptyCheckUtils.isEmpty(qFilterList)) {
                return false;
            }
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)BILL_ENTITY, (String)"id", (QFilter[])qFilterList.toArray(new QFilter[0]));
            List ids = dynamicObjects.stream().map(a -> a.get("id")).collect(Collectors.toList());
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)BILL_ENTITY));
            this.doInitBoard(Arrays.asList(load));
        }
        catch (KDBizException ex) {
            this.getView().showErrorNotification(ex.getMessage());
            return false;
        }
        return true;
    }

    private void doInitBoard(List<DynamicObject> dynamicObjects) {
        BigDecimal fpyr = BigDecimal.ZERO;
        BigDecimal sgxz = BigDecimal.ZERO;
        BigDecimal fpyrje = BigDecimal.ZERO;
        BigDecimal sgxzje = BigDecimal.ZERO;
        Map<String, List<DynamicObject>> collect = dynamicObjects.stream().collect(Collectors.groupingBy(a -> a.getString(DATASOURCES)));
        List<DynamicObject> xz = collect.get(XZ);
        if (xz != null) {
            for (DynamicObject dynamicObject : xz) {
                sgxz = sgxz.add(dynamicObject.getBigDecimal("dktax") == null ? BigDecimal.ZERO : dynamicObject.getBigDecimal("dktax"));
                sgxzje = sgxzje.add(dynamicObject.getBigDecimal("ncpmj") == null ? BigDecimal.ZERO : dynamicObject.getBigDecimal("ncpmj"));
            }
        }
        collect.remove(XZ);
        for (Map.Entry entry : collect.entrySet()) {
            List value = (List)entry.getValue();
            for (DynamicObject dynamicObject : value) {
                fpyr = fpyr.add(dynamicObject.getBigDecimal("dktax") == null ? BigDecimal.ZERO : dynamicObject.getBigDecimal("dktax"));
                fpyrje = fpyrje.add(dynamicObject.getBigDecimal("ncpmj") == null ? BigDecimal.ZERO : dynamicObject.getBigDecimal("ncpmj"));
            }
        }
        BigDecimal ygrzje = sgxzje.add(fpyrje);
        BigDecimal bqjsdkse = sgxz.add(fpyr);
        this.getModel().setValue("fpyr", (Object)fpyr);
        this.getModel().setValue("fpyrje", (Object)fpyrje);
        this.getModel().setValue("sgxz", (Object)sgxz);
        this.getModel().setValue("sgxzje", (Object)sgxzje);
        this.getModel().setValue("ygrzje", (Object)ygrzje);
        this.getModel().setValue("bqjsdkse", (Object)bqjsdkse);
        this.getView().updateView("flexpanelap2");
    }

    private List<QFilter> getQFilterList(String orgid) {
        if (EmptyCheckUtils.isEmpty((Object)orgid) && EmptyCheckUtils.isEmpty((Object)(orgid = this.getPageCache().get(VERIFY_ORG)))) {
            return new ArrayList<QFilter>();
        }
        Date date = new Date();
        int month = DateUtils.getMonthOfDate((Date)date);
        int year = DateUtils.getYearOfDate((Date)date);
        Date endDate = null;
        try {
            endDate = RegisterAddressUtil.findZZSMonthApplyEndDate((Object)orgid);
        }
        catch (KDBizException e) {
            this.getView().showErrorNotification(e.getMessage());
            return new ArrayList<QFilter>();
        }
        if (null == endDate) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u7ec4\u7ec7\u4fe1\u606f", (String)"NcpJsdkListPlugin_7", (String)"taxc-til", (Object[])new Object[0]));
        }
        endDate = DateUtils.stringToDate((String)DateUtils.format((Date)endDate));
        date = DateUtils.stringToDate((String)DateUtils.format((Date)date));
        if (endDate.getTime() >= date.getTime() && --month == 0) {
            month = 12;
            --year;
        }
        String cardTitleFormat = ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708\u7a0e\u671f\u770b\u677f", (String)"NcpJsdkListPlugin_3", (String)"taxc-til", (Object[])new Object[0]);
        this.getModel().setValue(CARD_TITLE, (Object)String.format(cardTitleFormat, year, month));
        String months = StringUtil.fillCharAtLeft((Object)month, (int)2, (char)'0');
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        String taxperiod = Stream.of(Integer.valueOf(year), months).map(v -> String.valueOf(v)).collect(Collectors.joining("-"));
        this.getPageCache().put("taxperiod", taxperiod);
        date = DateUtils.stringToDateInAnyFormat((String)taxperiod);
        QFilter taxperiodQFilter = new QFilter("taxperiod", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)date)).and("taxperiod", "<=", (Object)DateUtils.getLastDateOfMonth((Date)date));
        qFilters.add(taxperiodQFilter);
        QFilter orgFilter1 = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        qFilters.add(orgFilter1);
        return qFilters;
    }

    private void addNewSelectFlex(String key) {
        HashMap stylemap1 = new HashMap(8);
        String selectedlinestyle = "2px_solid_#5582F3";
        HashMap style = new HashMap();
        HashMap<String, String> border = new HashMap<String, String>();
        border.put("b", selectedlinestyle);
        style.put("b", border);
        stylemap1.put("s", style);
        this.getView().updateControlMetadata(key, stylemap1);
        this.getPageCache().put(SELECTED_FLEX_KEY, key);
    }

    private void removeOldSelectFlex(String oldselectflexkey) {
        HashMap stylemap1 = new HashMap(8);
        String selectedlinestyle = "1px_solid_#d9d9d9";
        HashMap style = new HashMap();
        HashMap<String, String> border = new HashMap<String, String>();
        border.put("b", selectedlinestyle);
        style.put("b", border);
        stylemap1.put("s", style);
        this.getView().updateControlMetadata(oldselectflexkey, stylemap1);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent beforeFilterF7SelectEvent) {
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)this.getControl(BILLLISTAP);
        Long primaryKey = (Long)list.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        HashMap<String, Long> customParams = new HashMap<String, Long>();
        if (!QueryServiceHelper.exists((String)BILL_ENTITY, (Object)primaryKey)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u518d\u8bd5\uff01", (String)"NcpJsdkListPlugin_8", (String)"taxc-til", (Object[])new Object[0]));
            return;
        }
        customParams.put("primaryKey", primaryKey);
        PageShowCommon.showForm((OperationStatus)OperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, (String)NCPJSDK_FORM, (IFormView)this.getView(), customParams, (IFormPlugin)this);
    }
}

