/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.inputtransferout;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class InputTransferOutDialogPlugin
extends AbstractFormPlugin {
    private static String REAL_OUTPUT_AMOUNT = "real_output_amount";
    private static String REAL_TRANSFERDATE = "real_transferdate";
    private static String REGISTER_TYPE = "output_signtype";
    private static String OUT_TYPE = "output_type";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"save"});
        this.addClickListeners(new String[]{"exit"});
    }

    public void afterCreateNewData(EventObject e) {
        FieldEdit control;
        QFilter valueFilter;
        QFilter fieldFilter;
        DynamicObject query;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object invoicelist = customParams.get("invoicelist");
        Object reason = customParams.get("reason");
        String outputReason = (String)customParams.get("outputReason");
        if (StringUtil.isNotBlank((CharSequence)outputReason) && (query = QueryServiceHelper.queryOne((String)"til_rollout_type_config", (String)"outputtype", (QFilter[])new QFilter[]{fieldFilter = new QFilter("mapfield", "=", (Object)"zcyy"), valueFilter = new QFilter("mapvalue", "=", (Object)outputReason)})) != null) {
            this.getModel().setValue("transfertype", (Object)query.getString("outputtype"));
            if (StringUtil.isNotBlank((CharSequence)query.getString("outputtype"))) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"transfertype"});
            }
        }
        DynamicObjectCollection query2 = QueryServiceHelper.query((String)"rim_invoice", (String)"id,tax_org,org,invoice_type,invoice_code,invoice_date,invoice_no,invoice_amount,total_tax_amount,total_amount,effective_tax_amount,output_amount,output_reason", (QFilter[])new QFilter[]{new QFilter("id", "in", invoicelist)});
        BigDecimal deductTax = BigDecimal.ZERO;
        BigDecimal perpayTax = BigDecimal.ZERO;
        IDataModel dataModel = this.getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("id", new Object[0]);
        vs.addField("tax_org", new Object[0]);
        vs.addField("org", new Object[0]);
        vs.addField("invoice_type", new Object[0]);
        vs.addField("invoice_code", new Object[0]);
        vs.addField("invoice_no", new Object[0]);
        vs.addField("invoice_date", new Object[0]);
        vs.addField("invoice_amount", new Object[0]);
        vs.addField("total_tax_amount", new Object[0]);
        vs.addField("total_amount", new Object[0]);
        vs.addField("effective_tax_amount", new Object[0]);
        vs.addField("output_amount", new Object[0]);
        vs.addField("output_reason", new Object[0]);
        vs.addField(REGISTER_TYPE, new Object[0]);
        vs.addField(OUT_TYPE, new Object[0]);
        vs.addField(REAL_OUTPUT_AMOUNT, new Object[0]);
        vs.addField(REAL_TRANSFERDATE, new Object[0]);
        String registertype = (String)this.getModel().getValue("registertype");
        String transfertype = (String)this.getModel().getValue("transfertype");
        Date transferperiod = (Date)this.getModel().getValue("transferperiod");
        for (int i = 0; i < query2.size(); ++i) {
            DynamicObject object = (DynamicObject)query2.get(i);
            vs.addRow(new Object[]{object.getLong("id"), object.getLong("tax_org"), object.getLong("org"), object.getString("invoice_type"), object.getString("invoice_code"), object.getString("invoice_no"), object.getDate("invoice_date"), object.getBigDecimal("invoice_amount"), object.getBigDecimal("total_tax_amount"), object.getBigDecimal("total_amount"), object.getBigDecimal("effective_tax_amount"), object.getBigDecimal("output_amount"), object.getString("output_reason"), registertype, "2".equals(registertype) ? "-" : transfertype, "empty".equals(reason) ? object.getBigDecimal("effective_tax_amount") : object.getBigDecimal("output_amount"), transferperiod});
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"tax_org", "org", "invoice_type", "invoice_code", "invoice_no", "invoice_date", "invoice_amount", "total_tax_amount", "total_amount", "effective_tax_amount", "output_amount", "output_reason", REGISTER_TYPE, OUT_TYPE, REAL_OUTPUT_AMOUNT, REAL_TRANSFERDATE});
            deductTax = deductTax.add(object.getBigDecimal("effective_tax_amount"));
            perpayTax = perpayTax.add(object.getBigDecimal("output_amount"));
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
        model.setValue("deducttax", (Object)deductTax);
        BigDecimal prepayTaxAmoutn = "empty".equals(reason) ? deductTax : perpayTax;
        model.setValue("perpaytax", (Object)prepayTaxAmoutn);
        Object radiogroup = model.getValue("radiogroup");
        if (radiogroup.equals("1")) {
            model.setValue("actualtax", (Object)prepayTaxAmoutn);
            this.getView().setEnable(Boolean.FALSE, new String[]{"signrate"});
        }
        if (null != (control = (FieldEdit)this.getControl("transfertype"))) {
            control.setMustInput("1".equals(registertype));
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        DynamicObjectCollection entry;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object reason = customParams.get("reason");
        String fieldName = "empty".equals(reason) ? "effective_tax_amount" : "output_amount";
        String name = args.getProperty().getName();
        Object newValue = args.getChangeSet()[0].getNewValue();
        Object oldValue = args.getChangeSet()[0].getOldValue();
        int rowIndex = args.getChangeSet()[0].getRowIndex();
        if ("registertype".equals(name)) {
            this.getView().setVisible(Boolean.valueOf("1".equals(newValue)), new String[]{"transfertype", "transfer"});
            FieldEdit control = (FieldEdit)this.getControl("transfertype");
            if (null != control) {
                control.setMustInput("1".equals(newValue));
            }
            Iterator entry2 = this.getView().getModel().getEntryEntity("entryentity");
            DynamicObjectType dot = entry2.getDynamicObjectType();
            String transfertype = (String)this.getModel().getValue("transfertype");
            for (int i = 0; i < entry2.size(); ++i) {
                DynamicObject data = (DynamicObject)entry2.get(i);
                dot.getProperty(REGISTER_TYPE).setValueFast((Object)data, newValue);
                if ("2".equals(newValue)) {
                    dot.getProperty(OUT_TYPE).setValueFast((Object)data, (Object)"-");
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{REAL_OUTPUT_AMOUNT});
                    dot.getProperty(REAL_OUTPUT_AMOUNT).setValueFast((Object)data, (Object)BigDecimal.ZERO);
                    continue;
                }
                dot.getProperty(OUT_TYPE).setValueFast((Object)data, (Object)transfertype);
                data.getDynamicObjectType().getProperty(REAL_OUTPUT_AMOUNT).setValueFast((Object)data, (Object)data.getBigDecimal(fieldName));
            }
            this.getView().updateView("entryentity");
            if ("2".equals(newValue)) {
                this.getModel().setValue("radiogroup", (Object)"1");
            }
        }
        if ("transfertype".equals(name)) {
            entry = this.getView().getModel().getEntryEntity("entryentity");
            for (Object data : entry) {
                data.getDynamicObjectType().getProperty(OUT_TYPE).setValueFast(data, newValue);
            }
            this.getView().updateView("entryentity");
        }
        if ("transferperiod".equals(name)) {
            entry = this.getView().getModel().getEntryEntity("entryentity");
            for (Object data : entry) {
                data.getDynamicObjectType().getProperty(REAL_TRANSFERDATE).setValueFast(data, newValue);
            }
            this.getView().updateView("entryentity");
        }
        if ("radiogroup".equals(name)) {
            this.getView().setEnable(Boolean.valueOf("2".equals(newValue)), new String[]{"signrate"});
            entry = this.getView().getModel().getEntryEntity("entryentity");
            BigDecimal perpaytax = (BigDecimal)this.getModel().getValue("perpaytax");
            if ("1".equals(newValue)) {
                this.getPageCache().put("enable", "false");
                this.getModel().setValue("actualtax", (Object)perpaytax);
                for (DynamicObject data : entry) {
                    BigDecimal amount = "2".equals(this.getModel().getValue("registertype")) ? BigDecimal.ZERO : data.getBigDecimal(fieldName);
                    data.getDynamicObjectType().getProperty(REAL_OUTPUT_AMOUNT).setValueFast((Object)data, (Object)amount);
                }
                this.getView().updateView("entryentity");
            }
            if ("2".equals(newValue)) {
                this.getPageCache().put("enable", "false");
                this.getPageCache().put("signratechange", "true");
                BigDecimal signrate = (BigDecimal)this.getModel().getValue("signrate");
                BigDecimal actualtax = perpaytax.multiply(signrate).divide(new BigDecimal(100L)).setScale(2, 4);
                this.getModel().setValue("actualtax", (Object)actualtax);
                for (DynamicObject data : entry) {
                    data.getDynamicObjectType().getProperty(REAL_OUTPUT_AMOUNT).setValueFast((Object)data, (Object)data.getBigDecimal(fieldName).multiply(signrate).divide(new BigDecimal(100L)).setScale(2, 4));
                }
                this.getView().updateView("entryentity");
            }
            if ("2".equals(oldValue)) {
                this.getPageCache().put("signratechange", "false");
                this.getModel().setValue("signrate", (Object)"");
            }
            if ("3".equals(newValue)) {
                for (int i = 0; i < entry.size(); ++i) {
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{REAL_OUTPUT_AMOUNT});
                }
                this.getPageCache().put("enable", "true");
                this.getModel().setValue("actualtax", (Object)InputTransferOutDialogPlugin.getEntryEntityAmount(this.getView(), "entryentity", REAL_OUTPUT_AMOUNT));
            }
        }
        if (REAL_OUTPUT_AMOUNT.equals(name) && "true".equals(this.getPageCache().get("enable"))) {
            BigDecimal realOutPutAmount;
            if ("empty".equals(reason)) {
                BigDecimal effectiveTaxAmount;
                realOutPutAmount = (BigDecimal)args.getChangeSet()[0].getNewValue();
                if (realOutPutAmount.compareTo(effectiveTaxAmount = args.getChangeSet()[0].getDataEntity().getBigDecimal("effective_tax_amount")) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u5b9e\u9645\u8f6c\u51fa\u7a0e\u989d\u5927\u4e8e\u62b5\u6263\u7a0e\u989d,\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"InputTransferOutDialogPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
                    this.getModel().setValue(REAL_OUTPUT_AMOUNT, (Object)BigDecimal.ZERO, rowIndex);
                    return;
                }
            } else {
                BigDecimal outputAmount;
                realOutPutAmount = (BigDecimal)args.getChangeSet()[0].getNewValue();
                if (realOutPutAmount.compareTo(outputAmount = args.getChangeSet()[0].getDataEntity().getBigDecimal("output_amount")) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u5b9e\u9645\u8f6c\u51fa\u7a0e\u989d\u6700\u5927\u4e0d\u5f97\u8d85\u8fc7\u3010\u8f6c\u51fa\u91d1\u989d\u3011,\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"InputTransferOutDialogPlugin_1", (String)"taxc-til", (Object[])new Object[0]));
                    this.getModel().setValue(REAL_OUTPUT_AMOUNT, (Object)BigDecimal.ZERO, rowIndex);
                    return;
                }
            }
            this.getModel().setValue("actualtax", (Object)InputTransferOutDialogPlugin.getEntryEntityAmount(this.getView(), "entryentity", REAL_OUTPUT_AMOUNT));
        }
        if ("signrate".equals(name) && "true".equals(this.getPageCache().get("signratechange"))) {
            BigDecimal perpaytax = (BigDecimal)this.getModel().getValue("perpaytax");
            BigDecimal signrate = (BigDecimal)this.getModel().getValue("signrate");
            BigDecimal actualtax = perpaytax.multiply(signrate).divide(new BigDecimal(100L)).setScale(2, 4);
            this.getModel().setValue("actualtax", (Object)actualtax);
            DynamicObjectCollection entry3 = this.getView().getModel().getEntryEntity("entryentity");
            for (DynamicObject data : entry3) {
                data.getDynamicObjectType().getProperty(REAL_OUTPUT_AMOUNT).setValueFast((Object)data, (Object)data.getBigDecimal(fieldName).multiply(signrate).divide(new BigDecimal(100L)).setScale(2, 4));
            }
            this.getView().updateView("entryentity");
        }
        if (!"3".equals(this.getModel().getValue("radiogroup"))) {
            entry = this.getView().getModel().getEntryEntity("entryentity");
            for (int i = 0; i < entry.size(); ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{REAL_OUTPUT_AMOUNT});
            }
        }
    }

    public static BigDecimal getEntryEntityAmount(IFormView getView, String entryName, String totalAmount) {
        DynamicObjectCollection salesentry = getView.getModel().getEntryEntity(entryName);
        return InputTransferOutDialogPlugin.getTotalAmount(salesentry, totalAmount);
    }

    public static BigDecimal getTotalAmount(DynamicObjectCollection entryEntity, String totalAmount) {
        if (entryEntity.size() > 0) {
            return entryEntity.parallelStream().map(s -> s.getBigDecimal(totalAmount)).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return BigDecimal.ZERO;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().returnDataToParent((Object)"close");
    }
}

