/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.inputtransferout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.PartitionSaveTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class InputTransferOutDialogSaveOp
extends AbstractOperationServicePlugIn {
    private static String REAL_OUTPUT_AMOUNT = "real_output_amount";
    private static String REAL_TRANSFERDATE = "real_transferdate";
    private static String OUTPUT_SIGNTYPE = "output_signtype";
    private static String OUTPUT_TYPE = "output_type";

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    String endDate;
                    Date transferperiod = dataEntity.getDataEntity().getDate("transferperiod");
                    DynamicObjectCollection entryentity = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
                    ArrayList<String> tax_org = new ArrayList<String>();
                    HashMap<String, String> orgName = new HashMap<String, String>();
                    for (DynamicObject object : entryentity) {
                        DynamicObject org = object.getDynamicObject("tax_org");
                        if (null == org) {
                            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801:\u201c%1$s\u201d \u53d1\u7968\u53f7\u7801:\u201c%2$s\u201d \u7684\u7a0e\u52a1\u7ec4\u7ec7\u4e3a\u7a7a", (String)"InputTransferOutDialogSaveOp_0", (String)"taxc-til", (Object[])new Object[0]), object.getString("invoice_code"), object.getString("invoice_no")));
                            continue;
                        }
                        tax_org.add(org.getString("id"));
                        orgName.put(org.getString("id"), org.getString("name"));
                    }
                    String startDate = DateUtils.getFirstDateOfMonthStr((Date)transferperiod, (String)"yyyy-MM-dd");
                    DynamicObjectCollection declareDataCollection = InputTransferOutDialogSaveOp.queryZzsSbb(tax_org, "zzsybnsr", startDate, endDate = DateUtils.getLastDateOfMonthStr((Date)transferperiod, (String)"yyyy-MM-dd"));
                    if (declareDataCollection.size() <= 0) continue;
                    for (DynamicObject object : declareDataCollection) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5728\u201c%2$s\u201d\u7684\u7533\u62a5\u8868\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u652f\u6301\u8f6c\u51fa\u767b\u8bb0\uff0c\u8bf7\u91cd\u65b0\u52fe\u9009", (String)"InputTransferOutDialogSaveOp_1", (String)"taxc-til", (Object[])new Object[0]), orgName.get(object.getString("org")), startDate));
                    }
                }
            }
        });
    }

    public static DynamicObjectCollection queryZzsSbb(List<String> orgList, String type, String startData, String endData) {
        QFilter orgidFilter = new QFilter("org", "in", orgList.stream().map(Long::parseLong).collect(Collectors.toList()));
        QFilter stypeFilter = new QFilter("type", "=", (Object)type);
        QFilter startDataFilter = new QFilter("skssqq", "=", (Object)DateUtils.addMonth((Date)DateUtils.stringToDate((String)startData), (int)0));
        QFilter endDataFilter = new QFilter("skssqz", "<=", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)DateUtils.stringToDate((String)endData), (int)0)));
        QFilter billstatusFilter = new QFilter("billstatus", "!=", (Object)"A");
        DynamicObjectCollection temp = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"declarestatus,org,id", (QFilter[])new QFilter[]{orgidFilter, stypeFilter, billstatusFilter, startDataFilter, endDataFilter});
        return temp;
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] invoices;
        DynamicObject dataEntities = e.getDataEntities()[0];
        DynamicObjectCollection entry = dataEntities.getDynamicObjectCollection("entryentity");
        Map<Long, DynamicObject> idMap = entry.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v, (k1, k2) -> k2));
        for (DynamicObject invoice : invoices = BusinessDataServiceHelper.load((Object[])idMap.keySet().toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_invoice"))) {
            invoice.set(REAL_OUTPUT_AMOUNT, (Object)idMap.get(invoice.getLong("id")).getBigDecimal(REAL_OUTPUT_AMOUNT));
            invoice.set(REAL_TRANSFERDATE, (Object)DateUtils.stringToDate((String)DateUtils.formatMonth((Date)idMap.get(invoice.getLong("id")).getDate(REAL_TRANSFERDATE)), (String)"yyyy-MM"));
            invoice.set(OUTPUT_SIGNTYPE, (Object)idMap.get(invoice.getLong("id")).getString(OUTPUT_SIGNTYPE));
            invoice.set(OUTPUT_TYPE, (Object)idMap.get(invoice.getLong("id")).getString(OUTPUT_TYPE));
        }
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(Arrays.asList(invoices)));
    }
}

