/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.inputtransferout;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.til.common.enums.InputInvoiceTypeEnum;

public class InputTransferOutPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    public static final String DELETE_FLAG_ENABLE = "1";
    private static final String KEY_TYPE_TREE = "typetree";
    private static final String KEY_DATA_FLEX = "data_flex";

    public void initialize() {
    }

    public void registerListener(EventObject e) {
        TreeView tree = (TreeView)this.getView().getControl(KEY_TYPE_TREE);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        TreeView tree1 = (TreeView)this.getView().getControl(KEY_TYPE_TREE);
        tree1.addTreeNodeClickListener((TreeNodeClickListener)this);
        InputInvoiceTypeEnum[] invoiceTypes = InputInvoiceTypeEnum.values();
        TreeView tree = (TreeView)this.getView().getControl(KEY_TYPE_TREE);
        ArrayList<TreeNode> list = new ArrayList<TreeNode>(8);
        for (InputInvoiceTypeEnum type : invoiceTypes) {
            TreeNode node = new TreeNode();
            node.setId(type.getCode() + "");
            node.setText(type.getName());
            list.add(node);
        }
        tree.addNodes(list);
        tree.focusNode((TreeNode)list.get(0));
        tree.treeNodeClick(null, ((TreeNode)list.get(0)).getId());
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Long nodeId = Long.parseLong((String)evt.getNodeId());
        ListShowParameter showParameter = new ListShowParameter();
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId("til_invoice_list");
        HashMap customParams = new HashMap();
        Map parameter = this.getView().getFormShowParameter().getCustomParams();
        Object queryType = parameter.get("querytype");
        customParams.put("querytype", queryType);
        customParams.put("invoicetype", nodeId);
        customParams.put("treePageId", this.getView().getPageId());
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(new QFilter("invoice_type", "in", InputInvoiceTypeEnum.getInvoiceType(nodeId).getCodeList()));
        QFilter delFilter = new QFilter("delete", "=", (Object)DELETE_FLAG_ENABLE);
        filters.add(delFilter);
        filters.add(InputInvoiceTypeEnum.getInvoiceType(nodeId).getFilter());
        listFilterParameter.setQFilters(filters);
        showParameter.setShowTitle(false);
        showParameter.setCustomParams(customParams);
        showParameter.setCaption(InputInvoiceTypeEnum.getInvoiceType(nodeId).getName());
        showParameter.setListFilterParameter(listFilterParameter);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(KEY_DATA_FLEX);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bos_list");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String returnData = (String)closedCallBackEvent.getReturnData();
        if ("close".equals(returnData)) {
            this.getView().close();
        }
    }
}

