/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.inputtransferout;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.PartitionSaveTask;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class InvoiceListPlugin
extends AbstractListPlugin {
    private static String REAL_OUTPUT_AMOUNT = "real_output_amount";
    private static String REAL_TRANSFERDATE = "real_transferdate";
    private static String OUTPUT_SIGNTYPE = "output_signtype";
    private static String OUTPUT_TYPE = "output_type";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.getControl("toolbarap");
        this.addClickListeners(new String[]{"registered", "unregistered"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String invoicetype = String.valueOf(customParams.get("invoicetype"));
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        if (!"0".equals(invoicetype)) {
            filterColumnList.removeIf(e -> "invoice_type.name".equals(e.getFieldName()));
        }
        for (FilterColumn filterColumn : filterColumnList) {
            if (!filterColumn.getFieldName().equals("org.name") || !(filterColumn instanceof CommonFilterColumn)) continue;
            long accountingDefaultOrgId = InvoiceListPlugin.getAccountingDefaultOrgId(this.getView());
            filterColumn.setDefaultValue(String.valueOf(accountingDefaultOrgId));
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"registered", "generatevoucher"});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String nodeId = String.valueOf(customParams.get("invoicetype"));
        if (StringUtil.isNotBlank((CharSequence)nodeId) && "0".equals(nodeId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"registered", "generatevoucher"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        ListSelectedRowCollection selectCollection;
        super.afterDoOperation(evt);
        String key = evt.getOperateKey();
        if ("registered".equals(key)) {
            String operateName = ResManager.loadKDString((String)"\u767b\u8bb0", (String)"InvoiceListPlugin_0", (String)"taxc-til", (Object[])new Object[0]);
            String operateDescription = ResManager.loadKDString((String)"\u8fdb\u9879\u8f6c\u51fa\u53d1\u7968\u767b\u8bb0\u5f39\u7a97\u6253\u5f00\u6210\u529f", (String)"InvoiceListPlugin_1", (String)"taxc-til", (Object[])new Object[0]);
            OperatorDialogUtils.operateDialog((String)"zzs", (String)"til_invoice_list", (String)operateName, (String)operateDescription);
            ListSelectedRowCollection selectCollection2 = ((IListView)this.getView()).getSelectedRows();
            if (selectCollection2.size() > 0) {
                QFilter idFilter = new QFilter("id", "in", (Object)selectCollection2.getPrimaryKeyValues());
                DynamicObjectCollection query = QueryServiceHelper.query((String)"rim_invoice", (String)"id,invoice_code,invoice_no,tax_org,serial_no,invoice_type,output_reason,invoice_status,real_transferdate", (QFilter[])new QFilter[]{idFilter});
                DynamicObject[] emptyReason = new AtomicInteger(0);
                AtomicInteger notEmptyPeriod = new AtomicInteger(0);
                AtomicInteger declaredCount = new AtomicInteger(0);
                StringBuffer codeAndNoStr = new StringBuffer();
                ArrayList specialidList = new ArrayList(query.size());
                ArrayList<Long> invoiceidList = new ArrayList<Long>(query.size());
                HashSet outputReasonSet = new HashSet(query.size());
                query.stream().forEach(arg_0 -> InvoiceListPlugin.lambda$afterDoOperation$1(specialidList, (AtomicInteger)emptyReason, declaredCount, codeAndNoStr, notEmptyPeriod, invoiceidList, outputReasonSet, arg_0));
                this.getPageCache().put("invoiceidlist", JsonUtil.toJson(invoiceidList));
                this.getPageCache().put("reason", emptyReason.get() > 0 ? "empty" : "notempty");
                if (outputReasonSet.size() > 1) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u8f6c\u51fa\u539f\u56e0\u4e0d\u4e00\u81f4\u7684\u53d1\u7968\uff0c\u8bf7\u68c0\u67e5\uff0c\u5e76\u91cd\u65b0\u9009\u62e9", (String)"InvoiceListPlugin_2", (String)"taxc-til", (Object[])new Object[0]), MessageBoxOptions.OK, new ConfirmCallBackListener(key, (IFormPlugin)this));
                    return;
                }
                outputReasonSet.stream().findFirst().ifPresent(s -> this.getPageCache().put("outputReason", s));
                if (emptyReason.get() > 0 && emptyReason.get() != query.size()) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u201c\u8f6c\u51fa\u539f\u56e0\u201d\u4e0d\u5141\u8bb8\u540c\u65f6\u5305\u542b\u7a7a\u503c\u548c\u975e\u7a7a\u503c \uff0c\u8bf7\u5206\u5f00\u52fe\u9009\u3002", (String)"InvoiceListPlugin_3", (String)"taxc-til", (Object[])new Object[0]), MessageBoxOptions.OK, new ConfirmCallBackListener(key, (IFormPlugin)this));
                    return;
                }
                QFilter idFilter2 = new QFilter("serial_no", "in", specialidList);
                DynamicObjectCollection special = QueryServiceHelper.query((String)"rim_inv_special", (String)"id,type,invoice_code,invoice_no", (QFilter[])new QFilter[]{idFilter2});
                AtomicInteger redCount = new AtomicInteger(0);
                StringBuilder redCodeNo = new StringBuilder();
                redCodeNo.append(ResManager.loadKDString((String)"\u7ea2\u5b57\u53d1\u7968:", (String)"InvoiceListPlugin_4", (String)"taxc-til", (Object[])new Object[0]));
                special.stream().forEach(s -> {
                    if ("1".equals(s.getString("type"))) {
                        redCount.incrementAndGet();
                        redCodeNo.append(s.getString("invoice_code")).append('-').append(s.getString("invoice_no")).append('\u3001');
                    }
                });
                if (redCount.get() > 0) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u7ea2\u5b57\u53d1\u7968\u4e0d\u652f\u6301\u8f6c\u51fa\u767b\u8bb0\uff0c\u8bf7\u524d\u5f80\u3010\u6d89\u7a0e\u6570\u636e\u7ba1\u7406\u3011-\u3010\u8fdb\u9879\u53d1\u7968\u3011-\u3010\u7ea2\u5b57\u4e13\u7528\u53d1\u7968\u4fe1\u606f\u8868\u3011\u4e2d\u767b\u8bb0", (String)"InvoiceListPlugin_5", (String)"taxc-til", (Object[])new Object[0]), redCodeNo.toString(), MessageBoxOptions.OK, ConfirmTypes.Save, new ConfirmCallBackListener(key, (IFormPlugin)this));
                    return;
                }
                if (notEmptyPeriod.get() > 0 || declaredCount.get() > 0) {
                    StringBuilder msg = new StringBuilder();
                    if (declaredCount.get() > 0) {
                        msg.append(String.format(ResManager.loadKDString((String)"\u5b58\u5728%1$s\u6761\u53d1\u7968\u5728\u3010\u5b9e\u9645\u8f6c\u51fa\u7a0e\u671f\u3011\u5185\u5df2\u751f\u6210\u7533\u62a5\u8868, \u672c\u6b21\u4e0d\u8fdb\u5165\u767b\u8bb0\u5217\u8868,\u53d1\u7968\u4ee3\u7801-\u53d1\u7968\u53f7\u7801: \u201c%2$s\u201d\u3002", (String)"InvoiceListPlugin_6", (String)"taxc-til", (Object[])new Object[0]), declaredCount, codeAndNoStr));
                    }
                    if (notEmptyPeriod.get() > 0) {
                        msg.append(String.format(ResManager.loadKDString((String)"\u5b58\u5728%s\u6761\u53d1\u7968\u5df2\u767b\u8bb0\uff0c\u662f\u5426\u91cd\u65b0\u8fdb\u884c\u8f6c\u51fa\u767b\u8bb0?", (String)"InvoiceListPlugin_7", (String)"taxc-til", (Object[])new Object[0]), notEmptyPeriod.get()));
                    }
                    this.getView().showConfirm(msg.toString(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(key, (IFormPlugin)this));
                    return;
                }
                this.openRegisterDialog(invoiceidList);
            }
        }
        if ("unregistered".equals(key) && (selectCollection = ((IListView)this.getView()).getSelectedRows()).size() > 0) {
            QFilter transferDate;
            QFilter registerType;
            QFilter idFilter = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"rim_invoice", (String)"invoice_no,invoice_code,output_signtype,output_type,serial_no,invoice_type,output_reason,invoice_status,real_output_amount,real_transferdate", (QFilter[])new QFilter[]{idFilter, registerType = new QFilter(OUTPUT_TYPE, "is not null", null), transferDate = new QFilter(REAL_TRANSFERDATE, "is not null", null)});
            if (invoices.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u53d1\u7968\u672a\u767b\u8bb0\u8f6c\u51fa\uff0c\u65e0\u9700\u53d6\u6d88\u3002", (String)"InvoiceListPlugin_8", (String)"taxc-til", (Object[])new Object[0]));
                return;
            }
            for (DynamicObject invoice : invoices) {
                String operateName = ResManager.loadKDString((String)"\u53d6\u6d88\u767b\u8bb0", (String)"InvoiceListPlugin_9", (String)"taxc-til", (Object[])new Object[0]);
                String operateDescription = String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801%1$s\uff0c\u53d1\u7968\u53f7\u7801%2$s\u7684\u53d1\u7968\u53d6\u6d88\u767b\u8bb0\u6210\u529f", (String)"InvoiceListPlugin_10", (String)"taxc-til", (Object[])new Object[0]), invoice.getString("invoice_code"), invoice.getString("invoice_no"));
                OperatorDialogUtils.operateDialog((String)"zzs", (String)"til_invoice_list", (String)operateName, (String)operateDescription);
                invoice.set(REAL_TRANSFERDATE, null);
                invoice.set(REAL_OUTPUT_AMOUNT, (Object)BigDecimal.ZERO);
                invoice.set(OUTPUT_SIGNTYPE, null);
                invoice.set(OUTPUT_TYPE, null);
            }
            boolean submit = ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(Arrays.asList(invoices)));
            if (submit) {
                if (selectCollection.size() > invoices.length) {
                    int x = selectCollection.size() - invoices.length;
                    this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u767b\u8bb0\u6210\u529f\u3002\uff08\u5176\u4e2d%s\u6761\u53d1\u7968\u672a\u767b\u8bb0\u8f6c\u51fa\uff0c\u65e0\u9700\u53d6\u6d88\uff09", (String)"InvoiceListPlugin_11", (String)"taxc-til", (Object[])new Object[0]), x));
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u767b\u8bb0\u6210\u529f", (String)"InvoiceListPlugin_12", (String)"taxc-til", (Object[])new Object[0]));
                }
            }
            BillList billlist = (BillList)this.getControl("billlistap");
            billlist.refresh();
        }
    }

    public static DynamicObject queryZzsSbb(Long org, String type, String startData, String endData) {
        QFilter orgidFilter = new QFilter("org", "in", (Object)org);
        QFilter stypeFilter = new QFilter("type", "=", (Object)type);
        QFilter startDataFilter = new QFilter("skssqq", "=", (Object)DateUtils.addMonth((Date)DateUtils.stringToDate((String)startData), (int)0));
        QFilter endDataFilter = new QFilter("skssqz", "<=", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)DateUtils.stringToDate((String)endData), (int)0)));
        QFilter billstatusFilter = new QFilter("billstatus", "!=", (Object)"A");
        DynamicObject temp = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"org,id", (QFilter[])new QFilter[]{orgidFilter, stypeFilter, billstatusFilter, startDataFilter, endDataFilter});
        return temp;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().returnDataToParent((Object)"close");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key = messageBoxClosedEvent.getCallBackId();
        if ("registered".equals(key) && "Yes".equals(messageBoxClosedEvent.getResult().name())) {
            List invoiceidlist = (List)JsonUtil.fromJson((String)this.getPageCache().get("invoiceidlist"), List.class);
            this.openRegisterDialog(invoiceidlist);
        }
    }

    private void openRegisterDialog(List<Long> invoiceIdList) {
        FormShowParameter param = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(10);
        customParams.put("invoicelist", invoiceIdList);
        customParams.put("reason", this.getPageCache().get("reason"));
        customParams.put("outputReason", this.getPageCache().get("outputReason"));
        param.setFormId("til_transfer_register");
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCaption(ResManager.loadKDString((String)"\u8fdb\u9879\u53d1\u7968\u767b\u8bb0", (String)"InvoiceListPlugin_13", (String)"taxc-til", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "close");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        BillList billlist = (BillList)this.getControl("billlistap");
        billlist.refresh();
    }

    private static Long getAccountingDefaultOrgId(IFormView view) {
        Long orgId = RequestContext.get().getOrgId();
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)view);
        List allOrg = OrgUnitServiceHelper.getAllOrg((String)"10");
        if (allOrg.contains(orgId)) {
            return orgId;
        }
        List orgList = hasPermOrgResult.getHasPermOrgs();
        List collect = orgList.stream().filter(allOrg::contains).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return 0L;
        }
        if (collect.contains(orgId)) {
            return orgId;
        }
        return (Long)collect.get(0);
    }

    private static /* synthetic */ void lambda$afterDoOperation$1(List specialidList, AtomicInteger emptyReason, AtomicInteger declaredCount, StringBuffer codeAndNoStr, AtomicInteger notEmptyPeriod, List invoiceidList, Set outputReasonSet, DynamicObject q) {
        if ("961639304377984000".equals(q.getString("invoice_type")) || "961640097369875456".equals(q.getString("invoice_type"))) {
            specialidList.add(q.getString("serial_no"));
        }
        if (StringUtil.isBlank((CharSequence)q.getString("output_reason"))) {
            emptyReason.incrementAndGet();
        }
        if (StringUtil.isNotBlank((CharSequence)q.getString(REAL_TRANSFERDATE))) {
            DynamicObject declareData = InvoiceListPlugin.queryZzsSbb(q.getLong("tax_org"), "zzsybnsr", DateUtils.getFirstDateOfMonthStr((Date)q.getDate("real_transferdate"), (String)"yyyy-MM-dd"), DateUtils.getLastDateOfMonthStr((Date)q.getDate("real_transferdate"), (String)"yyyy-MM-dd"));
            if (null != declareData) {
                declaredCount.incrementAndGet();
                codeAndNoStr.append(q.getString("invoice_code")).append('-').append(q.getString("invoice_no")).append('\uff1b');
            } else {
                notEmptyPeriod.incrementAndGet();
                invoiceidList.add(q.getLong("id"));
            }
        } else {
            invoiceidList.add(q.getLong("id"));
        }
        outputReasonSet.add(q.getString("output_reason"));
    }
}

