/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.inputtransferout.proportion;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class InvoiceCallBackInfoService {
    private static Log logger = LogFactory.getLog(InvoiceCallBackInfoService.class);

    public void callBackInfo(DynamicObject[] bills, String operatorKey) {
        Arrays.stream(bills).filter(s -> !s.getBoolean("manualregiste")).filter(a -> !StringUtil.isEmpty((CharSequence)a.getString("callbackinfo")) && !a.getString("callbackinfo").equals("[]")).forEach(c -> {
            String callbackinfo = c.getString("callbackinfo");
            String transferouttype = c.getDynamicObject("transferouttype").getString("number");
            BigDecimal ratio = c.getBigDecimal("ratio");
            BigDecimal actualtaxamount = c.getBigDecimal("actualtaxamount");
            List list = (List)SerializationUtils.fromJsonString((String)callbackinfo, List.class);
            long ruleIdCount = list.stream().map(s -> s.get("ruleId")).distinct().count();
            long tableCount = list.stream().map(s -> s.get("table")).distinct().count();
            if (ruleIdCount != 1L || tableCount != 1L) {
                logger.error("call back fail:" + callbackinfo);
                return;
            }
            List sourceIds = list.stream().flatMap(s -> ((List)s.get("sourceIds")).stream()).collect(Collectors.toList());
            Map<Long, List<Long>> listMap = sourceIds.stream().collect(Collectors.groupingBy(s -> s));
            DynamicObject[] invoiceLists = BusinessDataServiceHelper.load((Object[])sourceIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"til_invoice_list"));
            if ("audit".equals(operatorKey)) {
                List<DynamicObject> sortList = Arrays.stream(invoiceLists).sorted(Comparator.comparing(s -> s.getBigDecimal("effective_tax_amount"))).collect(Collectors.toList());
                BigDecimal sumTotal = BigDecimal.ZERO;
                for (int i = 0; i < sortList.size(); ++i) {
                    DynamicObject invoice = (DynamicObject)sortList.get(i);
                    invoice.set("output_type", (Object)("1".equals(transferouttype) ? "2" : "5"));
                    int factors = listMap.containsKey(invoice.getLong("id")) ? listMap.get(invoice.getLong("id")).size() : 1;
                    BigDecimal amount = new BigDecimal(factors).multiply(ratio.multiply(invoice.getBigDecimal("effective_tax_amount"))).setScale(2, 4);
                    invoice.set("real_output_amount", (Object)(i + 1 == sortList.size() ? actualtaxamount.subtract(sumTotal).setScale(2, 4) : amount));
                    sumTotal = sumTotal.add(amount);
                }
                SaveServiceHelper.save((DynamicObject[])sortList.toArray(new DynamicObject[0]));
            }
            if ("unaudit".equals(operatorKey)) {
                for (DynamicObject invoice : invoiceLists) {
                    invoice.set("output_type", null);
                    invoice.set("real_output_amount", null);
                }
                SaveServiceHelper.save((DynamicObject[])invoiceLists);
            }
        });
    }
}

